/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2023-11-23 14:13:15 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_aiowps_events` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `event_type` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `username` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_id` bigint DEFAULT NULL,
  `event_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `ip_or_host` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `referer_info` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `country_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `event_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aiowps_failed_logins` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `user_id` bigint NOT NULL,
  `user_login` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `failed_login_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `login_attempt_ip` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2350 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aiowps_global_meta` (
  `meta_id` bigint NOT NULL AUTO_INCREMENT,
  `date_time` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `meta_key1` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_key2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_key3` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_key4` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_key5` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value1` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value2` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value3` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value4` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value5` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aiowps_login_activity` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `user_id` bigint NOT NULL,
  `user_login` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `login_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `logout_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `login_ip` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `login_country` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `browser_type` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aiowps_login_lockdown` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `user_id` bigint NOT NULL,
  `user_login` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `lockdown_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `release_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `failed_login_ip` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `lock_reason` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `unlock_key` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aiowps_permanent_block` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `blocked_ip` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `block_reason` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `country_origin` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `blocked_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `unblock` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_layerslider` (
  `id` int NOT NULL AUTO_INCREMENT,
  `author` int NOT NULL DEFAULT '0',
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `slug` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_c` int NOT NULL,
  `date_m` int NOT NULL,
  `flag_hidden` tinyint(1) NOT NULL DEFAULT '0',
  `flag_deleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=302148 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=676 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=324 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_revslider_css` (
  `id` int NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` text,
  `hover` text,
  `params` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_revslider_layer_animations` (
  `id` int NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_revslider_settings` (
  `id` int NOT NULL AUTO_INCREMENT,
  `general` text NOT NULL,
  `params` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_revslider_sliders` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext,
  `params` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_revslider_slides` (
  `id` int NOT NULL AUTO_INCREMENT,
  `slider_id` int NOT NULL,
  `slide_order` int NOT NULL,
  `params` text NOT NULL,
  `layers` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_revslider_static_slides` (
  `id` int NOT NULL AUTO_INCREMENT,
  `slider_id` int NOT NULL,
  `params` text NOT NULL,
  `layers` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wfblockediplog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `countryCode` varchar(2) NOT NULL,
  `blockCount` int unsigned NOT NULL DEFAULT '0',
  `unixday` int unsigned NOT NULL,
  `blockType` varchar(50) NOT NULL DEFAULT 'generic',
  PRIMARY KEY (`IP`,`unixday`,`blockType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfblocks7` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` int unsigned NOT NULL DEFAULT '0',
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint NOT NULL,
  `reason` varchar(255) NOT NULL,
  `lastAttempt` int unsigned DEFAULT '0',
  `blockedHits` int unsigned DEFAULT '0',
  `expiration` bigint unsigned NOT NULL DEFAULT '0',
  `parameters` text,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `IP` (`IP`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB AUTO_INCREMENT=40293 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfconfig` (
  `name` varchar(100) NOT NULL,
  `val` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfcrawlers` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `patternSig` binary(16) NOT NULL,
  `status` char(8) NOT NULL,
  `lastUpdate` int unsigned NOT NULL,
  `PTR` varchar(255) DEFAULT '',
  PRIMARY KEY (`IP`,`patternSig`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wffilechanges` (
  `filenameHash` char(64) NOT NULL,
  `file` varchar(1000) NOT NULL,
  `md5` char(32) NOT NULL,
  PRIMARY KEY (`filenameHash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wffilemods` (
  `filenameMD5` binary(16) NOT NULL,
  `filename` varchar(1000) NOT NULL,
  `knownFile` tinyint unsigned NOT NULL,
  `oldMD5` binary(16) NOT NULL,
  `newMD5` binary(16) NOT NULL,
  `SHAC` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `stoppedOnSignature` varchar(255) NOT NULL DEFAULT '',
  `stoppedOnPosition` int unsigned NOT NULL DEFAULT '0',
  `isSafeFile` varchar(1) NOT NULL DEFAULT '?',
  PRIMARY KEY (`filenameMD5`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfhits` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `attackLogTime` double(17,6) unsigned NOT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `jsRun` tinyint DEFAULT '0',
  `statusCode` int NOT NULL DEFAULT '200',
  `isGoogle` tinyint NOT NULL,
  `userID` int unsigned NOT NULL,
  `newVisit` tinyint unsigned NOT NULL,
  `URL` text,
  `referer` text,
  `UA` text,
  `action` varchar(64) NOT NULL DEFAULT '',
  `actionDescription` text,
  `actionData` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`IP`,`ctime`),
  KEY `attackLogTime` (`attackLogTime`)
) ENGINE=InnoDB AUTO_INCREMENT=97341 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfhoover` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `owner` text,
  `host` text,
  `path` text,
  `hostKey` varbinary(124) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k2` (`hostKey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfissues` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `time` int unsigned NOT NULL,
  `lastUpdated` int unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB AUTO_INCREMENT=3694 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfknownfilelist` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8771 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wflivetraffichuman` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `identifier` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `expiration` int unsigned NOT NULL,
  PRIMARY KEY (`IP`,`identifier`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wflocs` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int unsigned NOT NULL,
  `failed` tinyint unsigned NOT NULL,
  `city` varchar(255) DEFAULT '',
  `region` varchar(255) DEFAULT '',
  `countryName` varchar(255) DEFAULT '',
  `countryCode` char(2) DEFAULT '',
  `lat` float(10,7) DEFAULT '0.0000000',
  `lon` float(10,7) DEFAULT '0.0000000',
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wflogins` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `hitID` int DEFAULT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `fail` tinyint unsigned NOT NULL,
  `action` varchar(40) NOT NULL,
  `username` varchar(255) NOT NULL,
  `userID` int unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `UA` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`IP`,`fail`),
  KEY `hitID` (`hitID`)
) ENGINE=InnoDB AUTO_INCREMENT=2352 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfls_2fa_secrets` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `secret` tinyblob NOT NULL,
  `recovery` blob NOT NULL,
  `ctime` int unsigned NOT NULL,
  `vtime` int unsigned NOT NULL,
  `mode` enum('authenticator') NOT NULL DEFAULT 'authenticator',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfls_settings` (
  `name` varchar(191) NOT NULL DEFAULT '',
  `value` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfnotifications` (
  `id` varchar(32) NOT NULL DEFAULT '',
  `new` tinyint unsigned NOT NULL DEFAULT '1',
  `category` varchar(255) NOT NULL,
  `priority` int NOT NULL DEFAULT '1000',
  `ctime` int unsigned NOT NULL,
  `html` text NOT NULL,
  `links` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfpendingissues` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `time` int unsigned NOT NULL,
  `lastUpdated` int unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfreversecache` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `host` varchar(255) NOT NULL,
  `lastUpdate` int unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfsnipcache` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `IP` varchar(45) NOT NULL DEFAULT '',
  `expiration` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `body` varchar(255) NOT NULL DEFAULT '',
  `count` int unsigned NOT NULL DEFAULT '0',
  `type` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `expiration` (`expiration`),
  KEY `IP` (`IP`),
  KEY `type` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=21872 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfstatus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `ctime` double(17,6) unsigned NOT NULL,
  `level` tinyint unsigned NOT NULL,
  `type` char(5) NOT NULL,
  `msg` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=72152 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wftrafficrates` (
  `eMin` int unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hitType` enum('hit','404') NOT NULL DEFAULT 'hit',
  `hits` int unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`,`hitType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;


/* INSERT TABLE DATA: wp_aiowps_failed_logins */
INSERT INTO `wp_aiowps_failed_logins` VALUES("1", "0", "admin", "2022-01-14 09:37:21", "178.128.54.225");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2", "0", "admin", "2022-01-14 09:43:30", "144.91.73.85");
INSERT INTO `wp_aiowps_failed_logins` VALUES("3", "0", "admin", "2022-01-14 09:49:18", "52.166.3.59");
INSERT INTO `wp_aiowps_failed_logins` VALUES("4", "0", "admin", "2022-01-14 09:55:26", "157.90.80.180");
INSERT INTO `wp_aiowps_failed_logins` VALUES("5", "0", "admin", "2022-01-14 10:01:24", "23.99.229.218");
INSERT INTO `wp_aiowps_failed_logins` VALUES("6", "1", "ucr", "2022-01-14 10:49:30", "118.27.30.151");
INSERT INTO `wp_aiowps_failed_logins` VALUES("7", "1", "ucr", "2022-01-14 11:01:42", "64.207.179.129");
INSERT INTO `wp_aiowps_failed_logins` VALUES("8", "1", "ucr", "2022-01-14 11:07:58", "81.88.52.163");
INSERT INTO `wp_aiowps_failed_logins` VALUES("9", "1", "ucr", "2022-01-14 11:44:51", "167.172.153.166");
INSERT INTO `wp_aiowps_failed_logins` VALUES("10", "1", "ucr", "2022-01-14 12:36:51", "192.187.127.20");
INSERT INTO `wp_aiowps_failed_logins` VALUES("11", "1", "ucr", "2022-01-14 12:46:23", "63.141.252.68");
INSERT INTO `wp_aiowps_failed_logins` VALUES("12", "1", "ucr", "2022-01-14 13:04:41", "103.121.89.72");
INSERT INTO `wp_aiowps_failed_logins` VALUES("13", "1", "ucr", "2022-01-14 13:29:08", "80.249.174.66");
INSERT INTO `wp_aiowps_failed_logins` VALUES("14", "1", "ucr", "2022-01-14 14:00:00", "89.96.90.125");
INSERT INTO `wp_aiowps_failed_logins` VALUES("15", "1", "ucr", "2022-01-14 14:06:07", "13.229.221.204");
INSERT INTO `wp_aiowps_failed_logins` VALUES("16", "0", "admin", "2022-01-14 14:11:30", "69.30.231.158");
INSERT INTO `wp_aiowps_failed_logins` VALUES("17", "1", "ucr", "2022-01-14 14:24:53", "173.212.212.180");
INSERT INTO `wp_aiowps_failed_logins` VALUES("18", "1", "ucr", "2022-01-14 14:43:19", "139.59.75.162");
INSERT INTO `wp_aiowps_failed_logins` VALUES("19", "1", "ucr", "2022-01-14 15:07:51", "195.201.42.236");
INSERT INTO `wp_aiowps_failed_logins` VALUES("20", "1", "ucr", "2022-01-14 15:51:18", "209.97.162.248");
INSERT INTO `wp_aiowps_failed_logins` VALUES("21", "1", "ucr", "2022-01-14 17:11:16", "167.71.215.224");
INSERT INTO `wp_aiowps_failed_logins` VALUES("22", "1", "ucr", "2022-01-14 18:11:41", "178.217.190.82");
INSERT INTO `wp_aiowps_failed_logins` VALUES("23", "1", "ucr", "2022-01-14 18:23:41", "115.29.199.218");
INSERT INTO `wp_aiowps_failed_logins` VALUES("24", "1", "ucr", "2022-01-14 19:34:07", "35.224.3.160");
INSERT INTO `wp_aiowps_failed_logins` VALUES("25", "0", "wpadmin", "2022-01-15 17:33:31", "134.209.144.38");
INSERT INTO `wp_aiowps_failed_logins` VALUES("26", "0", "wpadmin", "2022-01-15 18:01:59", "185.140.249.108");
INSERT INTO `wp_aiowps_failed_logins` VALUES("27", "0", "admin", "2022-01-16 15:09:49", "143.244.177.220");
INSERT INTO `wp_aiowps_failed_logins` VALUES("28", "0", "admin", "2022-01-16 15:12:43", "192.3.165.138");
INSERT INTO `wp_aiowps_failed_logins` VALUES("29", "0", "admin", "2022-01-16 16:12:38", "103.130.218.178");
INSERT INTO `wp_aiowps_failed_logins` VALUES("30", "0", "admin", "2022-01-16 17:14:35", "13.229.221.204");
INSERT INTO `wp_aiowps_failed_logins` VALUES("31", "0", "admin", "2022-01-16 18:15:31", "139.59.75.162");
INSERT INTO `wp_aiowps_failed_logins` VALUES("32", "0", "admin", "2022-01-16 18:18:25", "148.72.214.245");
INSERT INTO `wp_aiowps_failed_logins` VALUES("33", "0", "admin", "2022-01-16 20:19:11", "165.22.193.8");
INSERT INTO `wp_aiowps_failed_logins` VALUES("34", "0", "admin", "2022-01-16 20:46:08", "208.109.54.127");
INSERT INTO `wp_aiowps_failed_logins` VALUES("35", "0", "admin", "2022-01-16 20:46:30", "128.199.220.215");
INSERT INTO `wp_aiowps_failed_logins` VALUES("36", "0", "admin", "2022-01-16 21:47:02", "188.212.34.69");
INSERT INTO `wp_aiowps_failed_logins` VALUES("37", "0", "admin", "2022-01-16 21:47:02", "188.212.34.69");
INSERT INTO `wp_aiowps_failed_logins` VALUES("38", "0", "admin", "2022-01-17 01:20:24", "194.13.83.88");
INSERT INTO `wp_aiowps_failed_logins` VALUES("39", "0", "admin", "2022-01-17 02:36:12", "194.163.152.242");
INSERT INTO `wp_aiowps_failed_logins` VALUES("40", "0", "admin", "2022-01-17 03:07:06", "142.93.245.196");
INSERT INTO `wp_aiowps_failed_logins` VALUES("41", "0", "admin", "2022-01-17 03:23:00", "23.97.205.210");
INSERT INTO `wp_aiowps_failed_logins` VALUES("42", "0", "admin", "2022-01-17 04:09:39", "206.189.6.60");
INSERT INTO `wp_aiowps_failed_logins` VALUES("43", "0", "admin", "2022-01-17 04:26:05", "143.244.177.220");
INSERT INTO `wp_aiowps_failed_logins` VALUES("44", "0", "admin", "2022-01-17 04:56:45", "162.144.63.211");
INSERT INTO `wp_aiowps_failed_logins` VALUES("45", "0", "admin", "2022-01-17 05:57:38", "23.99.229.218");
INSERT INTO `wp_aiowps_failed_logins` VALUES("46", "0", "admin", "2022-01-17 06:00:57", "47.105.61.35");
INSERT INTO `wp_aiowps_failed_logins` VALUES("47", "0", "admin", "2022-01-17 06:28:05", "82.223.111.249");
INSERT INTO `wp_aiowps_failed_logins` VALUES("48", "0", "admin", "2022-01-17 08:02:06", "103.142.254.130");
INSERT INTO `wp_aiowps_failed_logins` VALUES("49", "0", "admin", "2022-01-17 08:32:21", "52.183.137.156");
INSERT INTO `wp_aiowps_failed_logins` VALUES("50", "0", "admin", "2022-01-17 09:21:33", "91.210.171.74");
INSERT INTO `wp_aiowps_failed_logins` VALUES("51", "0", "admin", "2022-01-17 09:43:50", "51.77.223.41");
INSERT INTO `wp_aiowps_failed_logins` VALUES("52", "0", "admin", "2022-01-17 10:26:31", "120.29.68.197");
INSERT INTO `wp_aiowps_failed_logins` VALUES("53", "0", "admin", "2022-01-17 10:30:29", "23.88.38.58");
INSERT INTO `wp_aiowps_failed_logins` VALUES("54", "0", "admin", "2022-01-17 10:53:11", "85.85.242.158");
INSERT INTO `wp_aiowps_failed_logins` VALUES("55", "0", "admin", "2022-01-17 11:13:31", "167.172.173.208");
INSERT INTO `wp_aiowps_failed_logins` VALUES("56", "0", "admin", "2022-01-17 12:48:12", "82.223.111.249");
INSERT INTO `wp_aiowps_failed_logins` VALUES("57", "0", "admin", "2022-01-17 13:09:14", "216.24.255.50");
INSERT INTO `wp_aiowps_failed_logins` VALUES("58", "0", "admin", "2022-01-17 13:32:52", "185.243.55.192");
INSERT INTO `wp_aiowps_failed_logins` VALUES("59", "0", "admin", "2022-01-17 15:19:46", "81.88.52.205");
INSERT INTO `wp_aiowps_failed_logins` VALUES("60", "0", "admin", "2022-01-17 15:57:55", "193.70.114.2");
INSERT INTO `wp_aiowps_failed_logins` VALUES("61", "0", "admin", "2022-01-17 16:50:32", "5.39.22.113");
INSERT INTO `wp_aiowps_failed_logins` VALUES("62", "0", "admin", "2022-01-17 17:05:34", "156.38.216.210");
INSERT INTO `wp_aiowps_failed_logins` VALUES("63", "0", "admin", "2022-01-17 17:05:34", "156.38.216.210");
INSERT INTO `wp_aiowps_failed_logins` VALUES("64", "0", "admin", "2022-01-17 17:49:24", "15.185.97.190");
INSERT INTO `wp_aiowps_failed_logins` VALUES("65", "0", "admin", "2022-01-17 18:47:29", "116.255.160.108");
INSERT INTO `wp_aiowps_failed_logins` VALUES("66", "0", "admin", "2022-01-17 20:43:54", "173.212.235.115");
INSERT INTO `wp_aiowps_failed_logins` VALUES("67", "0", "admin", "2022-01-17 21:20:47", "34.122.210.151");
INSERT INTO `wp_aiowps_failed_logins` VALUES("68", "0", "admin", "2022-01-17 22:49:27", "68.183.139.84");
INSERT INTO `wp_aiowps_failed_logins` VALUES("69", "0", "admin", "2022-01-17 23:40:50", "185.190.117.89");
INSERT INTO `wp_aiowps_failed_logins` VALUES("70", "0", "admin", "2022-01-18 00:40:22", "188.166.33.234");
INSERT INTO `wp_aiowps_failed_logins` VALUES("71", "0", "admin", "2022-01-18 02:33:02", "141.94.247.170");
INSERT INTO `wp_aiowps_failed_logins` VALUES("72", "0", "admin", "2022-01-18 03:18:18", "173.255.112.220");
INSERT INTO `wp_aiowps_failed_logins` VALUES("73", "0", "admin", "2022-01-18 03:25:44", "210.211.116.118");
INSERT INTO `wp_aiowps_failed_logins` VALUES("74", "0", "admin", "2022-01-18 04:42:05", "211.110.139.214");
INSERT INTO `wp_aiowps_failed_logins` VALUES("75", "0", "admin", "2022-01-18 07:30:59", "104.254.247.129");
INSERT INTO `wp_aiowps_failed_logins` VALUES("76", "0", "admin", "2022-01-18 10:42:15", "107.172.82.148");
INSERT INTO `wp_aiowps_failed_logins` VALUES("77", "0", "admin", "2022-01-18 10:49:51", "134.209.110.77");
INSERT INTO `wp_aiowps_failed_logins` VALUES("78", "0", "admin", "2022-01-18 11:12:02", "72.167.34.14");
INSERT INTO `wp_aiowps_failed_logins` VALUES("79", "0", "admin", "2022-01-18 11:12:02", "72.167.34.14");
INSERT INTO `wp_aiowps_failed_logins` VALUES("80", "0", "admin", "2022-01-18 14:25:40", "194.233.72.23");
INSERT INTO `wp_aiowps_failed_logins` VALUES("81", "0", "admin", "2022-01-18 14:48:36", "23.88.38.58");
INSERT INTO `wp_aiowps_failed_logins` VALUES("82", "0", "admin", "2022-01-19 01:39:07", "120.29.68.13");
INSERT INTO `wp_aiowps_failed_logins` VALUES("83", "0", "admin", "2022-01-19 02:00:27", "120.29.68.13");
INSERT INTO `wp_aiowps_failed_logins` VALUES("84", "0", "admin", "2022-01-19 13:53:17", "81.198.171.171");
INSERT INTO `wp_aiowps_failed_logins` VALUES("85", "0", "admin", "2022-01-19 15:23:51", "188.166.56.218");
INSERT INTO `wp_aiowps_failed_logins` VALUES("86", "0", "admin", "2022-01-19 15:24:24", "143.244.184.195");
INSERT INTO `wp_aiowps_failed_logins` VALUES("87", "0", "admin", "2022-01-19 15:38:01", "177.55.111.14");
INSERT INTO `wp_aiowps_failed_logins` VALUES("88", "0", "admin", "2022-01-19 15:51:20", "147.135.210.69");
INSERT INTO `wp_aiowps_failed_logins` VALUES("89", "0", "admin", "2022-01-19 16:32:24", "91.219.60.108");
INSERT INTO `wp_aiowps_failed_logins` VALUES("90", "0", "admin", "2022-01-19 16:46:26", "107.172.82.148");
INSERT INTO `wp_aiowps_failed_logins` VALUES("91", "0", "swoods", "2022-01-19 16:52:12", "172.104.26.232");
INSERT INTO `wp_aiowps_failed_logins` VALUES("92", "0", "admin", "2022-01-19 17:00:02", "167.172.151.91");
INSERT INTO `wp_aiowps_failed_logins` VALUES("93", "0", "admin", "2022-01-19 17:57:40", "74.208.34.142");
INSERT INTO `wp_aiowps_failed_logins` VALUES("94", "0", "admin", "2022-01-19 18:21:42", "193.70.114.2");
INSERT INTO `wp_aiowps_failed_logins` VALUES("95", "0", "admin", "2022-01-19 18:38:17", "47.93.61.192");
INSERT INTO `wp_aiowps_failed_logins` VALUES("96", "0", "admin", "2022-01-19 18:48:20", "193.70.114.2");
INSERT INTO `wp_aiowps_failed_logins` VALUES("97", "0", "admin", "2022-01-19 19:05:52", "185.2.5.25");
INSERT INTO `wp_aiowps_failed_logins` VALUES("98", "0", "admin", "2022-01-19 19:44:28", "103.149.154.8");
INSERT INTO `wp_aiowps_failed_logins` VALUES("99", "0", "admin", "2022-01-19 20:39:48", "217.160.67.32");
INSERT INTO `wp_aiowps_failed_logins` VALUES("100", "0", "admin", "2022-01-19 20:43:25", "95.128.43.176");
INSERT INTO `wp_aiowps_failed_logins` VALUES("101", "0", "admin", "2022-01-19 21:22:07", "103.121.89.72");
INSERT INTO `wp_aiowps_failed_logins` VALUES("102", "0", "admin", "2022-01-19 21:22:07", "103.121.89.72");
INSERT INTO `wp_aiowps_failed_logins` VALUES("103", "0", "admin", "2022-01-19 22:08:02", "167.71.34.185");
INSERT INTO `wp_aiowps_failed_logins` VALUES("104", "0", "admin", "2022-01-19 23:00:50", "185.137.233.223");
INSERT INTO `wp_aiowps_failed_logins` VALUES("105", "0", "admin", "2022-01-19 23:01:18", "89.96.90.125");
INSERT INTO `wp_aiowps_failed_logins` VALUES("106", "0", "admin", "2022-01-19 23:04:32", "34.135.118.195");
INSERT INTO `wp_aiowps_failed_logins` VALUES("107", "0", "admin", "2022-01-19 23:15:35", "52.60.77.201");
INSERT INTO `wp_aiowps_failed_logins` VALUES("108", "0", "admin", "2022-01-19 23:57:46", "62.221.194.243");
INSERT INTO `wp_aiowps_failed_logins` VALUES("109", "0", "admin", "2022-01-20 00:00:59", "187.51.127.28");
INSERT INTO `wp_aiowps_failed_logins` VALUES("110", "0", "admin", "2022-01-20 00:11:49", "58.96.40.33");
INSERT INTO `wp_aiowps_failed_logins` VALUES("111", "0", "admin", "2022-01-20 00:25:20", "159.89.0.102");
INSERT INTO `wp_aiowps_failed_logins` VALUES("112", "0", "admin", "2022-01-20 00:39:31", "138.197.12.140");
INSERT INTO `wp_aiowps_failed_logins` VALUES("113", "0", "admin", "2022-01-20 00:56:35", "167.71.215.224");
INSERT INTO `wp_aiowps_failed_logins` VALUES("114", "0", "admin", "2022-01-20 01:52:24", "167.71.163.218");
INSERT INTO `wp_aiowps_failed_logins` VALUES("115", "0", "admin", "2022-01-20 02:06:16", "42.193.21.177");
INSERT INTO `wp_aiowps_failed_logins` VALUES("116", "0", "admin", "2022-01-20 02:31:11", "13.94.249.188");
INSERT INTO `wp_aiowps_failed_logins` VALUES("117", "0", "admin", "2022-01-20 03:12:33", "161.35.126.102");
INSERT INTO `wp_aiowps_failed_logins` VALUES("118", "0", "admin", "2022-01-20 03:41:07", "103.74.253.244");
INSERT INTO `wp_aiowps_failed_logins` VALUES("119", "0", "admin", "2022-01-20 03:54:44", "161.35.34.204");
INSERT INTO `wp_aiowps_failed_logins` VALUES("120", "0", "admin", "2022-01-20 03:55:12", "47.93.61.192");
INSERT INTO `wp_aiowps_failed_logins` VALUES("121", "0", "admin", "2022-01-20 04:08:50", "206.189.6.60");
INSERT INTO `wp_aiowps_failed_logins` VALUES("122", "0", "admin", "2022-01-20 04:26:21", "206.189.139.182");
INSERT INTO `wp_aiowps_failed_logins` VALUES("123", "0", "admin", "2022-01-20 04:51:05", "178.128.247.244");
INSERT INTO `wp_aiowps_failed_logins` VALUES("124", "0", "admin", "2022-01-20 04:53:59", "167.99.32.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("125", "0", "admin", "2022-01-20 05:04:13", "195.242.103.103");
INSERT INTO `wp_aiowps_failed_logins` VALUES("126", "0", "admin", "2022-01-20 05:07:48", "93.113.110.104");
INSERT INTO `wp_aiowps_failed_logins` VALUES("127", "0", "admin", "2022-01-20 05:35:23", "162.144.63.211");
INSERT INTO `wp_aiowps_failed_logins` VALUES("128", "0", "admin", "2022-01-20 06:02:44", "103.46.239.133");
INSERT INTO `wp_aiowps_failed_logins` VALUES("129", "0", "admin", "2022-01-20 07:28:46", "185.190.117.89");
INSERT INTO `wp_aiowps_failed_logins` VALUES("130", "0", "admin", "2022-01-20 07:57:00", "103.28.49.63");
INSERT INTO `wp_aiowps_failed_logins` VALUES("131", "0", "admin", "2022-01-20 08:22:02", "185.2.4.56");
INSERT INTO `wp_aiowps_failed_logins` VALUES("132", "0", "admin", "2022-01-20 08:22:02", "185.2.4.56");
INSERT INTO `wp_aiowps_failed_logins` VALUES("133", "0", "admin", "2022-01-20 08:36:21", "103.142.254.130");
INSERT INTO `wp_aiowps_failed_logins` VALUES("134", "0", "admin", "2022-01-20 09:04:30", "103.144.253.38");
INSERT INTO `wp_aiowps_failed_logins` VALUES("135", "0", "admin", "2022-01-20 09:18:21", "206.189.129.168");
INSERT INTO `wp_aiowps_failed_logins` VALUES("136", "0", "admin", "2022-01-20 09:49:38", "164.68.101.188");
INSERT INTO `wp_aiowps_failed_logins` VALUES("137", "0", "admin", "2022-01-20 11:09:22", "185.126.219.43");
INSERT INTO `wp_aiowps_failed_logins` VALUES("138", "0", "admin", "2022-01-20 12:05:26", "188.212.34.69");
INSERT INTO `wp_aiowps_failed_logins` VALUES("139", "0", "admin", "2022-01-20 12:22:27", "51.77.223.41");
INSERT INTO `wp_aiowps_failed_logins` VALUES("140", "0", "admin", "2022-01-20 12:50:11", "185.190.117.89");
INSERT INTO `wp_aiowps_failed_logins` VALUES("141", "0", "admin", "2022-01-20 13:57:33", "217.9.143.94");
INSERT INTO `wp_aiowps_failed_logins` VALUES("142", "0", "admin", "2022-01-20 14:11:49", "103.121.89.72");
INSERT INTO `wp_aiowps_failed_logins` VALUES("143", "0", "admin", "2022-01-20 14:29:10", "51.77.223.41");
INSERT INTO `wp_aiowps_failed_logins` VALUES("144", "0", "admin", "2022-01-20 14:43:26", "173.212.212.180");
INSERT INTO `wp_aiowps_failed_logins` VALUES("145", "0", "admin", "2022-01-20 15:08:14", "103.121.89.72");
INSERT INTO `wp_aiowps_failed_logins` VALUES("146", "0", "admin", "2022-01-20 15:08:39", "159.65.216.18");
INSERT INTO `wp_aiowps_failed_logins` VALUES("147", "0", "admin", "2022-01-20 15:11:52", "165.22.198.210");
INSERT INTO `wp_aiowps_failed_logins` VALUES("148", "0", "admin", "2022-01-20 16:06:06", "137.184.159.101");
INSERT INTO `wp_aiowps_failed_logins` VALUES("149", "0", "admin", "2022-01-21 10:55:46", "120.29.68.13");
INSERT INTO `wp_aiowps_failed_logins` VALUES("150", "0", "admin", "2022-01-22 09:30:16", "128.199.220.215");
INSERT INTO `wp_aiowps_failed_logins` VALUES("151", "0", "admin", "2022-01-22 09:32:36", "162.144.63.211");
INSERT INTO `wp_aiowps_failed_logins` VALUES("152", "0", "admin", "2022-01-22 10:00:55", "206.189.6.60");
INSERT INTO `wp_aiowps_failed_logins` VALUES("153", "0", "admin", "2022-01-22 10:54:08", "164.68.99.94");
INSERT INTO `wp_aiowps_failed_logins` VALUES("154", "0", "admin", "2022-01-22 12:26:03", "211.110.139.214");
INSERT INTO `wp_aiowps_failed_logins` VALUES("155", "0", "admin", "2022-01-22 12:46:33", "35.220.192.251");
INSERT INTO `wp_aiowps_failed_logins` VALUES("156", "0", "admin", "2022-01-22 12:54:26", "23.88.38.58");
INSERT INTO `wp_aiowps_failed_logins` VALUES("157", "0", "admin", "2022-01-22 12:56:49", "93.113.110.104");
INSERT INTO `wp_aiowps_failed_logins` VALUES("158", "0", "admin", "2022-01-22 13:04:50", "143.244.177.220");
INSERT INTO `wp_aiowps_failed_logins` VALUES("159", "0", "admin", "2022-01-22 13:07:09", "46.63.80.162");
INSERT INTO `wp_aiowps_failed_logins` VALUES("160", "0", "admin", "2022-01-22 13:17:32", "132.248.60.104");
INSERT INTO `wp_aiowps_failed_logins` VALUES("161", "0", "admin", "2022-01-22 13:25:31", "40.113.8.202");
INSERT INTO `wp_aiowps_failed_logins` VALUES("162", "0", "admin", "2022-01-22 13:27:51", "93.113.110.104");
INSERT INTO `wp_aiowps_failed_logins` VALUES("163", "0", "admin", "2022-01-22 13:46:02", "167.71.89.92");
INSERT INTO `wp_aiowps_failed_logins` VALUES("164", "0", "admin", "2022-01-22 13:48:24", "78.47.116.216");
INSERT INTO `wp_aiowps_failed_logins` VALUES("165", "0", "admin", "2022-01-22 14:23:36", "162.144.63.211");
INSERT INTO `wp_aiowps_failed_logins` VALUES("166", "0", "admin", "2022-01-22 15:23:00", "74.208.34.142");
INSERT INTO `wp_aiowps_failed_logins` VALUES("167", "0", "admin", "2022-01-22 16:00:29", "52.183.137.156");
INSERT INTO `wp_aiowps_failed_logins` VALUES("168", "0", "admin", "2022-01-22 17:17:58", "165.232.177.227");
INSERT INTO `wp_aiowps_failed_logins` VALUES("169", "0", "admin", "2022-01-22 17:19:25", "128.199.242.105");
INSERT INTO `wp_aiowps_failed_logins` VALUES("170", "0", "admin", "2022-01-22 17:56:03", "72.167.34.14");
INSERT INTO `wp_aiowps_failed_logins` VALUES("171", "0", "admin", "2022-01-22 17:56:03", "72.167.34.14");
INSERT INTO `wp_aiowps_failed_logins` VALUES("172", "0", "admin", "2022-01-22 19:49:58", "95.128.43.176");
INSERT INTO `wp_aiowps_failed_logins` VALUES("173", "0", "admin", "2022-01-22 19:51:25", "167.172.153.166");
INSERT INTO `wp_aiowps_failed_logins` VALUES("174", "0", "admin", "2022-01-22 20:29:20", "141.94.247.170");
INSERT INTO `wp_aiowps_failed_logins` VALUES("175", "0", "admin", "2022-01-22 21:24:58", "172.105.47.223");
INSERT INTO `wp_aiowps_failed_logins` VALUES("176", "0", "admin", "2022-01-22 22:02:58", "64.141.87.4");
INSERT INTO `wp_aiowps_failed_logins` VALUES("177", "0", "admin", "2022-01-22 22:23:22", "147.135.210.69");
INSERT INTO `wp_aiowps_failed_logins` VALUES("178", "0", "admin", "2022-01-22 22:41:00", "206.189.6.60");
INSERT INTO `wp_aiowps_failed_logins` VALUES("179", "0", "admin", "2022-01-22 23:01:31", "122.114.249.12");
INSERT INTO `wp_aiowps_failed_logins` VALUES("180", "0", "admin", "2022-01-22 23:19:11", "157.245.110.251");
INSERT INTO `wp_aiowps_failed_logins` VALUES("181", "0", "admin", "2022-01-23 00:17:46", "107.172.219.253");
INSERT INTO `wp_aiowps_failed_logins` VALUES("182", "0", "admin", "2022-01-23 00:35:29", "185.49.20.77");
INSERT INTO `wp_aiowps_failed_logins` VALUES("183", "0", "admin", "2022-01-23 01:34:20", "192.71.144.12");
INSERT INTO `wp_aiowps_failed_logins` VALUES("184", "0", "admin", "2022-01-23 01:52:06", "109.168.97.89");
INSERT INTO `wp_aiowps_failed_logins` VALUES("185", "0", "admin", "2022-01-23 03:09:02", "101.32.178.221");
INSERT INTO `wp_aiowps_failed_logins` VALUES("186", "0", "admin", "2022-01-23 04:06:02", "138.68.248.47");
INSERT INTO `wp_aiowps_failed_logins` VALUES("187", "0", "admin", "2022-01-23 05:22:42", "46.43.9.213");
INSERT INTO `wp_aiowps_failed_logins` VALUES("188", "0", "admin", "2022-01-23 05:41:48", "162.240.27.242");
INSERT INTO `wp_aiowps_failed_logins` VALUES("189", "0", "admin", "2022-01-23 05:59:23", "23.99.229.218");
INSERT INTO `wp_aiowps_failed_logins` VALUES("190", "0", "admin", "2022-01-23 06:00:47", "137.117.208.19");
INSERT INTO `wp_aiowps_failed_logins` VALUES("191", "0", "admin", "2022-01-23 06:39:10", "85.85.242.158");
INSERT INTO `wp_aiowps_failed_logins` VALUES("192", "0", "admin", "2022-01-23 06:56:49", "84.205.178.134");
INSERT INTO `wp_aiowps_failed_logins` VALUES("193", "0", "admin", "2022-01-23 07:56:21", "167.172.151.91");
INSERT INTO `wp_aiowps_failed_logins` VALUES("194", "0", "admin", "2022-01-23 08:33:52", "185.243.55.192");
INSERT INTO `wp_aiowps_failed_logins` VALUES("195", "0", "admin", "2022-01-23 08:53:40", "220.132.196.5");
INSERT INTO `wp_aiowps_failed_logins` VALUES("196", "1", "ucr", "2022-01-24 06:36:43", "69.30.229.67");
INSERT INTO `wp_aiowps_failed_logins` VALUES("197", "1", "ucr", "2022-01-25 01:20:37", "69.30.229.67");
INSERT INTO `wp_aiowps_failed_logins` VALUES("198", "0", "plai", "2022-01-27 01:24:21", "165.227.26.80");
INSERT INTO `wp_aiowps_failed_logins` VALUES("199", "1", "ucr", "2022-01-27 05:17:44", "107.150.48.235");
INSERT INTO `wp_aiowps_failed_logins` VALUES("200", "1", "ucr", "2022-01-28 17:10:19", "74.91.19.188");
INSERT INTO `wp_aiowps_failed_logins` VALUES("201", "1", "ucr", "2022-01-29 03:34:34", "69.30.230.58");
INSERT INTO `wp_aiowps_failed_logins` VALUES("202", "1", "ucr", "2022-01-30 11:34:00", "63.141.252.66");
INSERT INTO `wp_aiowps_failed_logins` VALUES("203", "0", "admin", "2022-01-31 03:33:02", "107.150.63.173");
INSERT INTO `wp_aiowps_failed_logins` VALUES("204", "0", "admin", "2022-01-31 07:03:57", "47.105.61.35");
INSERT INTO `wp_aiowps_failed_logins` VALUES("205", "1", "ucr", "2022-01-31 08:56:50", "157.245.110.251");
INSERT INTO `wp_aiowps_failed_logins` VALUES("206", "1", "ucr", "2022-01-31 09:34:38", "68.183.108.18");
INSERT INTO `wp_aiowps_failed_logins` VALUES("207", "0", "admin", "2022-01-31 10:43:06", "91.219.60.108");
INSERT INTO `wp_aiowps_failed_logins` VALUES("208", "0", "admin", "2022-01-31 10:43:46", "47.100.208.57");
INSERT INTO `wp_aiowps_failed_logins` VALUES("209", "0", "admin", "2022-01-31 10:49:57", "50.115.120.213");
INSERT INTO `wp_aiowps_failed_logins` VALUES("210", "0", "admin", "2022-01-31 11:58:39", "185.49.20.76");
INSERT INTO `wp_aiowps_failed_logins` VALUES("211", "0", "admin", "2022-01-31 12:17:30", "37.139.13.163");
INSERT INTO `wp_aiowps_failed_logins` VALUES("212", "0", "admin", "2022-01-31 12:18:10", "34.92.58.160");
INSERT INTO `wp_aiowps_failed_logins` VALUES("213", "1", "ucr", "2022-01-31 12:36:32", "167.86.91.247");
INSERT INTO `wp_aiowps_failed_logins` VALUES("214", "1", "ucr", "2022-01-31 12:43:16", "138.197.12.140");
INSERT INTO `wp_aiowps_failed_logins` VALUES("215", "1", "ucr", "2022-01-31 13:14:23", "212.103.4.29");
INSERT INTO `wp_aiowps_failed_logins` VALUES("216", "1", "ucr", "2022-01-31 13:21:17", "103.39.134.190");
INSERT INTO `wp_aiowps_failed_logins` VALUES("217", "1", "ucr", "2022-01-31 13:29:00", "159.65.146.8");
INSERT INTO `wp_aiowps_failed_logins` VALUES("218", "1", "ucr", "2022-01-31 13:52:42", "195.67.74.174");
INSERT INTO `wp_aiowps_failed_logins` VALUES("219", "1", "ucr", "2022-01-31 13:59:34", "110.4.40.183");
INSERT INTO `wp_aiowps_failed_logins` VALUES("220", "1", "ucr", "2022-01-31 14:51:01", "39.106.55.148");
INSERT INTO `wp_aiowps_failed_logins` VALUES("221", "1", "ucr", "2022-01-31 15:10:12", "113.165.166.18");
INSERT INTO `wp_aiowps_failed_logins` VALUES("222", "1", "ucr", "2022-01-31 15:28:29", "47.100.208.57");
INSERT INTO `wp_aiowps_failed_logins` VALUES("223", "1", "ucr", "2022-01-31 15:35:17", "133.130.103.36");
INSERT INTO `wp_aiowps_failed_logins` VALUES("224", "1", "ucr", "2022-01-31 15:47:21", "206.189.129.168");
INSERT INTO `wp_aiowps_failed_logins` VALUES("225", "1", "ucr", "2022-01-31 17:22:08", "37.255.149.133");
INSERT INTO `wp_aiowps_failed_logins` VALUES("226", "1", "ucr", "2022-01-31 18:06:07", "52.183.137.156");
INSERT INTO `wp_aiowps_failed_logins` VALUES("227", "1", "ucr", "2022-01-31 18:06:07", "52.183.137.156");
INSERT INTO `wp_aiowps_failed_logins` VALUES("228", "1", "ucr", "2022-01-31 18:24:58", "158.69.63.179");
INSERT INTO `wp_aiowps_failed_logins` VALUES("229", "1", "ucr", "2022-01-31 19:02:48", "161.35.126.102");
INSERT INTO `wp_aiowps_failed_logins` VALUES("230", "1", "ucr", "2022-01-31 19:15:38", "82.156.109.203");
INSERT INTO `wp_aiowps_failed_logins` VALUES("231", "1", "ucr", "2022-01-31 19:26:16", "63.141.251.187");
INSERT INTO `wp_aiowps_failed_logins` VALUES("232", "1", "ucr", "2022-01-31 19:34:38", "2.59.117.55");
INSERT INTO `wp_aiowps_failed_logins` VALUES("233", "1", "ucr", "2022-01-31 19:40:53", "206.189.129.168");
INSERT INTO `wp_aiowps_failed_logins` VALUES("234", "1", "ucr", "2022-01-31 20:07:24", "195.242.103.103");
INSERT INTO `wp_aiowps_failed_logins` VALUES("235", "1", "ucr", "2022-01-31 23:03:22", "88.150.159.29");
INSERT INTO `wp_aiowps_failed_logins` VALUES("236", "1", "ucr", "2022-01-31 23:23:13", "165.232.177.227");
INSERT INTO `wp_aiowps_failed_logins` VALUES("237", "1", "ucr", "2022-02-01 00:19:44", "162.240.27.242");
INSERT INTO `wp_aiowps_failed_logins` VALUES("238", "1", "ucr", "2022-02-01 01:37:06", "47.105.61.35");
INSERT INTO `wp_aiowps_failed_logins` VALUES("239", "1", "ucr", "2022-02-01 02:54:10", "185.2.5.25");
INSERT INTO `wp_aiowps_failed_logins` VALUES("240", "1", "ucr", "2022-02-01 04:11:13", "139.59.85.224");
INSERT INTO `wp_aiowps_failed_logins` VALUES("241", "1", "ucr", "2022-02-01 04:30:01", "128.199.245.21");
INSERT INTO `wp_aiowps_failed_logins` VALUES("242", "1", "ucr", "2022-02-01 13:39:07", "185.2.4.56");
INSERT INTO `wp_aiowps_failed_logins` VALUES("243", "1", "ucr", "2022-02-01 13:43:40", "92.53.123.166");
INSERT INTO `wp_aiowps_failed_logins` VALUES("244", "1", "ucr", "2022-02-01 14:03:14", "13.229.221.204");
INSERT INTO `wp_aiowps_failed_logins` VALUES("245", "1", "ucr", "2022-02-01 14:28:25", "13.81.59.92");
INSERT INTO `wp_aiowps_failed_logins` VALUES("246", "1", "ucr", "2022-02-01 14:35:59", "85.85.242.158");
INSERT INTO `wp_aiowps_failed_logins` VALUES("247", "1", "ucr", "2022-02-01 14:47:24", "163.172.175.61");
INSERT INTO `wp_aiowps_failed_logins` VALUES("248", "1", "ucr", "2022-02-01 15:37:35", "185.137.233.223");
INSERT INTO `wp_aiowps_failed_logins` VALUES("249", "1", "ucr", "2022-02-01 17:14:32", "181.174.125.214");
INSERT INTO `wp_aiowps_failed_logins` VALUES("250", "1", "ucr", "2022-02-01 17:14:32", "181.174.125.214");
INSERT INTO `wp_aiowps_failed_logins` VALUES("251", "1", "ucr", "2022-02-01 17:53:09", "68.183.75.82");
INSERT INTO `wp_aiowps_failed_logins` VALUES("252", "1", "ucr", "2022-02-01 18:26:37", "195.242.103.103");
INSERT INTO `wp_aiowps_failed_logins` VALUES("253", "1", "ucr", "2022-02-01 18:38:25", "31.192.208.12");
INSERT INTO `wp_aiowps_failed_logins` VALUES("254", "1", "ucr", "2022-02-01 18:46:09", "159.65.115.75");
INSERT INTO `wp_aiowps_failed_logins` VALUES("255", "1", "ucr", "2022-02-01 18:46:09", "159.65.115.75");
INSERT INTO `wp_aiowps_failed_logins` VALUES("256", "1", "ucr", "2022-02-01 18:50:45", "143.198.162.183");
INSERT INTO `wp_aiowps_failed_logins` VALUES("257", "1", "ucr", "2022-02-01 18:50:45", "143.198.162.183");
INSERT INTO `wp_aiowps_failed_logins` VALUES("258", "1", "ucr", "2022-02-01 19:49:17", "42.193.21.177");
INSERT INTO `wp_aiowps_failed_logins` VALUES("259", "1", "ucr", "2022-02-01 20:14:51", "52.70.81.167");
INSERT INTO `wp_aiowps_failed_logins` VALUES("260", "1", "ucr", "2022-02-01 21:20:19", "42.193.21.177");
INSERT INTO `wp_aiowps_failed_logins` VALUES("261", "1", "ucr", "2022-02-01 21:24:58", "128.199.14.4");
INSERT INTO `wp_aiowps_failed_logins` VALUES("262", "1", "ucr", "2022-02-01 21:39:35", "167.71.89.92");
INSERT INTO `wp_aiowps_failed_logins` VALUES("263", "1", "ucr", "2022-02-01 21:44:12", "80.249.174.66");
INSERT INTO `wp_aiowps_failed_logins` VALUES("264", "1", "ucr", "2022-02-01 22:18:14", "188.166.236.240");
INSERT INTO `wp_aiowps_failed_logins` VALUES("265", "1", "ucr", "2022-02-02 00:53:16", "185.2.5.25");
INSERT INTO `wp_aiowps_failed_logins` VALUES("266", "1", "ucr", "2022-02-02 01:24:40", "185.126.219.43");
INSERT INTO `wp_aiowps_failed_logins` VALUES("267", "1", "ucr", "2022-02-02 02:56:07", "162.144.63.211");
INSERT INTO `wp_aiowps_failed_logins` VALUES("268", "1", "ucr", "2022-02-02 02:56:07", "162.144.63.211");
INSERT INTO `wp_aiowps_failed_logins` VALUES("269", "1", "ucr", "2022-02-02 03:35:24", "161.35.34.204");
INSERT INTO `wp_aiowps_failed_logins` VALUES("270", "1", "ucr", "2022-02-02 03:54:59", "188.166.152.29");
INSERT INTO `wp_aiowps_failed_logins` VALUES("271", "1", "ucr", "2022-02-02 05:23:05", "69.30.229.69");
INSERT INTO `wp_aiowps_failed_logins` VALUES("272", "1", "ucr", "2022-02-09 07:01:56", "107.150.48.235");
INSERT INTO `wp_aiowps_failed_logins` VALUES("273", "1", "ucr", "2022-02-24 19:12:41", "107.150.48.237");
INSERT INTO `wp_aiowps_failed_logins` VALUES("274", "1", "ucr", "2022-02-25 20:51:23", "69.30.240.29");
INSERT INTO `wp_aiowps_failed_logins` VALUES("275", "0", "admin", "2022-02-28 15:51:59", "69.30.230.59");
INSERT INTO `wp_aiowps_failed_logins` VALUES("276", "1", "ucr", "2022-03-01 11:21:04", "69.30.229.67");
INSERT INTO `wp_aiowps_failed_logins` VALUES("277", "1", "ucr", "2022-03-01 17:01:37", "69.30.240.26");
INSERT INTO `wp_aiowps_failed_logins` VALUES("278", "1", "ucr", "2022-03-02 05:13:57", "69.30.229.68");
INSERT INTO `wp_aiowps_failed_logins` VALUES("279", "0", "admin", "2022-03-03 13:13:54", "204.12.202.91");
INSERT INTO `wp_aiowps_failed_logins` VALUES("280", "0", "admin", "2022-03-03 23:27:32", "74.91.17.84");
INSERT INTO `wp_aiowps_failed_logins` VALUES("281", "1", "ucr", "2022-03-04 19:20:52", "69.30.230.61");
INSERT INTO `wp_aiowps_failed_logins` VALUES("282", "1", "ucr", "2022-03-05 08:26:33", "74.91.17.84");
INSERT INTO `wp_aiowps_failed_logins` VALUES("283", "1", "ucr", "2022-03-05 16:05:05", "69.30.229.69");
INSERT INTO `wp_aiowps_failed_logins` VALUES("284", "0", "wildnis-in-deutschland", "2022-03-06 17:55:59", "107.150.29.143");
INSERT INTO `wp_aiowps_failed_logins` VALUES("285", "0", "wildnis-in-deutschland", "2022-03-06 17:56:00", "107.150.29.143");
INSERT INTO `wp_aiowps_failed_logins` VALUES("286", "0", "wildnis-in-deutschland", "2022-03-06 17:56:01", "107.150.29.143");
INSERT INTO `wp_aiowps_failed_logins` VALUES("287", "0", "wildnis-in-deutschland", "2022-03-06 17:56:02", "107.150.29.143");
INSERT INTO `wp_aiowps_failed_logins` VALUES("288", "0", "wildnis-in-deutschland", "2022-03-06 17:56:03", "107.150.29.143");
INSERT INTO `wp_aiowps_failed_logins` VALUES("289", "0", "wildnis-in-deutschland", "2022-03-06 17:56:04", "107.150.29.143");
INSERT INTO `wp_aiowps_failed_logins` VALUES("290", "0", "wildnis-in-deutschland", "2022-03-06 17:56:05", "107.150.29.143");
INSERT INTO `wp_aiowps_failed_logins` VALUES("291", "0", "wildnis-in-deutschland", "2022-03-06 17:56:06", "107.150.29.143");
INSERT INTO `wp_aiowps_failed_logins` VALUES("292", "0", "wildnis-in-deutschland", "2022-03-06 17:56:07", "107.150.29.143");
INSERT INTO `wp_aiowps_failed_logins` VALUES("293", "0", "wildnis-in-deutschland", "2022-03-06 17:56:07", "107.150.29.143");
INSERT INTO `wp_aiowps_failed_logins` VALUES("294", "0", "wildnis-in-deutschland", "2022-03-06 17:56:08", "107.150.29.143");
INSERT INTO `wp_aiowps_failed_logins` VALUES("295", "0", "wildnis-in-deutschland", "2022-03-06 17:56:08", "107.150.29.143");
INSERT INTO `wp_aiowps_failed_logins` VALUES("296", "0", "wildnis-in-deutschland", "2022-03-06 17:56:09", "107.150.29.143");
INSERT INTO `wp_aiowps_failed_logins` VALUES("297", "0", "wildnis-in-deutschland", "2022-03-06 17:56:10", "107.150.29.143");
INSERT INTO `wp_aiowps_failed_logins` VALUES("298", "0", "wildnis-in-deutschland", "2022-03-06 17:56:11", "107.150.29.143");
INSERT INTO `wp_aiowps_failed_logins` VALUES("299", "0", "wildnis-in-deutschland", "2022-03-06 17:56:11", "107.150.29.143");
INSERT INTO `wp_aiowps_failed_logins` VALUES("300", "0", "wildnis-in-deutschland", "2022-03-06 17:56:11", "107.150.29.143");
INSERT INTO `wp_aiowps_failed_logins` VALUES("301", "0", "wildnis-in-deutschland", "2022-03-06 17:56:11", "107.150.29.143");
INSERT INTO `wp_aiowps_failed_logins` VALUES("302", "0", "wildnis-in-deutschland", "2022-03-06 17:56:12", "107.150.29.143");
INSERT INTO `wp_aiowps_failed_logins` VALUES("303", "0", "admin", "2022-03-07 11:40:55", "69.30.229.70");
INSERT INTO `wp_aiowps_failed_logins` VALUES("304", "0", "nb11", "2022-03-25 23:39:39", "89.187.165.102");
INSERT INTO `wp_aiowps_failed_logins` VALUES("305", "0", "nb11", "2022-03-25 23:39:39", "89.187.165.102");
INSERT INTO `wp_aiowps_failed_logins` VALUES("306", "0", "nb11", "2022-03-25 23:39:40", "89.187.165.102");
INSERT INTO `wp_aiowps_failed_logins` VALUES("307", "0", "nb11", "2022-03-25 23:39:40", "89.187.165.102");
INSERT INTO `wp_aiowps_failed_logins` VALUES("308", "0", "nb11", "2022-03-25 23:39:40", "89.187.165.102");
INSERT INTO `wp_aiowps_failed_logins` VALUES("309", "0", "nb11", "2022-03-25 23:39:41", "89.187.165.102");
INSERT INTO `wp_aiowps_failed_logins` VALUES("310", "0", "nb11", "2022-03-25 23:39:42", "89.187.165.102");
INSERT INTO `wp_aiowps_failed_logins` VALUES("311", "0", "nb11", "2022-03-25 23:39:42", "89.187.165.102");
INSERT INTO `wp_aiowps_failed_logins` VALUES("312", "0", "nb11", "2022-03-25 23:39:43", "89.187.165.102");
INSERT INTO `wp_aiowps_failed_logins` VALUES("313", "0", "nb11", "2022-03-25 23:39:44", "89.187.165.102");
INSERT INTO `wp_aiowps_failed_logins` VALUES("314", "0", "nb11", "2022-03-25 23:39:44", "89.187.165.102");
INSERT INTO `wp_aiowps_failed_logins` VALUES("315", "0", "nb11", "2022-03-25 23:39:44", "89.187.165.102");
INSERT INTO `wp_aiowps_failed_logins` VALUES("316", "0", "nb11", "2022-03-25 23:39:45", "89.187.165.102");
INSERT INTO `wp_aiowps_failed_logins` VALUES("317", "0", "nb11", "2022-03-25 23:39:45", "89.187.165.102");
INSERT INTO `wp_aiowps_failed_logins` VALUES("318", "0", "nb11", "2022-03-25 23:39:46", "89.187.165.102");
INSERT INTO `wp_aiowps_failed_logins` VALUES("319", "0", "nb11", "2022-03-25 23:39:46", "89.187.165.102");
INSERT INTO `wp_aiowps_failed_logins` VALUES("320", "0", "nb11", "2022-03-25 23:39:47", "89.187.165.102");
INSERT INTO `wp_aiowps_failed_logins` VALUES("321", "0", "nb11", "2022-03-25 23:39:47", "89.187.165.102");
INSERT INTO `wp_aiowps_failed_logins` VALUES("322", "0", "nb11", "2022-03-25 23:39:48", "89.187.165.102");
INSERT INTO `wp_aiowps_failed_logins` VALUES("323", "1", "ucr", "2022-03-26 23:53:55", "74.91.17.84");
INSERT INTO `wp_aiowps_failed_logins` VALUES("324", "1", "ucr", "2022-03-27 23:21:48", "192.187.127.21");
INSERT INTO `wp_aiowps_failed_logins` VALUES("325", "1", "ucr", "2022-03-28 14:48:31", "69.197.155.228");
INSERT INTO `wp_aiowps_failed_logins` VALUES("326", "0", "admin", "2022-03-29 02:28:52", "69.30.230.60");
INSERT INTO `wp_aiowps_failed_logins` VALUES("327", "1", "ucr", "2022-03-29 08:17:26", "69.197.154.19");
INSERT INTO `wp_aiowps_failed_logins` VALUES("328", "1", "ucr", "2022-04-01 15:43:13", "204.12.215.61");
INSERT INTO `wp_aiowps_failed_logins` VALUES("329", "1", "ucr", "2022-04-02 06:09:41", "63.141.252.67");
INSERT INTO `wp_aiowps_failed_logins` VALUES("330", "1", "ucr", "2022-04-02 10:10:03", "69.197.155.229");
INSERT INTO `wp_aiowps_failed_logins` VALUES("331", "1", "ucr", "2022-04-03 02:18:18", "192.187.127.22");
INSERT INTO `wp_aiowps_failed_logins` VALUES("332", "1", "ucr", "2022-04-08 01:18:14", "69.30.229.69");
INSERT INTO `wp_aiowps_failed_logins` VALUES("333", "1", "ucr", "2022-04-10 05:38:27", "107.150.36.76");
INSERT INTO `wp_aiowps_failed_logins` VALUES("334", "1", "ucr", "2022-04-10 21:05:12", "69.197.155.227");
INSERT INTO `wp_aiowps_failed_logins` VALUES("335", "1", "ucr", "2022-04-11 06:32:32", "69.30.229.69");
INSERT INTO `wp_aiowps_failed_logins` VALUES("336", "1", "ucr", "2022-04-11 11:43:31", "173.208.153.156");
INSERT INTO `wp_aiowps_failed_logins` VALUES("337", "1", "ucr", "2022-04-11 21:07:21", "173.208.153.156");
INSERT INTO `wp_aiowps_failed_logins` VALUES("338", "1", "ucr", "2022-04-12 01:19:11", "192.187.127.22");
INSERT INTO `wp_aiowps_failed_logins` VALUES("339", "1", "ucr", "2022-04-12 01:34:11", "69.30.229.69");
INSERT INTO `wp_aiowps_failed_logins` VALUES("340", "1", "ucr", "2022-04-12 19:00:45", "63.141.252.69");
INSERT INTO `wp_aiowps_failed_logins` VALUES("341", "1", "ucr", "2022-05-05 14:16:50", "192.187.127.20");
INSERT INTO `wp_aiowps_failed_logins` VALUES("342", "1", "ucr", "2022-05-07 23:42:03", "173.208.153.156");
INSERT INTO `wp_aiowps_failed_logins` VALUES("343", "1", "ucr", "2022-05-09 14:00:31", "173.208.153.157");
INSERT INTO `wp_aiowps_failed_logins` VALUES("344", "1", "ucr", "2022-05-10 18:25:40", "173.208.153.157");
INSERT INTO `wp_aiowps_failed_logins` VALUES("345", "1", "ucr", "2022-05-11 06:11:11", "124.106.71.219");
INSERT INTO `wp_aiowps_failed_logins` VALUES("346", "1", "ucr", "2022-05-11 06:19:36", "208.110.66.139");
INSERT INTO `wp_aiowps_failed_logins` VALUES("347", "0", "admin", "2022-05-11 06:44:51", "204.12.215.62");
INSERT INTO `wp_aiowps_failed_logins` VALUES("348", "1", "ucr", "2022-05-11 08:27:35", "128.199.197.163");
INSERT INTO `wp_aiowps_failed_logins` VALUES("349", "1", "ucr", "2022-05-11 09:25:12", "139.59.96.76");
INSERT INTO `wp_aiowps_failed_logins` VALUES("350", "1", "ucr", "2022-05-12 10:03:45", "69.30.230.59");
INSERT INTO `wp_aiowps_failed_logins` VALUES("351", "0", "admin", "2022-05-12 11:19:30", "69.30.230.59");
INSERT INTO `wp_aiowps_failed_logins` VALUES("352", "1", "ucr", "2022-05-13 20:12:53", "208.110.66.139");
INSERT INTO `wp_aiowps_failed_logins` VALUES("353", "0", "admin", "2022-05-14 16:24:22", "217.182.175.39");
INSERT INTO `wp_aiowps_failed_logins` VALUES("354", "0", "admin", "2022-05-14 16:33:57", "137.184.117.52");
INSERT INTO `wp_aiowps_failed_logins` VALUES("355", "0", "admin", "2022-05-14 16:36:37", "51.178.93.87");
INSERT INTO `wp_aiowps_failed_logins` VALUES("356", "0", "admin", "2022-05-14 17:23:16", "13.81.59.92");
INSERT INTO `wp_aiowps_failed_logins` VALUES("357", "0", "admin", "2022-05-14 19:39:20", "167.71.141.164");
INSERT INTO `wp_aiowps_failed_logins` VALUES("358", "0", "admin", "2022-05-14 22:46:57", "8.210.146.161");
INSERT INTO `wp_aiowps_failed_logins` VALUES("359", "0", "admin", "2022-05-14 22:49:59", "47.90.246.252");
INSERT INTO `wp_aiowps_failed_logins` VALUES("360", "0", "admin", "2022-05-14 23:26:12", "47.241.15.39");
INSERT INTO `wp_aiowps_failed_logins` VALUES("361", "0", "admin", "2022-05-14 23:26:12", "47.241.15.39");
INSERT INTO `wp_aiowps_failed_logins` VALUES("362", "0", "admin", "2022-05-15 00:14:15", "128.199.197.163");
INSERT INTO `wp_aiowps_failed_logins` VALUES("363", "0", "admin", "2022-05-15 00:47:44", "185.23.130.9");
INSERT INTO `wp_aiowps_failed_logins` VALUES("364", "0", "admin", "2022-05-15 00:59:25", "173.212.235.115");
INSERT INTO `wp_aiowps_failed_logins` VALUES("365", "0", "admin", "2022-05-15 00:59:47", "15.236.47.51");
INSERT INTO `wp_aiowps_failed_logins` VALUES("366", "0", "admin", "2022-05-15 01:36:07", "157.245.48.104");
INSERT INTO `wp_aiowps_failed_logins` VALUES("367", "0", "admin", "2022-05-15 02:24:25", "143.244.143.195");
INSERT INTO `wp_aiowps_failed_logins` VALUES("368", "0", "admin", "2022-05-15 03:53:12", "82.156.109.203");
INSERT INTO `wp_aiowps_failed_logins` VALUES("369", "0", "admin", "2022-05-15 04:17:47", "161.35.52.207");
INSERT INTO `wp_aiowps_failed_logins` VALUES("370", "0", "plai", "2022-05-16 04:33:47", "89.108.126.154");
INSERT INTO `wp_aiowps_failed_logins` VALUES("371", "0", "admin", "2022-05-16 08:36:34", "104.152.222.36");
INSERT INTO `wp_aiowps_failed_logins` VALUES("372", "0", "admin", "2022-05-16 08:36:35", "104.152.222.36");
INSERT INTO `wp_aiowps_failed_logins` VALUES("373", "0", "admin", "2022-05-16 08:36:36", "104.152.222.36");
INSERT INTO `wp_aiowps_failed_logins` VALUES("374", "0", "admin", "2022-05-16 08:36:37", "104.152.222.36");
INSERT INTO `wp_aiowps_failed_logins` VALUES("375", "0", "admin", "2022-05-16 08:36:38", "104.152.222.36");
INSERT INTO `wp_aiowps_failed_logins` VALUES("376", "0", "admin", "2022-05-16 08:36:39", "104.152.222.36");
INSERT INTO `wp_aiowps_failed_logins` VALUES("377", "0", "admin", "2022-05-16 08:36:40", "104.152.222.36");
INSERT INTO `wp_aiowps_failed_logins` VALUES("378", "0", "admin", "2022-05-16 08:36:41", "104.152.222.36");
INSERT INTO `wp_aiowps_failed_logins` VALUES("379", "0", "admin", "2022-05-16 08:36:42", "104.152.222.36");
INSERT INTO `wp_aiowps_failed_logins` VALUES("380", "0", "admin", "2022-05-16 08:36:42", "104.152.222.36");
INSERT INTO `wp_aiowps_failed_logins` VALUES("381", "0", "admin", "2022-05-16 08:36:43", "104.152.222.36");
INSERT INTO `wp_aiowps_failed_logins` VALUES("382", "0", "admin", "2022-05-16 08:36:43", "104.152.222.36");
INSERT INTO `wp_aiowps_failed_logins` VALUES("383", "0", "admin", "2022-05-16 08:36:44", "104.152.222.36");
INSERT INTO `wp_aiowps_failed_logins` VALUES("384", "0", "admin", "2022-05-16 08:36:45", "104.152.222.36");
INSERT INTO `wp_aiowps_failed_logins` VALUES("385", "0", "admin", "2022-05-16 08:36:46", "104.152.222.36");
INSERT INTO `wp_aiowps_failed_logins` VALUES("386", "0", "admin", "2022-05-16 08:36:46", "104.152.222.36");
INSERT INTO `wp_aiowps_failed_logins` VALUES("387", "0", "admin", "2022-05-16 08:36:47", "104.152.222.36");
INSERT INTO `wp_aiowps_failed_logins` VALUES("388", "0", "admin", "2022-05-16 08:36:47", "104.152.222.36");
INSERT INTO `wp_aiowps_failed_logins` VALUES("389", "0", "admin", "2022-05-16 08:36:48", "104.152.222.36");
INSERT INTO `wp_aiowps_failed_logins` VALUES("390", "1", "ucr", "2022-05-18 21:15:55", "107.150.36.78");
INSERT INTO `wp_aiowps_failed_logins` VALUES("391", "1", "ucr", "2022-05-18 22:33:31", "69.197.155.228");
INSERT INTO `wp_aiowps_failed_logins` VALUES("392", "1", "ucr", "2022-05-18 22:53:00", "208.110.66.141");
INSERT INTO `wp_aiowps_failed_logins` VALUES("393", "1", "ucr", "2022-05-18 23:18:09", "208.110.66.141");
INSERT INTO `wp_aiowps_failed_logins` VALUES("394", "1", "ucr", "2022-05-19 03:29:08", "69.30.230.60");
INSERT INTO `wp_aiowps_failed_logins` VALUES("395", "1", "ucr", "2022-05-19 13:14:18", "69.30.230.60");
INSERT INTO `wp_aiowps_failed_logins` VALUES("396", "0", "admin", "2022-05-23 03:15:01", "162.243.9.114");
INSERT INTO `wp_aiowps_failed_logins` VALUES("397", "1", "ucr", "2022-05-24 10:11:54", "5.9.116.144");
INSERT INTO `wp_aiowps_failed_logins` VALUES("398", "1", "ucr", "2022-05-24 10:39:31", "141.94.247.170");
INSERT INTO `wp_aiowps_failed_logins` VALUES("399", "1", "ucr", "2022-05-24 11:42:09", "103.39.134.190");
INSERT INTO `wp_aiowps_failed_logins` VALUES("400", "1", "ucr", "2022-05-24 11:56:02", "161.35.126.102");
INSERT INTO `wp_aiowps_failed_logins` VALUES("401", "1", "ucr", "2022-05-24 13:19:50", "35.197.204.193");
INSERT INTO `wp_aiowps_failed_logins` VALUES("402", "1", "ucr", "2022-05-24 14:11:40", "178.128.187.183");
INSERT INTO `wp_aiowps_failed_logins` VALUES("403", "1", "ucr", "2022-05-24 14:11:40", "178.128.187.183");
INSERT INTO `wp_aiowps_failed_logins` VALUES("404", "1", "ucr", "2022-05-24 14:44:07", "185.2.5.77");
INSERT INTO `wp_aiowps_failed_logins` VALUES("405", "1", "ucr", "2022-05-25 17:01:58", "173.208.153.155");
INSERT INTO `wp_aiowps_failed_logins` VALUES("406", "0", "admin", "2022-05-26 09:56:12", "69.30.229.68");
INSERT INTO `wp_aiowps_failed_logins` VALUES("407", "0", "admin", "2022-05-27 01:47:20", "190.110.197.116");
INSERT INTO `wp_aiowps_failed_logins` VALUES("408", "1", "ucr", "2022-05-27 16:31:47", "204.12.202.93");
INSERT INTO `wp_aiowps_failed_logins` VALUES("409", "1", "ucr", "2022-05-27 20:56:24", "69.30.229.69");
INSERT INTO `wp_aiowps_failed_logins` VALUES("410", "0", "admin", "2022-05-28 06:28:29", "192.187.127.20");
INSERT INTO `wp_aiowps_failed_logins` VALUES("411", "1", "ucr", "2022-05-28 23:20:54", "69.197.154.19");
INSERT INTO `wp_aiowps_failed_logins` VALUES("412", "0", "admin", "2022-05-31 02:13:40", "204.12.255.62");
INSERT INTO `wp_aiowps_failed_logins` VALUES("413", "0", "admin", "2022-05-31 13:15:04", "185.220.101.79");
INSERT INTO `wp_aiowps_failed_logins` VALUES("414", "0", "admin1", "2022-05-31 14:53:15", "23.128.248.65");
INSERT INTO `wp_aiowps_failed_logins` VALUES("415", "0", "admin", "2022-05-31 16:09:18", "104.244.73.93");
INSERT INTO `wp_aiowps_failed_logins` VALUES("416", "0", "admin", "2022-06-07 02:20:54", "190.110.197.116");
INSERT INTO `wp_aiowps_failed_logins` VALUES("417", "0", "admin", "2022-06-15 03:22:21", "159.203.120.246");
INSERT INTO `wp_aiowps_failed_logins` VALUES("418", "0", "admin", "2022-06-15 08:32:29", "39.108.148.88");
INSERT INTO `wp_aiowps_failed_logins` VALUES("419", "0", "admin", "2022-06-15 08:38:09", "178.62.35.35");
INSERT INTO `wp_aiowps_failed_logins` VALUES("420", "0", "admin", "2022-06-15 09:16:09", "134.209.231.225");
INSERT INTO `wp_aiowps_failed_logins` VALUES("421", "0", "admin", "2022-06-15 09:40:58", "209.97.151.249");
INSERT INTO `wp_aiowps_failed_logins` VALUES("422", "0", "admin", "2022-06-15 09:50:49", "68.79.63.93");
INSERT INTO `wp_aiowps_failed_logins` VALUES("423", "0", "admin", "2022-06-16 00:37:11", "106.53.136.24");
INSERT INTO `wp_aiowps_failed_logins` VALUES("424", "0", "admin", "2022-06-18 17:36:00", "194.67.91.197");
INSERT INTO `wp_aiowps_failed_logins` VALUES("425", "0", "admin", "2022-06-19 03:17:09", "213.108.110.135");
INSERT INTO `wp_aiowps_failed_logins` VALUES("426", "0", "admin", "2022-06-19 04:00:33", "167.172.64.96");
INSERT INTO `wp_aiowps_failed_logins` VALUES("427", "1", "ucr", "2022-06-19 17:45:45", "107.150.36.75");
INSERT INTO `wp_aiowps_failed_logins` VALUES("428", "0", "admin", "2022-06-19 17:53:51", "31.192.208.12");
INSERT INTO `wp_aiowps_failed_logins` VALUES("429", "0", "admin", "2022-06-22 20:12:56", "67.205.43.116");
INSERT INTO `wp_aiowps_failed_logins` VALUES("430", "0", "admin", "2022-06-22 20:12:56", "67.205.43.116");
INSERT INTO `wp_aiowps_failed_logins` VALUES("431", "0", "admin", "2022-06-22 20:15:32", "142.93.245.196");
INSERT INTO `wp_aiowps_failed_logins` VALUES("432", "0", "admin", "2022-06-22 20:15:32", "142.93.245.196");
INSERT INTO `wp_aiowps_failed_logins` VALUES("433", "0", "admin", "2022-06-22 20:40:55", "52.166.3.59");
INSERT INTO `wp_aiowps_failed_logins` VALUES("434", "0", "admin", "2022-06-22 20:50:54", "167.172.105.95");
INSERT INTO `wp_aiowps_failed_logins` VALUES("435", "0", "admin", "2022-06-22 20:53:28", "8.131.62.110");
INSERT INTO `wp_aiowps_failed_logins` VALUES("436", "0", "admin", "2022-06-22 21:06:02", "68.183.75.82");
INSERT INTO `wp_aiowps_failed_logins` VALUES("437", "0", "admin", "2022-06-22 21:15:52", "13.81.59.92");
INSERT INTO `wp_aiowps_failed_logins` VALUES("438", "0", "admin", "2022-06-22 21:15:52", "13.81.59.92");
INSERT INTO `wp_aiowps_failed_logins` VALUES("439", "0", "admin", "2022-06-22 21:28:09", "134.209.231.225");
INSERT INTO `wp_aiowps_failed_logins` VALUES("440", "0", "admin", "2022-06-22 22:31:06", "103.129.222.91");
INSERT INTO `wp_aiowps_failed_logins` VALUES("441", "0", "admin", "2022-06-23 12:08:49", "34.75.65.218");
INSERT INTO `wp_aiowps_failed_logins` VALUES("442", "0", "admin", "2022-06-23 21:05:48", "47.90.246.252");
INSERT INTO `wp_aiowps_failed_logins` VALUES("443", "0", "admin", "2022-06-23 21:11:06", "162.215.209.125");
INSERT INTO `wp_aiowps_failed_logins` VALUES("444", "0", "admin", "2022-06-23 22:40:59", "209.97.151.249");
INSERT INTO `wp_aiowps_failed_logins` VALUES("445", "0", "admin", "2022-06-23 23:29:55", "188.166.183.39");
INSERT INTO `wp_aiowps_failed_logins` VALUES("446", "0", "admin", "2022-06-24 02:51:02", "103.28.114.94");
INSERT INTO `wp_aiowps_failed_logins` VALUES("447", "0", "admin", "2022-06-24 12:20:10", "51.159.155.6");
INSERT INTO `wp_aiowps_failed_logins` VALUES("448", "0", "admin", "2022-06-24 16:06:00", "143.244.143.195");
INSERT INTO `wp_aiowps_failed_logins` VALUES("449", "0", "admin", "2022-06-24 17:50:03", "181.174.125.214");
INSERT INTO `wp_aiowps_failed_logins` VALUES("450", "0", "admin", "2022-06-24 20:02:08", "111.231.200.129");
INSERT INTO `wp_aiowps_failed_logins` VALUES("451", "0", "admin", "2022-06-25 05:14:17", "217.182.175.39");
INSERT INTO `wp_aiowps_failed_logins` VALUES("452", "0", "admin", "2022-06-25 05:56:20", "68.79.63.93");
INSERT INTO `wp_aiowps_failed_logins` VALUES("453", "0", "admin", "2022-06-25 16:50:26", "212.110.92.155");
INSERT INTO `wp_aiowps_failed_logins` VALUES("454", "0", "admin", "2022-06-25 22:59:20", "159.223.170.181");
INSERT INTO `wp_aiowps_failed_logins` VALUES("455", "0", "admin", "2022-06-26 04:50:46", "159.65.200.228");
INSERT INTO `wp_aiowps_failed_logins` VALUES("456", "0", "admin", "2022-06-26 17:40:44", "103.57.220.186");
INSERT INTO `wp_aiowps_failed_logins` VALUES("457", "0", "admin", "2022-06-26 19:35:32", "39.103.157.70");
INSERT INTO `wp_aiowps_failed_logins` VALUES("458", "0", "admin", "2022-06-27 19:45:04", "124.153.66.86");
INSERT INTO `wp_aiowps_failed_logins` VALUES("459", "0", "admin", "2022-06-28 19:13:51", "103.28.37.180");
INSERT INTO `wp_aiowps_failed_logins` VALUES("460", "0", "admin", "2022-06-29 08:48:45", "68.79.63.93");
INSERT INTO `wp_aiowps_failed_logins` VALUES("461", "0", "admin", "2022-06-30 23:39:13", "47.100.208.57");
INSERT INTO `wp_aiowps_failed_logins` VALUES("462", "0", "admin", "2022-07-01 07:08:30", "47.98.207.210");
INSERT INTO `wp_aiowps_failed_logins` VALUES("463", "0", "admin", "2022-07-01 07:49:03", "46.101.150.34");
INSERT INTO `wp_aiowps_failed_logins` VALUES("464", "0", "admin", "2022-07-01 08:27:16", "159.89.109.117");
INSERT INTO `wp_aiowps_failed_logins` VALUES("465", "0", "admin", "2022-07-01 08:29:22", "121.42.231.47");
INSERT INTO `wp_aiowps_failed_logins` VALUES("466", "0", "admin", "2022-07-01 09:43:56", "34.77.106.220");
INSERT INTO `wp_aiowps_failed_logins` VALUES("467", "0", "admin", "2022-07-01 09:43:59", "68.183.71.174");
INSERT INTO `wp_aiowps_failed_logins` VALUES("468", "0", "admin", "2022-07-01 10:03:18", "208.113.160.8");
INSERT INTO `wp_aiowps_failed_logins` VALUES("469", "0", "admin", "2022-07-01 10:03:20", "138.201.201.6");
INSERT INTO `wp_aiowps_failed_logins` VALUES("470", "0", "admin", "2022-07-01 10:05:27", "167.71.234.124");
INSERT INTO `wp_aiowps_failed_logins` VALUES("471", "0", "admin", "2022-07-01 10:22:43", "138.68.67.56");
INSERT INTO `wp_aiowps_failed_logins` VALUES("472", "0", "admin", "2022-07-01 10:22:48", "164.46.122.50");
INSERT INTO `wp_aiowps_failed_logins` VALUES("473", "0", "admin", "2022-07-01 10:24:50", "188.166.183.39");
INSERT INTO `wp_aiowps_failed_logins` VALUES("474", "0", "admin", "2022-07-01 10:42:07", "151.106.39.173");
INSERT INTO `wp_aiowps_failed_logins` VALUES("475", "0", "admin", "2022-07-01 10:42:11", "51.77.223.62");
INSERT INTO `wp_aiowps_failed_logins` VALUES("476", "0", "admin", "2022-07-01 10:44:12", "35.224.250.64");
INSERT INTO `wp_aiowps_failed_logins` VALUES("477", "0", "admin", "2022-07-01 11:01:37", "194.90.234.21");
INSERT INTO `wp_aiowps_failed_logins` VALUES("478", "0", "admin", "2022-07-01 11:01:41", "13.79.17.158");
INSERT INTO `wp_aiowps_failed_logins` VALUES("479", "0", "admin", "2022-07-01 11:03:43", "161.35.126.102");
INSERT INTO `wp_aiowps_failed_logins` VALUES("480", "0", "admin", "2022-07-01 11:21:19", "8.130.55.145");
INSERT INTO `wp_aiowps_failed_logins` VALUES("481", "0", "admin", "2022-07-01 11:21:20", "51.91.220.143");
INSERT INTO `wp_aiowps_failed_logins` VALUES("482", "0", "admin", "2022-07-01 11:23:22", "162.240.27.242");
INSERT INTO `wp_aiowps_failed_logins` VALUES("483", "0", "admin", "2022-07-01 11:40:50", "67.205.39.9");
INSERT INTO `wp_aiowps_failed_logins` VALUES("484", "0", "admin", "2022-07-01 11:40:52", "35.241.156.161");
INSERT INTO `wp_aiowps_failed_logins` VALUES("485", "0", "admin", "2022-07-01 11:42:54", "188.34.183.162");
INSERT INTO `wp_aiowps_failed_logins` VALUES("486", "0", "admin", "2022-07-01 12:00:55", "35.241.156.161");
INSERT INTO `wp_aiowps_failed_logins` VALUES("487", "0", "admin", "2022-07-01 12:00:58", "67.205.1.9");
INSERT INTO `wp_aiowps_failed_logins` VALUES("488", "0", "admin", "2022-07-01 12:03:10", "213.175.66.138");
INSERT INTO `wp_aiowps_failed_logins` VALUES("489", "0", "admin", "2022-07-01 15:36:05", "139.59.150.45");
INSERT INTO `wp_aiowps_failed_logins` VALUES("490", "0", "admin", "2022-07-04 17:20:51", "151.106.41.64");
INSERT INTO `wp_aiowps_failed_logins` VALUES("491", "0", "admin", "2022-07-04 21:15:34", "185.2.5.25");
INSERT INTO `wp_aiowps_failed_logins` VALUES("492", "0", "admin", "2022-07-05 01:19:12", "167.71.234.124");
INSERT INTO `wp_aiowps_failed_logins` VALUES("493", "0", "admin", "2022-07-05 04:55:48", "139.59.96.76");
INSERT INTO `wp_aiowps_failed_logins` VALUES("494", "0", "admin", "2022-07-05 05:44:34", "144.217.15.207");
INSERT INTO `wp_aiowps_failed_logins` VALUES("495", "0", "admin", "2022-07-06 13:46:13", "103.42.58.102");
INSERT INTO `wp_aiowps_failed_logins` VALUES("496", "0", "admin", "2022-07-06 13:54:32", "157.0.140.186");
INSERT INTO `wp_aiowps_failed_logins` VALUES("497", "0", "admin", "2022-07-07 01:30:30", "103.129.222.91");
INSERT INTO `wp_aiowps_failed_logins` VALUES("498", "0", "admin", "2022-07-07 01:30:30", "103.129.222.91");
INSERT INTO `wp_aiowps_failed_logins` VALUES("499", "0", "admin", "2022-07-07 12:28:49", "208.113.180.18");
INSERT INTO `wp_aiowps_failed_logins` VALUES("500", "0", "admin", "2022-07-07 21:31:26", "143.244.155.35");
INSERT INTO `wp_aiowps_failed_logins` VALUES("501", "0", "admin", "2022-07-07 21:31:26", "143.244.155.35");
INSERT INTO `wp_aiowps_failed_logins` VALUES("502", "0", "admin", "2022-07-08 13:23:30", "194.233.67.249");
INSERT INTO `wp_aiowps_failed_logins` VALUES("503", "0", "admin", "2022-07-08 17:48:10", "51.75.15.189");
INSERT INTO `wp_aiowps_failed_logins` VALUES("504", "0", "admin", "2022-07-10 11:26:02", "168.119.80.254");
INSERT INTO `wp_aiowps_failed_logins` VALUES("505", "0", "admin", "2022-07-10 12:35:19", "134.209.184.76");
INSERT INTO `wp_aiowps_failed_logins` VALUES("506", "0", "admin", "2022-07-11 03:17:18", "188.127.231.190");
INSERT INTO `wp_aiowps_failed_logins` VALUES("507", "0", "admin", "2022-07-12 02:47:51", "64.225.65.31");
INSERT INTO `wp_aiowps_failed_logins` VALUES("508", "0", "admin", "2022-07-12 04:41:51", "51.75.15.189");
INSERT INTO `wp_aiowps_failed_logins` VALUES("509", "0", "admin", "2022-07-12 05:49:50", "147.135.255.8");
INSERT INTO `wp_aiowps_failed_logins` VALUES("510", "0", "admin", "2022-07-12 11:12:27", "82.166.39.15");
INSERT INTO `wp_aiowps_failed_logins` VALUES("511", "0", "admin", "2022-07-12 13:35:30", "103.130.218.189");
INSERT INTO `wp_aiowps_failed_logins` VALUES("512", "0", "admin", "2022-07-12 20:13:55", "185.2.5.77");
INSERT INTO `wp_aiowps_failed_logins` VALUES("513", "0", "admin", "2022-07-13 11:53:51", "95.111.196.19");
INSERT INTO `wp_aiowps_failed_logins` VALUES("514", "0", "admin", "2022-07-15 18:46:02", "13.79.17.158");
INSERT INTO `wp_aiowps_failed_logins` VALUES("515", "0", "admin", "2022-07-15 22:07:07", "139.59.80.50");
INSERT INTO `wp_aiowps_failed_logins` VALUES("516", "0", "admin", "2022-07-15 22:07:07", "139.59.80.50");
INSERT INTO `wp_aiowps_failed_logins` VALUES("517", "0", "admin", "2022-07-15 22:17:48", "165.22.0.191");
INSERT INTO `wp_aiowps_failed_logins` VALUES("518", "0", "admin", "2022-07-16 06:56:23", "123.25.21.16");
INSERT INTO `wp_aiowps_failed_logins` VALUES("519", "0", "admin", "2022-07-16 10:13:16", "159.65.76.38");
INSERT INTO `wp_aiowps_failed_logins` VALUES("520", "0", "admin", "2022-07-16 13:36:09", "82.204.204.250");
INSERT INTO `wp_aiowps_failed_logins` VALUES("521", "0", "admin", "2022-07-16 13:51:00", "209.97.151.249");
INSERT INTO `wp_aiowps_failed_logins` VALUES("522", "0", "admin", "2022-07-16 14:05:58", "185.190.117.89");
INSERT INTO `wp_aiowps_failed_logins` VALUES("523", "0", "admin", "2022-07-16 14:20:37", "34.75.65.218");
INSERT INTO `wp_aiowps_failed_logins` VALUES("524", "0", "admin", "2022-07-18 20:20:01", "88.198.14.131");
INSERT INTO `wp_aiowps_failed_logins` VALUES("525", "0", "admin", "2022-07-19 01:05:44", "77.240.13.186");
INSERT INTO `wp_aiowps_failed_logins` VALUES("526", "0", "admin", "2022-07-19 01:48:28", "142.93.201.0");
INSERT INTO `wp_aiowps_failed_logins` VALUES("527", "0", "admin", "2022-07-19 07:01:38", "54.37.156.240");
INSERT INTO `wp_aiowps_failed_logins` VALUES("528", "0", "admin", "2022-07-19 12:35:19", "195.250.67.106");
INSERT INTO `wp_aiowps_failed_logins` VALUES("529", "0", "admin", "2022-07-19 14:17:20", "188.166.183.39");
INSERT INTO `wp_aiowps_failed_logins` VALUES("530", "0", "admin", "2022-07-19 14:22:29", "103.130.219.13");
INSERT INTO `wp_aiowps_failed_logins` VALUES("531", "0", "admin", "2022-07-19 15:05:24", "104.248.225.59");
INSERT INTO `wp_aiowps_failed_logins` VALUES("532", "0", "admin", "2022-07-21 09:06:45", "37.187.154.95");
INSERT INTO `wp_aiowps_failed_logins` VALUES("533", "0", "admin", "2022-07-21 16:43:05", "165.22.0.191");
INSERT INTO `wp_aiowps_failed_logins` VALUES("534", "0", "admin", "2022-07-21 17:01:37", "82.166.39.15");
INSERT INTO `wp_aiowps_failed_logins` VALUES("535", "0", "admin", "2022-07-21 18:45:49", "13.81.59.92");
INSERT INTO `wp_aiowps_failed_logins` VALUES("536", "0", "admin", "2022-07-22 05:04:48", "69.163.152.108");
INSERT INTO `wp_aiowps_failed_logins` VALUES("537", "0", "admin", "2022-07-22 08:50:28", "202.21.38.119");
INSERT INTO `wp_aiowps_failed_logins` VALUES("538", "0", "admin", "2022-07-22 16:35:47", "216.139.241.148");
INSERT INTO `wp_aiowps_failed_logins` VALUES("539", "0", "admin", "2022-07-22 23:33:10", "159.203.143.36");
INSERT INTO `wp_aiowps_failed_logins` VALUES("540", "0", "admin", "2022-07-23 00:35:07", "8.131.62.110");
INSERT INTO `wp_aiowps_failed_logins` VALUES("541", "0", "admin", "2022-07-23 04:51:20", "69.163.224.107");
INSERT INTO `wp_aiowps_failed_logins` VALUES("542", "0", "admin", "2022-07-23 05:59:46", "212.103.4.29");
INSERT INTO `wp_aiowps_failed_logins` VALUES("543", "0", "admin", "2022-07-23 08:48:04", "8.210.146.161");
INSERT INTO `wp_aiowps_failed_logins` VALUES("544", "0", "admin", "2022-07-23 08:48:31", "139.59.85.224");
INSERT INTO `wp_aiowps_failed_logins` VALUES("545", "0", "admin", "2022-07-23 20:28:54", "120.25.104.120");
INSERT INTO `wp_aiowps_failed_logins` VALUES("546", "0", "admin", "2022-07-23 21:34:40", "195.93.152.83");
INSERT INTO `wp_aiowps_failed_logins` VALUES("547", "0", "admin", "2022-07-23 23:09:48", "35.241.156.161");
INSERT INTO `wp_aiowps_failed_logins` VALUES("548", "0", "admin", "2022-07-24 00:16:02", "47.114.72.18");
INSERT INTO `wp_aiowps_failed_logins` VALUES("549", "0", "admin", "2022-07-24 17:36:17", "51.91.220.143");
INSERT INTO `wp_aiowps_failed_logins` VALUES("550", "0", "admin", "2022-07-24 21:26:51", "45.13.132.210");
INSERT INTO `wp_aiowps_failed_logins` VALUES("551", "0", "admin", "2022-07-25 12:00:59", "141.94.247.170");
INSERT INTO `wp_aiowps_failed_logins` VALUES("552", "0", "admin", "2022-07-25 20:49:28", "204.12.255.58");
INSERT INTO `wp_aiowps_failed_logins` VALUES("553", "0", "admin", "2022-07-26 23:27:08", "103.163.139.202");
INSERT INTO `wp_aiowps_failed_logins` VALUES("554", "0", "admin", "2022-07-26 23:27:08", "103.163.139.202");
INSERT INTO `wp_aiowps_failed_logins` VALUES("555", "0", "admin", "2022-07-27 01:51:40", "148.72.214.245");
INSERT INTO `wp_aiowps_failed_logins` VALUES("556", "0", "admin", "2022-07-27 11:32:34", "159.69.119.237");
INSERT INTO `wp_aiowps_failed_logins` VALUES("557", "0", "admin", "2022-07-27 11:32:34", "159.69.119.237");
INSERT INTO `wp_aiowps_failed_logins` VALUES("558", "0", "admin", "2022-07-27 18:03:02", "93.114.185.76");
INSERT INTO `wp_aiowps_failed_logins` VALUES("559", "0", "admin", "2022-07-27 20:15:48", "181.174.125.214");
INSERT INTO `wp_aiowps_failed_logins` VALUES("560", "0", "admin", "2022-07-28 02:16:53", "173.208.249.123");
INSERT INTO `wp_aiowps_failed_logins` VALUES("561", "0", "admin", "2022-07-28 03:08:09", "209.97.151.249");
INSERT INTO `wp_aiowps_failed_logins` VALUES("562", "0", "admin", "2022-07-28 04:01:34", "188.165.198.224");
INSERT INTO `wp_aiowps_failed_logins` VALUES("563", "0", "admin", "2022-07-28 05:49:23", "192.99.201.91");
INSERT INTO `wp_aiowps_failed_logins` VALUES("564", "0", "admin", "2022-07-28 09:56:53", "13.215.128.63");
INSERT INTO `wp_aiowps_failed_logins` VALUES("565", "0", "admin", "2022-07-28 09:57:59", "85.25.100.54");
INSERT INTO `wp_aiowps_failed_logins` VALUES("566", "0", "admin", "2022-07-28 09:58:07", "167.172.79.47");
INSERT INTO `wp_aiowps_failed_logins` VALUES("567", "0", "admin", "2022-07-28 09:58:19", "210.211.113.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("568", "0", "admin", "2022-07-28 09:59:32", "65.21.207.149");
INSERT INTO `wp_aiowps_failed_logins` VALUES("569", "0", "admin", "2022-07-28 10:00:25", "103.74.120.192");
INSERT INTO `wp_aiowps_failed_logins` VALUES("570", "0", "admin", "2022-07-28 10:01:10", "139.162.40.223");
INSERT INTO `wp_aiowps_failed_logins` VALUES("571", "0", "admin", "2022-07-28 10:01:33", "104.248.144.242");
INSERT INTO `wp_aiowps_failed_logins` VALUES("572", "0", "admin", "2022-07-28 10:02:55", "167.172.79.47");
INSERT INTO `wp_aiowps_failed_logins` VALUES("573", "0", "admin", "2022-07-28 10:03:01", "144.126.140.17");
INSERT INTO `wp_aiowps_failed_logins` VALUES("574", "0", "admin", "2022-07-28 10:03:38", "142.44.201.177");
INSERT INTO `wp_aiowps_failed_logins` VALUES("575", "0", "admin", "2022-07-28 10:05:16", "116.62.49.96");
INSERT INTO `wp_aiowps_failed_logins` VALUES("576", "0", "admin", "2022-07-28 10:05:56", "37.187.132.114");
INSERT INTO `wp_aiowps_failed_logins` VALUES("577", "0", "admin", "2022-07-28 10:05:59", "41.93.82.7");
INSERT INTO `wp_aiowps_failed_logins` VALUES("578", "0", "admin", "2022-07-28 10:06:13", "187.32.211.193");
INSERT INTO `wp_aiowps_failed_logins` VALUES("579", "0", "admin", "2022-07-28 10:07:56", "167.172.79.47");
INSERT INTO `wp_aiowps_failed_logins` VALUES("580", "0", "admin", "2022-07-28 10:08:48", "159.89.48.15");
INSERT INTO `wp_aiowps_failed_logins` VALUES("581", "0", "admin", "2022-07-28 10:09:13", "35.219.66.183");
INSERT INTO `wp_aiowps_failed_logins` VALUES("582", "0", "admin", "2022-07-28 10:10:46", "134.209.105.240");
INSERT INTO `wp_aiowps_failed_logins` VALUES("583", "0", "admin", "2022-07-28 10:11:14", "192.71.144.12");
INSERT INTO `wp_aiowps_failed_logins` VALUES("584", "0", "admin", "2022-07-28 10:11:46", "79.137.65.179");
INSERT INTO `wp_aiowps_failed_logins` VALUES("585", "0", "admin", "2022-07-28 10:11:51", "111.90.150.36");
INSERT INTO `wp_aiowps_failed_logins` VALUES("586", "0", "admin", "2022-07-28 10:13:36", "159.65.149.229");
INSERT INTO `wp_aiowps_failed_logins` VALUES("587", "0", "admin", "2022-07-28 10:13:57", "198.50.224.66");
INSERT INTO `wp_aiowps_failed_logins` VALUES("588", "0", "admin", "2022-07-28 10:14:14", "45.32.99.51");
INSERT INTO `wp_aiowps_failed_logins` VALUES("589", "0", "admin", "2022-07-28 10:15:44", "139.180.132.96");
INSERT INTO `wp_aiowps_failed_logins` VALUES("590", "0", "admin", "2022-07-28 10:16:19", "159.65.142.51");
INSERT INTO `wp_aiowps_failed_logins` VALUES("591", "0", "admin", "2022-07-28 10:16:21", "128.199.134.216");
INSERT INTO `wp_aiowps_failed_logins` VALUES("592", "0", "admin", "2022-07-28 10:17:44", "38.105.209.111");
INSERT INTO `wp_aiowps_failed_logins` VALUES("593", "0", "admin", "2022-07-28 10:18:24", "138.128.173.10");
INSERT INTO `wp_aiowps_failed_logins` VALUES("594", "0", "admin", "2022-07-28 10:18:41", "46.182.4.119");
INSERT INTO `wp_aiowps_failed_logins` VALUES("595", "0", "admin", "2022-07-28 10:20:10", "162.0.224.206");
INSERT INTO `wp_aiowps_failed_logins` VALUES("596", "0", "admin", "2022-07-28 11:32:03", "42.200.109.156");
INSERT INTO `wp_aiowps_failed_logins` VALUES("597", "0", "admin", "2022-07-28 11:54:01", "144.91.68.32");
INSERT INTO `wp_aiowps_failed_logins` VALUES("598", "0", "admin", "2022-07-28 11:56:07", "178.217.190.82");
INSERT INTO `wp_aiowps_failed_logins` VALUES("599", "0", "admin", "2022-07-28 12:06:56", "139.180.132.96");
INSERT INTO `wp_aiowps_failed_logins` VALUES("600", "0", "admin", "2022-07-28 12:32:08", "54.39.49.75");
INSERT INTO `wp_aiowps_failed_logins` VALUES("601", "0", "admin", "2022-07-28 12:32:08", "54.39.49.75");
INSERT INTO `wp_aiowps_failed_logins` VALUES("602", "0", "wadminw", "2022-07-28 13:25:22", "160.153.249.218");
INSERT INTO `wp_aiowps_failed_logins` VALUES("603", "0", "admin", "2022-07-28 16:00:04", "8.130.55.145");
INSERT INTO `wp_aiowps_failed_logins` VALUES("604", "0", "http", "2022-07-28 17:07:58", "188.212.34.69");
INSERT INTO `wp_aiowps_failed_logins` VALUES("605", "0", "https", "2022-07-28 17:18:51", "166.62.125.246");
INSERT INTO `wp_aiowps_failed_logins` VALUES("606", "0", "https", "2022-07-28 17:31:56", "167.172.153.166");
INSERT INTO `wp_aiowps_failed_logins` VALUES("607", "0", "https", "2022-07-28 19:13:06", "69.163.224.107");
INSERT INTO `wp_aiowps_failed_logins` VALUES("608", "0", "https", "2022-07-28 23:11:48", "212.103.4.29");
INSERT INTO `wp_aiowps_failed_logins` VALUES("609", "0", "https", "2022-07-28 23:32:23", "35.197.204.193");
INSERT INTO `wp_aiowps_failed_logins` VALUES("610", "0", "http", "2022-07-28 23:54:13", "181.174.125.214");
INSERT INTO `wp_aiowps_failed_logins` VALUES("611", "0", "https", "2022-07-29 02:35:12", "91.249.163.48");
INSERT INTO `wp_aiowps_failed_logins` VALUES("612", "0", "https", "2022-07-29 02:39:58", "104.131.68.19");
INSERT INTO `wp_aiowps_failed_logins` VALUES("613", "0", "http", "2022-07-29 03:11:55", "109.168.97.89");
INSERT INTO `wp_aiowps_failed_logins` VALUES("614", "0", "http", "2022-07-29 03:18:28", "176.98.40.88");
INSERT INTO `wp_aiowps_failed_logins` VALUES("615", "0", "https", "2022-07-29 04:15:09", "208.113.180.18");
INSERT INTO `wp_aiowps_failed_logins` VALUES("616", "0", "https", "2022-07-29 04:16:56", "85.146.18.88");
INSERT INTO `wp_aiowps_failed_logins` VALUES("617", "0", "http", "2022-07-29 07:27:12", "120.78.15.126");
INSERT INTO `wp_aiowps_failed_logins` VALUES("618", "0", "http", "2022-07-29 07:32:17", "97.74.89.166");
INSERT INTO `wp_aiowps_failed_logins` VALUES("619", "0", "https", "2022-07-29 07:52:17", "198.244.167.101");
INSERT INTO `wp_aiowps_failed_logins` VALUES("620", "0", "https", "2022-07-29 08:02:22", "111.231.200.129");
INSERT INTO `wp_aiowps_failed_logins` VALUES("621", "0", "admin", "2022-07-29 08:33:56", "46.32.228.70");
INSERT INTO `wp_aiowps_failed_logins` VALUES("622", "0", "admin", "2022-07-29 08:40:35", "159.203.120.246");
INSERT INTO `wp_aiowps_failed_logins` VALUES("623", "0", "admin", "2022-07-29 09:15:36", "202.29.236.140");
INSERT INTO `wp_aiowps_failed_logins` VALUES("624", "0", "admin", "2022-07-29 14:29:15", "161.35.126.102");
INSERT INTO `wp_aiowps_failed_logins` VALUES("625", "0", "admin", "2022-07-30 00:48:46", "89.108.126.154");
INSERT INTO `wp_aiowps_failed_logins` VALUES("626", "0", "admin", "2022-07-30 02:23:43", "204.12.202.91");
INSERT INTO `wp_aiowps_failed_logins` VALUES("627", "0", "admin", "2022-07-30 21:10:26", "159.65.76.38");
INSERT INTO `wp_aiowps_failed_logins` VALUES("628", "0", "admin", "2022-07-30 23:03:22", "133.130.103.36");
INSERT INTO `wp_aiowps_failed_logins` VALUES("629", "0", "admin", "2022-07-31 00:17:39", "173.208.153.156");
INSERT INTO `wp_aiowps_failed_logins` VALUES("630", "0", "admin", "2022-07-31 09:08:01", "173.208.249.123");
INSERT INTO `wp_aiowps_failed_logins` VALUES("631", "0", "admin", "2022-07-31 13:23:11", "192.99.201.91");
INSERT INTO `wp_aiowps_failed_logins` VALUES("632", "0", "admin", "2022-07-31 14:23:37", "207.154.248.39");
INSERT INTO `wp_aiowps_failed_logins` VALUES("633", "0", "admin", "2022-07-31 17:27:45", "198.244.167.101");
INSERT INTO `wp_aiowps_failed_logins` VALUES("634", "0", "admin", "2022-08-01 05:55:51", "176.98.40.88");
INSERT INTO `wp_aiowps_failed_logins` VALUES("635", "1", "ucr", "2022-08-02 02:17:18", "142.54.173.141");
INSERT INTO `wp_aiowps_failed_logins` VALUES("636", "0", "admin", "2022-08-02 18:25:33", "202.131.107.130");
INSERT INTO `wp_aiowps_failed_logins` VALUES("637", "0", "admin", "2022-08-02 19:05:11", "65.52.200.48");
INSERT INTO `wp_aiowps_failed_logins` VALUES("638", "0", "admin", "2022-08-03 04:29:31", "67.205.43.169");
INSERT INTO `wp_aiowps_failed_logins` VALUES("639", "0", "admin", "2022-08-03 07:35:38", "162.240.28.177");
INSERT INTO `wp_aiowps_failed_logins` VALUES("640", "0", "admin", "2022-08-03 07:36:13", "143.244.155.35");
INSERT INTO `wp_aiowps_failed_logins` VALUES("641", "0", "admin", "2022-08-03 07:45:50", "167.99.252.52");
INSERT INTO `wp_aiowps_failed_logins` VALUES("642", "0", "admin", "2022-08-03 07:55:29", "45.120.69.121");
INSERT INTO `wp_aiowps_failed_logins` VALUES("643", "0", "admin", "2022-08-03 12:03:09", "188.166.183.39");
INSERT INTO `wp_aiowps_failed_logins` VALUES("644", "0", "admin", "2022-08-03 15:37:09", "101.34.224.66");
INSERT INTO `wp_aiowps_failed_logins` VALUES("645", "0", "admin", "2022-08-03 15:47:25", "46.32.228.70");
INSERT INTO `wp_aiowps_failed_logins` VALUES("646", "0", "admin", "2022-08-04 09:17:02", "118.27.30.151");
INSERT INTO `wp_aiowps_failed_logins` VALUES("647", "0", "admin", "2022-08-04 11:25:29", "188.127.231.190");
INSERT INTO `wp_aiowps_failed_logins` VALUES("648", "0", "admin", "2022-08-06 00:54:01", "188.166.61.228");
INSERT INTO `wp_aiowps_failed_logins` VALUES("649", "0", "admin", "2022-08-06 06:16:00", "145.239.30.120");
INSERT INTO `wp_aiowps_failed_logins` VALUES("650", "0", "admin", "2022-08-06 06:45:55", "69.163.196.200");
INSERT INTO `wp_aiowps_failed_logins` VALUES("651", "0", "admin", "2022-08-06 06:46:01", "51.91.151.60");
INSERT INTO `wp_aiowps_failed_logins` VALUES("652", "0", "admin", "2022-08-06 15:42:48", "67.205.43.169");
INSERT INTO `wp_aiowps_failed_logins` VALUES("653", "0", "admin", "2022-08-06 17:41:11", "81.70.248.169");
INSERT INTO `wp_aiowps_failed_logins` VALUES("654", "0", "admin", "2022-08-06 23:31:20", "159.65.76.38");
INSERT INTO `wp_aiowps_failed_logins` VALUES("655", "0", "admin", "2022-08-07 03:24:17", "75.119.157.181");
INSERT INTO `wp_aiowps_failed_logins` VALUES("656", "0", "admin", "2022-08-07 19:42:39", "31.170.161.30");
INSERT INTO `wp_aiowps_failed_logins` VALUES("657", "0", "admin", "2022-08-07 23:30:28", "143.244.143.195");
INSERT INTO `wp_aiowps_failed_logins` VALUES("658", "0", "admin", "2022-08-08 14:03:26", "118.24.106.172");
INSERT INTO `wp_aiowps_failed_logins` VALUES("659", "0", "admin", "2022-08-08 14:21:44", "14.241.233.205");
INSERT INTO `wp_aiowps_failed_logins` VALUES("660", "0", "admin", "2022-08-09 07:10:43", "68.183.75.82");
INSERT INTO `wp_aiowps_failed_logins` VALUES("661", "0", "admin", "2022-08-09 07:45:50", "202.131.107.130");
INSERT INTO `wp_aiowps_failed_logins` VALUES("662", "0", "admin", "2022-08-09 08:43:11", "34.77.125.33");
INSERT INTO `wp_aiowps_failed_logins` VALUES("663", "0", "admin", "2022-08-09 09:00:17", "103.149.154.8");
INSERT INTO `wp_aiowps_failed_logins` VALUES("664", "0", "admin", "2022-08-09 10:47:18", "107.182.129.160");
INSERT INTO `wp_aiowps_failed_logins` VALUES("665", "0", "admin", "2022-08-09 10:47:20", "107.182.129.160");
INSERT INTO `wp_aiowps_failed_logins` VALUES("666", "0", "admin", "2022-08-09 10:47:21", "107.182.129.160");
INSERT INTO `wp_aiowps_failed_logins` VALUES("667", "0", "admin", "2022-08-09 10:47:22", "107.182.129.160");
INSERT INTO `wp_aiowps_failed_logins` VALUES("668", "0", "admin", "2022-08-09 10:47:24", "107.182.129.160");
INSERT INTO `wp_aiowps_failed_logins` VALUES("669", "0", "admin", "2022-08-09 10:47:25", "107.182.129.160");
INSERT INTO `wp_aiowps_failed_logins` VALUES("670", "0", "admin", "2022-08-09 10:47:27", "107.182.129.160");
INSERT INTO `wp_aiowps_failed_logins` VALUES("671", "0", "admin", "2022-08-09 10:47:28", "107.182.129.160");
INSERT INTO `wp_aiowps_failed_logins` VALUES("672", "0", "admin", "2022-08-09 10:47:29", "107.182.129.160");
INSERT INTO `wp_aiowps_failed_logins` VALUES("673", "0", "admin", "2022-08-09 10:47:30", "107.182.129.160");
INSERT INTO `wp_aiowps_failed_logins` VALUES("674", "0", "admin", "2022-08-09 10:47:32", "107.182.129.160");
INSERT INTO `wp_aiowps_failed_logins` VALUES("675", "0", "admin", "2022-08-09 10:47:33", "107.182.129.160");
INSERT INTO `wp_aiowps_failed_logins` VALUES("676", "0", "admin", "2022-08-09 10:47:34", "107.182.129.160");
INSERT INTO `wp_aiowps_failed_logins` VALUES("677", "0", "admin", "2022-08-09 10:47:35", "107.182.129.160");
INSERT INTO `wp_aiowps_failed_logins` VALUES("678", "0", "admin", "2022-08-09 10:47:37", "107.182.129.160");
INSERT INTO `wp_aiowps_failed_logins` VALUES("679", "0", "admin", "2022-08-09 10:47:38", "107.182.129.160");
INSERT INTO `wp_aiowps_failed_logins` VALUES("680", "0", "admin", "2022-08-09 10:47:39", "107.182.129.160");
INSERT INTO `wp_aiowps_failed_logins` VALUES("681", "0", "admin", "2022-08-09 10:47:40", "107.182.129.160");
INSERT INTO `wp_aiowps_failed_logins` VALUES("682", "0", "admin", "2022-08-09 10:47:41", "107.182.129.160");
INSERT INTO `wp_aiowps_failed_logins` VALUES("683", "0", "admin", "2022-08-09 11:10:50", "148.72.214.245");
INSERT INTO `wp_aiowps_failed_logins` VALUES("684", "0", "admin", "2022-08-09 12:06:59", "198.244.167.101");
INSERT INTO `wp_aiowps_failed_logins` VALUES("685", "0", "admin", "2022-08-09 13:55:09", "109.233.192.83");
INSERT INTO `wp_aiowps_failed_logins` VALUES("686", "0", "admin", "2022-08-09 16:54:15", "137.184.33.6");
INSERT INTO `wp_aiowps_failed_logins` VALUES("687", "0", "admin", "2022-08-09 21:22:07", "68.183.75.82");
INSERT INTO `wp_aiowps_failed_logins` VALUES("688", "0", "admin", "2022-08-10 02:10:17", "159.203.120.246");
INSERT INTO `wp_aiowps_failed_logins` VALUES("689", "0", "admin", "2022-08-10 06:17:04", "118.27.30.151");
INSERT INTO `wp_aiowps_failed_logins` VALUES("690", "0", "admin", "2022-08-10 08:03:03", "66.33.193.231");
INSERT INTO `wp_aiowps_failed_logins` VALUES("691", "0", "admin", "2022-08-10 08:20:21", "188.166.225.235");
INSERT INTO `wp_aiowps_failed_logins` VALUES("692", "0", "admin", "2022-08-10 14:03:18", "178.62.35.35");
INSERT INTO `wp_aiowps_failed_logins` VALUES("693", "0", "admin", "2022-08-10 14:34:10", "173.236.242.233");
INSERT INTO `wp_aiowps_failed_logins` VALUES("694", "0", "admin", "2022-08-10 15:44:44", "168.119.80.254");
INSERT INTO `wp_aiowps_failed_logins` VALUES("695", "0", "admin", "2022-08-10 16:25:15", "208.109.54.127");
INSERT INTO `wp_aiowps_failed_logins` VALUES("696", "0", "admin", "2022-08-11 06:18:59", "146.148.44.185");
INSERT INTO `wp_aiowps_failed_logins` VALUES("697", "0", "admin", "2022-08-13 08:42:24", "143.244.177.220");
INSERT INTO `wp_aiowps_failed_logins` VALUES("698", "0", "admin", "2022-08-13 08:46:12", "47.105.73.13");
INSERT INTO `wp_aiowps_failed_logins` VALUES("699", "0", "admin", "2022-08-13 18:29:05", "101.34.224.66");
INSERT INTO `wp_aiowps_failed_logins` VALUES("700", "0", "admin", "2022-08-13 19:31:59", "128.199.105.159");
INSERT INTO `wp_aiowps_failed_logins` VALUES("701", "0", "admin", "2022-08-13 19:44:03", "47.98.207.210");
INSERT INTO `wp_aiowps_failed_logins` VALUES("702", "0", "admin", "2022-08-14 08:40:51", "110.40.244.196");
INSERT INTO `wp_aiowps_failed_logins` VALUES("703", "0", "admin", "2022-08-14 13:13:07", "51.15.160.148");
INSERT INTO `wp_aiowps_failed_logins` VALUES("704", "0", "admin", "2022-08-14 13:41:45", "146.56.99.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("705", "0", "admin", "2022-08-14 15:28:44", "47.105.61.35");
INSERT INTO `wp_aiowps_failed_logins` VALUES("706", "0", "admin", "2022-08-15 00:56:43", "173.236.184.128");
INSERT INTO `wp_aiowps_failed_logins` VALUES("707", "0", "admin", "2022-08-15 16:45:58", "146.56.99.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("708", "0", "admin", "2022-08-15 18:16:02", "139.59.96.126");
INSERT INTO `wp_aiowps_failed_logins` VALUES("709", "0", "admin", "2022-08-15 20:08:17", "103.149.154.8");
INSERT INTO `wp_aiowps_failed_logins` VALUES("710", "0", "admin", "2022-08-15 21:32:33", "82.166.39.15");
INSERT INTO `wp_aiowps_failed_logins` VALUES("711", "0", "admin", "2022-08-16 01:13:28", "202.21.38.119");
INSERT INTO `wp_aiowps_failed_logins` VALUES("712", "0", "wwwadmin", "2022-08-16 16:10:05", "104.131.189.63");
INSERT INTO `wp_aiowps_failed_logins` VALUES("713", "0", "wwwadmin", "2022-08-16 16:10:05", "104.131.189.63");
INSERT INTO `wp_aiowps_failed_logins` VALUES("714", "1", "ucr", "2022-08-18 06:00:44", "173.208.153.157");
INSERT INTO `wp_aiowps_failed_logins` VALUES("715", "0", "admin", "2022-08-18 16:42:24", "103.146.202.150");
INSERT INTO `wp_aiowps_failed_logins` VALUES("716", "0", "admin", "2022-08-18 16:42:24", "103.146.202.150");
INSERT INTO `wp_aiowps_failed_logins` VALUES("717", "0", "admin", "2022-08-19 01:20:19", "94.231.86.20");
INSERT INTO `wp_aiowps_failed_logins` VALUES("718", "0", "admin", "2022-08-19 01:20:19", "94.231.86.20");
INSERT INTO `wp_aiowps_failed_logins` VALUES("719", "0", "admin", "2022-08-19 01:36:16", "157.7.174.49");
INSERT INTO `wp_aiowps_failed_logins` VALUES("720", "0", "admin", "2022-08-19 07:40:10", "85.146.18.88");
INSERT INTO `wp_aiowps_failed_logins` VALUES("721", "0", "admin", "2022-08-19 09:59:14", "35.187.58.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("722", "0", "admin", "2022-08-19 19:22:13", "51.107.184.18");
INSERT INTO `wp_aiowps_failed_logins` VALUES("723", "0", "admin", "2022-08-19 22:47:37", "217.61.54.110");
INSERT INTO `wp_aiowps_failed_logins` VALUES("724", "0", "admin", "2022-08-20 00:45:55", "52.138.180.227");
INSERT INTO `wp_aiowps_failed_logins` VALUES("725", "0", "admin", "2022-08-20 16:42:29", "34.76.63.113");
INSERT INTO `wp_aiowps_failed_logins` VALUES("726", "0", "admin", "2022-08-21 10:37:15", "147.135.255.8");
INSERT INTO `wp_aiowps_failed_logins` VALUES("727", "0", "admin", "2022-08-21 19:19:30", "148.72.214.245");
INSERT INTO `wp_aiowps_failed_logins` VALUES("728", "0", "admin", "2022-08-21 20:20:31", "167.71.141.164");
INSERT INTO `wp_aiowps_failed_logins` VALUES("729", "0", "admin", "2022-08-21 22:24:57", "178.62.35.35");
INSERT INTO `wp_aiowps_failed_logins` VALUES("730", "0", "admin", "2022-08-29 02:58:23", "79.110.62.43");
INSERT INTO `wp_aiowps_failed_logins` VALUES("731", "0", "admin", "2022-08-29 02:58:27", "79.110.62.43");
INSERT INTO `wp_aiowps_failed_logins` VALUES("732", "0", "admin", "2022-08-29 02:58:31", "79.110.62.43");
INSERT INTO `wp_aiowps_failed_logins` VALUES("733", "0", "admin", "2022-08-29 02:58:38", "79.110.62.43");
INSERT INTO `wp_aiowps_failed_logins` VALUES("734", "0", "admin", "2022-08-29 02:58:45", "79.110.62.43");
INSERT INTO `wp_aiowps_failed_logins` VALUES("735", "0", "admin", "2022-08-29 02:58:55", "79.110.62.43");
INSERT INTO `wp_aiowps_failed_logins` VALUES("736", "0", "admin", "2022-08-29 02:59:06", "79.110.62.43");
INSERT INTO `wp_aiowps_failed_logins` VALUES("737", "0", "admin", "2022-08-29 02:59:13", "79.110.62.43");
INSERT INTO `wp_aiowps_failed_logins` VALUES("738", "0", "admin", "2022-08-29 02:59:23", "79.110.62.43");
INSERT INTO `wp_aiowps_failed_logins` VALUES("739", "0", "admin", "2022-08-29 02:59:32", "79.110.62.43");
INSERT INTO `wp_aiowps_failed_logins` VALUES("740", "0", "admin", "2022-08-29 02:59:42", "79.110.62.43");
INSERT INTO `wp_aiowps_failed_logins` VALUES("741", "0", "admin", "2022-08-29 02:59:47", "79.110.62.43");
INSERT INTO `wp_aiowps_failed_logins` VALUES("742", "0", "admin", "2022-08-29 02:59:51", "79.110.62.43");
INSERT INTO `wp_aiowps_failed_logins` VALUES("743", "0", "admin", "2022-08-29 02:59:54", "79.110.62.43");
INSERT INTO `wp_aiowps_failed_logins` VALUES("744", "0", "admin", "2022-08-29 02:59:58", "79.110.62.43");
INSERT INTO `wp_aiowps_failed_logins` VALUES("745", "0", "admin", "2022-08-29 03:00:03", "79.110.62.43");
INSERT INTO `wp_aiowps_failed_logins` VALUES("746", "0", "admin", "2022-08-29 03:00:07", "79.110.62.43");
INSERT INTO `wp_aiowps_failed_logins` VALUES("747", "0", "admin", "2022-08-29 03:00:11", "79.110.62.43");
INSERT INTO `wp_aiowps_failed_logins` VALUES("748", "0", "admin", "2022-08-29 03:00:15", "79.110.62.43");
INSERT INTO `wp_aiowps_failed_logins` VALUES("749", "0", "admin", "2022-08-29 21:56:12", "39.99.51.221");
INSERT INTO `wp_aiowps_failed_logins` VALUES("750", "0", "admin", "2022-09-01 14:42:24", "82.166.39.15");
INSERT INTO `wp_aiowps_failed_logins` VALUES("751", "0", "admin", "2022-09-01 19:00:50", "137.184.117.52");
INSERT INTO `wp_aiowps_failed_logins` VALUES("752", "0", "admin", "2022-09-02 22:18:47", "47.105.73.13");
INSERT INTO `wp_aiowps_failed_logins` VALUES("753", "0", "admin", "2022-09-03 03:41:34", "47.98.207.210");
INSERT INTO `wp_aiowps_failed_logins` VALUES("754", "0", "admin", "2022-09-03 06:58:14", "103.39.134.190");
INSERT INTO `wp_aiowps_failed_logins` VALUES("755", "0", "admin", "2022-09-03 21:08:51", "209.182.195.110");
INSERT INTO `wp_aiowps_failed_logins` VALUES("756", "0", "admin", "2022-09-04 01:06:40", "185.2.4.33");
INSERT INTO `wp_aiowps_failed_logins` VALUES("757", "0", "admin", "2022-09-04 07:40:03", "208.113.171.103");
INSERT INTO `wp_aiowps_failed_logins` VALUES("758", "0", "admin", "2022-09-04 10:18:13", "178.128.187.183");
INSERT INTO `wp_aiowps_failed_logins` VALUES("759", "0", "admin", "2022-09-04 14:33:04", "139.59.118.238");
INSERT INTO `wp_aiowps_failed_logins` VALUES("760", "0", "admin", "2022-09-04 16:38:28", "139.59.150.45");
INSERT INTO `wp_aiowps_failed_logins` VALUES("761", "0", "admin", "2022-09-05 07:45:49", "212.38.40.215");
INSERT INTO `wp_aiowps_failed_logins` VALUES("762", "0", "admin", "2022-09-05 08:20:44", "88.99.66.27");
INSERT INTO `wp_aiowps_failed_logins` VALUES("763", "0", "admin", "2022-09-05 08:26:12", "43.156.80.77");
INSERT INTO `wp_aiowps_failed_logins` VALUES("764", "0", "admin", "2022-09-05 08:26:12", "43.156.80.77");
INSERT INTO `wp_aiowps_failed_logins` VALUES("765", "0", "admin", "2022-09-05 08:35:32", "23.239.3.24");
INSERT INTO `wp_aiowps_failed_logins` VALUES("766", "0", "admin", "2022-09-05 08:44:57", "51.159.57.26");
INSERT INTO `wp_aiowps_failed_logins` VALUES("767", "0", "admin", "2022-09-05 08:51:11", "198.12.254.32");
INSERT INTO `wp_aiowps_failed_logins` VALUES("768", "0", "admin", "2022-09-05 08:57:19", "167.99.78.164");
INSERT INTO `wp_aiowps_failed_logins` VALUES("769", "0", "admin", "2022-09-05 08:59:53", "206.72.197.170");
INSERT INTO `wp_aiowps_failed_logins` VALUES("770", "0", "admin", "2022-09-05 09:05:41", "216.48.178.76");
INSERT INTO `wp_aiowps_failed_logins` VALUES("771", "0", "admin", "2022-09-05 09:05:41", "216.48.178.76");
INSERT INTO `wp_aiowps_failed_logins` VALUES("772", "0", "admin", "2022-09-05 09:10:21", "159.203.31.171");
INSERT INTO `wp_aiowps_failed_logins` VALUES("773", "0", "admin", "2022-09-05 09:16:16", "192.163.194.31");
INSERT INTO `wp_aiowps_failed_logins` VALUES("774", "0", "admin", "2022-09-05 09:16:16", "192.163.194.31");
INSERT INTO `wp_aiowps_failed_logins` VALUES("775", "0", "admin", "2022-09-05 09:20:48", "138.197.158.8");
INSERT INTO `wp_aiowps_failed_logins` VALUES("776", "0", "admin", "2022-09-05 09:20:48", "138.197.158.8");
INSERT INTO `wp_aiowps_failed_logins` VALUES("777", "0", "admin", "2022-09-06 15:39:44", "51.38.192.91");
INSERT INTO `wp_aiowps_failed_logins` VALUES("778", "0", "admin", "2022-09-07 11:49:42", "85.146.18.88");
INSERT INTO `wp_aiowps_failed_logins` VALUES("779", "0", "admin", "2022-09-07 11:57:03", "150.109.148.216");
INSERT INTO `wp_aiowps_failed_logins` VALUES("780", "0", "admin", "2022-09-07 15:08:38", "173.236.169.240");
INSERT INTO `wp_aiowps_failed_logins` VALUES("781", "0", "admin", "2022-09-09 03:39:59", "106.52.120.186");
INSERT INTO `wp_aiowps_failed_logins` VALUES("782", "0", "admin", "2022-09-09 06:25:46", "139.59.82.122");
INSERT INTO `wp_aiowps_failed_logins` VALUES("783", "0", "admin", "2022-09-09 06:45:45", "103.130.218.178");
INSERT INTO `wp_aiowps_failed_logins` VALUES("784", "0", "admin", "2022-09-09 07:05:09", "141.94.247.170");
INSERT INTO `wp_aiowps_failed_logins` VALUES("785", "0", "admin", "2022-09-09 08:38:34", "46.63.80.162");
INSERT INTO `wp_aiowps_failed_logins` VALUES("786", "0", "admin", "2022-09-09 22:10:48", "43.251.135.217");
INSERT INTO `wp_aiowps_failed_logins` VALUES("787", "0", "admin", "2022-09-10 06:38:38", "8.142.173.121");
INSERT INTO `wp_aiowps_failed_logins` VALUES("788", "0", "admin", "2022-09-10 07:45:56", "81.88.52.221");
INSERT INTO `wp_aiowps_failed_logins` VALUES("789", "0", "admin", "2022-09-10 07:46:25", "209.182.195.110");
INSERT INTO `wp_aiowps_failed_logins` VALUES("790", "0", "admin", "2022-09-10 08:40:47", "81.88.52.106");
INSERT INTO `wp_aiowps_failed_logins` VALUES("791", "0", "admin", "2022-09-10 09:35:13", "34.75.65.218");
INSERT INTO `wp_aiowps_failed_logins` VALUES("792", "0", "admin", "2022-09-10 09:35:43", "68.183.71.174");
INSERT INTO `wp_aiowps_failed_logins` VALUES("793", "0", "admin", "2022-09-10 09:45:26", "188.166.61.228");
INSERT INTO `wp_aiowps_failed_logins` VALUES("794", "0", "admin", "2022-09-10 13:06:51", "51.38.192.91");
INSERT INTO `wp_aiowps_failed_logins` VALUES("795", "0", "admin", "2022-09-10 17:11:19", "79.110.62.40");
INSERT INTO `wp_aiowps_failed_logins` VALUES("796", "0", "admin", "2022-09-10 17:11:25", "79.110.62.40");
INSERT INTO `wp_aiowps_failed_logins` VALUES("797", "0", "admin", "2022-09-10 17:11:31", "79.110.62.40");
INSERT INTO `wp_aiowps_failed_logins` VALUES("798", "0", "admin", "2022-09-10 17:11:37", "79.110.62.40");
INSERT INTO `wp_aiowps_failed_logins` VALUES("799", "0", "admin", "2022-09-10 17:11:42", "79.110.62.40");
INSERT INTO `wp_aiowps_failed_logins` VALUES("800", "0", "admin", "2022-09-10 17:11:48", "79.110.62.40");
INSERT INTO `wp_aiowps_failed_logins` VALUES("801", "0", "admin", "2022-09-10 17:12:00", "79.110.62.40");
INSERT INTO `wp_aiowps_failed_logins` VALUES("802", "0", "admin", "2022-09-10 17:12:06", "79.110.62.40");
INSERT INTO `wp_aiowps_failed_logins` VALUES("803", "0", "admin", "2022-09-10 17:12:12", "79.110.62.40");
INSERT INTO `wp_aiowps_failed_logins` VALUES("804", "0", "admin", "2022-09-10 17:12:13", "79.110.62.40");
INSERT INTO `wp_aiowps_failed_logins` VALUES("805", "0", "admin", "2022-09-10 17:12:18", "79.110.62.40");
INSERT INTO `wp_aiowps_failed_logins` VALUES("806", "0", "admin", "2022-09-10 17:12:19", "79.110.62.40");
INSERT INTO `wp_aiowps_failed_logins` VALUES("807", "0", "admin", "2022-09-10 17:12:26", "79.110.62.40");
INSERT INTO `wp_aiowps_failed_logins` VALUES("808", "0", "admin", "2022-09-10 17:12:28", "79.110.62.40");
INSERT INTO `wp_aiowps_failed_logins` VALUES("809", "0", "admin", "2022-09-11 08:30:19", "208.109.54.127");
INSERT INTO `wp_aiowps_failed_logins` VALUES("810", "0", "admin", "2022-09-11 15:33:41", "46.32.228.70");
INSERT INTO `wp_aiowps_failed_logins` VALUES("811", "0", "admin", "2022-09-11 21:05:39", "212.110.92.155");
INSERT INTO `wp_aiowps_failed_logins` VALUES("812", "0", "admin", "2022-09-12 02:45:45", "188.166.183.39");
INSERT INTO `wp_aiowps_failed_logins` VALUES("813", "0", "admin", "2022-09-12 03:48:05", "118.27.30.151");
INSERT INTO `wp_aiowps_failed_logins` VALUES("814", "0", "admin", "2022-09-12 07:40:25", "69.163.196.200");
INSERT INTO `wp_aiowps_failed_logins` VALUES("815", "0", "admin", "2022-09-13 17:07:32", "104.131.68.19");
INSERT INTO `wp_aiowps_failed_logins` VALUES("816", "0", "admin", "2022-09-13 21:23:06", "123.25.21.16");
INSERT INTO `wp_aiowps_failed_logins` VALUES("817", "0", "admin", "2022-09-13 21:23:06", "123.25.21.16");
INSERT INTO `wp_aiowps_failed_logins` VALUES("818", "0", "admin", "2022-09-14 06:18:51", "162.144.87.29");
INSERT INTO `wp_aiowps_failed_logins` VALUES("819", "0", "admin", "2022-09-14 11:16:11", "23.99.229.218");
INSERT INTO `wp_aiowps_failed_logins` VALUES("820", "0", "admin", "2022-09-14 11:18:10", "85.146.18.88");
INSERT INTO `wp_aiowps_failed_logins` VALUES("821", "0", "admin", "2022-09-14 11:25:24", "157.245.110.251");
INSERT INTO `wp_aiowps_failed_logins` VALUES("822", "0", "admin", "2022-09-14 15:01:27", "47.115.24.165");
INSERT INTO `wp_aiowps_failed_logins` VALUES("823", "0", "admin", "2022-09-15 18:55:36", "65.21.105.105");
INSERT INTO `wp_aiowps_failed_logins` VALUES("824", "0", "admin", "2022-09-15 22:06:12", "47.105.73.13");
INSERT INTO `wp_aiowps_failed_logins` VALUES("825", "0", "admin", "2022-09-15 22:23:40", "34.69.109.132");
INSERT INTO `wp_aiowps_failed_logins` VALUES("826", "0", "admin", "2022-09-16 08:52:11", "34.76.63.113");
INSERT INTO `wp_aiowps_failed_logins` VALUES("827", "0", "admin", "2022-09-17 10:36:29", "162.240.28.177");
INSERT INTO `wp_aiowps_failed_logins` VALUES("828", "0", "admin", "2022-09-17 11:15:15", "165.232.180.174");
INSERT INTO `wp_aiowps_failed_logins` VALUES("829", "1", "ucr", "2022-09-18 17:29:20", "71.41.225.12");
INSERT INTO `wp_aiowps_failed_logins` VALUES("830", "0", "wadminw", "2022-09-18 22:34:43", "140.246.255.164");
INSERT INTO `wp_aiowps_failed_logins` VALUES("831", "1", "ucr", "2022-09-18 23:14:39", "71.41.225.12");
INSERT INTO `wp_aiowps_failed_logins` VALUES("832", "0", "admin", "2022-09-18 23:50:08", "67.205.39.9");
INSERT INTO `wp_aiowps_failed_logins` VALUES("833", "0", "admin", "2022-09-19 13:53:19", "92.205.110.137");
INSERT INTO `wp_aiowps_failed_logins` VALUES("834", "0", "wadminw", "2022-09-19 15:58:55", "103.98.152.12");
INSERT INTO `wp_aiowps_failed_logins` VALUES("835", "0", "admin", "2022-09-19 16:40:14", "45.55.44.23");
INSERT INTO `wp_aiowps_failed_logins` VALUES("836", "1", "ucr", "2022-09-20 02:21:29", "51.38.192.91");
INSERT INTO `wp_aiowps_failed_logins` VALUES("837", "1", "ucr", "2022-09-20 04:36:43", "209.97.162.248");
INSERT INTO `wp_aiowps_failed_logins` VALUES("838", "1", "ucr", "2022-09-20 05:05:40", "212.103.4.29");
INSERT INTO `wp_aiowps_failed_logins` VALUES("839", "1", "ucr", "2022-09-20 05:05:40", "212.103.4.29");
INSERT INTO `wp_aiowps_failed_logins` VALUES("840", "1", "ucr", "2022-09-20 05:49:02", "148.72.207.163");
INSERT INTO `wp_aiowps_failed_logins` VALUES("841", "1", "ucr", "2022-09-20 06:24:28", "159.203.121.12");
INSERT INTO `wp_aiowps_failed_logins` VALUES("842", "1", "ucr", "2022-09-20 07:07:29", "103.129.222.91");
INSERT INTO `wp_aiowps_failed_logins` VALUES("843", "1", "ucr", "2022-09-20 08:17:56", "115.78.122.58");
INSERT INTO `wp_aiowps_failed_logins` VALUES("844", "1", "ucr", "2022-09-20 09:13:41", "68.183.86.247");
INSERT INTO `wp_aiowps_failed_logins` VALUES("845", "1", "ucr", "2022-09-20 09:14:17", "168.119.80.254");
INSERT INTO `wp_aiowps_failed_logins` VALUES("846", "1", "ucr", "2022-09-20 09:56:36", "124.106.71.219");
INSERT INTO `wp_aiowps_failed_logins` VALUES("847", "0", "admin", "2022-09-20 10:26:10", "207.244.239.41");
INSERT INTO `wp_aiowps_failed_logins` VALUES("848", "0", "admin", "2022-09-21 00:53:01", "134.209.184.76");
INSERT INTO `wp_aiowps_failed_logins` VALUES("849", "0", "admin", "2022-09-21 03:23:48", "51.75.15.189");
INSERT INTO `wp_aiowps_failed_logins` VALUES("850", "0", "admin", "2022-09-23 15:55:56", "123.25.21.16");
INSERT INTO `wp_aiowps_failed_logins` VALUES("851", "0", "admin", "2022-09-23 19:45:37", "1.117.250.215");
INSERT INTO `wp_aiowps_failed_logins` VALUES("852", "0", "admin", "2022-09-27 10:55:05", "167.99.54.31");
INSERT INTO `wp_aiowps_failed_logins` VALUES("853", "0", "admin", "2022-09-27 13:16:59", "207.154.204.99");
INSERT INTO `wp_aiowps_failed_logins` VALUES("854", "0", "admin", "2022-09-28 01:25:15", "68.183.86.247");
INSERT INTO `wp_aiowps_failed_logins` VALUES("855", "0", "admin", "2022-09-28 06:41:53", "208.109.54.127");
INSERT INTO `wp_aiowps_failed_logins` VALUES("856", "0", "admin", "2022-09-28 08:22:49", "51.178.76.51");
INSERT INTO `wp_aiowps_failed_logins` VALUES("857", "0", "admin", "2022-09-28 08:34:16", "104.131.68.19");
INSERT INTO `wp_aiowps_failed_logins` VALUES("858", "0", "admin", "2022-09-28 09:51:24", "178.128.5.109");
INSERT INTO `wp_aiowps_failed_logins` VALUES("859", "0", "admin", "2022-09-28 15:35:49", "166.62.125.246");
INSERT INTO `wp_aiowps_failed_logins` VALUES("860", "0", "admin", "2022-10-03 21:14:29", "151.106.41.64");
INSERT INTO `wp_aiowps_failed_logins` VALUES("861", "0", "admin", "2022-10-03 21:14:29", "151.106.41.64");
INSERT INTO `wp_aiowps_failed_logins` VALUES("862", "0", "admin", "2022-10-03 22:44:48", "85.191.40.94");
INSERT INTO `wp_aiowps_failed_logins` VALUES("863", "0", "admin", "2022-10-04 01:29:02", "152.228.208.88");
INSERT INTO `wp_aiowps_failed_logins` VALUES("864", "0", "admin", "2022-10-04 15:22:38", "185.2.5.31");
INSERT INTO `wp_aiowps_failed_logins` VALUES("865", "0", "admin", "2022-10-04 15:22:38", "185.2.5.31");
INSERT INTO `wp_aiowps_failed_logins` VALUES("866", "0", "admin", "2022-10-05 21:31:50", "188.166.120.27");
INSERT INTO `wp_aiowps_failed_logins` VALUES("867", "0", "admin", "2022-10-06 03:30:08", "133.130.103.36");
INSERT INTO `wp_aiowps_failed_logins` VALUES("868", "0", "admin", "2022-10-06 05:02:28", "142.93.203.156");
INSERT INTO `wp_aiowps_failed_logins` VALUES("869", "0", "admin", "2022-10-06 07:01:01", "185.2.4.134");
INSERT INTO `wp_aiowps_failed_logins` VALUES("870", "1", "ucr", "2022-10-06 10:14:22", "165.232.180.174");
INSERT INTO `wp_aiowps_failed_logins` VALUES("871", "1", "ucr", "2022-10-06 14:17:41", "150.136.250.229");
INSERT INTO `wp_aiowps_failed_logins` VALUES("872", "1", "ucr", "2022-10-06 15:41:24", "146.56.99.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("873", "0", "admin", "2022-10-07 03:18:28", "120.78.15.126");
INSERT INTO `wp_aiowps_failed_logins` VALUES("874", "1", "ucr", "2022-10-07 05:53:41", "144.217.15.207");
INSERT INTO `wp_aiowps_failed_logins` VALUES("875", "1", "ucr", "2022-10-07 13:16:05", "161.35.52.207");
INSERT INTO `wp_aiowps_failed_logins` VALUES("876", "1", "ucr", "2022-10-07 15:29:07", "185.2.4.134");
INSERT INTO `wp_aiowps_failed_logins` VALUES("877", "1", "ucr", "2022-10-07 15:29:07", "185.2.4.134");
INSERT INTO `wp_aiowps_failed_logins` VALUES("878", "1", "ucr", "2022-10-09 17:14:58", "159.203.143.36");
INSERT INTO `wp_aiowps_failed_logins` VALUES("879", "0", "admin", "2022-10-09 22:09:04", "64.227.183.25");
INSERT INTO `wp_aiowps_failed_logins` VALUES("880", "0", "admin", "2022-10-09 22:09:04", "64.227.183.25");
INSERT INTO `wp_aiowps_failed_logins` VALUES("881", "0", "admin", "2022-10-10 00:24:08", "198.244.167.101");
INSERT INTO `wp_aiowps_failed_logins` VALUES("882", "0", "admin", "2022-10-10 01:48:50", "209.97.162.248");
INSERT INTO `wp_aiowps_failed_logins` VALUES("883", "0", "admin", "2022-10-10 10:19:30", "43.251.135.37");
INSERT INTO `wp_aiowps_failed_logins` VALUES("884", "0", "admin", "2022-10-11 05:30:24", "111.231.200.129");
INSERT INTO `wp_aiowps_failed_logins` VALUES("885", "0", "admin", "2022-10-11 07:19:44", "144.217.15.207");
INSERT INTO `wp_aiowps_failed_logins` VALUES("886", "0", "admin", "2022-10-11 11:33:20", "164.92.73.132");
INSERT INTO `wp_aiowps_failed_logins` VALUES("887", "0", "admin", "2022-10-11 12:42:41", "68.183.71.174");
INSERT INTO `wp_aiowps_failed_logins` VALUES("888", "0", "admin", "2022-10-11 13:35:43", "34.75.65.218");
INSERT INTO `wp_aiowps_failed_logins` VALUES("889", "0", "admin", "2022-10-11 21:05:40", "82.165.184.74");
INSERT INTO `wp_aiowps_failed_logins` VALUES("890", "0", "admin", "2022-10-12 12:56:30", "202.21.38.119");
INSERT INTO `wp_aiowps_failed_logins` VALUES("891", "0", "admin", "2022-10-12 14:07:27", "34.75.65.218");
INSERT INTO `wp_aiowps_failed_logins` VALUES("892", "1", "ucr", "2022-10-14 00:08:08", "34.170.36.88");
INSERT INTO `wp_aiowps_failed_logins` VALUES("893", "1", "ucr", "2022-10-14 09:35:01", "43.251.135.37");
INSERT INTO `wp_aiowps_failed_logins` VALUES("894", "1", "ucr", "2022-10-14 10:12:36", "13.81.59.92");
INSERT INTO `wp_aiowps_failed_logins` VALUES("895", "1", "ucr", "2022-10-14 12:19:49", "198.244.167.101");
INSERT INTO `wp_aiowps_failed_logins` VALUES("896", "0", "admin", "2022-10-17 06:27:28", "77.240.13.186");
INSERT INTO `wp_aiowps_failed_logins` VALUES("897", "0", "admin", "2022-10-17 12:14:26", "23.97.205.210");
INSERT INTO `wp_aiowps_failed_logins` VALUES("898", "0", "admin", "2022-10-17 17:21:15", "54.36.182.160");
INSERT INTO `wp_aiowps_failed_logins` VALUES("899", "0", "admin", "2022-10-20 06:04:27", "148.72.214.245");
INSERT INTO `wp_aiowps_failed_logins` VALUES("900", "0", "admin", "2022-10-20 21:55:23", "66.33.193.231");
INSERT INTO `wp_aiowps_failed_logins` VALUES("901", "0", "admin", "2022-10-20 23:58:49", "93.114.185.76");
INSERT INTO `wp_aiowps_failed_logins` VALUES("902", "0", "admin", "2022-10-21 17:39:58", "23.99.229.218");
INSERT INTO `wp_aiowps_failed_logins` VALUES("903", "0", "admin", "2022-10-22 03:37:15", "139.59.85.224");
INSERT INTO `wp_aiowps_failed_logins` VALUES("904", "0", "admin", "2022-10-24 10:57:52", "34.75.65.218");
INSERT INTO `wp_aiowps_failed_logins` VALUES("905", "0", "admin", "2022-10-24 19:44:11", "20.204.131.100");
INSERT INTO `wp_aiowps_failed_logins` VALUES("906", "0", "admin", "2022-10-24 19:44:12", "20.204.131.100");
INSERT INTO `wp_aiowps_failed_logins` VALUES("907", "0", "admin", "2022-10-24 19:44:13", "20.204.131.100");
INSERT INTO `wp_aiowps_failed_logins` VALUES("908", "0", "admin", "2022-10-24 19:44:14", "20.204.131.100");
INSERT INTO `wp_aiowps_failed_logins` VALUES("909", "0", "admin", "2022-10-24 19:44:15", "20.204.131.100");
INSERT INTO `wp_aiowps_failed_logins` VALUES("910", "0", "admin", "2022-10-24 19:44:16", "20.204.131.100");
INSERT INTO `wp_aiowps_failed_logins` VALUES("911", "0", "admin", "2022-10-24 19:44:16", "20.204.131.100");
INSERT INTO `wp_aiowps_failed_logins` VALUES("912", "0", "admin", "2022-10-24 19:44:17", "20.204.131.100");
INSERT INTO `wp_aiowps_failed_logins` VALUES("913", "0", "admin", "2022-10-24 19:44:18", "20.204.131.100");
INSERT INTO `wp_aiowps_failed_logins` VALUES("914", "0", "admin", "2022-10-24 19:44:19", "20.204.131.100");
INSERT INTO `wp_aiowps_failed_logins` VALUES("915", "0", "admin", "2022-10-24 19:44:20", "20.204.131.100");
INSERT INTO `wp_aiowps_failed_logins` VALUES("916", "0", "admin", "2022-10-24 19:44:21", "20.204.131.100");
INSERT INTO `wp_aiowps_failed_logins` VALUES("917", "0", "admin", "2022-10-24 19:44:22", "20.204.131.100");
INSERT INTO `wp_aiowps_failed_logins` VALUES("918", "0", "admin", "2022-10-24 19:44:22", "20.204.131.100");
INSERT INTO `wp_aiowps_failed_logins` VALUES("919", "0", "admin", "2022-10-24 19:44:23", "20.204.131.100");
INSERT INTO `wp_aiowps_failed_logins` VALUES("920", "0", "admin", "2022-10-24 19:44:24", "20.204.131.100");
INSERT INTO `wp_aiowps_failed_logins` VALUES("921", "0", "admin", "2022-10-24 19:44:24", "20.204.131.100");
INSERT INTO `wp_aiowps_failed_logins` VALUES("922", "0", "admin", "2022-10-24 19:44:25", "20.204.131.100");
INSERT INTO `wp_aiowps_failed_logins` VALUES("923", "0", "admin", "2022-10-24 19:44:25", "20.204.131.100");
INSERT INTO `wp_aiowps_failed_logins` VALUES("924", "0", "admin", "2022-10-25 01:41:49", "51.91.220.143");
INSERT INTO `wp_aiowps_failed_logins` VALUES("925", "0", "admin", "2022-10-26 02:40:10", "138.68.140.0");
INSERT INTO `wp_aiowps_failed_logins` VALUES("926", "0", "admin", "2022-10-26 03:17:25", "85.191.40.94");
INSERT INTO `wp_aiowps_failed_logins` VALUES("927", "0", "admin", "2022-10-26 03:17:25", "85.191.40.94");
INSERT INTO `wp_aiowps_failed_logins` VALUES("928", "0", "admin", "2022-10-26 15:45:55", "47.96.74.105");
INSERT INTO `wp_aiowps_failed_logins` VALUES("929", "0", "admin", "2022-10-26 17:36:03", "207.154.248.39");
INSERT INTO `wp_aiowps_failed_logins` VALUES("930", "0", "admin", "2022-10-26 17:37:03", "148.72.207.163");
INSERT INTO `wp_aiowps_failed_logins` VALUES("931", "0", "admin", "2022-10-26 17:46:05", "198.98.50.216");
INSERT INTO `wp_aiowps_failed_logins` VALUES("932", "0", "admin", "2022-10-26 20:51:20", "198.98.50.216");
INSERT INTO `wp_aiowps_failed_logins` VALUES("933", "0", "admin", "2022-10-26 21:55:50", "188.166.225.235");
INSERT INTO `wp_aiowps_failed_logins` VALUES("934", "0", "admin", "2022-10-26 22:27:24", "51.91.151.60");
INSERT INTO `wp_aiowps_failed_logins` VALUES("935", "0", "admin", "2022-10-27 02:24:59", "80.88.88.149");
INSERT INTO `wp_aiowps_failed_logins` VALUES("936", "0", "admin", "2022-10-27 05:27:46", "120.27.240.230");
INSERT INTO `wp_aiowps_failed_logins` VALUES("937", "0", "admin", "2022-10-27 07:36:50", "207.154.250.8");
INSERT INTO `wp_aiowps_failed_logins` VALUES("938", "0", "admin", "2022-10-27 09:51:36", "109.168.97.89");
INSERT INTO `wp_aiowps_failed_logins` VALUES("939", "0", "admin", "2022-10-27 17:08:23", "104.41.221.5");
INSERT INTO `wp_aiowps_failed_logins` VALUES("940", "0", "wadminw", "2022-10-28 16:06:25", "68.183.177.20");
INSERT INTO `wp_aiowps_failed_logins` VALUES("941", "0", "admin", "2022-10-29 03:53:18", "51.255.81.60");
INSERT INTO `wp_aiowps_failed_logins` VALUES("942", "0", "admin", "2022-10-29 05:07:30", "35.238.16.223");
INSERT INTO `wp_aiowps_failed_logins` VALUES("943", "0", "admin", "2022-10-29 08:18:13", "164.92.73.132");
INSERT INTO `wp_aiowps_failed_logins` VALUES("944", "0", "admin", "2022-10-29 16:09:25", "81.70.248.169");
INSERT INTO `wp_aiowps_failed_logins` VALUES("945", "0", "admin", "2022-10-29 18:10:51", "13.81.59.92");
INSERT INTO `wp_aiowps_failed_logins` VALUES("946", "0", "admin", "2022-10-29 20:31:08", "103.130.218.189");
INSERT INTO `wp_aiowps_failed_logins` VALUES("947", "0", "admin", "2022-10-30 12:08:32", "188.212.34.69");
INSERT INTO `wp_aiowps_failed_logins` VALUES("948", "0", "admin", "2022-11-01 07:40:17", "46.32.228.70");
INSERT INTO `wp_aiowps_failed_logins` VALUES("949", "1", "ucr", "2022-11-01 14:38:33", "47.105.73.13");
INSERT INTO `wp_aiowps_failed_logins` VALUES("950", "0", "admin", "2022-11-03 04:23:50", "159.203.143.36");
INSERT INTO `wp_aiowps_failed_logins` VALUES("951", "0", "admin", "2022-11-03 07:49:19", "47.110.72.238");
INSERT INTO `wp_aiowps_failed_logins` VALUES("952", "0", "admin", "2022-11-03 07:55:54", "137.184.124.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("953", "1", "ucr", "2022-11-03 07:59:03", "205.185.116.156");
INSERT INTO `wp_aiowps_failed_logins` VALUES("954", "0", "admin", "2022-11-03 08:34:55", "142.93.203.156");
INSERT INTO `wp_aiowps_failed_logins` VALUES("955", "0", "admin", "2022-11-03 10:11:08", "192.71.144.12");
INSERT INTO `wp_aiowps_failed_logins` VALUES("956", "0", "admin", "2022-11-03 10:56:27", "139.59.82.122");
INSERT INTO `wp_aiowps_failed_logins` VALUES("957", "0", "admin", "2022-11-03 11:08:26", "139.59.82.122");
INSERT INTO `wp_aiowps_failed_logins` VALUES("958", "1", "ucr", "2022-11-03 16:34:01", "3.115.198.208");
INSERT INTO `wp_aiowps_failed_logins` VALUES("959", "1", "ucr", "2022-11-03 16:51:16", "159.203.120.246");
INSERT INTO `wp_aiowps_failed_logins` VALUES("960", "1", "ucr", "2022-11-03 21:03:54", "208.113.180.18");
INSERT INTO `wp_aiowps_failed_logins` VALUES("961", "1", "ucr", "2022-11-04 05:21:58", "44.193.57.42");
INSERT INTO `wp_aiowps_failed_logins` VALUES("962", "1", "ucr", "2022-11-04 07:13:33", "205.185.116.156");
INSERT INTO `wp_aiowps_failed_logins` VALUES("963", "1", "ucr", "2022-11-04 07:13:33", "205.185.116.156");
INSERT INTO `wp_aiowps_failed_logins` VALUES("964", "1", "ucr", "2022-11-04 07:15:25", "34.78.198.205");
INSERT INTO `wp_aiowps_failed_logins` VALUES("965", "1", "ucr", "2022-11-04 12:17:43", "159.65.200.228");
INSERT INTO `wp_aiowps_failed_logins` VALUES("966", "1", "ucr", "2022-11-04 14:38:21", "149.56.26.54");
INSERT INTO `wp_aiowps_failed_logins` VALUES("967", "1", "ucr", "2022-11-04 18:15:13", "166.62.125.246");
INSERT INTO `wp_aiowps_failed_logins` VALUES("968", "1", "ucr", "2022-11-04 23:22:20", "113.161.116.141");
INSERT INTO `wp_aiowps_failed_logins` VALUES("969", "1", "ucr", "2022-11-04 23:44:41", "47.114.72.18");
INSERT INTO `wp_aiowps_failed_logins` VALUES("970", "1", "ucr", "2022-11-05 02:10:20", "188.166.91.172");
INSERT INTO `wp_aiowps_failed_logins` VALUES("971", "1", "ucr", "2022-11-05 02:31:19", "194.195.121.233");
INSERT INTO `wp_aiowps_failed_logins` VALUES("972", "1", "ucr", "2022-11-05 03:14:56", "167.172.206.144");
INSERT INTO `wp_aiowps_failed_logins` VALUES("973", "1", "ucr", "2022-11-05 05:02:50", "209.141.44.126");
INSERT INTO `wp_aiowps_failed_logins` VALUES("974", "1", "ucr", "2022-11-05 05:46:04", "188.212.34.69");
INSERT INTO `wp_aiowps_failed_logins` VALUES("975", "1", "ucr", "2022-11-05 06:07:50", "45.55.44.23");
INSERT INTO `wp_aiowps_failed_logins` VALUES("976", "1", "ucr", "2022-11-05 07:11:56", "151.106.41.64");
INSERT INTO `wp_aiowps_failed_logins` VALUES("977", "1", "ucr", "2022-11-05 08:15:44", "139.59.85.224");
INSERT INTO `wp_aiowps_failed_logins` VALUES("978", "1", "ucr", "2022-11-05 08:15:44", "139.59.85.224");
INSERT INTO `wp_aiowps_failed_logins` VALUES("979", "1", "ucr", "2022-11-05 08:16:25", "148.72.214.194");
INSERT INTO `wp_aiowps_failed_logins` VALUES("980", "1", "ucr", "2022-11-05 08:16:25", "148.72.214.194");
INSERT INTO `wp_aiowps_failed_logins` VALUES("981", "1", "ucr", "2022-11-05 08:36:03", "113.161.116.141");
INSERT INTO `wp_aiowps_failed_logins` VALUES("982", "1", "ucr", "2022-11-05 08:36:03", "113.161.116.141");
INSERT INTO `wp_aiowps_failed_logins` VALUES("983", "1", "ucr", "2022-11-05 08:36:49", "47.105.73.13");
INSERT INTO `wp_aiowps_failed_logins` VALUES("984", "1", "ucr", "2022-11-05 09:41:05", "150.109.148.216");
INSERT INTO `wp_aiowps_failed_logins` VALUES("985", "1", "ucr", "2022-11-05 09:41:50", "192.145.239.35");
INSERT INTO `wp_aiowps_failed_logins` VALUES("986", "1", "ucr", "2022-11-05 12:01:20", "68.183.75.82");
INSERT INTO `wp_aiowps_failed_logins` VALUES("987", "1", "ucr", "2022-11-05 12:34:41", "46.105.29.21");
INSERT INTO `wp_aiowps_failed_logins` VALUES("988", "1", "ucr", "2022-11-06 16:30:54", "124.106.71.219");
INSERT INTO `wp_aiowps_failed_logins` VALUES("989", "1", "ucr", "2022-11-06 22:23:08", "175.178.125.173");
INSERT INTO `wp_aiowps_failed_logins` VALUES("990", "1", "ucr", "2022-11-07 04:40:31", "51.79.80.79");
INSERT INTO `wp_aiowps_failed_logins` VALUES("991", "1", "ucr", "2022-11-07 08:05:38", "3.115.198.208");
INSERT INTO `wp_aiowps_failed_logins` VALUES("992", "1", "ucr", "2022-11-07 09:45:12", "173.236.224.113");
INSERT INTO `wp_aiowps_failed_logins` VALUES("993", "1", "ucr", "2022-11-07 11:01:49", "144.126.223.177");
INSERT INTO `wp_aiowps_failed_logins` VALUES("994", "1", "ucr", "2022-11-07 14:08:39", "92.204.138.28");
INSERT INTO `wp_aiowps_failed_logins` VALUES("995", "1", "ucr", "2022-11-07 14:20:53", "185.2.4.147");
INSERT INTO `wp_aiowps_failed_logins` VALUES("996", "0", "admin", "2022-11-07 15:35:38", "132.145.249.180");
INSERT INTO `wp_aiowps_failed_logins` VALUES("997", "0", "admin", "2022-11-07 21:40:24", "141.94.247.170");
INSERT INTO `wp_aiowps_failed_logins` VALUES("998", "0", "admin", "2022-11-08 01:46:19", "54.37.156.240");
INSERT INTO `wp_aiowps_failed_logins` VALUES("999", "1", "ucr", "2022-11-08 17:44:10", "51.159.155.6");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1000", "1", "ucr", "2022-11-08 20:46:28", "185.250.251.124");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1001", "1", "ucr", "2022-11-08 21:16:53", "107.189.14.89");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1002", "1", "ucr", "2022-11-08 22:05:32", "164.132.170.4");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1003", "1", "ucr", "2022-11-08 23:20:31", "120.27.240.230");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1004", "0", "admin", "2022-11-09 03:39:14", "49.233.192.222");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1005", "1", "ucr", "2022-11-09 07:36:55", "3.108.138.206");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1006", "1", "ucr", "2022-11-09 09:44:12", "45.61.185.74");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1007", "1", "ucr", "2022-11-09 09:48:32", "107.189.6.184");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1008", "1", "ucr", "2022-11-09 10:47:01", "145.239.30.120");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1009", "1", "ucr", "2022-11-09 11:15:34", "205.185.120.53");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1010", "1", "ucr", "2022-11-09 14:30:22", "139.59.237.225");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1011", "1", "ucr", "2022-11-09 15:04:33", "209.141.37.194");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1012", "0", "admin", "2022-11-09 20:14:53", "128.199.14.4");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1013", "0", "admin", "2022-11-09 20:14:53", "128.199.14.4");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1014", "0", "admin", "2022-11-09 23:14:46", "103.219.60.130");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1015", "0", "admin", "2022-11-10 11:56:28", "31.192.224.145");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1016", "0", "admin", "2022-11-10 12:52:31", "103.114.35.88");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1017", "0", "admin", "2022-11-10 13:05:11", "81.88.52.221");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1018", "0", "admin", "2022-11-10 13:15:44", "202.21.38.119");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1019", "1", "ucr", "2022-11-11 19:03:08", "45.61.187.99");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1020", "1", "ucr", "2022-11-11 19:08:00", "198.98.50.216");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1021", "1", "ucr", "2022-11-11 19:08:00", "198.98.50.216");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1022", "1", "ucr", "2022-11-11 21:43:53", "209.141.47.94");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1023", "1", "ucr", "2022-11-12 03:44:03", "45.61.187.99");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1024", "0", "admin", "2022-11-13 10:26:54", "141.95.233.130");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1025", "0", "admin", "2022-11-13 13:03:26", "106.15.38.206");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1026", "0", "FredrikModh", "2022-11-16 00:48:49", "44.201.204.11");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1027", "1", "ucr", "2022-11-17 08:35:01", "153.92.13.107");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1028", "1", "ucr", "2022-11-17 10:37:52", "35.187.58.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1029", "0", "admin", "2022-11-17 10:55:04", "39.105.183.18");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1030", "1", "ucr", "2022-11-17 14:42:24", "164.132.170.4");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1031", "1", "ucr", "2022-11-17 14:58:57", "69.163.207.121");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1032", "1", "ucr", "2022-11-17 15:44:25", "103.114.35.88");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1033", "1", "ucr", "2022-11-17 17:00:37", "159.203.121.12");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1034", "0", "admin", "2022-11-17 21:48:29", "207.154.250.8");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1035", "0", "wadminw", "2022-11-21 12:41:29", "206.189.163.232");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1036", "1", "ucr", "2022-11-21 18:42:31", "107.189.1.148");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1037", "0", "admin", "2022-11-23 11:16:25", "83.143.116.3");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1038", "0", "wadminw", "2022-11-23 12:57:28", "35.201.224.83");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1039", "0", "poznan", "2022-11-24 08:35:10", "45.61.188.188");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1040", "0", "poznan", "2022-11-25 09:41:02", "45.61.185.74");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1041", "0", "admin", "2022-11-28 03:19:02", "72.167.225.151");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1042", "0", "admin", "2022-11-30 23:49:37", "103.31.249.221");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1043", "0", "admin", "2022-11-30 23:55:02", "109.168.97.89");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1044", "0", "admin", "2022-11-30 23:57:02", "142.93.203.156");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1045", "0", "admin", "2022-12-01 00:46:01", "14.241.233.205");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1046", "0", "admin", "2022-12-01 00:48:11", "188.166.225.235");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1047", "0", "admin", "2022-12-01 02:28:20", "34.65.234.0");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1048", "0", "admin", "2022-12-01 02:28:20", "34.65.234.0");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1049", "0", "admin", "2022-12-01 02:30:28", "14.241.233.205");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1050", "0", "admin", "2022-12-01 02:30:28", "14.241.233.205");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1051", "0", "pl", "2022-12-01 05:51:25", "104.244.77.229");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1052", "0", "admin", "2022-12-01 05:55:56", "43.154.9.162");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1053", "0", "admin", "2022-12-01 06:02:13", "69.163.186.158");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1054", "0", "admin", "2022-12-01 06:04:36", "178.217.190.82");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1055", "0", "admin", "2022-12-01 12:56:37", "77.240.13.186");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1056", "0", "admin", "2022-12-01 19:18:30", "185.2.4.56");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1057", "0", "admin", "2022-12-02 01:33:46", "143.244.177.220");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1058", "0", "admin", "2022-12-02 01:33:46", "143.244.177.220");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1059", "0", "admin", "2022-12-02 03:44:48", "188.166.91.172");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1060", "0", "admin", "2022-12-02 10:45:49", "23.97.205.210");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1061", "0", "admin", "2022-12-02 13:05:54", "144.126.223.177");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1062", "0", "admin", "2022-12-03 07:21:02", "104.244.77.192");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1063", "0", "pl", "2022-12-04 17:43:46", "209.141.48.210");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1064", "0", "1gridadmin", "2022-12-05 20:56:21", "120.79.8.223");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1065", "0", "admin", "2022-12-06 05:30:23", "46.101.150.34");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1066", "1", "ucr", "2022-12-06 05:53:06", "185.252.178.103");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1067", "0", "admin", "2022-12-06 05:53:27", "54.37.235.96");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1068", "0", "administrator", "2022-12-06 06:02:26", "198.98.60.32");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1069", "0", "poznan", "2022-12-06 06:06:52", "209.141.47.94");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1070", "0", "admin", "2022-12-06 06:41:11", "138.68.180.230");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1071", "0", "admin", "2022-12-06 09:24:04", "103.130.218.189");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1072", "0", "poznan", "2022-12-06 14:54:55", "198.98.60.32");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1073", "1", "ucr", "2022-12-07 08:35:27", "185.252.178.103");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1074", "0", "admin", "2022-12-08 00:40:17", "54.37.156.240");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1075", "0", "admin", "2022-12-08 02:56:13", "128.199.131.42");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1076", "0", "administrator", "2022-12-08 04:50:22", "198.98.50.19");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1077", "1", "ucr", "2022-12-08 04:51:10", "209.141.48.210");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1078", "1", "ucr", "2022-12-08 04:51:10", "209.141.48.210");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1079", "0", "admin", "2022-12-08 04:55:56", "178.128.167.203");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1080", "0", "administrator", "2022-12-08 04:56:43", "209.141.48.210");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1081", "0", "admin", "2022-12-08 05:01:06", "104.244.77.192");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1082", "0", "admin", "2022-12-08 05:40:36", "209.141.43.56");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1083", "0", "admin", "2022-12-08 05:54:51", "162.253.42.216");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1084", "0", "FredrikModh", "2022-12-08 09:45:15", "120.79.8.223");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1085", "0", "admin", "2022-12-08 11:38:11", "161.35.52.207");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1086", "0", "winda", "2022-12-08 12:43:01", "107.189.13.99");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1087", "0", "admin", "2022-12-08 23:55:18", "80.247.230.51");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1088", "0", "admin", "2022-12-09 02:22:07", "185.2.4.33");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1089", "0", "admin", "2022-12-09 02:54:54", "117.50.16.203");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1090", "0", "admin", "2022-12-09 08:23:59", "107.189.14.89");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1091", "0", "admin", "2022-12-09 10:47:00", "138.68.96.111");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1092", "0", "admin", "2022-12-09 12:43:22", "151.106.38.6");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1093", "0", "pl", "2022-12-09 16:19:12", "107.189.14.89");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1094", "0", "administrator", "2022-12-10 05:47:51", "107.189.14.89");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1095", "0", "winda", "2022-12-10 06:00:18", "107.189.6.203");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1096", "1", "ucr", "2022-12-10 20:44:59", "107.189.14.89");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1097", "0", "pl", "2022-12-10 22:12:20", "205.185.121.252");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1098", "0", "admin", "2022-12-10 22:46:13", "95.217.167.17");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1099", "0", "admin", "2022-12-11 00:59:54", "148.72.214.194");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1100", "0", "pl", "2022-12-11 02:00:20", "209.141.45.47");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1101", "1", "ucr", "2022-12-11 06:15:34", "209.141.45.47");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1102", "0", "pl", "2022-12-11 11:25:04", "199.195.253.123");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1103", "0", "winda", "2022-12-12 01:58:52", "209.141.43.56");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1104", "0", "pl", "2022-12-12 14:58:24", "45.61.184.58");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1105", "0", "admin", "2022-12-12 17:49:46", "159.89.228.214");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1106", "0", "admin", "2022-12-13 01:44:13", "103.147.241.56");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1107", "0", "pl", "2022-12-13 02:29:18", "107.189.6.184");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1108", "0", "admin", "2022-12-13 06:06:30", "46.105.29.21");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1109", "0", "administrator", "2022-12-13 11:04:19", "199.195.253.123");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1110", "0", "admin", "2022-12-13 15:02:49", "147.182.249.22");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1111", "1", "ucr", "2022-12-14 17:43:43", "51.91.151.60");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1112", "1", "ucr", "2022-12-14 19:09:29", "85.191.55.178");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1113", "1", "ucr", "2022-12-15 01:02:22", "157.245.207.53");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1114", "1", "ucr", "2022-12-15 01:15:25", "188.166.236.35");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1115", "1", "ucr", "2022-12-15 02:28:41", "178.62.85.205");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1116", "0", "admin", "2022-12-15 09:40:17", "23.99.229.218");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1117", "0", "admin", "2022-12-15 14:26:49", "82.166.39.15");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1118", "0", "admin", "2022-12-15 18:49:50", "209.141.43.56");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1119", "0", "administrator", "2022-12-16 00:02:16", "104.244.77.192");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1120", "0", "admin", "2022-12-18 20:44:14", "171.244.0.91");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1121", "0", "admin", "2022-12-18 20:44:14", "171.244.0.91");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1122", "0", "admin", "2022-12-19 00:58:10", "103.147.241.56");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1123", "0", "admin", "2022-12-19 10:13:11", "67.205.11.198");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1124", "0", "admin", "2022-12-21 08:14:53", "79.110.62.41");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1125", "0", "admin", "2022-12-21 09:50:06", "128.199.80.137");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1126", "0", "admin", "2022-12-21 10:06:26", "47.57.186.73");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1127", "0", "admin", "2022-12-21 10:14:22", "43.153.168.248");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1128", "0", "admin", "2022-12-23 23:33:21", "45.61.184.58");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1129", "0", "admin", "2022-12-23 23:33:21", "45.61.184.58");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1130", "1", "ucr", "2022-12-24 15:08:45", "45.61.186.46");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1131", "1", "ucr", "2022-12-25 10:52:01", "209.141.44.126");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1132", "0", "admin", "2022-12-27 19:08:48", "209.97.162.248");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1133", "0", "admin", "2022-12-27 19:08:48", "209.97.162.248");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1134", "0", "admin", "2022-12-28 00:40:07", "207.154.250.8");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1135", "0", "admin", "2022-12-29 17:06:12", "82.166.39.15");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1136", "1", "ucr", "2022-12-29 17:21:27", "107.189.6.203");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1137", "0", "admin", "2022-12-29 17:24:22", "133.130.103.36");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1138", "0", "admin", "2022-12-29 17:25:26", "138.68.96.111");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1139", "0", "admin", "2022-12-29 17:28:11", "23.99.229.218");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1140", "0", "admin", "2022-12-29 17:42:11", "145.239.30.120");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1141", "0", "admin", "2022-12-29 17:43:10", "34.69.109.132");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1142", "0", "admin", "2022-12-29 17:46:02", "138.68.96.111");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1143", "0", "admin", "2022-12-29 18:00:12", "80.247.230.51");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1144", "0", "admin", "2022-12-29 18:01:08", "34.75.65.218");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1145", "0", "admin", "2022-12-29 18:03:59", "67.205.11.198");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1146", "0", "admin", "2022-12-29 18:18:13", "205.196.221.177");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1147", "0", "admin", "2022-12-29 18:19:09", "142.93.203.156");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1148", "0", "admin", "2022-12-29 18:22:00", "103.130.218.189");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1149", "1", "ucr", "2022-12-29 18:27:35", "107.189.1.148");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1150", "0", "admin", "2022-12-29 18:36:20", "207.46.234.202");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1151", "0", "admin", "2022-12-29 18:37:16", "103.130.219.13");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1152", "0", "admin", "2022-12-29 18:40:07", "178.217.190.82");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1153", "0", "admin", "2022-12-29 18:54:28", "173.236.152.148");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1154", "0", "admin", "2022-12-29 18:55:24", "207.154.250.8");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1155", "0", "admin", "2022-12-29 18:58:21", "111.93.53.163");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1156", "0", "admin", "2022-12-29 19:13:00", "72.167.34.14");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1157", "0", "admin", "2022-12-29 19:13:59", "213.175.66.138");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1158", "0", "admin", "2022-12-29 19:16:51", "111.93.53.163");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1159", "1", "ucr", "2022-12-29 19:22:41", "107.189.6.203");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1160", "1", "ucr", "2022-12-29 19:22:41", "107.189.6.203");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1161", "1", "ucr", "2022-12-29 19:30:52", "209.141.48.210");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1162", "0", "admin", "2022-12-29 19:31:19", "111.93.53.163");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1163", "0", "admin", "2022-12-29 19:32:24", "61.219.43.253");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1164", "0", "admin", "2022-12-29 19:35:13", "92.204.138.28");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1165", "1", "ucr", "2022-12-29 19:36:57", "107.189.6.184");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1166", "1", "ucr", "2022-12-29 19:36:57", "107.189.6.184");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1167", "1", "ucr", "2022-12-29 19:45:01", "209.141.47.134");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1168", "1", "ucr", "2022-12-29 19:45:01", "209.141.47.134");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1169", "0", "admin", "2022-12-29 19:49:49", "202.29.236.140");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1170", "0", "admin", "2022-12-29 20:30:34", "185.2.5.77");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1171", "1", "ucr", "2022-12-30 00:30:44", "198.98.60.32");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1172", "1", "ucr", "2022-12-30 03:37:42", "118.24.106.172");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1173", "1", "ucr", "2022-12-30 04:51:36", "86.105.198.149");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1174", "1", "ucr", "2022-12-30 06:35:34", "185.2.4.134");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1175", "1", "ucr", "2022-12-30 07:00:37", "178.128.107.59");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1176", "1", "ucr", "2022-12-30 09:01:07", "141.94.247.170");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1177", "1", "ucr", "2022-12-30 10:06:36", "45.120.69.121");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1178", "1", "ucr", "2022-12-30 10:06:36", "45.120.69.121");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1179", "1", "ucr", "2022-12-30 12:43:12", "146.56.99.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1180", "1", "ucr", "2022-12-30 13:32:47", "141.94.247.170");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1181", "0", "admin", "2022-12-30 16:48:49", "54.37.235.96");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1182", "0", "admin", "2022-12-30 16:58:32", "138.68.96.111");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1183", "0", "admin", "2022-12-30 19:24:47", "141.94.247.170");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1184", "0", "admin", "2022-12-30 19:24:47", "141.94.247.170");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1185", "0", "admin", "2022-12-30 23:16:27", "39.108.148.88");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1186", "0", "admin", "2022-12-31 07:40:45", "159.89.164.128");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1187", "1", "ucr", "2023-01-01 04:56:55", "209.141.57.9");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1188", "1", "ucr", "2023-01-01 14:55:13", "142.93.203.156");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1189", "1", "ucr", "2023-01-01 17:59:58", "51.210.183.128");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1190", "1", "ucr", "2023-01-01 21:36:00", "52.138.180.227");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1191", "0", "winda", "2023-01-01 21:42:26", "205.185.116.156");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1192", "1", "ucr", "2023-01-01 22:30:14", "39.108.148.88");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1193", "1", "ucr", "2023-01-01 23:13:49", "185.2.4.134");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1194", "1", "ucr", "2023-01-02 01:00:31", "109.168.97.89");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1195", "1", "ucr", "2023-01-02 01:58:32", "209.141.48.210");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1196", "1", "ucr", "2023-01-02 05:25:10", "204.232.237.184");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1197", "0", "winda", "2023-01-03 17:42:19", "198.98.60.32");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1198", "1", "ucr", "2023-01-04 10:56:16", "209.141.49.253");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1199", "1", "ucr", "2023-01-04 17:17:55", "107.189.6.184");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1200", "1", "ucr", "2023-01-04 22:09:52", "207.46.234.202");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1201", "1", "ucr", "2023-01-05 04:43:17", "45.61.187.99");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1202", "0", "admin", "2023-01-05 15:50:11", "181.174.125.214");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1203", "0", "admin", "2023-01-05 18:24:38", "64.227.183.25");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1204", "0", "admin", "2023-01-05 18:33:22", "164.132.170.4");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1205", "0", "admin", "2023-01-05 22:56:03", "54.37.235.96");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1206", "0", "admin", "2023-01-06 07:41:02", "43.154.9.162");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1207", "0", "admin", "2023-01-06 13:04:52", "81.88.52.205");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1208", "0", "admin", "2023-01-06 13:04:52", "81.88.52.205");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1209", "0", "admin", "2023-01-06 14:57:25", "82.166.39.15");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1210", "0", "admin", "2023-01-06 22:08:44", "81.88.52.160");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1211", "1", "ucr", "2023-01-07 07:25:54", "209.141.49.253");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1212", "1", "ucr", "2023-01-08 05:51:14", "209.141.36.190");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1213", "1", "ucr", "2023-01-08 08:45:56", "159.28.220.85");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1214", "1", "ucr", "2023-01-08 08:45:56", "159.28.220.85");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1215", "0", "mail", "2023-01-08 09:59:51", "107.189.1.148");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1216", "1", "ucr", "2023-01-08 10:25:18", "209.141.45.47");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1217", "1", "ucr", "2023-01-08 20:52:13", "198.98.60.32");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1218", "1", "ucr", "2023-01-08 21:21:11", "209.141.49.253");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1219", "0", "admin", "2023-01-08 21:56:08", "34.82.218.143");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1220", "0", "admin", "2023-01-09 03:50:24", "167.99.228.9");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1221", "0", "admin", "2023-01-09 08:13:20", "198.98.60.32");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1222", "0", "admin", "2023-01-09 08:26:59", "43.154.9.162");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1223", "1", "ucr", "2023-01-09 09:28:21", "107.189.6.203");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1224", "1", "ucr", "2023-01-09 14:49:54", "209.141.49.253");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1225", "1", "ucr", "2023-01-09 15:29:46", "198.98.48.183");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1226", "1", "ucr", "2023-01-09 15:31:20", "209.141.47.134");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1227", "1", "ucr", "2023-01-10 00:49:44", "107.189.13.99");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1228", "0", "admin", "2023-01-10 16:08:30", "34.69.109.132");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1229", "0", "mail", "2023-01-11 22:47:49", "45.61.184.58");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1230", "1", "ucr", "2023-01-12 00:17:19", "209.141.48.210");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1231", "0", "admin", "2023-01-12 22:44:39", "92.53.96.222");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1232", "0", "admin", "2023-01-13 03:58:21", "104.244.77.229");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1233", "0", "admin", "2023-01-13 03:59:36", "81.88.52.160");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1234", "0", "admin", "2023-01-13 08:35:18", "103.28.36.113");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1235", "0", "admin", "2023-01-13 10:44:18", "54.37.156.240");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1236", "0", "admin", "2023-01-13 17:54:17", "88.135.37.49");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1237", "0", "admin", "2023-01-13 22:54:05", "97.74.80.103");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1238", "0", "admin", "2023-01-14 00:42:21", "202.29.236.140");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1239", "0", "admin", "2023-01-14 02:04:26", "148.72.244.186");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1240", "0", "admin", "2023-01-14 18:54:50", "106.15.38.206");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1241", "0", "mail", "2023-01-14 21:51:40", "107.189.6.203");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1242", "1", "ucr", "2023-01-15 04:57:08", "45.61.186.46");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1243", "0", "admin", "2023-01-15 07:11:41", "82.165.88.193");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1244", "0", "admin", "2023-01-15 08:09:12", "185.231.115.134");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1245", "0", "admin", "2023-01-16 05:49:27", "205.185.116.162");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1246", "0", "admin", "2023-01-16 15:33:51", "178.217.190.82");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1247", "0", "admin", "2023-01-17 00:39:47", "173.236.169.230");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1248", "0", "admin", "2023-01-17 07:24:46", "165.227.93.224");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1249", "1", "ucr", "2023-01-17 19:20:39", "107.189.6.203");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1250", "1", "ucr", "2023-01-17 20:39:16", "209.141.47.94");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1251", "0", "admin", "2023-01-18 01:53:14", "47.114.72.18");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1252", "0", "admin", "2023-01-18 15:52:05", "47.110.72.238");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1253", "0", "admin", "2023-01-18 15:52:05", "47.110.72.238");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1254", "0", "wadminw", "2023-01-18 15:53:53", "103.164.34.93");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1255", "0", "admin", "2023-01-19 03:28:14", "121.36.224.178");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1256", "0", "winda", "2023-01-20 03:00:26", "209.141.36.190");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1257", "1", "ucr", "2023-01-20 05:15:51", "209.141.48.210");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1258", "1", "ucr", "2023-01-20 05:16:18", "205.185.116.156");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1259", "0", "admin", "2023-01-20 05:32:41", "180.250.28.34");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1260", "1", "ucr", "2023-01-20 06:14:59", "198.98.48.183");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1261", "0", "admin", "2023-01-20 06:21:29", "192.71.144.12");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1262", "0", "admin", "2023-01-20 06:23:39", "167.99.228.9");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1263", "1", "ucr", "2023-01-20 06:50:57", "209.141.36.190");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1264", "0", "admin", "2023-01-20 09:45:32", "54.37.235.96");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1265", "1", "ucr", "2023-01-21 05:51:07", "107.189.3.40");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1266", "1", "ucr", "2023-01-21 07:07:14", "107.189.3.40");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1267", "0", "admin", "2023-01-21 10:30:33", "132.145.249.180");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1268", "0", "admin", "2023-01-21 19:30:17", "159.65.200.228");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1269", "0", "administrator", "2023-01-21 20:35:37", "107.189.14.89");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1270", "0", "admin", "2023-01-21 23:15:24", "199.182.169.134");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1271", "0", "admin", "2023-01-21 23:54:56", "23.97.205.210");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1272", "0", "admin", "2023-01-22 00:21:18", "177.55.124.62");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1273", "0", "admin", "2023-01-22 03:28:41", "93.114.185.76");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1274", "0", "admin", "2023-01-22 05:12:40", "192.71.144.12");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1275", "0", "admin", "2023-01-22 13:32:42", "177.55.124.62");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1276", "0", "admin", "2023-01-22 14:02:29", "86.105.198.149");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1277", "0", "admin", "2023-01-22 15:00:24", "207.154.248.39");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1278", "0", "admin", "2023-01-22 19:14:32", "92.53.96.243");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1279", "0", "admin", "2023-01-22 20:15:33", "157.245.55.196");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1280", "0", "admin", "2023-01-23 08:12:17", "13.81.59.92");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1281", "0", "admin", "2023-01-23 08:12:17", "13.81.59.92");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1282", "0", "admin", "2023-01-23 18:09:25", "159.65.133.255");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1283", "0", "admin", "2023-01-23 18:18:45", "159.89.228.214");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1284", "0", "admin", "2023-01-23 22:10:58", "80.88.88.149");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1285", "0", "admin", "2023-01-24 01:25:03", "195.154.184.235");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1286", "0", "admin", "2023-01-24 04:50:33", "198.98.60.32");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1287", "0", "admin", "2023-01-24 05:50:53", "209.141.36.190");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1288", "0", "admin", "2023-01-24 07:44:01", "178.128.5.109");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1289", "0", "mail", "2023-01-24 15:23:12", "209.141.52.244");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1290", "0", "admin", "2023-01-24 17:52:30", "148.72.207.163");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1291", "0", "admin", "2023-01-25 02:39:34", "191.101.41.142");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1292", "0", "admin", "2023-01-25 04:54:39", "64.227.183.25");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1293", "0", "admin", "2023-01-25 05:00:05", "39.108.148.88");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1294", "1", "ucr", "2023-01-25 09:44:50", "198.98.48.183");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1295", "0", "admin", "2023-01-25 10:32:17", "209.97.162.248");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1296", "0", "admin", "2023-01-26 03:30:29", "199.167.131.50");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1297", "0", "admin", "2023-01-26 04:47:15", "185.231.115.134");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1298", "0", "winda", "2023-01-26 14:06:36", "209.141.48.210");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1299", "1", "ucr", "2023-01-27 16:29:33", "45.61.187.99");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1300", "0", "admin", "2023-01-27 18:22:40", "188.166.225.235");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1301", "0", "admin", "2023-01-27 22:27:36", "34.75.65.218");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1302", "0", "pl", "2023-01-28 03:24:32", "104.244.77.229");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1303", "0", "admin", "2023-01-28 03:28:40", "93.114.185.76");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1304", "0", "admin", "2023-01-28 03:28:40", "93.114.185.76");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1305", "1", "ucr", "2023-01-28 08:00:40", "45.61.187.99");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1306", "0", "mail", "2023-01-28 09:45:29", "205.185.116.156");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1307", "0", "admin", "2023-01-28 14:31:19", "51.210.183.128");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1308", "0", "admin", "2023-01-29 05:44:04", "95.217.167.17");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1309", "0", "admin", "2023-01-29 07:14:45", "165.227.93.224");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1310", "1", "ucr", "2023-01-30 03:44:19", "205.185.121.252");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1311", "0", "administrator", "2023-01-30 09:56:32", "107.189.13.99");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1312", "0", "admin", "2023-01-31 11:30:22", "199.195.253.123");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1313", "1", "ucr", "2023-01-31 12:45:24", "107.189.6.184");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1314", "0", "admin", "2023-01-31 23:28:53", "80.88.88.149");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1315", "0", "admin", "2023-02-01 08:11:27", "47.114.72.18");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1316", "0", "pl", "2023-02-01 15:10:25", "205.185.116.156");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1317", "1", "ucr", "2023-02-01 20:27:22", "209.141.45.47");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1318", "0", "pl", "2023-02-02 09:20:20", "45.61.188.28");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1319", "0", "pl", "2023-02-03 17:13:13", "205.185.120.53");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1320", "0", "pl", "2023-02-03 17:13:13", "205.185.120.53");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1321", "0", "admin", "2023-02-06 11:47:15", "35.219.66.183");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1322", "0", "admin", "2023-02-06 14:14:50", "185.231.115.134");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1323", "0", "wwwadmin", "2023-02-07 13:22:24", "103.152.164.103");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1324", "0", "wwwadmin", "2023-02-07 13:22:24", "103.152.164.103");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1325", "0", "wwwadmin", "2023-02-07 13:41:34", "45.130.83.80");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1326", "0", "wwwadmin", "2023-02-07 13:41:34", "45.130.83.80");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1327", "0", "admin", "2023-02-09 03:52:30", "47.114.72.18");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1328", "0", "admin", "2023-02-09 10:41:05", "35.224.178.6");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1329", "0", "admin", "2023-02-10 10:50:31", "45.130.83.59");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1330", "0", "administrator", "2023-02-13 16:03:41", "205.185.124.182");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1331", "0", "admin", "2023-02-13 20:56:49", "199.182.169.171");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1332", "0", "administrator", "2023-02-14 15:37:34", "45.61.185.196");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1333", "1", "ucr", "2023-02-15 14:05:05", "209.141.32.29");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1334", "0", "mail", "2023-02-15 15:31:38", "45.61.184.193");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1335", "0", "admin", "2023-02-16 08:37:34", "132.145.249.180");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1336", "0", "admin", "2023-02-16 14:52:08", "23.97.205.210");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1337", "0", "admin", "2023-02-17 06:04:39", "173.236.168.102");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1338", "0", "admin", "2023-02-17 17:22:57", "47.111.116.44");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1339", "0", "admin", "2023-02-17 18:31:31", "113.161.151.124");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1340", "0", "admin", "2023-02-18 10:39:39", "162.253.42.216");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1341", "0", "admin", "2023-02-18 12:30:37", "46.105.29.21");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1342", "0", "admin", "2023-02-18 12:30:37", "46.105.29.21");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1343", "0", "admin", "2023-02-18 16:30:19", "13.213.202.70");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1344", "0", "admin", "2023-02-22 04:13:00", "172.98.33.231");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1345", "0", "admin", "2023-02-22 13:49:26", "93.114.185.76");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1346", "0", "mail", "2023-02-22 14:04:27", "205.185.126.99");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1347", "0", "winda", "2023-02-23 08:03:26", "107.189.7.170");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1348", "0", "adminnaert", "2023-02-23 16:54:10", "205.185.124.182");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1349", "0", "admin", "2023-02-24 06:21:36", "23.99.229.218");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1350", "0", "admin", "2023-02-24 06:21:36", "23.99.229.218");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1351", "0", "admin", "2023-02-24 07:22:31", "146.148.44.185");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1352", "0", "admin", "2023-02-24 12:47:02", "172.98.33.240");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1353", "0", "admin", "2023-02-25 18:39:42", "198.211.110.178");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1354", "0", "admin", "2023-02-25 18:55:48", "51.161.115.146");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1355", "0", "admin", "2023-02-26 00:54:44", "172.98.33.233");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1356", "1", "ucr", "2023-02-26 05:50:23", "198.98.62.37");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1357", "0", "admin", "2023-03-02 08:53:46", "35.187.58.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1358", "0", "wwwadmin", "2023-03-02 12:07:11", "190.92.159.48");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1359", "0", "wwwadmin", "2023-03-02 12:07:11", "190.92.159.48");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1360", "0", "wadminw", "2023-03-02 13:12:24", "178.128.82.148");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1361", "0", "admin", "2023-03-05 01:49:17", "103.166.183.192");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1362", "0", "admin", "2023-03-06 05:04:45", "185.231.115.134");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1363", "0", "admin", "2023-03-09 09:48:35", "172.98.33.221");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1364", "0", "admin", "2023-03-09 10:01:22", "164.132.170.4");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1365", "0", "admin", "2023-03-11 01:59:59", "45.120.69.121");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1366", "0", "admin", "2023-03-12 22:25:59", "49.51.134.238");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1367", "0", "admin", "2023-03-13 09:28:52", "65.21.108.17");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1368", "0", "admin", "2023-03-15 14:12:03", "45.61.188.28");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1369", "0", "admin", "2023-03-16 05:58:58", "162.241.203.22");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1370", "0", "admin", "2023-03-16 08:41:35", "142.44.243.214");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1371", "0", "admin", "2023-03-16 14:34:43", "185.231.115.134");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1372", "0", "administrator", "2023-03-16 14:47:46", "209.141.62.244");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1373", "0", "admin", "2023-03-16 15:41:04", "8.218.143.243");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1374", "0", "admin", "2023-03-16 16:21:10", "45.132.115.249");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1375", "0", "admin", "2023-03-18 02:25:30", "134.122.123.193");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1376", "0", "admin", "2023-03-18 04:05:01", "46.105.29.21");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1377", "0", "admin", "2023-03-18 05:53:23", "141.94.247.170");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1378", "0", "admin", "2023-03-20 05:09:01", "181.174.125.214");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1379", "0", "admin", "2023-03-20 16:01:21", "172.98.33.10");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1380", "0", "admin", "2023-03-21 00:48:02", "172.98.33.17");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1381", "0", "admin", "2023-03-21 16:16:47", "1.244.222.132");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1382", "0", "admin", "2023-03-22 02:44:43", "45.132.115.249");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1383", "0", "admin", "2023-03-22 03:04:33", "47.114.72.18");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1384", "0", "adminnaert", "2023-03-25 03:48:30", "209.141.49.96");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1385", "0", "wwwadmin", "2023-03-25 18:34:12", "24.199.86.99");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1386", "0", "wwwadmin", "2023-03-25 18:34:12", "24.199.86.99");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1387", "0", "wwwadmin", "2023-03-26 14:37:45", "103.118.168.221");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1388", "0", "wwwadmin", "2023-03-26 14:37:45", "103.118.168.221");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1389", "1", "ucr", "2023-03-27 05:09:16", "45.61.185.241");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1390", "1", "ucr", "2023-03-28 07:16:58", "209.141.49.234");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1391", "0", "admin", "2023-03-29 08:49:13", "20.205.233.37");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1392", "0", "admin", "2023-03-29 08:49:14", "20.205.233.37");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1393", "0", "admin", "2023-03-29 08:49:15", "20.205.233.37");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1394", "0", "admin", "2023-03-29 08:49:16", "20.205.233.37");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1395", "0", "admin", "2023-03-29 08:49:17", "20.205.233.37");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1396", "0", "admin", "2023-03-29 08:49:17", "20.205.233.37");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1397", "0", "admin", "2023-03-29 08:49:18", "20.205.233.37");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1398", "0", "admin", "2023-03-29 08:49:19", "20.205.233.37");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1399", "0", "admin", "2023-03-29 08:49:20", "20.205.233.37");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1400", "0", "admin", "2023-03-29 08:49:21", "20.205.233.37");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1401", "0", "admin", "2023-03-29 08:49:21", "20.205.233.37");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1402", "0", "admin", "2023-03-29 08:49:22", "20.205.233.37");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1403", "0", "admin", "2023-03-29 08:49:23", "20.205.233.37");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1404", "0", "admin", "2023-03-29 08:49:24", "20.205.233.37");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1405", "0", "admin", "2023-03-29 08:49:25", "20.205.233.37");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1406", "0", "admin", "2023-03-29 08:49:25", "20.205.233.37");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1407", "0", "admin", "2023-03-29 08:49:26", "20.205.233.37");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1408", "0", "admin", "2023-03-29 08:49:27", "20.205.233.37");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1409", "0", "admin", "2023-03-29 08:49:28", "20.205.233.37");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1410", "0", "admin", "2023-03-29 12:38:52", "103.163.139.202");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1411", "0", "admin", "2023-03-31 07:29:15", "93.114.185.76");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1412", "0", "admin", "2023-03-31 07:43:57", "93.114.185.76");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1413", "0", "admin", "2023-03-31 19:26:24", "198.244.167.101");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1414", "0", "admin", "2023-04-01 11:05:54", "104.131.4.140");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1415", "0", "admin", "2023-04-01 12:03:56", "141.94.247.170");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1416", "0", "admin", "2023-04-01 19:46:02", "47.111.116.44");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1417", "0", "wwwadmin", "2023-04-02 18:16:29", "148.72.207.163");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1418", "0", "wwwadmin", "2023-04-02 18:16:29", "148.72.207.163");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1419", "0", "admin", "2023-04-02 23:17:50", "104.131.4.140");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1420", "0", "admin", "2023-04-03 03:11:21", "172.98.33.7");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1421", "0", "admin", "2023-04-03 07:02:15", "165.227.89.189");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1422", "0", "admin", "2023-04-03 17:44:35", "150.109.148.216");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1423", "0", "adminnaert", "2023-04-03 22:46:59", "205.185.113.218");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1424", "0", "admin", "2023-04-04 09:55:25", "43.154.9.162");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1425", "0", "wwwadmin", "2023-04-04 17:09:24", "24.199.86.99");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1426", "0", "wwwadmin", "2023-04-04 17:09:24", "24.199.86.99");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1427", "0", "wwwadmin", "2023-04-05 12:11:35", "104.254.247.33");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1428", "0", "wwwadmin", "2023-04-05 12:11:35", "104.254.247.33");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1429", "0", "wwwadmin", "2023-04-05 12:11:38", "82.223.66.74");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1430", "0", "wwwadmin", "2023-04-05 12:11:38", "82.223.66.74");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1431", "1", "ucr", "2023-04-05 12:11:56", "45.81.243.77");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1432", "1", "ucr", "2023-04-05 12:11:56", "45.81.243.77");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1433", "1", "ucr", "2023-04-05 12:13:42", "45.81.243.77");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1434", "0", "admin", "2023-04-06 07:06:05", "133.130.103.36");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1435", "0", "admin", "2023-04-06 09:12:35", "209.141.32.29");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1436", "1", "ucr", "2023-04-06 23:41:37", "45.81.243.77");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1437", "0", "admin", "2023-04-07 05:01:17", "64.227.161.192");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1438", "0", "admin", "2023-04-07 08:58:57", "205.185.120.195");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1439", "0", "administrator", "2023-04-07 17:27:14", "45.61.185.188");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1440", "0", "wadminw", "2023-04-08 13:23:02", "85.17.88.170");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1441", "0", "admin", "2023-04-08 20:02:45", "46.105.29.21");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1442", "0", "administrator", "2023-04-09 13:30:43", "198.98.62.37");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1443", "0", "wwwadmin", "2023-04-09 14:49:01", "185.231.115.134");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1444", "0", "wwwadmin", "2023-04-09 14:49:01", "185.231.115.134");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1445", "1", "ucr", "2023-04-09 16:51:17", "205.185.121.200");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1446", "1", "ucr", "2023-04-10 02:42:38", "45.12.253.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1447", "1", "ucr", "2023-04-10 11:18:00", "45.12.253.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1448", "1", "ucr", "2023-04-11 01:08:40", "45.12.253.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1449", "1", "ucr", "2023-04-11 07:45:49", "205.185.121.200");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1450", "0", "admin", "2023-04-11 09:55:06", "104.248.125.139");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1451", "0", "admin", "2023-04-11 09:55:07", "104.248.125.139");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1452", "1", "ucr", "2023-04-11 14:17:51", "205.185.115.239");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1453", "1", "ucr", "2023-04-12 09:07:52", "192.42.116.203");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1454", "1", "ucr", "2023-04-12 18:51:49", "45.12.253.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1455", "1", "ucr", "2023-04-13 00:59:40", "45.12.253.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1456", "1", "ucr", "2023-04-13 00:59:40", "45.12.253.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1457", "1", "ucr", "2023-04-13 01:49:46", "45.12.253.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1458", "1", "ucr", "2023-04-13 04:24:54", "45.12.253.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1459", "0", "admin", "2023-04-13 13:49:29", "93.114.185.76");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1460", "1", "ucr", "2023-04-13 19:31:02", "45.12.253.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1461", "1", "ucr", "2023-04-14 06:23:13", "45.12.253.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1462", "0", "wadminw", "2023-04-14 14:41:21", "213.175.66.138");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1463", "1", "ucr", "2023-04-15 00:05:06", "45.12.253.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1464", "1", "ucr", "2023-04-18 03:04:38", "45.12.253.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1465", "1", "ucr", "2023-04-18 03:29:36", "45.12.253.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1466", "1", "ucr", "2023-04-18 15:55:19", "45.12.253.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1467", "0", "admin", "2023-04-19 11:27:01", "44.193.57.42");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1468", "0", "wadminw", "2023-04-19 14:41:15", "202.134.19.110");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1469", "0", "admin", "2023-04-20 07:54:12", "167.172.80.135");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1470", "0", "admin", "2023-04-20 18:45:30", "23.99.229.218");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1471", "0", "admin", "2023-04-21 00:14:42", "93.114.184.214");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1472", "0", "admin", "2023-04-21 22:20:14", "128.199.183.41");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1473", "1", "ucr", "2023-04-22 02:50:24", "45.12.253.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1474", "0", "wwwadmin", "2023-04-22 15:32:36", "124.70.98.118");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1475", "0", "wwwadmin", "2023-04-22 15:32:36", "124.70.98.118");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1476", "1", "ucr", "2023-04-24 16:43:31", "45.12.253.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1477", "1", "ucr", "2023-04-26 13:38:51", "45.12.253.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1478", "1", "ucr", "2023-04-27 19:22:09", "45.12.253.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1479", "0", "admin", "2023-04-27 21:10:05", "106.15.38.206");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1480", "0", "wpmanager", "2023-04-29 14:44:45", "13.126.234.168");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1481", "0", "wadminw", "2023-04-29 14:44:46", "13.126.234.168");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1482", "0", "wpadmin", "2023-04-29 14:46:22", "173.198.208.103");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1483", "0", "itsme", "2023-04-29 14:46:22", "173.198.208.103");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1484", "0", "woopayplug", "2023-04-29 14:47:19", "81.30.228.253");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1485", "0", "adminlin", "2023-04-29 14:47:19", "81.30.228.253");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1486", "0", "wordcamp", "2023-04-29 14:47:21", "119.195.102.159");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1487", "1", "ucr", "2023-04-29 17:10:24", "45.12.253.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1488", "1", "ucr", "2023-04-29 17:10:24", "45.12.253.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1489", "0", "admin", "2023-04-29 21:57:49", "185.46.229.59");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1490", "0", "winda", "2023-04-29 23:56:49", "148.66.147.43");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1491", "0", "admin", "2023-04-29 23:56:49", "148.66.147.43");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1492", "0", "admin", "2023-04-29 23:56:55", "198.71.225.128");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1493", "0", "admin", "2023-04-29 23:56:55", "198.71.225.128");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1494", "0", "winda", "2023-04-29 23:58:14", "173.233.84.186");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1495", "1", "ucr", "2023-04-29 23:58:14", "173.233.84.186");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1496", "0", "winda", "2023-04-29 23:59:39", "3.98.252.244");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1497", "0", "admin", "2023-04-29 23:59:39", "3.98.252.244");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1498", "0", "admin", "2023-04-30 00:01:11", "52.213.116.234");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1499", "0", "admin", "2023-04-30 00:01:12", "52.213.116.234");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1500", "1", "ucr", "2023-04-30 00:01:12", "203.94.76.101");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1501", "0", "winda", "2023-04-30 00:01:12", "203.94.76.101");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1502", "0", "winda", "2023-04-30 00:01:31", "54.226.237.254");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1503", "1", "ucr", "2023-04-30 00:01:32", "54.226.237.254");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1504", "0", "admin", "2023-04-30 00:01:32", "184.154.194.138");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1505", "0", "admin", "2023-04-30 00:01:32", "184.154.194.138");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1506", "0", "admin", "2023-04-30 00:01:57", "162.0.229.109");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1507", "0", "admin", "2023-04-30 00:01:57", "162.0.229.109");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1508", "1", "ucr", "2023-04-30 00:02:01", "128.199.122.215");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1509", "0", "winda", "2023-04-30 00:02:01", "128.199.122.215");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1510", "0", "admin", "2023-04-30 00:02:24", "148.72.87.45");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1511", "0", "admin", "2023-04-30 00:02:24", "148.72.87.45");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1512", "0", "admin", "2023-04-30 00:02:32", "113.20.141.50");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1513", "1", "ucr", "2023-04-30 00:02:32", "113.20.141.50");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1514", "1", "ucr", "2023-04-30 00:03:49", "68.183.43.38");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1515", "0", "admin", "2023-04-30 00:03:49", "68.183.43.38");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1516", "1", "ucr", "2023-04-30 00:05:06", "209.126.8.209");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1517", "0", "winda", "2023-04-30 00:05:06", "139.99.62.131");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1518", "0", "winda", "2023-04-30 00:05:06", "139.99.62.131");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1519", "0", "winda", "2023-04-30 00:05:06", "209.126.8.209");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1520", "0", "admin", "2023-04-30 00:07:36", "50.62.56.97");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1521", "1", "ucr", "2023-04-30 00:07:36", "50.62.56.97");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1522", "1", "ucr", "2023-04-30 00:08:44", "189.90.130.30");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1523", "1", "ucr", "2023-04-30 00:08:44", "189.90.130.30");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1524", "0", "admin", "2023-04-30 00:10:54", "74.235.201.205");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1525", "1", "ucr", "2023-04-30 00:10:54", "74.235.201.205");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1526", "1", "ucr", "2023-04-30 00:10:54", "45.63.20.187");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1527", "0", "winda", "2023-04-30 00:10:54", "45.63.20.187");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1528", "0", "winda", "2023-04-30 00:12:17", "62.82.138.5");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1529", "0", "admin", "2023-04-30 00:12:17", "62.82.138.5");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1530", "0", "winda", "2023-04-30 00:12:40", "50.31.1.187");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1531", "0", "admin", "2023-04-30 00:12:41", "50.31.1.187");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1532", "1", "ucr", "2023-04-30 00:12:44", "78.46.18.150");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1533", "0", "admin", "2023-04-30 00:12:45", "78.46.18.150");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1534", "0", "winda", "2023-04-30 00:12:45", "52.3.138.134");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1535", "1", "ucr", "2023-04-30 00:12:45", "52.3.138.134");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1536", "1", "ucr", "2023-04-30 00:13:14", "46.235.40.128");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1537", "0", "admin", "2023-04-30 00:13:15", "46.235.40.128");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1538", "0", "winda", "2023-04-30 00:13:34", "209.97.191.147");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1539", "0", "admin", "2023-04-30 00:13:34", "209.97.191.147");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1540", "1", "ucr", "2023-04-30 00:13:35", "35.238.14.180");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1541", "1", "ucr", "2023-04-30 00:13:35", "35.238.14.180");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1542", "0", "winda", "2023-04-30 00:14:24", "34.72.72.120");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1543", "0", "winda", "2023-04-30 00:15:04", "173.201.179.126");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1544", "1", "ucr", "2023-04-30 00:15:05", "173.201.179.126");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1545", "0", "admin", "2023-04-30 00:15:28", "92.204.218.67");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1546", "0", "admin", "2023-04-30 00:15:28", "92.204.218.67");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1547", "1", "ucr", "2023-04-30 00:15:43", "199.91.64.51");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1548", "1", "ucr", "2023-04-30 00:15:44", "199.91.64.51");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1549", "0", "winda", "2023-04-30 00:16:22", "207.109.170.56");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1550", "0", "admin", "2023-04-30 00:16:22", "207.109.170.56");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1551", "0", "winda", "2023-04-30 00:16:47", "44.230.215.75");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1552", "0", "admin", "2023-04-30 00:16:47", "44.230.215.75");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1553", "1", "ucr", "2023-04-30 00:16:57", "157.7.188.127");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1554", "0", "admin", "2023-05-01 15:41:53", "34.152.50.52");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1555", "0", "winda", "2023-05-01 15:41:54", "34.152.50.52");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1556", "1", "ucr", "2023-05-01 15:43:12", "160.153.154.161");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1557", "0", "winda", "2023-05-01 15:43:12", "160.153.154.161");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1558", "1", "ucr", "2023-05-01 15:43:14", "52.30.235.232");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1559", "0", "winda", "2023-05-01 15:43:14", "52.30.235.232");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1560", "0", "admin", "2023-05-01 15:44:26", "80.59.35.231");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1561", "0", "winda", "2023-05-01 15:44:26", "80.59.35.231");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1562", "1", "ucr", "2023-05-01 15:45:16", "46.235.40.128");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1563", "0", "admin", "2023-05-01 15:45:16", "46.235.40.128");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1564", "1", "ucr", "2023-05-01 15:45:44", "64.6.254.94");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1565", "0", "admin", "2023-05-01 15:45:44", "64.6.254.94");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1566", "0", "admin", "2023-05-01 15:46:32", "46.235.40.55");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1567", "1", "ucr", "2023-05-01 15:46:32", "46.235.40.55");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1568", "0", "winda", "2023-05-01 15:46:54", "81.30.228.253");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1569", "0", "admin", "2023-05-01 15:46:54", "81.30.228.253");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1570", "0", "admin", "2023-05-01 15:46:57", "198.71.228.23");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1571", "1", "ucr", "2023-05-01 15:46:57", "198.71.228.23");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1572", "1", "ucr", "2023-05-01 15:48:01", "89.107.184.213");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1573", "0", "admin", "2023-05-01 15:48:01", "89.107.184.213");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1574", "1", "ucr", "2023-05-01 15:49:07", "46.235.40.132");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1575", "0", "winda", "2023-05-01 15:49:07", "46.235.40.132");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1576", "1", "ucr", "2023-05-01 15:49:31", "94.23.10.46");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1577", "0", "winda", "2023-05-01 15:49:31", "94.23.10.46");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1578", "0", "winda", "2023-05-01 15:50:16", "119.18.49.15");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1579", "1", "ucr", "2023-05-01 15:50:16", "119.18.49.15");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1580", "1", "ucr", "2023-05-01 15:51:11", "157.7.105.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1581", "0", "admin", "2023-05-01 15:51:11", "157.7.105.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1582", "0", "admin", "2023-05-01 15:52:22", "46.235.40.122");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1583", "0", "winda", "2023-05-01 15:52:22", "46.235.40.122");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1584", "1", "ucr", "2023-05-01 15:52:51", "198.71.230.55");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1585", "0", "winda", "2023-05-01 15:52:51", "198.71.230.55");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1586", "0", "winda", "2023-05-01 15:53:16", "207.45.183.66");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1587", "1", "ucr", "2023-05-01 15:53:22", "52.67.148.87");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1588", "0", "winda", "2023-05-01 15:53:22", "52.67.148.87");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1589", "1", "ucr", "2023-05-01 15:53:55", "178.79.146.120");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1590", "0", "admin", "2023-05-01 15:53:55", "178.79.146.120");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1591", "0", "admin", "2023-05-01 15:54:28", "46.235.40.122");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1592", "1", "ucr", "2023-05-01 15:54:28", "46.235.40.122");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1593", "0", "admin", "2023-05-01 15:54:56", "198.71.226.29");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1594", "1", "ucr", "2023-05-01 15:54:56", "198.71.226.29");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1595", "0", "winda", "2023-05-01 15:54:58", "167.172.175.35");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1596", "0", "admin", "2023-05-01 15:54:59", "167.172.175.35");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1597", "0", "admin", "2023-05-01 15:55:47", "153.92.16.50");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1598", "0", "winda", "2023-05-01 15:56:16", "62.151.176.138");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1599", "1", "ucr", "2023-05-01 15:56:17", "62.151.176.138");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1600", "0", "winda", "2023-05-01 15:56:18", "62.74.238.145");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1601", "1", "ucr", "2023-05-01 15:56:18", "62.74.238.145");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1602", "0", "winda", "2023-05-01 15:56:32", "46.235.42.139");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1603", "1", "ucr", "2023-05-01 15:56:32", "46.235.42.139");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1604", "0", "winda", "2023-05-01 15:56:40", "46.101.230.156");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1605", "1", "ucr", "2023-05-01 15:56:40", "46.101.230.156");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1606", "1", "ucr", "2023-05-01 15:56:57", "46.235.40.146");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1607", "0", "winda", "2023-05-01 15:56:57", "46.235.40.146");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1608", "0", "winda", "2023-05-01 15:57:22", "144.91.82.30");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1609", "1", "ucr", "2023-05-01 15:57:22", "144.91.82.30");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1610", "0", "winda", "2023-05-01 15:57:48", "50.22.151.222");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1611", "1", "ucr", "2023-05-01 15:57:49", "50.22.151.222");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1612", "0", "admin", "2023-05-03 05:46:38", "89.252.140.197");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1613", "0", "admin", "2023-05-05 11:45:36", "195.154.184.235");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1614", "0", "wadminw", "2023-05-05 14:35:41", "88.212.207.125");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1615", "0", "itsme", "2023-05-07 00:58:14", "92.204.218.88");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1616", "1", "ucr", "2023-05-09 07:37:37", "95.214.27.219");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1617", "0", "admin", "2023-05-11 01:14:45", "164.90.170.158");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1618", "0", "admin", "2023-05-11 03:04:34", "103.28.36.113");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1619", "0", "admin", "2023-05-11 21:47:52", "35.233.164.145");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1620", "0", "admin", "2023-05-12 02:17:48", "146.148.44.185");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1621", "0", "admin", "2023-05-12 02:17:48", "146.148.44.185");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1622", "0", "admin", "2023-05-12 06:07:18", "34.143.243.10");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1623", "0", "admin", "2023-05-12 06:40:09", "91.197.199.240");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1624", "1", "ucr", "2023-05-14 13:49:01", "45.81.243.77");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1625", "0", "admin", "2023-05-15 23:26:12", "104.248.125.139");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1626", "0", "winda", "2023-05-16 01:15:16", "173.219.72.221");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1627", "0", "admin", "2023-05-16 01:15:17", "173.219.72.221");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1628", "0", "admin", "2023-05-16 01:16:10", "35.184.48.83");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1629", "1", "ucr", "2023-05-16 01:16:10", "35.184.48.83");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1630", "0", "admin", "2023-05-16 01:17:53", "51.91.103.92");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1631", "0", "winda", "2023-05-16 01:17:53", "51.91.103.92");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1632", "0", "winda", "2023-05-16 01:18:42", "82.223.161.92");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1633", "0", "admin", "2023-05-16 01:18:42", "82.223.161.92");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1634", "0", "winda", "2023-05-16 01:19:27", "193.35.102.254");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1635", "0", "admin", "2023-05-16 01:19:27", "193.35.102.254");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1636", "1", "ucr", "2023-05-16 01:19:29", "129.232.187.186");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1637", "1", "ucr", "2023-05-16 01:19:29", "129.232.187.186");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1638", "1", "ucr", "2023-05-16 01:19:52", "134.122.82.80");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1639", "1", "ucr", "2023-05-16 01:19:52", "134.122.82.80");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1640", "0", "admin", "2023-05-16 01:20:11", "46.101.26.42");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1641", "1", "ucr", "2023-05-16 01:20:11", "46.101.26.42");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1642", "0", "winda", "2023-05-16 01:20:52", "45.32.126.125");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1643", "0", "winda", "2023-05-16 01:20:52", "45.32.126.125");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1644", "0", "winda", "2023-05-16 01:21:18", "198.187.29.174");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1645", "0", "winda", "2023-05-16 01:21:18", "198.187.29.174");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1646", "1", "ucr", "2023-05-16 01:21:28", "50.62.176.25");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1647", "0", "admin", "2023-05-16 01:21:28", "50.62.176.25");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1648", "0", "winda", "2023-05-16 01:21:59", "143.110.186.10");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1649", "1", "ucr", "2023-05-16 01:21:59", "143.110.186.10");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1650", "0", "admin", "2023-05-16 01:22:29", "95.216.208.178");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1651", "1", "ucr", "2023-05-16 01:22:29", "95.216.208.178");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1652", "0", "admin", "2023-05-16 01:23:37", "103.146.177.212");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1653", "0", "admin", "2023-05-16 01:23:43", "76.12.219.234");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1654", "0", "winda", "2023-05-16 01:23:43", "76.12.219.234");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1655", "0", "admin", "2023-05-16 01:23:53", "31.22.4.238");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1656", "0", "winda", "2023-05-16 01:23:55", "50.62.177.177");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1657", "1", "ucr", "2023-05-16 01:24:09", "143.110.186.10");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1658", "0", "admin", "2023-05-16 01:24:09", "143.110.186.10");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1659", "0", "admin", "2023-05-16 01:24:10", "162.246.248.71");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1660", "1", "ucr", "2023-05-16 01:24:14", "103.113.24.254");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1661", "1", "ucr", "2023-05-16 01:24:56", "162.255.118.204");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1662", "0", "admin", "2023-05-16 19:39:34", "143.244.177.220");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1663", "0", "admin", "2023-05-17 06:12:48", "192.210.206.253");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1664", "0", "admin", "2023-05-17 06:13:13", "93.183.131.53");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1665", "0", "admin", "2023-05-17 06:19:00", "185.200.240.65");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1666", "0", "admin", "2023-05-17 13:28:48", "24.199.86.99");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1667", "0", "wadminw", "2023-05-17 15:17:33", "193.107.236.42");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1668", "0", "wwwadmin", "2023-05-17 15:34:35", "92.204.184.3");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1669", "0", "wwwadmin", "2023-05-17 15:34:35", "92.204.184.3");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1670", "0", "admin", "2023-05-17 19:31:08", "103.173.78.11");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1671", "0", "admin", "2023-05-18 03:34:01", "13.79.17.158");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1672", "0", "admin", "2023-05-19 15:57:39", "84.22.111.93");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1673", "1", "ucr", "2023-05-19 16:00:04", "92.205.8.185");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1674", "0", "admin", "2023-05-21 00:18:31", "67.205.10.234");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1675", "0", "wadminw", "2023-05-21 15:12:42", "134.122.123.193");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1676", "1", "ucr", "2023-05-23 17:30:39", "45.12.253.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1677", "0", "admin", "2023-05-23 20:55:38", "43.225.108.187");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1678", "0", "winda", "2023-05-24 01:12:52", "45.76.142.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1679", "0", "admin", "2023-05-24 01:12:52", "45.76.142.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1680", "1", "ucr", "2023-05-24 01:14:47", "94.182.95.134");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1681", "0", "itsme", "2023-05-24 02:56:52", "94.130.32.145");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1682", "0", "support@innohosting.com", "2023-05-24 11:36:57", "54.175.105.147");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1683", "0", "admin", "2023-05-25 06:02:42", "189.126.206.157");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1684", "0", "admin", "2023-05-25 12:00:19", "111.90.150.171");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1685", "1", "ucr", "2023-05-25 18:29:01", "45.12.253.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1686", "0", "tescb@tcf.sdf", "2023-05-25 23:18:59", "167.71.169.170");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1687", "0", "admin", "2023-05-26 01:20:19", "202.152.135.235");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1688", "0", "admin", "2023-05-26 01:20:19", "202.152.135.235");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1689", "0", "admin", "2023-05-26 08:27:20", "122.9.150.5");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1690", "0", "wadminw", "2023-05-26 11:28:18", "89.36.209.120");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1691", "0", "wpenginesupport", "2023-05-26 11:28:19", "89.36.209.120");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1692", "0", "hostingadmin", "2023-05-26 11:30:01", "128.199.152.152");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1693", "0", "wpmanager", "2023-05-26 11:30:01", "128.199.152.152");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1694", "0", "adminlin", "2023-05-26 11:30:35", "184.168.97.218");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1695", "0", "woopayplug", "2023-05-26 11:30:35", "184.168.97.218");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1696", "0", "wpadmin", "2023-05-26 11:30:59", "13.126.234.168");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1697", "0", "wordcamp", "2023-05-26 11:31:00", "13.126.234.168");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1698", "0", "adminlin", "2023-05-26 11:31:11", "35.232.107.205");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1699", "0", "woopayplug", "2023-05-26 11:31:11", "35.232.107.205");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1700", "0", "1001010", "2023-05-26 11:31:49", "165.227.106.20");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1701", "0", "WPADMIN", "2023-05-26 11:31:49", "165.227.106.20");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1702", "0", "admin", "2023-05-27 07:36:22", "51.158.124.112");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1703", "0", "admin", "2023-05-27 23:10:59", "103.28.36.113");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1704", "0", "wadminw", "2023-05-28 05:41:33", "194.233.76.140");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1705", "0", "admin", "2023-05-28 15:48:42", "167.99.88.28");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1706", "0", "admin", "2023-05-28 22:42:38", "106.0.49.122");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1707", "0", "admin", "2023-05-29 03:46:13", "208.109.56.252");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1708", "0", "admin", "2023-05-29 03:46:13", "208.109.56.252");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1709", "0", "admin", "2023-05-29 03:46:44", "197.243.19.117");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1710", "0", "admin", "2023-05-29 03:46:44", "197.243.19.117");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1711", "0", "winda", "2023-05-29 03:47:09", "80.68.151.206");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1712", "0", "winda", "2023-05-29 03:47:09", "80.68.151.206");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1713", "0", "admin", "2023-05-29 03:47:35", "138.197.161.71");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1714", "0", "winda", "2023-05-29 03:47:35", "138.197.161.71");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1715", "0", "winda", "2023-05-29 03:48:01", "66.113.180.84");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1716", "0", "admin", "2023-05-29 03:48:01", "66.113.180.84");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1717", "1", "ucr", "2023-05-29 03:48:27", "198.12.249.249");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1718", "1", "ucr", "2023-05-29 03:48:27", "198.12.249.249");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1719", "0", "admin", "2023-05-29 03:48:57", "208.88.6.30");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1720", "0", "winda", "2023-05-29 03:48:57", "208.88.6.30");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1721", "1", "ucr", "2023-05-29 03:50:29", "46.101.111.77");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1722", "0", "winda", "2023-05-29 03:50:29", "46.101.111.77");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1723", "0", "admin", "2023-05-29 03:52:01", "92.204.218.67");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1724", "1", "ucr", "2023-05-29 03:52:01", "92.204.218.67");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1725", "0", "admin", "2023-05-29 03:52:30", "138.68.19.26");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1726", "1", "ucr", "2023-05-29 03:52:30", "138.68.19.26");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1727", "0", "winda", "2023-05-29 03:52:42", "161.35.61.218");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1728", "0", "admin", "2023-05-29 03:52:42", "161.35.61.218");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1729", "0", "admin", "2023-05-29 03:53:51", "107.180.108.4");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1730", "0", "winda", "2023-05-29 03:53:51", "107.180.108.4");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1731", "0", "winda", "2023-05-29 03:53:53", "96.45.76.242");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1732", "0", "admin", "2023-05-29 03:53:53", "96.45.76.242");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1733", "0", "admin", "2023-05-29 03:54:06", "206.126.248.93");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1734", "0", "winda", "2023-05-29 03:54:06", "206.126.248.93");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1735", "1", "ucr", "2023-05-29 03:54:18", "50.62.177.47");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1736", "0", "admin", "2023-05-29 03:54:18", "50.62.177.47");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1737", "0", "admin", "2023-05-29 03:54:25", "164.52.200.113");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1738", "1", "ucr", "2023-05-29 03:54:25", "164.52.200.113");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1739", "0", "admin", "2023-05-29 03:54:44", "170.187.153.79");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1740", "0", "winda", "2023-05-29 03:54:44", "170.187.153.79");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1741", "0", "winda", "2023-05-29 03:54:58", "197.138.40.28");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1742", "0", "admin", "2023-05-29 03:54:58", "197.138.40.28");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1743", "0", "admin", "2023-05-29 03:55:06", "162.0.229.84");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1744", "0", "winda", "2023-05-29 03:55:06", "162.0.229.84");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1745", "0", "admin", "2023-05-29 03:55:08", "104.198.37.199");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1746", "0", "winda", "2023-05-29 03:55:08", "104.198.37.199");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1747", "1", "ucr", "2023-05-29 03:55:27", "52.7.65.43");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1748", "1", "ucr", "2023-05-29 03:55:27", "52.7.65.43");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1749", "0", "admin", "2023-05-29 03:55:47", "185.62.73.46");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1750", "1", "ucr", "2023-05-29 03:55:47", "185.62.73.46");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1751", "0", "winda", "2023-05-29 03:55:48", "178.170.103.87");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1752", "0", "winda", "2023-05-29 03:55:48", "178.170.103.87");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1753", "0", "admin", "2023-05-29 03:56:07", "162.255.118.203");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1754", "1", "ucr", "2023-05-29 03:56:07", "162.255.118.206");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1755", "1", "ucr", "2023-05-29 03:56:12", "92.205.64.128");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1756", "0", "admin", "2023-05-29 03:56:12", "92.205.64.128");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1757", "0", "winda", "2023-05-29 03:56:47", "211.217.170.10");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1758", "0", "tescb@tcf.sdf", "2023-05-30 09:04:44", "5.44.104.72");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1759", "0", "winda", "2023-05-31 19:45:36", "72.167.57.119");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1760", "0", "admin", "2023-05-31 19:45:37", "72.167.57.119");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1761", "1", "ucr", "2023-05-31 19:45:37", "209.126.119.58");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1762", "0", "winda", "2023-05-31 19:45:37", "209.126.119.58");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1763", "0", "winda", "2023-05-31 19:45:44", "34.230.128.10");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1764", "0", "admin", "2023-05-31 19:45:44", "34.230.128.10");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1765", "0", "winda", "2023-05-31 19:46:01", "160.153.154.133");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1766", "1", "ucr", "2023-05-31 19:46:01", "160.153.154.133");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1767", "0", "winda", "2023-05-31 19:47:30", "34.80.6.78");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1768", "1", "ucr", "2023-05-31 19:47:30", "34.80.6.78");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1769", "0", "winda", "2023-05-31 19:47:55", "66.33.205.86");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1770", "1", "ucr", "2023-05-31 19:47:55", "66.33.205.86");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1771", "0", "admin", "2023-05-31 19:49:14", "94.130.135.184");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1772", "0", "winda", "2023-05-31 19:49:14", "94.130.135.184");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1773", "0", "admin", "2023-05-31 19:50:54", "144.76.153.123");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1774", "0", "admin", "2023-05-31 19:50:54", "144.76.153.123");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1775", "0", "admin", "2023-05-31 19:52:34", "185.112.145.140");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1776", "0", "winda", "2023-05-31 19:52:35", "185.112.145.140");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1777", "1", "ucr", "2023-05-31 19:54:40", "173.82.245.65");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1778", "1", "ucr", "2023-05-31 19:54:40", "173.82.245.65");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1779", "0", "admin", "2023-05-31 19:55:49", "94.158.149.174");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1780", "0", "winda", "2023-05-31 19:55:49", "94.158.149.174");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1781", "0", "admin", "2023-05-31 19:57:24", "144.91.109.107");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1782", "1", "ucr", "2023-05-31 19:57:24", "144.91.109.107");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1783", "0", "admin", "2023-05-31 19:57:26", "164.52.217.174");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1784", "0", "winda", "2023-05-31 19:57:26", "164.52.217.174");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1785", "1", "ucr", "2023-05-31 19:58:51", "81.30.228.253");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1786", "1", "ucr", "2023-05-31 20:00:21", "34.193.64.124");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1787", "0", "admin", "2023-05-31 20:00:21", "34.193.64.124");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1788", "0", "admin", "2023-05-31 20:01:45", "138.197.134.114");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1789", "0", "winda", "2023-05-31 20:01:45", "138.197.134.114");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1790", "1", "ucr", "2023-05-31 20:03:29", "52.4.127.185");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1791", "0", "winda", "2023-05-31 20:03:29", "52.4.127.185");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1792", "0", "admin", "2023-05-31 20:04:17", "50.62.177.81");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1793", "0", "admin", "2023-05-31 20:04:17", "50.62.177.81");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1794", "0", "admin", "2023-05-31 20:04:17", "50.63.165.22");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1795", "1", "ucr", "2023-05-31 20:04:17", "50.63.165.22");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1796", "0", "admin", "2023-05-31 20:05:24", "54.214.137.99");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1797", "0", "winda", "2023-05-31 20:05:24", "54.214.137.99");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1798", "1", "ucr", "2023-05-31 20:07:21", "139.162.52.41");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1799", "0", "winda", "2023-05-31 20:07:21", "139.162.52.41");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1800", "1", "ucr", "2023-05-31 20:08:10", "95.211.55.213");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1801", "0", "winda", "2023-05-31 20:08:10", "95.211.55.213");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1802", "0", "winda", "2023-05-31 20:08:28", "84.255.249.80");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1803", "0", "winda", "2023-05-31 20:08:55", "195.177.217.131");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1804", "1", "ucr", "2023-05-31 20:08:55", "195.177.217.131");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1805", "0", "admin", "2023-05-31 20:09:44", "173.201.188.182");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1806", "0", "winda", "2023-05-31 20:09:44", "173.201.188.182");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1807", "1", "ucr", "2023-05-31 20:10:25", "159.203.63.113");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1808", "0", "winda", "2023-05-31 20:10:25", "159.203.63.113");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1809", "0", "admin", "2023-05-31 20:11:09", "83.166.138.108");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1810", "0", "winda", "2023-05-31 20:11:09", "83.166.138.108");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1811", "1", "ucr", "2023-05-31 20:12:01", "34.152.31.23");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1812", "1", "ucr", "2023-05-31 20:12:01", "34.152.31.23");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1813", "0", "admin", "2023-05-31 20:12:21", "68.183.43.38");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1814", "0", "admin", "2023-05-31 20:12:21", "68.183.43.38");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1815", "0", "winda", "2023-05-31 20:13:19", "5.196.83.166");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1816", "0", "winda", "2023-05-31 20:13:19", "5.196.83.166");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1817", "1", "ucr", "2023-05-31 20:13:28", "37.187.151.166");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1818", "0", "wadminw", "2023-06-01 16:17:41", "49.51.134.238");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1819", "0", "admin", "2023-06-02 04:23:45", "68.183.235.66");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1820", "0", "admin", "2023-06-02 05:18:05", "35.187.58.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1821", "0", "admin", "2023-06-02 05:18:05", "35.187.58.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1822", "0", "admin", "2023-06-03 15:22:24", "165.227.89.189");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1823", "0", "admin", "2023-06-04 17:50:54", "36.91.100.149");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1824", "0", "wwwadmin", "2023-06-05 14:09:20", "46.182.4.118");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1825", "0", "wwwadmin", "2023-06-05 14:09:20", "46.182.4.118");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1826", "0", "admin", "2023-06-09 05:24:28", "103.179.56.32");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1827", "0", "admin", "2023-06-09 05:24:28", "103.179.56.32");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1828", "0", "admin", "2023-06-09 06:46:55", "67.205.10.253");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1829", "0", "admin", "2023-06-09 07:26:32", "51.79.144.41");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1830", "0", "admin", "2023-06-09 09:42:54", "192.71.144.12");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1831", "0", "admin", "2023-06-09 10:37:40", "124.123.76.210");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1832", "0", "wwwadmin", "2023-06-09 11:50:50", "103.163.139.202");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1833", "0", "wwwadmin", "2023-06-09 11:50:50", "103.163.139.202");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1834", "0", "admin", "2023-06-09 18:40:52", "143.244.177.220");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1835", "0", "admin", "2023-06-09 21:53:01", "167.99.88.28");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1836", "0", "admin", "2023-06-09 23:36:34", "13.79.17.158");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1837", "0", "admin", "2023-06-10 01:00:37", "128.199.20.182");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1838", "0", "admin", "2023-06-10 01:08:03", "141.94.247.170");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1839", "0", "support@innohosting.com", "2023-06-14 07:00:11", "34.136.143.10");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1840", "0", "admin", "2023-06-14 17:43:41", "34.75.65.218");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1841", "0", "admin", "2023-06-14 19:54:35", "52.140.17.41");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1842", "0", "admin", "2023-06-14 23:43:21", "51.38.52.128");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1843", "0", "admin", "2023-06-15 00:13:24", "195.154.184.235");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1844", "0", "admin", "2023-06-15 01:57:19", "39.108.148.88");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1845", "0", "itsme", "2023-06-15 02:13:15", "91.203.110.235");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1846", "0", "admin", "2023-06-15 02:16:24", "141.94.247.170");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1847", "0", "admin", "2023-06-15 05:12:27", "165.227.89.189");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1848", "0", "admin", "2023-06-15 11:33:45", "35.233.164.145");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1849", "0", "wwwadmin", "2023-06-15 13:26:28", "184.171.250.244");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1850", "0", "wwwadmin", "2023-06-15 13:26:28", "184.171.250.244");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1851", "0", "wadminw", "2023-06-15 13:36:43", "146.190.71.232");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1852", "0", "admin", "2023-06-15 22:50:33", "165.227.89.189");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1853", "0", "admin", "2023-06-15 23:20:23", "162.255.118.205");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1854", "1", "ucr", "2023-06-15 23:21:27", "112.78.2.154");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1855", "0", "admin", "2023-06-15 23:49:15", "81.88.52.41");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1856", "0", "admin", "2023-06-16 04:55:13", "159.223.54.154");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1857", "0", "wadminw", "2023-06-16 20:52:37", "66.29.132.27");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1858", "0", "wpmanager", "2023-06-16 20:52:37", "66.29.132.27");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1859", "0", "wpmanager", "2023-06-16 20:52:44", "37.187.136.65");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1860", "0", "wadminw", "2023-06-16 20:52:44", "37.187.136.65");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1861", "0", "wpenginesupport", "2023-06-16 20:53:57", "50.62.177.2");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1862", "0", "woopayplug", "2023-06-16 20:54:01", "50.62.177.2");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1863", "0", "wpenginesupport", "2023-06-16 20:54:31", "111.93.53.170");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1864", "0", "wpadmin", "2023-06-16 20:55:14", "192.241.179.67");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1865", "0", "adminlin", "2023-06-16 20:55:14", "192.241.179.67");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1866", "0", "wordcamp", "2023-06-16 20:56:22", "68.178.196.149");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1867", "0", "hostingadmin", "2023-06-16 20:56:22", "68.178.196.149");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1868", "0", "1001010", "2023-06-16 20:57:29", "107.180.109.20");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1869", "0", "WPADMIN", "2023-06-16 20:57:29", "107.180.109.20");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1870", "0", "WPADMIN", "2023-06-16 20:57:32", "151.80.60.202");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1871", "0", "1001010", "2023-06-16 20:57:32", "151.80.60.202");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1872", "0", "itsme", "2023-06-16 20:59:58", "34.170.196.107");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1873", "0", "admin", "2023-06-16 22:38:25", "43.225.108.187");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1874", "0", "admin", "2023-06-17 05:09:51", "208.113.170.116");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1875", "0", "wadminw", "2023-06-18 15:20:43", "208.97.186.104");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1876", "0", "wadminw", "2023-06-18 15:20:57", "206.189.203.123");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1877", "0", "wwwadmin", "2023-06-18 15:31:06", "157.245.152.50");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1878", "0", "wwwadmin", "2023-06-18 15:31:06", "157.245.152.50");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1879", "0", "admin", "2023-06-19 05:18:00", "113.161.72.135");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1880", "0", "tescb@tcf.sdf", "2023-06-20 14:24:29", "45.33.59.15");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1881", "0", "itsme", "2023-06-21 08:35:42", "206.189.80.189");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1882", "0", "admin", "2023-06-23 02:11:23", "148.72.244.186");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1883", "0", "admin", "2023-06-23 04:10:13", "80.88.88.149");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1884", "0", "hostingadmin", "2023-06-23 04:16:30", "178.62.196.228");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1885", "0", "wpmanager", "2023-06-23 04:16:30", "178.62.196.228");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1886", "0", "wpenginesupport", "2023-06-23 04:16:48", "85.17.28.85");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1887", "0", "adminlin", "2023-06-23 04:16:50", "85.17.28.85");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1888", "0", "wpadmin", "2023-06-23 04:17:29", "198.54.114.19");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1889", "0", "WPADMIN", "2023-06-23 04:17:29", "198.54.114.19");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1890", "0", "wpadmin", "2023-06-23 04:17:32", "136.243.72.94");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1891", "0", "WPADMIN", "2023-06-23 04:17:32", "136.243.72.94");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1892", "0", "wpadmin", "2023-06-23 04:17:59", "198.71.236.47");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1893", "0", "WPADMIN", "2023-06-23 04:17:59", "198.71.236.47");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1894", "0", "WPADMIN", "2023-06-23 04:18:38", "148.72.121.232");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1895", "0", "wpadmin", "2023-06-23 04:18:38", "148.72.121.232");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1896", "0", "wpadmin", "2023-06-23 04:18:54", "198.71.237.3");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1897", "0", "WPADMIN", "2023-06-23 04:18:54", "198.71.237.3");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1898", "0", "WPADMIN", "2023-06-23 04:18:57", "83.166.138.44");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1899", "0", "wpadmin", "2023-06-23 04:18:57", "83.166.138.44");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1900", "0", "1001010", "2023-06-23 04:19:14", "173.246.38.153");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1901", "0", "woopayplug", "2023-06-23 04:19:14", "173.246.38.153");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1902", "0", "1001010", "2023-06-23 04:19:40", "89.43.66.107");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1903", "0", "itsme", "2023-06-23 04:20:31", "46.43.15.165");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1904", "0", "support@innohosting.com", "2023-06-23 14:25:51", "148.72.121.232");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1905", "0", "admin", "2023-06-23 21:52:29", "103.158.206.167");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1906", "0", "admin", "2023-06-24 00:29:00", "8.129.212.192");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1907", "0", "admin", "2023-06-24 01:52:33", "66.42.52.15");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1908", "0", "admin", "2023-06-24 02:22:50", "202.134.19.110");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1909", "0", "admin", "2023-06-24 05:03:38", "161.35.52.207");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1910", "0", "admin", "2023-06-24 05:58:17", "20.224.212.230");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1911", "0", "admin", "2023-06-24 06:39:44", "211.75.243.6");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1912", "0", "admin", "2023-06-24 06:40:09", "65.1.72.77");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1913", "1", "ucr", "2023-06-24 06:43:33", "139.162.5.183");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1914", "1", "ucr", "2023-06-24 06:43:58", "68.178.198.34");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1915", "0", "admin", "2023-06-24 09:39:56", "120.79.240.62");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1916", "0", "admin", "2023-06-24 09:39:56", "120.79.240.62");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1917", "0", "admin", "2023-06-24 11:49:06", "94.237.80.158");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1918", "0", "admin", "2023-06-25 05:37:15", "209.145.52.234");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1919", "0", "admin", "2023-06-25 07:15:56", "43.241.70.75");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1920", "0", "admin", "2023-06-25 07:51:20", "38.242.144.48");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1921", "0", "admin", "2023-06-25 07:51:20", "38.242.144.48");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1922", "0", "admin", "2023-06-25 08:21:13", "20.224.212.230");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1923", "0", "admin", "2023-06-25 08:21:13", "20.224.212.230");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1924", "0", "admin", "2023-06-25 09:02:46", "69.163.224.107");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1925", "0", "admin", "2023-06-25 09:14:25", "34.79.133.157");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1926", "0", "admin", "2023-06-25 11:44:02", "13.75.189.243");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1927", "0", "admin", "2023-06-25 14:06:34", "212.224.98.109");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1928", "0", "admin", "2023-06-25 14:32:59", "112.213.125.230");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1929", "0", "admin", "2023-06-26 00:25:37", "89.248.107.48");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1930", "0", "wwwadmin", "2023-06-26 15:13:29", "148.72.207.110");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1931", "0", "wwwadmin", "2023-06-26 15:13:29", "148.72.207.110");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1932", "0", "wwwadmin", "2023-06-26 15:14:27", "51.255.64.58");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1933", "0", "wwwadmin", "2023-06-26 15:14:27", "51.255.64.58");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1934", "0", "admin", "2023-06-27 08:49:59", "157.245.202.8");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1935", "0", "admin", "2023-06-27 10:01:34", "23.97.205.210");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1936", "0", "admin", "2023-06-27 12:02:25", "103.173.78.11");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1937", "0", "admin", "2023-06-27 13:16:57", "45.153.58.185");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1938", "0", "admin", "2023-06-27 18:47:45", "150.109.148.216");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1939", "0", "admin", "2023-06-27 23:51:29", "208.97.186.104");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1940", "0", "admin", "2023-06-28 01:44:12", "69.163.224.108");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1941", "0", "admin", "2023-06-28 03:16:32", "111.230.202.147");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1942", "0", "admin", "2023-06-28 05:28:21", "148.72.40.90");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1943", "0", "admin", "2023-06-28 06:50:28", "120.79.240.62");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1944", "0", "admin", "2023-06-28 09:34:22", "54.37.156.240");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1945", "0", "admin", "2023-06-28 11:18:51", "209.145.52.234");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1946", "0", "admin", "2023-06-28 18:15:08", "3.111.23.40");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1947", "0", "admin", "2023-06-28 23:08:11", "81.88.52.160");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1948", "0", "admin", "2023-06-29 00:37:18", "103.173.78.11");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1949", "0", "admin", "2023-06-29 03:25:59", "51.68.38.140");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1950", "0", "admin", "2023-06-29 03:25:59", "51.68.38.140");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1951", "0", "admin", "2023-06-29 04:57:35", "192.71.144.12");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1952", "0", "admin", "2023-06-29 08:35:30", "86.105.198.149");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1953", "0", "admin", "2023-06-29 08:35:30", "86.105.198.149");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1954", "0", "admin", "2023-06-29 08:45:50", "128.140.53.90");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1955", "0", "admin", "2023-06-29 08:51:55", "108.12.224.113");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1956", "0", "admin", "2023-06-29 19:07:13", "51.68.38.140");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1957", "0", "admin", "2023-06-30 06:10:04", "161.35.52.207");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1958", "0", "admin", "2023-07-01 18:34:40", "45.84.206.5");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1959", "0", "admin", "2023-07-01 23:09:35", "161.35.215.200");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1960", "0", "admin", "2023-07-02 01:27:33", "202.134.19.110");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1961", "0", "wwwadmin", "2023-07-02 15:10:08", "213.175.66.138");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1962", "0", "wwwadmin", "2023-07-02 15:10:08", "213.175.66.138");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1963", "0", "admin", "2023-07-06 11:57:55", "108.12.224.113");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1964", "0", "admin", "2023-07-06 22:51:51", "49.51.134.238");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1965", "0", "admin", "2023-07-07 03:30:20", "46.105.28.158");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1966", "0", "admin", "2023-07-07 08:09:34", "148.72.207.163");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1967", "0", "admin", "2023-07-11 17:33:29", "173.236.168.10");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1968", "0", "admin", "2023-07-12 04:15:17", "91.197.199.240");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1969", "0", "admin", "2023-07-12 18:19:54", "103.56.149.67");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1970", "0", "admin", "2023-07-12 23:47:24", "167.99.88.28");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1971", "0", "admin", "2023-07-12 23:47:24", "167.99.88.28");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1972", "0", "admin", "2023-07-16 16:34:07", "118.101.72.45");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1973", "0", "admin", "2023-07-17 05:18:12", "173.236.176.129");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1974", "0", "wwwadmin", "2023-07-17 14:33:18", "141.94.247.170");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1975", "0", "wwwadmin", "2023-07-17 14:33:18", "141.94.247.170");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1976", "0", "smngrs951", "2023-07-18 00:13:45", "50.62.177.171");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1977", "0", "smngrs951", "2023-07-18 00:13:46", "95.217.114.163");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1978", "0", "matakucing3", "2023-07-18 00:13:46", "95.217.114.163");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1979", "0", "smngrs951", "2023-07-18 00:14:01", "213.187.10.198");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1980", "0", "matakucing3", "2023-07-18 00:14:01", "213.187.10.198");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1981", "0", "pajero_sports", "2023-07-18 00:14:40", "83.216.185.94");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1982", "0", "smngrs953", "2023-07-18 00:14:40", "198.71.236.36");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1983", "0", "smngrs955", "2023-07-18 00:15:01", "107.170.49.15");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1984", "0", "smngrs953", "2023-07-18 00:15:01", "107.170.49.15");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1985", "0", "admin", "2023-07-18 23:10:07", "35.209.180.50");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1986", "0", "admin", "2023-07-19 03:32:20", "23.97.205.210");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1987", "0", "wwwadmin", "2023-07-21 15:00:46", "116.109.45.9");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1988", "0", "wwwadmin", "2023-07-21 15:00:46", "116.109.45.9");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1989", "0", "admin", "2023-07-21 20:48:18", "141.95.160.225");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1990", "0", "admin", "2023-07-22 06:35:10", "54.36.173.205");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1991", "0", "admin", "2023-07-22 07:56:44", "203.112.76.18");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1992", "0", "admin", "2023-07-23 17:23:48", "185.18.197.110");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1993", "0", "admin", "2023-07-23 17:54:57", "103.173.78.11");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1994", "0", "admin", "2023-07-24 08:26:57", "173.236.168.10");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1995", "0", "admin", "2023-07-24 09:52:06", "103.56.149.67");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1996", "0", "admin", "2023-07-24 12:03:07", "150.230.27.122");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1997", "0", "admin", "2023-07-25 07:45:22", "87.106.169.74");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1998", "0", "admin", "2023-07-25 13:00:05", "69.63.64.21");
INSERT INTO `wp_aiowps_failed_logins` VALUES("1999", "0", "admin", "2023-07-25 20:19:06", "210.207.92.24");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2000", "0", "admin", "2023-07-25 23:38:15", "178.128.40.163");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2001", "0", "admin", "2023-07-26 08:26:40", "183.181.16.139");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2002", "0", "wwwadmin", "2023-07-26 13:39:14", "81.30.204.18");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2003", "0", "wwwadmin", "2023-07-26 13:39:14", "81.30.204.18");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2004", "0", "admin", "2023-07-26 18:09:14", "165.227.89.189");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2005", "0", "wpmanager", "2023-07-27 04:39:53", "195.56.146.60");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2006", "0", "wpadmin", "2023-07-27 04:39:53", "195.56.146.60");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2007", "0", "wordcamp", "2023-07-27 04:41:27", "162.240.17.165");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2008", "0", "itsme", "2023-07-27 04:41:27", "162.240.17.165");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2009", "0", "adminlin", "2023-07-27 04:41:55", "118.68.168.207");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2010", "0", "itsme", "2023-07-27 09:12:51", "68.183.86.200");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2011", "0", "matakucing3", "2023-07-27 09:55:23", "45.118.145.52");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2012", "0", "smngrs955", "2023-07-27 09:55:23", "45.118.145.52");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2013", "0", "pajero_sports", "2023-07-27 09:56:35", "65.109.20.147");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2014", "0", "smngrs952", "2023-07-27 09:56:35", "65.109.20.147");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2015", "0", "smngrs951", "2023-07-27 09:57:47", "92.204.65.146");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2016", "0", "smngrs951", "2023-07-27 09:57:53", "72.167.190.1");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2017", "0", "smngrs951", "2023-07-27 09:58:04", "103.74.54.34");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2018", "0", "smngrs953", "2023-07-27 09:58:57", "104.155.140.115");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2019", "0", "admin", "2023-07-27 16:04:58", "47.111.116.44");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2020", "0", "admin", "2023-07-28 09:29:24", "198.211.110.178");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2021", "0", "wwwadmin", "2023-07-29 15:02:23", "178.62.239.223");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2022", "0", "wwwadmin", "2023-07-29 15:02:23", "178.62.239.223");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2023", "0", "admin", "2023-07-30 14:58:33", "209.141.51.44");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2024", "0", "administrator", "2023-07-30 14:58:53", "209.141.51.44");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2025", "0", "admin", "2023-07-31 23:46:56", "185.18.197.110");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2026", "0", "admin", "2023-07-31 23:51:49", "54.37.156.240");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2027", "0", "admin", "2023-08-03 09:32:26", "184.168.116.160");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2028", "0", "admin", "2023-08-03 20:02:48", "173.236.184.135");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2029", "0", "admin", "2023-08-04 00:05:49", "35.187.58.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2030", "0", "admin", "2023-08-04 08:14:26", "148.72.207.163");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2031", "0", "wadminw", "2023-08-04 14:08:48", "104.168.157.134");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2032", "0", "admin", "2023-08-05 09:54:57", "165.227.236.111");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2033", "0", "admin", "2023-08-05 10:57:14", "62.116.165.86");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2034", "0", "admin", "2023-08-06 06:36:26", "194.39.67.52");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2035", "1", "ucr", "2023-08-06 22:34:22", "95.214.27.219");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2036", "0", "admin", "2023-08-07 01:05:28", "82.220.34.9");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2037", "0", "admin", "2023-08-07 05:27:16", "159.65.137.180");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2038", "0", "admin", "2023-08-07 08:07:18", "173.236.224.157");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2039", "0", "admin", "2023-08-07 12:49:03", "198.54.126.134");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2040", "0", "admin", "2023-08-07 18:41:22", "148.72.207.163");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2041", "0", "admin", "2023-08-08 20:25:07", "146.190.71.232");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2042", "0", "wwwadmin", "2023-08-09 14:47:11", "159.89.172.158");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2043", "0", "wwwadmin", "2023-08-09 14:47:11", "159.89.172.158");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2044", "0", "smngrs951", "2023-08-10 00:39:00", "198.71.224.84");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2045", "0", "smngrs952", "2023-08-10 00:39:00", "198.71.224.84");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2046", "0", "smngrs952", "2023-08-10 00:39:02", "162.0.235.124");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2047", "0", "smngrs951", "2023-08-10 00:39:02", "162.0.235.124");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2048", "0", "smngrs952", "2023-08-10 00:39:04", "34.135.64.229");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2049", "0", "smngrs951", "2023-08-10 00:39:04", "34.135.64.229");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2050", "0", "wwwadmin", "2023-08-10 15:22:36", "209.97.169.15");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2051", "0", "wwwadmin", "2023-08-10 15:22:36", "209.97.169.15");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2052", "0", "wpmanager", "2023-08-12 03:02:07", "86.105.226.85");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2053", "0", "wadminw", "2023-08-12 03:02:07", "86.105.226.85");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2054", "0", "wpenginesupport", "2023-08-12 03:03:05", "192.254.250.177");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2055", "0", "adminlin", "2023-08-12 03:03:05", "192.254.250.177");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2056", "0", "wordcamp", "2023-08-12 03:03:50", "148.72.121.232");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2057", "0", "wpadmin", "2023-08-12 03:03:50", "148.72.121.232");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2058", "0", "wpadmin", "2023-08-12 03:04:06", "162.0.209.190");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2059", "0", "wordcamp", "2023-08-12 03:04:06", "162.0.209.190");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2060", "0", "hostingadmin", "2023-08-12 03:04:54", "103.93.160.210");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2061", "0", "WPADMIN", "2023-08-12 03:04:54", "103.93.160.210");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2062", "0", "woopayplug", "2023-08-12 03:05:41", "194.243.52.190");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2063", "0", "1001010", "2023-08-12 03:06:50", "178.128.63.221");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2064", "0", "admin", "2023-08-12 04:39:05", "94.23.61.165");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2065", "0", "admin", "2023-08-12 13:04:38", "178.32.114.31");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2066", "0", "admin", "2023-08-12 20:36:41", "111.230.202.147");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2067", "0", "admin", "2023-08-13 03:23:28", "74.81.38.26");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2068", "0", "admin", "2023-08-15 08:40:23", "67.205.12.218");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2069", "0", "admin", "2023-08-15 09:49:38", "92.205.8.255");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2070", "0", "admin", "2023-08-15 11:02:14", "103.159.239.224");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2071", "0", "admin", "2023-08-15 11:39:15", "35.213.170.208");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2072", "0", "admin", "2023-08-15 11:44:00", "74.81.38.26");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2073", "0", "admin", "2023-08-15 13:31:23", "68.65.120.209");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2074", "0", "admin", "2023-08-16 00:34:11", "148.72.214.245");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2075", "0", "admin", "2023-08-16 00:34:11", "148.72.214.245");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2076", "0", "admin", "2023-08-16 08:35:30", "37.139.13.81");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2077", "0", "admin", "2023-08-19 18:17:55", "202.95.9.31");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2078", "0", "admin", "2023-08-20 00:22:12", "198.244.167.101");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2079", "0", "admin", "2023-08-20 22:05:42", "51.15.228.58");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2080", "0", "admin", "2023-08-21 03:52:43", "93.39.217.133");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2081", "0", "admin", "2023-08-21 03:52:43", "93.39.217.133");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2082", "0", "admin", "2023-08-28 07:29:47", "182.43.230.63");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2083", "0", "admin", "2023-08-28 13:17:23", "180.211.108.182");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2084", "0", "admin", "2023-09-03 00:33:52", "124.106.70.154");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2085", "0", "admin", "2023-09-03 03:29:41", "157.245.202.8");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2086", "0", "admin", "2023-09-04 07:03:30", "135.125.1.9");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2087", "0", "admin", "2023-09-04 07:03:30", "135.125.1.9");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2088", "0", "admin", "2023-09-04 11:53:49", "31.186.172.143");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2089", "0", "wadminw", "2023-09-04 14:54:16", "152.32.191.185");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2090", "0", "admin", "2023-09-04 22:58:32", "51.91.151.60");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2091", "0", "admin", "2023-09-05 04:25:26", "190.228.29.221");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2092", "0", "admin", "2023-09-05 09:34:08", "213.136.93.170");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2093", "0", "admin", "2023-09-05 12:45:55", "51.79.177.175");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2094", "0", "admin", "2023-09-06 16:58:22", "69.43.139.165");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2095", "0", "admin", "2023-09-09 02:47:20", "39.101.185.186");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2096", "0", "admin", "2023-09-09 09:12:47", "46.182.4.124");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2097", "0", "admin", "2023-09-09 11:43:39", "178.128.240.227");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2098", "0", "admin", "2023-09-09 11:43:39", "178.128.240.227");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2099", "0", "admin", "2023-09-09 13:58:08", "39.105.120.190");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2100", "0", "admin", "2023-09-09 14:00:51", "42.200.231.120");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2101", "0", "admin", "2023-09-10 19:09:21", "51.91.151.60");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2102", "0", "admin", "2023-09-10 23:34:02", "192.71.144.12");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2103", "0", "admin", "2023-09-11 07:38:57", "143.110.177.0");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2104", "0", "admin", "2023-09-11 07:38:57", "143.110.177.0");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2105", "0", "admin", "2023-09-12 09:29:24", "13.210.255.220");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2106", "0", "wadminw", "2023-09-12 14:19:00", "188.40.131.158");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2107", "0", "admin", "2023-09-12 23:01:15", "45.119.82.52");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2108", "0", "admin", "2023-09-13 10:19:37", "167.99.88.28");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2109", "0", "admin", "2023-09-15 01:11:28", "111.230.202.147");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2110", "0", "admin", "2023-09-15 18:18:43", "150.109.148.216");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2111", "0", "admin", "2023-09-16 03:20:10", "206.189.54.26");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2112", "0", "admin", "2023-09-16 03:20:10", "206.189.54.26");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2113", "0", "wadminw", "2023-09-16 16:47:01", "173.236.176.128");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2114", "0", "admin", "2023-09-16 23:25:41", "167.172.66.189");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2115", "0", "admin", "2023-09-16 23:43:35", "103.158.206.167");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2116", "0", "admin", "2023-09-17 02:40:06", "122.176.39.124");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2117", "0", "admin", "2023-09-17 05:58:42", "173.236.176.141");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2118", "0", "admin", "2023-09-18 09:50:16", "23.235.210.218");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2119", "0", "admin", "2023-09-18 11:35:47", "110.42.217.219");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2120", "0", "admin", "2023-09-18 12:10:44", "164.92.205.132");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2121", "0", "admin", "2023-09-18 14:05:45", "124.40.255.186");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2122", "0", "admin", "2023-09-18 14:05:45", "124.40.255.186");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2123", "0", "admin", "2023-09-19 07:35:20", "23.97.205.210");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2124", "0", "admin", "2023-09-19 14:03:16", "106.52.91.38");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2125", "0", "admin", "2023-09-20 06:29:17", "213.175.66.138");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2126", "1", "ucr", "2023-09-21 07:38:47", "95.214.27.219");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2127", "0", "wwwadmin", "2023-09-21 17:18:46", "35.219.66.183");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2128", "0", "wwwadmin", "2023-09-21 17:18:46", "35.219.66.183");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2129", "1", "ucr", "2023-09-26 01:29:42", "95.214.27.219");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2130", "1", "ucr", "2023-09-26 12:40:29", "95.214.27.219");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2131", "1", "ucr", "2023-09-27 13:12:40", "95.214.27.219");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2132", "1", "ucr", "2023-09-28 00:57:28", "172.172.118.212");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2133", "1", "ucr", "2023-09-29 01:34:31", "95.214.27.219");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2134", "0", "admin", "2023-09-30 01:35:48", "69.163.185.172");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2135", "0", "admin", "2023-09-30 02:20:58", "103.154.184.42");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2136", "0", "admin", "2023-09-30 02:40:56", "45.117.80.238");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2137", "0", "admin", "2023-10-01 05:33:09", "137.184.124.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2138", "0", "admin", "2023-10-01 05:33:09", "137.184.124.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2139", "0", "admin", "2023-10-01 08:21:55", "206.189.54.26");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2140", "0", "admin", "2023-10-01 16:05:49", "69.163.224.107");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2141", "0", "admin", "2023-10-01 23:17:09", "37.139.13.81");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2142", "0", "admin", "2023-10-03 23:37:34", "188.166.82.64");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2143", "0", "admin", "2023-10-04 00:57:27", "210.207.92.24");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2144", "0", "admin", "2023-10-04 03:21:22", "69.163.224.104");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2145", "0", "admin", "2023-10-04 04:46:13", "69.163.203.185");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2146", "0", "admin", "2023-10-04 20:07:14", "148.72.214.245");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2147", "0", "admin", "2023-10-05 00:44:16", "150.109.148.216");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2148", "0", "admin", "2023-10-05 03:16:49", "148.72.214.245");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2149", "1", "ucr", "2023-10-06 02:30:30", "111.230.202.147");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2150", "0", "admin", "2023-10-06 08:11:10", "140.238.147.93");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2151", "0", "admin", "2023-10-06 08:11:11", "140.238.147.93");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2152", "0", "admin", "2023-10-06 08:11:11", "140.238.147.93");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2153", "0", "admin", "2023-10-06 08:11:11", "140.238.147.93");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2154", "0", "admin", "2023-10-06 08:11:11", "140.238.147.93");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2155", "0", "admin", "2023-10-06 08:11:12", "140.238.147.93");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2156", "0", "admin", "2023-10-06 08:11:12", "140.238.147.93");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2157", "0", "admin", "2023-10-06 08:11:12", "140.238.147.93");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2158", "0", "admin", "2023-10-06 08:11:12", "140.238.147.93");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2159", "0", "admin", "2023-10-06 08:11:13", "140.238.147.93");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2160", "0", "admin", "2023-10-06 08:11:13", "140.238.147.93");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2161", "0", "admin", "2023-10-06 08:11:13", "140.238.147.93");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2162", "0", "admin", "2023-10-06 08:11:14", "140.238.147.93");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2163", "0", "admin", "2023-10-06 08:11:14", "140.238.147.93");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2164", "0", "admin", "2023-10-06 08:11:14", "140.238.147.93");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2165", "0", "admin", "2023-10-06 08:11:14", "140.238.147.93");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2166", "0", "admin", "2023-10-06 08:11:15", "140.238.147.93");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2167", "0", "admin", "2023-10-06 08:11:15", "140.238.147.93");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2168", "0", "admin", "2023-10-06 08:11:15", "140.238.147.93");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2169", "0", "admin", "2023-10-09 19:37:46", "202.134.19.110");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2170", "1", "ucr", "2023-10-10 03:48:20", "47.97.195.29");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2171", "0", "admin", "2023-10-11 06:20:29", "202.134.19.110");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2172", "0", "nata004", "2023-10-11 17:11:52", "192.9.151.173");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2173", "0", "nata004", "2023-10-11 17:11:52", "192.9.151.173");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2174", "0", "nata004", "2023-10-11 17:11:53", "192.9.151.173");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2175", "0", "nata004", "2023-10-11 17:11:53", "192.9.151.173");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2176", "0", "nata004", "2023-10-11 17:11:53", "192.9.151.173");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2177", "0", "nata004", "2023-10-11 17:11:54", "192.9.151.173");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2178", "0", "nata004", "2023-10-11 17:11:54", "192.9.151.173");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2179", "0", "nata004", "2023-10-11 17:11:54", "192.9.151.173");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2180", "0", "nata004", "2023-10-11 17:11:54", "192.9.151.173");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2181", "0", "nata004", "2023-10-11 17:11:55", "192.9.151.173");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2182", "0", "nata004", "2023-10-11 17:11:55", "192.9.151.173");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2183", "0", "nata004", "2023-10-11 17:11:55", "192.9.151.173");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2184", "0", "nata004", "2023-10-11 17:11:56", "192.9.151.173");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2185", "0", "nata004", "2023-10-11 17:11:56", "192.9.151.173");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2186", "0", "nata004", "2023-10-11 17:11:56", "192.9.151.173");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2187", "0", "nata004", "2023-10-11 17:11:57", "192.9.151.173");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2188", "0", "nata004", "2023-10-11 17:11:57", "192.9.151.173");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2189", "0", "nata004", "2023-10-11 17:11:57", "192.9.151.173");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2190", "0", "nata004", "2023-10-11 17:11:58", "192.9.151.173");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2191", "0", "admin", "2023-10-11 20:38:28", "199.249.230.182");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2192", "0", "admin", "2023-10-11 22:22:38", "139.99.80.15");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2193", "0", "admin", "2023-10-12 01:01:03", "91.238.164.172");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2194", "0", "admin", "2023-10-12 23:54:45", "138.2.24.226");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2195", "0", "admin", "2023-10-13 09:31:12", "116.62.206.174");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2196", "0", "admin", "2023-10-14 15:51:14", "165.227.89.189");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2197", "0", "admin", "2023-10-14 18:16:49", "173.212.231.122");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2198", "0", "admin", "2023-10-14 18:39:09", "75.119.221.80");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2199", "0", "admin", "2023-10-14 19:08:31", "185.92.194.80");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2200", "0", "admin", "2023-10-14 19:08:42", "57.128.161.18");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2201", "0", "admin", "2023-10-14 23:09:20", "178.128.110.234");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2202", "0", "admin", "2023-10-15 05:05:31", "47.242.107.149");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2203", "0", "admin", "2023-10-15 05:55:47", "45.117.80.26");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2204", "0", "admin", "2023-10-16 13:51:39", "103.154.101.95");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2205", "0", "admin", "2023-10-16 21:27:41", "5.255.115.58");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2206", "0", "admin", "2023-10-18 08:02:20", "86.107.198.192");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2207", "1", "ucr", "2023-10-18 18:49:37", "184.105.238.162");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2208", "1", "ucr", "2023-10-18 18:49:37", "184.105.238.162");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2209", "0", "admin", "2023-10-19 13:46:50", "141.94.247.170");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2210", "0", "admin", "2023-10-19 14:59:38", "51.91.151.60");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2211", "0", "admin", "2023-10-20 06:03:00", "149.91.122.223");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2212", "0", "admin", "2023-10-20 12:22:27", "212.110.92.158");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2213", "1", "ucr", "2023-10-20 23:53:03", "151.251.123.178");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2214", "0", "wwwadmin", "2023-10-22 15:57:03", "35.187.58.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2215", "0", "wwwadmin", "2023-10-22 15:57:03", "35.187.58.136");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2216", "0", "admin", "2023-10-22 23:57:29", "35.209.174.128");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2217", "0", "admin", "2023-10-23 02:51:08", "66.70.170.152");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2218", "0", "admin", "2023-10-24 11:31:01", "47.107.176.36");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2219", "0", "admin", "2023-10-24 11:43:47", "81.12.119.74");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2220", "0", "admin", "2023-10-24 12:05:33", "104.248.45.30");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2221", "0", "admin", "2023-10-24 12:13:41", "192.169.148.26");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2222", "0", "admin", "2023-10-24 12:57:33", "92.205.13.134");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2223", "0", "admin", "2023-10-24 12:57:33", "92.205.13.134");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2224", "0", "admin", "2023-10-24 13:03:55", "150.230.93.233");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2225", "0", "admin", "2023-10-24 13:13:47", "184.168.116.126");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2226", "0", "admin", "2023-10-24 14:49:16", "64.90.48.179");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2227", "0", "admin", "2023-10-25 03:07:48", "165.227.89.189");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2228", "0", "admin", "2023-10-25 03:32:25", "69.163.203.185");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2229", "1", "ucr", "2023-10-25 15:55:03", "102.130.201.167");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2230", "1", "ucr", "2023-10-25 15:55:03", "102.130.201.167");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2231", "0", "wordpress_administrator", "2023-10-25 20:56:39", "82.165.85.57");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2232", "0", "admin", "2023-10-26 01:12:17", "190.27.188.165");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2233", "0", "admin", "2023-10-26 01:12:17", "190.27.188.165");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2234", "0", "admin", "2023-10-27 17:38:39", "120.25.104.120");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2235", "0", "admin", "2023-10-28 00:09:02", "156.209.195.201");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2236", "0", "admin", "2023-10-29 20:22:47", "209.97.169.15");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2237", "0", "admin", "2023-10-29 20:23:02", "209.97.169.15");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2238", "0", "admin", "2023-10-29 23:50:18", "143.110.177.0");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2239", "0", "admin", "2023-10-30 05:19:15", "148.72.214.245");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2240", "0", "admin", "2023-10-30 05:19:15", "148.72.214.245");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2241", "1", "ucr", "2023-10-30 08:58:34", "188.113.158.140");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2242", "1", "ucr", "2023-10-30 18:16:03", "13.95.233.164");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2243", "1", "ucr", "2023-10-31 15:09:15", "14.188.172.179");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2244", "0", "admin", "2023-11-01 15:00:04", "31.128.252.198");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2245", "1", "ucr", "2023-11-02 12:05:07", "137.117.153.139");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2246", "1", "ucr", "2023-11-04 01:23:35", "167.99.87.191");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2247", "0", "wadminw", "2023-11-04 14:44:13", "173.212.231.122");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2248", "0", "wwwadmin", "2023-11-04 14:57:28", "39.103.225.8");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2249", "0", "wwwadmin", "2023-11-04 14:57:28", "39.103.225.8");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2250", "1", "ucr", "2023-11-05 17:25:50", "13.95.233.141");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2251", "0", "admin", "2023-11-06 11:58:38", "166.62.122.244");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2252", "0", "admin", "2023-11-06 12:43:20", "148.72.245.234");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2253", "0", "admin", "2023-11-06 16:43:51", "69.163.224.107");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2254", "0", "admin", "2023-11-07 10:56:00", "136.144.191.124");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2255", "0", "admin", "2023-11-07 12:43:51", "3.87.196.59");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2256", "0", "wwwadmin", "2023-11-07 14:34:34", "217.133.221.210");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2257", "0", "wwwadmin", "2023-11-07 14:34:34", "217.133.221.210");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2258", "1", "ucr", "2023-11-07 17:49:06", "52.178.5.22");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2259", "0", "wordpress_administrator", "2023-11-07 18:19:02", "45.61.186.18");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2260", "1", "ucr", "2023-11-07 20:36:44", "94.23.61.165");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2261", "1", "ucr", "2023-11-07 21:04:34", "45.79.209.150");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2262", "1", "ucr", "2023-11-07 22:30:19", "148.66.130.195");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2263", "1", "ucr", "2023-11-07 23:07:28", "139.196.46.20");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2264", "1", "ucr", "2023-11-08 01:03:40", "111.230.202.147");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2265", "1", "ucr", "2023-11-08 01:34:25", "80.208.57.158");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2266", "1", "ucr", "2023-11-08 01:43:14", "5.144.132.128");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2267", "1", "ucr", "2023-11-08 07:26:07", "161.35.188.92");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2268", "1", "ucr", "2023-11-08 07:27:01", "3.13.130.91");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2269", "1", "ucr", "2023-11-08 10:04:29", "83.33.2.117");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2270", "1", "ucr", "2023-11-08 10:29:13", "125.212.209.171");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2271", "1", "ucr", "2023-11-08 11:06:12", "161.35.188.92");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2272", "1", "ucr", "2023-11-08 12:03:22", "162.240.226.96");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2273", "0", "admin", "2023-11-08 22:03:36", "5.9.238.116");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2274", "0", "admin", "2023-11-08 22:03:36", "5.9.238.116");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2275", "0", "admin", "2023-11-08 23:32:30", "62.138.24.179");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2276", "0", "admin", "2023-11-09 07:16:32", "15.207.142.148");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2277", "0", "admin", "2023-11-09 08:17:49", "141.95.11.53");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2278", "1", "ucr", "2023-11-09 18:00:40", "159.223.45.212");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2279", "1", "ucr", "2023-11-09 23:14:58", "35.245.96.16");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2280", "1", "ucr", "2023-11-10 02:45:30", "213.227.149.178");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2281", "1", "ucr", "2023-11-10 02:45:30", "213.227.149.178");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2282", "1", "ucr", "2023-11-10 04:23:57", "128.199.238.118");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2283", "1", "ucr", "2023-11-10 07:59:07", "143.198.227.241");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2284", "0", "admin", "2023-11-10 11:00:55", "142.93.253.82");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2285", "1", "ucr", "2023-11-10 11:14:55", "159.65.113.235");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2286", "1", "ucr", "2023-11-10 12:55:44", "185.193.17.135");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2287", "0", "wordpress_administrator", "2023-11-10 14:07:39", "104.244.79.114");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2288", "1", "ucr", "2023-11-11 00:22:23", "3.131.62.223");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2289", "1", "ucr", "2023-11-11 00:23:55", "178.128.160.8");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2290", "1", "ucr", "2023-11-11 00:28:39", "192.71.144.12");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2291", "1", "ucr", "2023-11-11 01:15:36", "69.163.137.39");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2292", "1", "ucr", "2023-11-11 01:20:28", "167.99.87.191");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2293", "0", "admin", "2023-11-11 03:47:01", "45.119.84.18");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2294", "0", "admin", "2023-11-12 07:44:28", "51.178.136.164");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2295", "0", "admin", "2023-11-12 12:40:10", "49.12.197.167");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2296", "0", "admin", "2023-11-14 11:21:04", "45.89.246.214");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2297", "0", "admin", "2023-11-14 19:45:05", "103.157.27.197");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2298", "1", "ucr", "2023-11-15 13:09:53", "171.247.164.75");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2299", "0", "admin", "2023-11-15 21:28:18", "162.240.17.77");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2300", "0", "admin", "2023-11-15 22:12:34", "51.77.53.202");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2301", "0", "admin", "2023-11-16 01:26:28", "178.128.160.8");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2302", "0", "admin", "2023-11-16 02:23:56", "36.92.68.137");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2303", "0", "admin", "2023-11-16 02:39:57", "209.145.60.98");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2304", "0", "admin", "2023-11-16 04:40:01", "143.110.244.123");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2305", "0", "admin", "2023-11-16 06:04:29", "149.91.122.223");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2306", "0", "admin", "2023-11-16 07:48:33", "144.217.181.5");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2307", "0", "plesk_administrator", "2023-11-16 10:04:56", "45.61.186.18");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2308", "1", "ucr", "2023-11-16 12:18:19", "105.158.30.70");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2309", "0", "admin", "2023-11-16 19:48:59", "169.0.227.7");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2310", "0", "stender", "2023-11-17 10:41:34", "188.40.8.228");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2311", "0", "wpcore", "2023-11-17 10:41:34", "188.40.8.228");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2312", "0", "admin", "2023-11-17 13:38:37", "186.79.225.144");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2313", "1", "ucr", "2023-11-17 19:18:33", "111.68.97.173");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2314", "0", "admin", "2023-11-18 02:27:23", "167.99.66.5");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2315", "0", "admin", "2023-11-18 04:08:46", "202.95.9.249");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2316", "0", "admin", "2023-11-18 06:10:21", "208.97.147.187");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2317", "0", "admin", "2023-11-18 07:11:23", "185.208.180.23");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2318", "0", "admin", "2023-11-18 08:01:58", "139.59.169.190");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2319", "0", "plesk_administrator", "2023-11-18 14:59:49", "107.189.8.58");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2320", "1", "ucr", "2023-11-18 16:22:15", "183.89.155.139");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2321", "1", "ucr", "2023-11-18 19:36:09", "35.155.211.248");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2322", "0", "admin", "2023-11-18 21:24:05", "203.210.192.198");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2323", "0", "admin", "2023-11-19 01:37:12", "51.77.230.29");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2324", "1", "ucr", "2023-11-19 03:01:20", "35.155.211.248");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2325", "1", "ucr", "2023-11-19 04:03:44", "115.79.26.123");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2326", "0", "admin", "2023-11-19 05:50:28", "67.205.12.146");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2327", "0", "admin", "2023-11-19 17:54:47", "154.117.146.133");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2328", "1", "ucr", "2023-11-19 23:15:56", "117.240.234.36");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2329", "0", "admin", "2023-11-20 11:31:38", "27.109.21.54");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2330", "1", "ucr", "2023-11-21 00:13:42", "138.99.68.59");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2331", "0", "admin", "2023-11-21 09:14:22", "125.166.8.247");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2332", "1", "ucr", "2023-11-21 09:28:37", "14.227.112.234");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2333", "1", "ucr", "2023-11-21 09:28:37", "14.227.112.234");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2334", "0", "plesk_administrator", "2023-11-21 10:54:39", "107.189.6.122");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2335", "0", "admin", "2023-11-21 21:14:00", "83.42.244.134");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2336", "0", "admin", "2023-11-21 21:14:00", "83.42.244.134");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2337", "1", "ucr", "2023-11-22 05:58:20", "117.213.255.34");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2338", "1", "ucr", "2023-11-22 05:58:20", "117.213.255.34");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2339", "0", "admin", "2023-11-22 07:22:15", "142.93.148.170");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2340", "0", "admin", "2023-11-22 07:53:16", "157.230.191.135");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2341", "0", "admin", "2023-11-22 07:53:16", "157.230.191.135");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2342", "0", "admin", "2023-11-22 08:14:40", "67.225.161.14");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2343", "0", "admin", "2023-11-22 14:36:08", "177.222.33.99");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2344", "0", "admin", "2023-11-22 14:36:08", "177.222.33.99");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2345", "0", "admin", "2023-11-22 19:26:52", "170.79.85.35");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2346", "1", "ucr", "2023-11-23 07:08:44", "14.171.88.204");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2347", "0", "plesk_administrator", "2023-11-23 07:08:52", "104.244.76.147");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2348", "1", "ucr", "2023-11-23 11:22:09", "117.216.140.118");
INSERT INTO `wp_aiowps_failed_logins` VALUES("2349", "1", "ucr", "2023-11-23 13:37:08", "35.91.18.161");

/* INSERT TABLE DATA: wp_aiowps_login_activity */
INSERT INTO `wp_aiowps_login_activity` VALUES("1", "1", "ucr", "2023-11-22 12:52:31", "2023-11-22 12:53:29", "46.187.233.246", "", "");
INSERT INTO `wp_aiowps_login_activity` VALUES("2", "1", "ucr", "2023-11-23 15:12:17", "1000-10-10 10:00:00", "46.205.132.252", "", "");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("2", "48", "Mr WordPress", "", "https://wordpress.org/", "", "2015-04-08 06:56:18", "2015-04-08 06:56:18", "Hi, this is a comment.\nTo delete a comment, just log in and view the post&#039;s comments. There you will have the option to edit or delete them.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("3", "36", "fue", "", "https://www.fue.edu.eg/admissions/undergraduate_applicants/admissions_steps", "82.118.29.103", "2023-05-08 08:08:32", "2023-05-08 06:08:32", "<strong>fue</strong>\n\n[...]Every as soon as in a though we select blogs that we read. Listed below would be the newest internet sites that we decide on [...]", "0", "0", "Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; WOW64; Trident/5.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; Media Center PC 6.0; Zune 4.0; InfoPath.3; MS-RTC LM 8; .NET4.0C; .NET4.0E)", "trackback", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "20190919_windapoznan", "d63e74598d9173f92777_20190919095740", "100", "2019-09-19 09:58:00", "unknown", "O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2019-09-19 09:57:40\";s:7:\"Version\";s:6:\"1.3.22\";s:9:\"VersionWP\";s:6:\"4.8.10\";s:9:\"VersionDB\";s:7:\"10.0.38\";s:10:\"VersionPHP\";s:6:\"5.6.40\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:20:\"20190919_windapoznan\";s:4:\"Hash\";s:35:\"d63e74598d9173f92777_20190919095740\";s:8:\"NameHash\";s:56:\"20190919_windapoznan_d63e74598d9173f92777_20190919095740\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:45:\"/home/windad/public_html/www/wp-snapshots/tmp\";s:8:\"StoreURL\";s:40:\"http://www.winda.poznan.pl/wp-snapshots/\";s:8:\"ScanFile\";s:66:\"20190919_windapoznan_d63e74598d9173f92777_20190919095740_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:11:\"771.78 sec.\";s:7:\"ExeSize\";s:7:\"60.53KB\";s:7:\"ZipSize\";s:7:\"86.15MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":23:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:68:\"20190919_windapoznan_d63e74598d9173f92777_20190919095740_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:28:\"/home/windad/public_html/www\";s:4:\"Size\";i:90339979;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":5:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":6:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:7153;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:37:\"/home/windad/public_html/www/wp-admin\";i:1;s:47:\"/home/windad/public_html/www/wp-content/uploads\";i:2;s:49:\"/home/windad/public_html/www/wp-content/languages\";i:3;s:46:\"/home/windad/public_html/www/wp-content/themes\";i:4;s:40:\"/home/windad/public_html/www/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:28:\"/home/windad/public_html/www\";i:1;s:39:\"/home/windad/public_html/www/wp-content\";}s:19:\"isOuterWPContentDir\";b:0;s:25:\"wpContentDirNormalizePath\";s:40:\"/home/windad/public_html/www/wp-content/\";}s:9:\"Installer\";O:13:\"DUP_Installer\":11:{s:4:\"File\";s:70:\"20190919_windapoznan_d63e74598d9173f92777_20190919095740_installer.php\";s:4:\"Size\";i:61982;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:1267603;s:4:\"File\";s:69:\"20190919_windapoznan_d63e74598d9173f92777_20190919095740_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":15:{s:9:\"buildMode\";s:9:\"MYSQLDUMP\";s:13:\"collationList\";a:3:{i:0;s:22:\"utf8mb4_unicode_520_ci\";i:1;s:17:\"latin1_swedish_ci\";i:2;s:15:\"utf8_general_ci\";}s:17:\"isTablesUpperCase\";i:0;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:13:\"windad_strona\";s:15:\"tablesBaseCount\";i:20;s:16:\"tablesFinalCount\";i:20;s:14:\"tablesRowCount\";s:5:\"1,211\";s:16:\"tablesSizeOnDisk\";s:6:\"2.94MB\";s:18:\"varLowerCaseTables\";s:1:\"0\";s:7:\"version\";s:7:\"10.0.38\";s:14:\"versionComment\";s:14:\"MariaDB Server\";s:18:\"tableWiseRowCounts\";a:20:{s:14:\"wp_commentmeta\";s:1:\"0\";s:11:\"wp_comments\";s:1:\"1\";s:22:\"wp_duplicator_packages\";s:1:\"1\";s:14:\"wp_layerslider\";s:1:\"0\";s:8:\"wp_links\";s:1:\"0\";s:10:\"wp_options\";s:3:\"219\";s:11:\"wp_postmeta\";s:3:\"585\";s:8:\"wp_posts\";s:3:\"289\";s:16:\"wp_revslider_css\";s:2:\"51\";s:29:\"wp_revslider_layer_animations\";s:1:\"0\";s:21:\"wp_revslider_settings\";s:1:\"1\";s:20:\"wp_revslider_sliders\";s:1:\"1\";s:19:\"wp_revslider_slides\";s:1:\"2\";s:26:\"wp_revslider_static_slides\";s:1:\"0\";s:21:\"wp_term_relationships\";s:1:\"9\";s:16:\"wp_term_taxonomy\";s:1:\"4\";s:11:\"wp_termmeta\";s:1:\"0\";s:8:\"wp_terms\";s:1:\"4\";s:11:\"wp_usermeta\";s:2:\"24\";s:8:\"wp_users\";s:1:\"1\";}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:115:\"/home/windad/public_html/www/wp-snapshots/tmp/20190919_windapoznan_d63e74598d9173f92777_20190919095740_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2019-09-19 09:57:40\";s:7:\"Version\";s:6:\"1.3.22\";s:9:\"VersionWP\";s:6:\"4.8.10\";s:9:\"VersionDB\";s:7:\"10.0.38\";s:10:\"VersionPHP\";s:6:\"5.6.40\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:20:\"20190919_windapoznan\";s:4:\"Hash\";s:35:\"d63e74598d9173f92777_20190919095740\";s:8:\"NameHash\";s:56:\"20190919_windapoznan_d63e74598d9173f92777_20190919095740\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:45:\"/home/windad/public_html/www/wp-snapshots/tmp\";s:8:\"StoreURL\";s:40:\"http://www.winda.poznan.pl/wp-snapshots/\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:23;s:9:\"Installer\";r:76;s:8:\"Database\";r:88;s:13:\"BuildProgress\";r:142;}}}");
INSERT INTO `wp_duplicator_packages` VALUES("2", "20190919_windapoznan", "43c3afcf2015e0774742_20231123141255", "22", "2023-11-23 14:13:15", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-11-23 14:12:55\";s:7:\"Version\";s:5:\"1.4.3\";s:9:\"VersionWP\";s:5:\"6.4.1\";s:9:\"VersionDB\";s:6:\"8.0.33\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:2;s:4:\"Name\";s:20:\"20190919_windapoznan\";s:4:\"Hash\";s:35:\"43c3afcf2015e0774742_20231123141255\";s:8:\"NameHash\";s:56:\"20190919_windapoznan_43c3afcf2015e0774742_20231123141255\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:66:\"20190919_windapoznan_43c3afcf2015e0774742_20231123141255_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.7\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":21:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:68:\"20190919_windapoznan_43c3afcf2015e0774742_20231123141255_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:28:\"/home/windad/public_html/www\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-11-23 14:12:55\";s:7:\"Version\";s:5:\"1.4.3\";s:9:\"VersionWP\";s:5:\"6.4.1\";s:9:\"VersionDB\";s:6:\"8.0.33\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:20:\"20190919_windapoznan\";s:4:\"Hash\";s:35:\"43c3afcf2015e0774742_20231123141255\";s:8:\"NameHash\";s:56:\"20190919_windapoznan_43c3afcf2015e0774742_20231123141255\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";s:70:\"20190919_windapoznan_43c3afcf2015e0774742_20231123141255_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:63;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:69:\"20190919_windapoznan_43c3afcf2015e0774742_20231123141255_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":16:{s:9:\"buildMode\";N;s:13:\"collationList\";a:0:{}s:17:\"isTablesUpperCase\";N;s:15:\"isNameUpperCase\";N;s:4:\"name\";N;s:15:\"tablesBaseCount\";N;s:16:\"tablesFinalCount\";N;s:14:\"tablesRowCount\";N;s:16:\"tablesSizeOnDisk\";N;s:18:\"varLowerCaseTables\";i:0;s:7:\"version\";N;s:14:\"versionComment\";N;s:18:\"tableWiseRowCounts\";a:7:{s:16:\"wp_aiowps_events\";s:1:\"0\";s:23:\"wp_aiowps_failed_logins\";s:4:\"2349\";s:21:\"wp_aiowps_global_meta\";s:1:\"0\";s:24:\"wp_aiowps_login_activity\";s:1:\"2\";s:24:\"wp_aiowps_login_lockdown\";s:1:\"0\";s:25:\"wp_aiowps_permanent_block\";s:1:\"0\";s:14:\"wp_commentmeta\";s:1:\"0\";}s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:115:\"/home/windad/public_html/www/wp-snapshots/tmp/20190919_windapoznan_43c3afcf2015e0774742_20231123141255_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:63;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:37:\"/home/windad/public_html/www/wp-admin\";i:1;s:47:\"/home/windad/public_html/www/wp-content/uploads\";i:2;s:49:\"/home/windad/public_html/www/wp-content/languages\";i:3;s:46:\"/home/windad/public_html/www/wp-content/themes\";i:4;s:40:\"/home/windad/public_html/www/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:28:\"/home/windad/public_html/www\";i:1;s:39:\"/home/windad/public_html/www/wp-content\";}}s:9:\"Installer\";r:84;s:8:\"Database\";r:98;s:13:\"BuildProgress\";r:137;}");

/* INSERT TABLE DATA: wp_layerslider */
INSERT INTO `wp_layerslider` VALUES("1", "1", "home", "", "{\"properties\":{\"post_taxonomy\":\"0\",\"post_orderby\":\"date\",\"post_order\":\"DESC\",\"post_offset\":\"-1\",\"title\":\"home\",\"slug\":\"\",\"width\":\"600\",\"height\":\"300\",\"responsive\":\"on\",\"maxwidth\":\"\",\"responsiveunder\":\"0\",\"sublayercontainer\":\"0\",\"hideunder\":\"0\",\"hideover\":\"100000\",\"autostart\":\"on\",\"startinviewport\":\"on\",\"pauseonhover\":\"on\",\"firstlayer\":\"1\",\"animatefirstlayer\":\"on\",\"keybnav\":\"on\",\"touchnav\":\"on\",\"loops\":\"0\",\"forceloopnum\":\"on\",\"skin\":\"v5\",\"backgroundcolor\":\"\",\"backgroundimageId\":\"\",\"backgroundimage\":\"\",\"sliderfadeinduration\":\"350\",\"sliderstyle\":\"margin-bottom: 0px;\",\"navprevnext\":\"on\",\"navstartstop\":\"on\",\"navbuttons\":\"on\",\"hoverprevnext\":\"on\",\"circletimer\":\"on\",\"thumb_nav\":\"hover\",\"thumb_container_width\":\"60%\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"autoplayvideos\":\"on\",\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"imgpreload\":\"on\",\"lazyload\":\"on\",\"yourlogoId\":\"\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: -10px; top: -10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"cbinit\":\"function(element) {\\r\\n\\r\\n}\",\"cbstart\":\"function(data) {\\r\\n\\r\\n}\",\"cbstop\":\"function(data) {\\r\\n\\r\\n}\",\"cbpause\":\"function(data) {\\r\\n\\r\\n}\",\"cbanimstart\":\"function(data) {\\r\\n\\r\\n}\",\"cbanimstop\":\"function(data) {\\r\\n\\r\\n}\",\"cbprev\":\"function(data) {\\r\\n\\r\\n}\",\"cbnext\":\"function(data) {\\r\\n\\r\\n}\"},\"layers\":[{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":\"244\",\"background\":\"http:\\/\\/www.winda.poznan.pl\\/wp-content\\/uploads\\/2015\\/04\\/13WINDA-MA\\u0141E.jpg\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"timeshift\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"}},{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":\"232\",\"background\":\"http:\\/\\/www.winda.poznan.pl\\/wp-content\\/uploads\\/2015\\/04\\/1WINDA-MA\\u0141E.jpg\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"timeshift\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Layer #1\",\"media\":\"img\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\"offsetxin\\\":\\\"80\\\",\\\"offsetyin\\\":\\\"0\\\",\\\"durationin\\\":\\\"1000\\\",\\\"delayin\\\":\\\"0\\\",\\\"easingin\\\":\\\"easeInOutQuint\\\",\\\"fadein\\\":true,\\\"rotatein\\\":\\\"0\\\",\\\"rotatexin\\\":\\\"0\\\",\\\"rotateyin\\\":\\\"0\\\",\\\"transformoriginin\\\":\\\"50% 50% 0\\\",\\\"skewxin\\\":\\\"0\\\",\\\"skewyin\\\":\\\"0\\\",\\\"scalexin\\\":\\\"1\\\",\\\"scaleyin\\\":\\\"1\\\",\\\"offsetxout\\\":\\\"-80\\\",\\\"offsetyout\\\":\\\"0\\\",\\\"durationout\\\":\\\"400\\\",\\\"showuntil\\\":\\\"0\\\",\\\"easingout\\\":\\\"easeInOutQuint\\\",\\\"fadeout\\\":true,\\\"rotateout\\\":\\\"0\\\",\\\"rotatexout\\\":\\\"0\\\",\\\"rotateyout\\\":\\\"0\\\",\\\"transformoriginout\\\":\\\"50% 50% 0\\\",\\\"skewxout\\\":\\\"0\\\",\\\"skewyout\\\":\\\"0\\\",\\\"scalexout\\\":\\\"1\\\",\\\"scaleyout\\\":\\\"1\\\",\\\"parallaxlevel\\\":\\\"0\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"0px\",\"left\":\"0px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]}]}", "1630334760", "1630334971", "0", "1");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "https://www.winda.poznan.pl", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "https://www.winda.poznan.pl", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "Winda Poznań", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "info@ucr.com.pl", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "closed", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "closed", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "4", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "j F Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "H:i", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "j F Y H:i", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "1", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("29", "rewrite_rules", "a:255:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:40:\"vc_grid_item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"vc_grid_item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"vc_grid_item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"vc_grid_item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"vc_grid_item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"vc_grid_item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"vc_grid_item/([^/]+)/embed/?$\";s:45:\"index.php?vc_grid_item=$matches[1]&embed=true\";s:33:\"vc_grid_item/([^/]+)/trackback/?$\";s:39:\"index.php?vc_grid_item=$matches[1]&tb=1\";s:41:\"vc_grid_item/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&paged=$matches[2]\";s:48:\"vc_grid_item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&cpage=$matches[2]\";s:37:\"vc_grid_item/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?vc_grid_item=$matches[1]&page=$matches[2]\";s:29:\"vc_grid_item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"vc_grid_item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"vc_grid_item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"vc_grid_item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"vc_grid_item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"vc_grid_item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:39:\"client-item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"client-item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"client-item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"client-item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"client-item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"client-item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"client-item/([^/]+)/embed/?$\";s:39:\"index.php?client=$matches[1]&embed=true\";s:32:\"client-item/([^/]+)/trackback/?$\";s:33:\"index.php?client=$matches[1]&tb=1\";s:40:\"client-item/([^/]+)/page/?([0-9]{1,})/?$\";s:46:\"index.php?client=$matches[1]&paged=$matches[2]\";s:47:\"client-item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:46:\"index.php?client=$matches[1]&cpage=$matches[2]\";s:36:\"client-item/([^/]+)(?:/([0-9]+))?/?$\";s:45:\"index.php?client=$matches[1]&page=$matches[2]\";s:28:\"client-item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"client-item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"client-item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"client-item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"client-item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"client-item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"client-types/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?client-types=$matches[1]&feed=$matches[2]\";s:48:\"client-types/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?client-types=$matches[1]&feed=$matches[2]\";s:29:\"client-types/([^/]+)/embed/?$\";s:45:\"index.php?client-types=$matches[1]&embed=true\";s:41:\"client-types/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?client-types=$matches[1]&paged=$matches[2]\";s:23:\"client-types/([^/]+)/?$\";s:34:\"index.php?client-types=$matches[1]\";s:38:\"offer-item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"offer-item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"offer-item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"offer-item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"offer-item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"offer-item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"offer-item/([^/]+)/embed/?$\";s:38:\"index.php?offer=$matches[1]&embed=true\";s:31:\"offer-item/([^/]+)/trackback/?$\";s:32:\"index.php?offer=$matches[1]&tb=1\";s:39:\"offer-item/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?offer=$matches[1]&paged=$matches[2]\";s:46:\"offer-item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?offer=$matches[1]&cpage=$matches[2]\";s:35:\"offer-item/([^/]+)(?:/([0-9]+))?/?$\";s:44:\"index.php?offer=$matches[1]&page=$matches[2]\";s:27:\"offer-item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"offer-item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"offer-item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"offer-item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"offer-item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"offer-item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:52:\"offer-types/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?offer-types=$matches[1]&feed=$matches[2]\";s:47:\"offer-types/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?offer-types=$matches[1]&feed=$matches[2]\";s:28:\"offer-types/([^/]+)/embed/?$\";s:44:\"index.php?offer-types=$matches[1]&embed=true\";s:40:\"offer-types/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?offer-types=$matches[1]&paged=$matches[2]\";s:22:\"offer-types/([^/]+)/?$\";s:33:\"index.php?offer-types=$matches[1]\";s:42:\"portfolio-item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"portfolio-item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"portfolio-item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"portfolio-item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"portfolio-item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"portfolio-item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"portfolio-item/([^/]+)/embed/?$\";s:42:\"index.php?portfolio=$matches[1]&embed=true\";s:35:\"portfolio-item/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:43:\"portfolio-item/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:50:\"portfolio-item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:39:\"portfolio-item/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:31:\"portfolio-item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"portfolio-item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"portfolio-item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"portfolio-item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"portfolio-item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"portfolio-item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:56:\"portfolio-types/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?portfolio-types=$matches[1]&feed=$matches[2]\";s:51:\"portfolio-types/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?portfolio-types=$matches[1]&feed=$matches[2]\";s:32:\"portfolio-types/([^/]+)/embed/?$\";s:48:\"index.php?portfolio-types=$matches[1]&embed=true\";s:44:\"portfolio-types/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?portfolio-types=$matches[1]&paged=$matches[2]\";s:26:\"portfolio-types/([^/]+)/?$\";s:37:\"index.php?portfolio-types=$matches[1]\";s:38:\"slide-item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"slide-item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"slide-item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"slide-item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"slide-item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"slide-item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"slide-item/([^/]+)/embed/?$\";s:38:\"index.php?slide=$matches[1]&embed=true\";s:31:\"slide-item/([^/]+)/trackback/?$\";s:32:\"index.php?slide=$matches[1]&tb=1\";s:39:\"slide-item/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?slide=$matches[1]&paged=$matches[2]\";s:46:\"slide-item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?slide=$matches[1]&cpage=$matches[2]\";s:35:\"slide-item/([^/]+)(?:/([0-9]+))?/?$\";s:44:\"index.php?slide=$matches[1]&page=$matches[2]\";s:27:\"slide-item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"slide-item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"slide-item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"slide-item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"slide-item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"slide-item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:52:\"slide-types/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?slide-types=$matches[1]&feed=$matches[2]\";s:47:\"slide-types/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?slide-types=$matches[1]&feed=$matches[2]\";s:28:\"slide-types/([^/]+)/embed/?$\";s:44:\"index.php?slide-types=$matches[1]&embed=true\";s:40:\"slide-types/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?slide-types=$matches[1]&paged=$matches[2]\";s:22:\"slide-types/([^/]+)/?$\";s:33:\"index.php?slide-types=$matches[1]\";s:44:\"testimonial-item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"testimonial-item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"testimonial-item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"testimonial-item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"testimonial-item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"testimonial-item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"testimonial-item/([^/]+)/embed/?$\";s:44:\"index.php?testimonial=$matches[1]&embed=true\";s:37:\"testimonial-item/([^/]+)/trackback/?$\";s:38:\"index.php?testimonial=$matches[1]&tb=1\";s:45:\"testimonial-item/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?testimonial=$matches[1]&paged=$matches[2]\";s:52:\"testimonial-item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?testimonial=$matches[1]&cpage=$matches[2]\";s:41:\"testimonial-item/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?testimonial=$matches[1]&page=$matches[2]\";s:33:\"testimonial-item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"testimonial-item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"testimonial-item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"testimonial-item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"testimonial-item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"testimonial-item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:58:\"testimonial-types/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?testimonial-types=$matches[1]&feed=$matches[2]\";s:53:\"testimonial-types/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?testimonial-types=$matches[1]&feed=$matches[2]\";s:34:\"testimonial-types/([^/]+)/embed/?$\";s:50:\"index.php?testimonial-types=$matches[1]&embed=true\";s:46:\"testimonial-types/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?testimonial-types=$matches[1]&paged=$matches[2]\";s:28:\"testimonial-types/([^/]+)/?$\";s:39:\"index.php?testimonial-types=$matches[1]\";s:39:\"layout-item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"layout-item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"layout-item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"layout-item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"layout-item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"layout-item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"layout-item/([^/]+)/embed/?$\";s:39:\"index.php?layout=$matches[1]&embed=true\";s:32:\"layout-item/([^/]+)/trackback/?$\";s:33:\"index.php?layout=$matches[1]&tb=1\";s:40:\"layout-item/([^/]+)/page/?([0-9]{1,})/?$\";s:46:\"index.php?layout=$matches[1]&paged=$matches[2]\";s:47:\"layout-item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:46:\"index.php?layout=$matches[1]&cpage=$matches[2]\";s:36:\"layout-item/([^/]+)(?:/([0-9]+))?/?$\";s:45:\"index.php?layout=$matches[1]&page=$matches[2]\";s:28:\"layout-item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"layout-item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"layout-item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"layout-item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"layout-item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"layout-item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:41:\"template-item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"template-item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"template-item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"template-item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"template-item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"template-item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:30:\"template-item/([^/]+)/embed/?$\";s:41:\"index.php?template=$matches[1]&embed=true\";s:34:\"template-item/([^/]+)/trackback/?$\";s:35:\"index.php?template=$matches[1]&tb=1\";s:42:\"template-item/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?template=$matches[1]&paged=$matches[2]\";s:49:\"template-item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?template=$matches[1]&cpage=$matches[2]\";s:38:\"template-item/([^/]+)(?:/([0-9]+))?/?$\";s:47:\"index.php?template=$matches[1]&page=$matches[2]\";s:30:\"template-item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:40:\"template-item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:60:\"template-item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"template-item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"template-item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:36:\"template-item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=49&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:10:{i:0;s:27:\"LayerSlider/layerslider.php\";i:1;s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";i:2;s:36:\"contact-form-7/wp-contact-form-7.php\";i:3;s:31:\"cookie-notice/cookie-notice.php\";i:4;s:33:\"duplicate-post/duplicate-post.php\";i:5;s:25:\"duplicator/duplicator.php\";i:7;s:27:\"js_composer/js_composer.php\";i:8;s:38:\"recent-tweets-widget/recent-tweets.php\";i:9;s:23:\"revslider/revslider.php\";i:10;s:23:\"wordfence/wordfence.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "a:5:{i:0;s:63:\"/home/windad/public_html/www/wp-content/themes/betheme/page.php\";i:1;s:64:\"/home/windad/public_html/www/wp-content/themes/betheme/index.php\";i:2;s:64:\"/home/windad/public_html/www/wp-content/themes/betheme/style.css\";i:3;s:74:\"/home/windad/public_html/www/wp-content/themes/betheme-child/functions.php\";i:4;s:70:\"/home/windad/public_html/www/wp-content/themes/betheme-child/style.css\";}", "no");
INSERT INTO `wp_options` VALUES("40", "template", "betheme", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "betheme-child", "yes");
INSERT INTO `wp_options` VALUES("44", "comment_registration", "1", "yes");
INSERT INTO `wp_options` VALUES("45", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("46", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("48", "db_version", "56657", "yes");
INSERT INTO `wp_options` VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("51", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("52", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("53", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("54", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("55", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("57", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("67", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("68", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("69", "close_comments_for_old_posts", "1", "yes");
INSERT INTO `wp_options` VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("71", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("73", "page_comments", "", "yes");
INSERT INTO `wp_options` VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("76", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "widget_text", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("80", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("81", "uninstall_plugins", "a:1:{s:27:\"LayerSlider/layerslider.php\";s:29:\"layerslider_uninstall_scripts\";}", "no");
INSERT INTO `wp_options` VALUES("82", "timezone_string", "Europe/Warsaw", "yes");
INSERT INTO `wp_options` VALUES("83", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "page_on_front", "49", "yes");
INSERT INTO `wp_options` VALUES("85", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("88", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("91", "initial_db_version", "38590", "yes");
INSERT INTO `wp_options` VALUES("92", "wp_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:65:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:10:\"copy_posts\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:35:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"copy_posts\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("93", "fresh_site", "0", "yes");
INSERT INTO `wp_options` VALUES("94", "WPLANG", "pl_PL", "yes");
INSERT INTO `wp_options` VALUES("95", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("96", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("97", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("98", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("99", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("100", "sidebars_widgets", "a:15:{s:19:\"wp_inactive_widgets\";a:0:{}s:13:\"footer-area-1\";a:0:{}s:13:\"footer-area-2\";a:0:{}s:13:\"footer-area-3\";a:0:{}s:13:\"footer-area-4\";a:0:{}s:10:\"top-area-1\";a:0:{}s:10:\"top-area-2\";a:0:{}s:10:\"top-area-3\";a:0:{}s:10:\"top-area-4\";a:0:{}s:5:\"forum\";a:0:{}s:5:\"buddy\";a:0:{}s:6:\"events\";a:0:{}s:4:\"shop\";a:0:{}s:22:\"blog-cat-uncategorized\";a:0:{}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("101", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("102", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("103", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("104", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("105", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("106", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("107", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("108", "cron", "a:20:{i:1700750128;a:1:{s:24:\"aiowps_hourly_cron_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1700751139;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1700751910;a:1:{s:21:\"wordfence_ls_ntp_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1700751916;a:1:{s:21:\"wordfence_hourly_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1700755545;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1700762941;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1700789016;a:2:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1700814928;a:1:{s:23:\"aiowps_daily_cron_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1700816716;a:1:{s:20:\"wordfence_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1700823137;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1700823221;a:1:{s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1700832220;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1700853600;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"339ea05740526288f88c4cb7f973b303\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1700853600;}}}}i:1700887375;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1701097200;a:1:{s:31:\"wordfence_email_activity_report\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1701112800;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"b4d45d1440ff0f2583ba0d5a7f3f97b8\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1701112800;}}}}i:1701172753;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1701221682;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1701372000;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"0cda9bd63b7e9e8e86d51d4b6cdd692c\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1701372000;}}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("109", "theme_mods_twentyseventeen", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1506950784;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}}}}", "yes");
INSERT INTO `wp_options` VALUES("132", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("137", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:15:\"info@ucr.com.pl\";s:7:\"version\";s:5:\"6.4.1\";s:9:\"timestamp\";i:1699520856;}", "no");
INSERT INTO `wp_options` VALUES("141", "recently_activated", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("158", "current_theme", "Betheme Child", "yes");
INSERT INTO `wp_options` VALUES("159", "theme_mods_betheme-child", "a:3:{i:0;b:0;s:18:\"custom_css_post_id\";i:316;s:18:\"nav_menu_locations\";a:5:{s:9:\"main-menu\";i:2;s:14:\"secondary-menu\";i:0;s:9:\"lang-menu\";i:0;s:11:\"social-menu\";i:0;s:18:\"social-menu-bottom\";i:0;}}", "yes");
INSERT INTO `wp_options` VALUES("160", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("161", "betheme", "a:305:{s:8:\"last_tab\";s:4:\"logo\";s:5:\"style\";s:0:\"\";s:6:\"layout\";s:10:\"full-width\";s:10:\"grid-width\";s:0:\"\";s:7:\"grid960\";s:1:\"0\";s:11:\"favicon-img\";s:62:\"http://www.winda.poznan.pl/wp-content/uploads/2017/10/logo.jpg\";s:11:\"img-page-bg\";s:0:\"\";s:16:\"position-page-bg\";s:22:\"no-repeat;center top;;\";s:22:\"content-remove-padding\";s:1:\"0\";s:17:\"image-frame-style\";s:7:\"overlay\";s:8:\"logo-img\";s:63:\"https://www.winda.poznan.pl/wp-content/uploads/2017/10/logo.jpg\";s:15:\"retina-logo-img\";s:0:\"\";s:15:\"sticky-logo-img\";s:0:\"\";s:22:\"sticky-retina-logo-img\";s:0:\"\";s:9:\"logo-text\";s:0:\"\";s:10:\"logo-width\";s:0:\"\";s:9:\"logo-link\";a:1:{s:4:\"link\";s:4:\"link\";}s:19:\"slider-blog-timeout\";s:1:\"0\";s:22:\"slider-clients-timeout\";s:1:\"0\";s:20:\"slider-offer-timeout\";s:1:\"0\";s:24:\"slider-portfolio-timeout\";s:1:\"0\";s:19:\"slider-shop-timeout\";s:1:\"0\";s:21:\"slider-slider-timeout\";s:1:\"0\";s:27:\"slider-testimonials-timeout\";s:1:\"0\";s:18:\"builder-visibility\";s:0:\"\";s:13:\"display-order\";s:1:\"1\";s:23:\"math-animations-disable\";s:1:\"0\";s:19:\"table-hover-disable\";s:1:\"0\";s:10:\"static-css\";s:1:\"0\";s:12:\"table_prefix\";s:11:\"base_prefix\";s:8:\"hook-top\";s:0:\"\";s:19:\"hook-content-before\";s:0:\"\";s:18:\"hook-content-after\";s:0:\"\";s:11:\"hook-bottom\";s:0:\"\";s:12:\"header-style\";s:7:\"classic\";s:16:\"img-subheader-bg\";s:0:\"\";s:24:\"img-subheader-attachment\";s:0:\"\";s:17:\"minimalist-header\";s:1:\"1\";s:13:\"sticky-header\";s:1:\"1\";s:19:\"sticky-header-style\";s:5:\"white\";s:21:\"subheader-transparent\";s:1:\"0\";s:15:\"subheader-image\";s:0:\"\";s:21:\"subheader-slider-show\";s:1:\"0\";s:15:\"subheader-style\";s:11:\"both-center\";s:19:\"header-action-title\";s:0:\"\";s:18:\"header-action-link\";s:0:\"\";s:13:\"header-banner\";s:0:\"\";s:13:\"header-search\";s:1:\"1\";s:11:\"sliding-top\";s:1:\"0\";s:16:\"sliding-top-icon\";s:19:\"icon-down-open-mini\";s:11:\"header-wpml\";s:0:\"\";s:10:\"menu-style\";s:0:\"\";s:10:\"action-bar\";s:1:\"1\";s:13:\"header-slogan\";s:23:\"Masz pytania? Zadzwoń!\";s:12:\"header-phone\";s:26:\"61 879-63-10 , 501 437 310\";s:14:\"header-phone-2\";s:0:\"\";s:12:\"header-email\";s:18:\"winda.poznan@op.pl\";s:13:\"sidebar-width\";s:2:\"23\";s:13:\"sidebar-lines\";s:0:\"\";s:18:\"single-page-layout\";s:0:\"\";s:19:\"single-page-sidebar\";s:0:\"\";s:20:\"single-page-sidebar2\";s:0:\"\";s:13:\"single-layout\";s:0:\"\";s:14:\"single-sidebar\";s:0:\"\";s:15:\"single-sidebar2\";s:0:\"\";s:23:\"single-portfolio-layout\";s:0:\"\";s:24:\"single-portfolio-sidebar\";s:0:\"\";s:25:\"single-portfolio-sidebar2\";s:0:\"\";s:19:\"pagination-show-all\";s:1:\"1\";s:4:\"love\";s:1:\"0\";s:13:\"prev-next-nav\";s:1:\"1\";s:5:\"share\";s:1:\"1\";s:13:\"title-heading\";s:1:\"1\";s:10:\"blog-posts\";s:1:\"4\";s:11:\"blog-layout\";s:7:\"classic\";s:12:\"blog-columns\";s:0:\"\";s:15:\"blog-full-width\";s:1:\"0\";s:14:\"excerpt-length\";s:2:\"26\";s:10:\"blog-title\";s:1:\"1\";s:9:\"blog-meta\";s:1:\"1\";s:14:\"blog-load-more\";s:1:\"0\";s:9:\"blog-page\";s:0:\"\";s:11:\"blog-author\";s:1:\"1\";s:12:\"blog-related\";s:1:\"1\";s:13:\"blog-comments\";s:1:\"1\";s:16:\"blog-single-zoom\";s:1:\"1\";s:18:\"blog-single-layout\";s:0:\"\";s:15:\"portfolio-posts\";s:1:\"8\";s:16:\"portfolio-layout\";s:4:\"grid\";s:17:\"portfolio-columns\";s:0:\"\";s:20:\"portfolio-full-width\";s:1:\"0\";s:17:\"portfolio-orderby\";s:4:\"date\";s:15:\"portfolio-order\";s:4:\"DESC\";s:21:\"portfolio-hover-title\";s:1:\"0\";s:18:\"portfolio-external\";s:0:\"\";s:17:\"portfolio-isotope\";s:1:\"1\";s:19:\"portfolio-load-more\";s:1:\"0\";s:14:\"portfolio-page\";s:0:\"\";s:17:\"portfolio-related\";s:1:\"1\";s:18:\"portfolio-comments\";s:1:\"0\";s:14:\"portfolio-slug\";s:14:\"portfolio-item\";s:13:\"portfolio-tax\";s:15:\"portfolio-types\";s:14:\"shop-catalogue\";s:1:\"0\";s:11:\"shop-images\";s:0:\"\";s:11:\"shop-layout\";s:4:\"grid\";s:13:\"shop-products\";s:2:\"12\";s:12:\"shop-excerpt\";s:1:\"0\";s:11:\"shop-slider\";s:0:\"\";s:19:\"shop-product-images\";s:0:\"\";s:12:\"shop-related\";s:1:\"1\";s:18:\"shop-product-style\";s:0:\"\";s:9:\"shop-cart\";s:11:\"icon-basket\";s:13:\"page-comments\";s:1:\"0\";s:13:\"error404-icon\";s:17:\"icon-traffic-cone\";s:13:\"error404-page\";s:0:\"\";s:12:\"construction\";s:1:\"0\";s:18:\"construction-title\";s:11:\"Coming Soon\";s:17:\"construction-text\";s:0:\"\";s:17:\"construction-date\";s:19:\"12/30/2014 12:00:00\";s:19:\"construction-offset\";s:1:\"0\";s:20:\"construction-contact\";s:0:\"\";s:17:\"construction-page\";s:0:\"\";s:13:\"footer-layout\";s:0:\"\";s:12:\"footer-style\";s:0:\"\";s:13:\"footer-bg-img\";s:0:\"\";s:21:\"footer-call-to-action\";s:0:\"\";s:11:\"footer-copy\";s:100:\"© 2017 Winda Poznań - Wszelkie Prawa Zastrzeżone. Wdrożenie: <a href=\"http://ucr.com.pl\">UCR</a>\";s:11:\"footer-hide\";s:0:\"\";s:12:\"back-top-top\";s:0:\"\";s:18:\"popup-contact-form\";s:0:\"\";s:23:\"popup-contact-form-icon\";s:0:\"\";s:10:\"responsive\";s:1:\"1\";s:19:\"responsive-logo-img\";s:0:\"\";s:26:\"responsive-retina-logo-img\";s:0:\"\";s:20:\"font-size-responsive\";s:1:\"0\";s:8:\"no-hover\";s:0:\"\";s:25:\"header-menu-mobile-sticky\";s:1:\"0\";s:16:\"header-menu-text\";s:0:\"\";s:13:\"no-section-bg\";s:0:\"\";s:18:\"responsive-top-bar\";s:4:\"left\";s:16:\"google-analytics\";s:0:\"\";s:18:\"google-remarketing\";s:0:\"\";s:7:\"mfn-seo\";s:1:\"1\";s:16:\"meta-description\";s:27:\"Just another WordPress site\";s:13:\"meta-keywords\";s:0:\"\";s:13:\"social-target\";s:1:\"0\";s:12:\"social-skype\";s:0:\"\";s:15:\"social-facebook\";s:0:\"\";s:17:\"social-googleplus\";s:0:\"\";s:14:\"social-twitter\";s:0:\"\";s:12:\"social-vimeo\";s:0:\"\";s:14:\"social-youtube\";s:0:\"\";s:13:\"social-flickr\";s:0:\"\";s:15:\"social-linkedin\";s:0:\"\";s:16:\"social-pinterest\";s:0:\"\";s:15:\"social-dribbble\";s:0:\"\";s:16:\"social-instagram\";s:0:\"\";s:14:\"social-behance\";s:0:\"\";s:13:\"social-tumblr\";s:0:\"\";s:16:\"social-vkontakte\";s:0:\"\";s:13:\"social-viadeo\";s:0:\"\";s:11:\"social-xing\";s:0:\"\";s:10:\"social-rss\";s:1:\"0\";s:11:\"nice-scroll\";s:1:\"0\";s:17:\"nice-scroll-speed\";s:2:\"40\";s:18:\"sc-gallery-disable\";s:1:\"0\";s:11:\"prettyphoto\";s:10:\"pp_default\";s:17:\"prettyphoto-width\";s:0:\"\";s:18:\"prettyphoto-height\";s:0:\"\";s:17:\"retina-js-disable\";s:1:\"0\";s:10:\"plugin-rev\";s:0:\"\";s:12:\"plugin-layer\";s:0:\"\";s:13:\"plugin-visual\";s:0:\"\";s:4:\"skin\";s:5:\"green\";s:15:\"background-body\";s:7:\"#FCFCFC\";s:9:\"color-one\";s:7:\"#2991D6\";s:17:\"background-header\";s:7:\"#18171d\";s:19:\"background-top-left\";s:7:\"#ffffff\";s:21:\"background-top-middle\";s:7:\"#e3e3e3\";s:20:\"background-top-right\";s:7:\"#f5f5f5\";s:17:\"color-top-right-a\";s:7:\"#444444\";s:17:\"background-search\";s:7:\"#825339\";s:20:\"background-subheader\";s:7:\"#F7F7F7\";s:15:\"color-subheader\";s:7:\"#BBB3C9\";s:12:\"color-menu-a\";s:7:\"#444444\";s:19:\"color-menu-a-active\";s:7:\"#825339\";s:24:\"background-menu-a-active\";s:7:\"#825339\";s:18:\"background-submenu\";s:7:\"#F2F2F2\";s:15:\"color-submenu-a\";s:7:\"#5f5f5f\";s:21:\"color-submenu-a-hover\";s:7:\"#2e2e2e\";s:21:\"background-action-bar\";s:7:\"#2C2C2C\";s:23:\"background-overlay-menu\";s:7:\"#825339\";s:25:\"background-overlay-menu-a\";s:7:\"#ffffff\";s:17:\"border-menu-plain\";s:7:\"#F2F2F2\";s:11:\"color-theme\";s:7:\"#825339\";s:10:\"color-text\";s:7:\"#626262\";s:7:\"color-a\";s:7:\"#825339\";s:13:\"color-a-hover\";s:7:\"#653920\";s:16:\"color-fancy-link\";s:7:\"#656B6F\";s:21:\"background-fancy-link\";s:7:\"#825339\";s:22:\"color-fancy-link-hover\";s:7:\"#825339\";s:27:\"background-fancy-link-hover\";s:7:\"#653920\";s:10:\"color-note\";s:7:\"#a8a8a8\";s:10:\"color-list\";s:7:\"#737E86\";s:20:\"background-highlight\";s:7:\"#825339\";s:28:\"background-highlight-section\";s:7:\"#825339\";s:8:\"color-hr\";s:7:\"#825339\";s:12:\"button-style\";s:0:\"\";s:17:\"background-button\";s:7:\"#f7f7f7\";s:12:\"color-button\";s:7:\"#747474\";s:18:\"color-footer-theme\";s:7:\"#825339\";s:17:\"background-footer\";s:7:\"#2C2C2C\";s:12:\"color-footer\";s:7:\"#cccccc\";s:14:\"color-footer-a\";s:7:\"#825339\";s:20:\"color-footer-a-hover\";s:7:\"#653920\";s:20:\"color-footer-heading\";s:7:\"#ffffff\";s:17:\"color-footer-note\";s:7:\"#a8a8a8\";s:23:\"color-sliding-top-theme\";s:7:\"#825339\";s:22:\"background-sliding-top\";s:7:\"#545454\";s:17:\"color-sliding-top\";s:7:\"#cccccc\";s:19:\"color-sliding-top-a\";s:7:\"#825339\";s:25:\"color-sliding-top-a-hover\";s:7:\"#653920\";s:25:\"color-sliding-top-heading\";s:7:\"#ffffff\";s:22:\"color-sliding-top-note\";s:7:\"#a8a8a8\";s:8:\"color-h1\";s:7:\"#444444\";s:8:\"color-h2\";s:7:\"#444444\";s:8:\"color-h3\";s:7:\"#444444\";s:8:\"color-h4\";s:7:\"#444444\";s:8:\"color-h5\";s:7:\"#444444\";s:8:\"color-h6\";s:7:\"#444444\";s:15:\"color-tab-title\";s:7:\"#825339\";s:16:\"color-blockquote\";s:7:\"#444444\";s:17:\"color-contentlink\";s:7:\"#825339\";s:13:\"color-counter\";s:7:\"#825339\";s:21:\"background-getintouch\";s:7:\"#825339\";s:13:\"color-iconbar\";s:7:\"#825339\";s:13:\"color-iconbox\";s:7:\"#825339\";s:26:\"background-imageframe-link\";s:7:\"#825339\";s:21:\"color-imageframe-link\";s:7:\"#ffffff\";s:15:\"color-list-icon\";s:7:\"#825339\";s:19:\"color-pricing-price\";s:7:\"#825339\";s:27:\"background-pricing-featured\";s:7:\"#825339\";s:22:\"background-progressbar\";s:7:\"#825339\";s:22:\"color-quickfact-number\";s:7:\"#825339\";s:27:\"background-slidingbox-title\";s:7:\"#825339\";s:27:\"background-trailer-subtitle\";s:7:\"#825339\";s:12:\"font-content\";s:4:\"Lato\";s:9:\"font-menu\";s:6:\"Roboto\";s:10:\"font-title\";s:9:\"Patua One\";s:13:\"font-headings\";s:9:\"Patua One\";s:19:\"font-headings-small\";s:6:\"Roboto\";s:15:\"font-blockquote\";s:9:\"Patua One\";s:11:\"font-subset\";s:0:\"\";s:17:\"font-size-content\";s:2:\"16\";s:14:\"font-size-menu\";s:2:\"14\";s:12:\"font-size-h1\";s:2:\"46\";s:12:\"font-size-h2\";s:2:\"30\";s:12:\"font-size-h3\";s:2:\"25\";s:12:\"font-size-h4\";s:2:\"21\";s:12:\"font-size-h5\";s:2:\"15\";s:12:\"font-size-h6\";s:2:\"13\";s:11:\"font-custom\";s:0:\"\";s:16:\"font-custom-woff\";s:0:\"\";s:15:\"font-custom-ttf\";s:0:\"\";s:15:\"font-custom-svg\";s:0:\"\";s:15:\"font-custom-eot\";s:0:\"\";s:12:\"font-custom2\";s:0:\"\";s:17:\"font-custom2-woff\";s:0:\"\";s:16:\"font-custom2-ttf\";s:0:\"\";s:16:\"font-custom2-svg\";s:0:\"\";s:16:\"font-custom2-eot\";s:0:\"\";s:9:\"translate\";s:1:\"1\";s:28:\"translate-search-placeholder\";s:6:\"Szukaj\";s:24:\"translate-search-results\";s:22:\"wyniki znalezione dla:\";s:14:\"translate-home\";s:4:\"Home\";s:14:\"translate-prev\";s:17:\"Poprzednia strona\";s:14:\"translate-next\";s:16:\"Następna strona\";s:19:\"translate-load-more\";s:16:\"Załaduj więcej\";s:17:\"translate-wpml-no\";s:43:\"Brak dostępnych tłumaczeń dla tej strony\";s:14:\"translate-days\";s:3:\"dni\";s:15:\"translate-hours\";s:6:\"godzin\";s:17:\"translate-minutes\";s:5:\"minut\";s:17:\"translate-seconds\";s:6:\"sekund\";s:16:\"translate-filter\";s:9:\"Filter by\";s:14:\"translate-tags\";s:4:\"Tags\";s:17:\"translate-authors\";s:7:\"Authors\";s:13:\"translate-all\";s:8:\"Show all\";s:18:\"translate-item-all\";s:0:\"\";s:19:\"translate-published\";s:12:\"Published by\";s:12:\"translate-at\";s:2:\"at\";s:20:\"translate-categories\";s:10:\"Categories\";s:18:\"translate-readmore\";s:9:\"Read more\";s:14:\"translate-like\";s:15:\"Do you like it?\";s:17:\"translate-related\";s:13:\"Related posts\";s:16:\"translate-client\";s:6:\"Client\";s:14:\"translate-date\";s:4:\"Date\";s:17:\"translate-website\";s:7:\"Website\";s:14:\"translate-view\";s:12:\"View website\";s:14:\"translate-task\";s:4:\"Task\";s:19:\"translate-404-title\";s:18:\"Ooops... Error 404\";s:22:\"translate-404-subtitle\";s:62:\"We are sorry, but the page you are looking for does not exist.\";s:18:\"translate-404-text\";s:46:\"Please check entered address and try again or \";s:17:\"translate-404-btn\";s:14:\"go to homepage\";s:10:\"custom-css\";s:401:\"@media only screen and (max-width: 767px) {\r\nbody:not(.template-slider):not(.header-simple) #Header {\r\n    min-height: 260px;\r\n}\r\n}\r\nbody:not(.template-slider) #Header {\r\n    min-height: 185px;\r\n}\r\n#Subheader {\r\n    padding: 30px 0 90px;\r\n}\r\n\r\n/* Footer */\r\n#Footer .widgets_wrapper { padding: 40px 0; }\r\n#Footer {background-color: #2C2C2C;}\r\n.vc_general.vc_cta3 .vc_cta3-actions {white-space:normal;}\";s:9:\"custom-js\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("163", "wpcf7", "a:2:{s:7:\"version\";s:5:\"5.5.3\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";d:1506958026;s:7:\"version\";s:3:\"4.9\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}", "yes");
INSERT INTO `wp_options` VALUES("164", "revslider_checktables", "1", "yes");
INSERT INTO `wp_options` VALUES("165", "revslider-static-css", ".tp-caption a {\n-webkit-transition:all 0.2s ease-out;\n-moz-transition:all 0.2s ease-out;\n-o-transition:all 0.2s ease-out;\n-ms-transition:all 0.2s ease-out;\n}", "yes");
INSERT INTO `wp_options` VALUES("166", "revslider-update-check-short", "1700578213", "yes");
INSERT INTO `wp_options` VALUES("167", "ls-plugin-version", "5.4.0", "yes");
INSERT INTO `wp_options` VALUES("168", "ls-db-version", "5.0.0", "yes");
INSERT INTO `wp_options` VALUES("169", "ls-installed", "1", "yes");
INSERT INTO `wp_options` VALUES("170", "ls-google-fonts", "a:4:{i:0;a:2:{s:5:\"param\";s:28:\"Lato:100,300,regular,700,900\";s:5:\"admin\";b:0;}i:1;a:2:{s:5:\"param\";s:13:\"Open+Sans:300\";s:5:\"admin\";b:0;}i:2;a:2:{s:5:\"param\";s:20:\"Indie+Flower:regular\";s:5:\"admin\";b:0;}i:3;a:2:{s:5:\"param\";s:22:\"Oswald:300,regular,700\";s:5:\"admin\";b:0;}}", "yes");
INSERT INTO `wp_options` VALUES("171", "ls-date-installed", "1506950826", "yes");
INSERT INTO `wp_options` VALUES("173", "tp_twitter_global_notification", "0", "yes");
INSERT INTO `wp_options` VALUES("176", "widget_tp_widget_recent_tweets", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("177", "widget_layerslider_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("178", "widget_rev-slider-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("179", "vc_version", "6.0.5", "yes");
INSERT INTO `wp_options` VALUES("180", "duplicate_post_copytitle", "1", "yes");
INSERT INTO `wp_options` VALUES("181", "duplicate_post_copydate", "0", "yes");
INSERT INTO `wp_options` VALUES("182", "duplicate_post_copystatus", "0", "yes");
INSERT INTO `wp_options` VALUES("183", "duplicate_post_copyslug", "1", "yes");
INSERT INTO `wp_options` VALUES("184", "duplicate_post_copyexcerpt", "1", "yes");
INSERT INTO `wp_options` VALUES("185", "duplicate_post_copycontent", "1", "yes");
INSERT INTO `wp_options` VALUES("186", "duplicate_post_copythumbnail", "1", "yes");
INSERT INTO `wp_options` VALUES("187", "duplicate_post_copytemplate", "1", "yes");
INSERT INTO `wp_options` VALUES("188", "duplicate_post_copyformat", "1", "yes");
INSERT INTO `wp_options` VALUES("189", "duplicate_post_copyauthor", "0", "yes");
INSERT INTO `wp_options` VALUES("190", "duplicate_post_copypassword", "0", "yes");
INSERT INTO `wp_options` VALUES("191", "duplicate_post_copyattachments", "0", "yes");
INSERT INTO `wp_options` VALUES("192", "duplicate_post_copychildren", "0", "yes");
INSERT INTO `wp_options` VALUES("193", "duplicate_post_copycomments", "0", "yes");
INSERT INTO `wp_options` VALUES("194", "duplicate_post_copymenuorder", "1", "yes");
INSERT INTO `wp_options` VALUES("195", "duplicate_post_taxonomies_blacklist", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("196", "duplicate_post_blacklist", "", "yes");
INSERT INTO `wp_options` VALUES("197", "duplicate_post_types_enabled", "a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}", "yes");
INSERT INTO `wp_options` VALUES("204", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("219", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("220", "client-types_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("221", "offer-types_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("222", "portfolio-types_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("223", "slide-types_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("224", "testimonial-types_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("236", "widget_widget_mfn_flickr", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("237", "widget_widget_mfn_login", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("238", "widget_widget_mfn_menu", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("239", "widget_widget_mfn_recent_comments", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("240", "widget_widget_mfn_recent_posts", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("241", "widget_widget_mfn_tag_cloud", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("253", "wpb_js_composer_license_activation_notified", "yes", "yes");
INSERT INTO `wp_options` VALUES("254", "revslider-valid-notice", "false", "yes");
INSERT INTO `wp_options` VALUES("323", "revslider-latest-version", "0", "yes");
INSERT INTO `wp_options` VALUES("324", "revslider-notices", "a:4:{i:0;O:8:\"stdClass\":7:{s:7:\"version\";s:5:\"4.9.9\";s:4:\"text\";s:202:\"<a href=\"http://revolution.themepunch.com\" target=\"_blank\"><img src=\"http://updates.themepunch.tools/banners/updatenow_banner.jpg\" style=\"min-width: 50%; max-width:100%\" alt=\"revslider 5.0 is out\" ></a>\";s:4:\"code\";s:10:\"TPRS500-75\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"additional\";a:0:{}}i:1;O:8:\"stdClass\":7:{s:7:\"version\";s:7:\"5.0.4.1\";s:4:\"text\";s:230:\"<a href=\"http://revolution.themepunch.com/direct-customer-benefits/\" target=\"_blank\"><img src=\"http://updates.themepunch.tools/banners/updateto506_banner.jpg\" style=\"min-width: 50%; max-width:100%\" alt=\"revslider 5.0 is out\" ></a>\";s:4:\"code\";s:10:\"TPRS506-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"additional\";a:0:{}}i:2;O:8:\"stdClass\":7:{s:7:\"version\";s:5:\"5.1.4\";s:4:\"text\";s:260:\"<a href=\"http://revolution.themepunch.com/direct-customer-benefits/?ref=515b#productactivation\" target=\"_blank\"><img src=\"http://updates.themepunch.tools/banners/updatenow_banner515.jpg\" style=\"min-width: 50%; max-width:100%\" alt=\"revslider 5.1.5 is out\" ></a>\";s:4:\"code\";s:10:\"TPRS515-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"additional\";a:0:{}}i:3;O:8:\"stdClass\":7:{s:7:\"version\";s:5:\"5.1.6\";s:4:\"text\";s:235:\"<a href=\"//revolution.themepunch.com/direct-customer-benefits/?ref=52b\" target=\"_blank\"><img src=\"http://updates.themepunch.tools/banners/updatenow_banner52.jpg\" style=\"min-width: 50%; max-width:100%\" alt=\"revslider 5.1.5 is out\" ></a>\";s:4:\"code\";s:10:\"TPRS515-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"additional\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("578", "duplicator_exe_safe_mode", "0", "yes");
INSERT INTO `wp_options` VALUES("3283", "cookie_notice_options", "a:34:{s:6:\"app_id\";s:0:\"\";s:7:\"app_key\";s:0:\"\";s:12:\"app_blocking\";b:1;s:11:\"hide_banner\";b:0;s:8:\"position\";s:6:\"bottom\";s:12:\"message_text\";s:50:\" Polityka prywatności serwisu www.winda.poznan.pl\";s:9:\"css_class\";s:0:\"\";s:11:\"accept_text\";s:5:\"Zgoda\";s:11:\"refuse_text\";s:18:\"Nie wyrażam zgody\";s:10:\"refuse_opt\";b:0;s:11:\"refuse_code\";s:0:\"\";s:16:\"refuse_code_head\";s:0:\"\";s:14:\"revoke_cookies\";b:0;s:18:\"revoke_cookies_opt\";s:9:\"automatic\";s:19:\"revoke_message_text\";s:0:\"\";s:11:\"revoke_text\";s:0:\"\";s:11:\"redirection\";b:0;s:8:\"see_more\";b:1;s:11:\"link_target\";s:6:\"_blank\";s:13:\"link_position\";s:6:\"banner\";s:4:\"time\";s:5:\"month\";s:13:\"time_rejected\";s:5:\"month\";s:11:\"hide_effect\";s:4:\"fade\";s:9:\"on_scroll\";b:0;s:16:\"on_scroll_offset\";i:100;s:8:\"on_click\";b:0;s:6:\"colors\";a:4:{s:4:\"text\";s:4:\"#fff\";s:6:\"button\";s:7:\"#00a99d\";s:3:\"bar\";s:4:\"#000\";s:11:\"bar_opacity\";i:100;}s:12:\"see_more_opt\";a:5:{s:4:\"text\";s:20:\"Dowiedz się więcej\";s:9:\"link_type\";s:6:\"custom\";s:2:\"id\";i:0;s:4:\"link\";s:48:\"http://www.winda.poznan.pl/polityka-prywatnosci/\";s:4:\"sync\";b:0;}s:16:\"script_placement\";s:6:\"header\";s:9:\"translate\";b:0;s:19:\"deactivation_delete\";b:0;s:14:\"update_version\";i:6;s:13:\"update_notice\";b:1;s:17:\"update_delay_date\";i:0;}", "no");
INSERT INTO `wp_options` VALUES("3284", "cookie_notice_version", "2.2.1", "no");
INSERT INTO `wp_options` VALUES("9788", "duplicator_settings", "a:17:{s:7:\"version\";s:5:\"1.4.3\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"legacy\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";i:2;s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("9789", "duplicator_version_plugin", "1.4.3", "yes");
INSERT INTO `wp_options` VALUES("9790", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-11-23 14:12:55\";s:7:\"Version\";s:5:\"1.4.3\";s:9:\"VersionWP\";s:5:\"6.4.1\";s:9:\"VersionDB\";s:6:\"8.0.33\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:20:\"20190919_windapoznan\";s:4:\"Hash\";s:35:\"43c3afcf2015e0774742_20231123141255\";s:8:\"NameHash\";s:56:\"20190919_windapoznan_43c3afcf2015e0774742_20231123141255\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:66:\"20190919_windapoznan_43c3afcf2015e0774742_20231123141255_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":21:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:28:\"/home/windad/public_html/www\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-11-23 14:12:55\";s:7:\"Version\";s:5:\"1.4.3\";s:9:\"VersionWP\";s:5:\"6.4.1\";s:9:\"VersionDB\";s:6:\"8.0.33\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:20:\"20190919_windapoznan\";s:4:\"Hash\";s:35:\"43c3afcf2015e0774742_20231123141255\";s:8:\"NameHash\";s:56:\"20190919_windapoznan_43c3afcf2015e0774742_20231123141255\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:63;}s:8:\"Database\";O:12:\"DUP_Database\":14:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":16:{s:9:\"buildMode\";N;s:13:\"collationList\";a:0:{}s:17:\"isTablesUpperCase\";N;s:15:\"isNameUpperCase\";N;s:4:\"name\";N;s:15:\"tablesBaseCount\";N;s:16:\"tablesFinalCount\";N;s:14:\"tablesRowCount\";N;s:16:\"tablesSizeOnDisk\";N;s:18:\"varLowerCaseTables\";i:0;s:7:\"version\";N;s:14:\"versionComment\";N;s:18:\"tableWiseRowCounts\";a:0:{}s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:63;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:63;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:37:\"/home/windad/public_html/www/wp-admin\";i:1;s:47:\"/home/windad/public_html/www/wp-content/uploads\";i:2;s:49:\"/home/windad/public_html/www/wp-content/languages\";i:3;s:46:\"/home/windad/public_html/www/wp-content/themes\";i:4;s:40:\"/home/windad/public_html/www/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:28:\"/home/windad/public_html/www\";i:1;s:39:\"/home/windad/public_html/www/wp-content\";}}s:9:\"Installer\";r:84;s:8:\"Database\";r:98;s:13:\"BuildProgress\";r:129;}", "yes");
INSERT INTO `wp_options` VALUES("9806", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("9808", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("9809", "wp_page_for_privacy_policy", "0", "yes");
INSERT INTO `wp_options` VALUES("9810", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_options` VALUES("9811", "db_upgraded", "", "yes");
INSERT INTO `wp_options` VALUES("11784", "recovery_mode_email_last_sent", "1630323979", "yes");
INSERT INTO `wp_options` VALUES("36015", "_transient_health-check-site-status-result", "{\"good\":19,\"recommended\":3,\"critical\":1}", "yes");
INSERT INTO `wp_options` VALUES("36173", "widget_block", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("36175", "https_detection_errors", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("36176", "admin_email_lifespan", "1645876761", "yes");
INSERT INTO `wp_options` VALUES("36177", "disallowed_keys", "", "no");
INSERT INTO `wp_options` VALUES("36178", "comment_previously_approved", "1", "yes");
INSERT INTO `wp_options` VALUES("36179", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("36180", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wp_options` VALUES("36181", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wp_options` VALUES("36182", "auto_update_core_major", "enabled", "no");
INSERT INTO `wp_options` VALUES("36183", "wp_force_deactivated_plugins", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("36184", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wp_options` VALUES("36207", "duplicate_post_show_original_column", "0", "yes");
INSERT INTO `wp_options` VALUES("36208", "duplicate_post_show_original_in_post_states", "0", "yes");
INSERT INTO `wp_options` VALUES("36209", "duplicate_post_show_original_meta_box", "0", "yes");
INSERT INTO `wp_options` VALUES("36210", "duplicate_post_show_link", "a:3:{s:9:\"new_draft\";s:1:\"1\";s:5:\"clone\";s:1:\"1\";s:17:\"rewrite_republish\";s:1:\"1\";}", "yes");
INSERT INTO `wp_options` VALUES("36211", "duplicate_post_show_link_in", "a:4:{s:3:\"row\";s:1:\"1\";s:8:\"adminbar\";s:1:\"1\";s:9:\"submitbox\";s:1:\"1\";s:11:\"bulkactions\";s:1:\"1\";}", "yes");
INSERT INTO `wp_options` VALUES("36217", "_transient_cn_show_welcome", "1", "yes");
INSERT INTO `wp_options` VALUES("36263", "new_admin_email", "info@ucr.com.pl", "yes");
INSERT INTO `wp_options` VALUES("36264", "https_migration_required", "1", "yes");
INSERT INTO `wp_options` VALUES("40052", "aiowpsec_db_version", "1.9", "yes");
INSERT INTO `wp_options` VALUES("40053", "aio_wp_security_configs", "a:94:{s:19:\"aiowps_enable_debug\";s:0:\"\";s:36:\"aiowps_remove_wp_generator_meta_info\";s:0:\"\";s:25:\"aiowps_prevent_hotlinking\";s:0:\"\";s:28:\"aiowps_enable_login_lockdown\";s:0:\"\";s:28:\"aiowps_allow_unlock_requests\";s:0:\"\";s:25:\"aiowps_max_login_attempts\";s:1:\"3\";s:24:\"aiowps_retry_time_period\";s:1:\"5\";s:26:\"aiowps_lockout_time_length\";s:2:\"60\";s:28:\"aiowps_set_generic_login_msg\";s:0:\"\";s:26:\"aiowps_enable_email_notify\";s:0:\"\";s:20:\"aiowps_email_address\";s:15:\"info@ucr.com.pl\";s:27:\"aiowps_enable_forced_logout\";s:0:\"\";s:25:\"aiowps_logout_time_period\";s:2:\"60\";s:39:\"aiowps_enable_invalid_username_lockdown\";s:0:\"\";s:43:\"aiowps_instantly_lockout_specific_usernames\";a:0:{}s:32:\"aiowps_unlock_request_secret_key\";s:20:\"vjxdqv1ehyj8k629c96r\";s:35:\"aiowps_lockdown_enable_whitelisting\";s:0:\"\";s:36:\"aiowps_lockdown_allowed_ip_addresses\";s:0:\"\";s:26:\"aiowps_enable_whitelisting\";s:0:\"\";s:27:\"aiowps_allowed_ip_addresses\";s:0:\"\";s:27:\"aiowps_enable_login_captcha\";s:0:\"\";s:34:\"aiowps_enable_custom_login_captcha\";s:0:\"\";s:31:\"aiowps_enable_woo_login_captcha\";s:0:\"\";s:34:\"aiowps_enable_woo_register_captcha\";s:0:\"\";s:38:\"aiowps_enable_woo_lostpassword_captcha\";s:0:\"\";s:25:\"aiowps_captcha_secret_key\";s:20:\"vz79w7ybh23wm45el60o\";s:42:\"aiowps_enable_manual_registration_approval\";s:0:\"\";s:39:\"aiowps_enable_registration_page_captcha\";s:0:\"\";s:35:\"aiowps_enable_registration_honeypot\";s:0:\"\";s:27:\"aiowps_enable_random_prefix\";s:0:\"\";s:31:\"aiowps_enable_automated_backups\";s:0:\"\";s:26:\"aiowps_db_backup_frequency\";s:1:\"4\";s:25:\"aiowps_db_backup_interval\";s:1:\"2\";s:26:\"aiowps_backup_files_stored\";s:1:\"2\";s:32:\"aiowps_send_backup_email_address\";s:0:\"\";s:27:\"aiowps_backup_email_address\";s:15:\"info@ucr.com.pl\";s:27:\"aiowps_disable_file_editing\";s:0:\"\";s:37:\"aiowps_prevent_default_wp_file_access\";s:0:\"\";s:22:\"aiowps_system_log_file\";s:9:\"error_log\";s:26:\"aiowps_enable_blacklisting\";s:0:\"\";s:26:\"aiowps_banned_ip_addresses\";s:0:\"\";s:28:\"aiowps_enable_basic_firewall\";s:1:\"1\";s:27:\"aiowps_max_file_upload_size\";i:10;s:31:\"aiowps_enable_pingback_firewall\";s:1:\"1\";s:38:\"aiowps_disable_xmlrpc_pingback_methods\";s:1:\"1\";s:34:\"aiowps_block_debug_log_file_access\";s:1:\"1\";s:26:\"aiowps_disable_index_views\";s:0:\"\";s:30:\"aiowps_disable_trace_and_track\";s:0:\"\";s:28:\"aiowps_forbid_proxy_comments\";s:0:\"\";s:29:\"aiowps_deny_bad_query_strings\";s:0:\"\";s:34:\"aiowps_advanced_char_string_filter\";s:0:\"\";s:25:\"aiowps_enable_5g_firewall\";s:0:\"\";s:25:\"aiowps_enable_6g_firewall\";s:0:\"\";s:26:\"aiowps_enable_custom_rules\";s:0:\"\";s:32:\"aiowps_place_custom_rules_at_top\";s:0:\"\";s:19:\"aiowps_custom_rules\";s:0:\"\";s:25:\"aiowps_enable_404_logging\";s:0:\"\";s:28:\"aiowps_enable_404_IP_lockout\";s:0:\"\";s:30:\"aiowps_404_lockout_time_length\";s:2:\"60\";s:28:\"aiowps_404_lock_redirect_url\";s:16:\"http://127.0.0.1\";s:31:\"aiowps_enable_rename_login_page\";s:0:\"\";s:28:\"aiowps_enable_login_honeypot\";s:0:\"\";s:43:\"aiowps_enable_brute_force_attack_prevention\";s:0:\"\";s:30:\"aiowps_brute_force_secret_word\";s:0:\"\";s:24:\"aiowps_cookie_brute_test\";s:0:\"\";s:44:\"aiowps_cookie_based_brute_force_redirect_url\";s:16:\"http://127.0.0.1\";s:59:\"aiowps_brute_force_attack_prevention_pw_protected_exception\";s:0:\"\";s:51:\"aiowps_brute_force_attack_prevention_ajax_exception\";s:0:\"\";s:19:\"aiowps_site_lockout\";s:0:\"\";s:23:\"aiowps_site_lockout_msg\";s:0:\"\";s:30:\"aiowps_enable_spambot_blocking\";s:0:\"\";s:29:\"aiowps_enable_comment_captcha\";s:0:\"\";s:31:\"aiowps_enable_autoblock_spam_ip\";s:0:\"\";s:33:\"aiowps_spam_ip_min_comments_block\";s:0:\"\";s:33:\"aiowps_enable_bp_register_captcha\";s:0:\"\";s:35:\"aiowps_enable_bbp_new_topic_captcha\";s:0:\"\";s:32:\"aiowps_enable_automated_fcd_scan\";s:1:\"1\";s:25:\"aiowps_fcd_scan_frequency\";i:2;s:24:\"aiowps_fcd_scan_interval\";s:1:\"1\";s:28:\"aiowps_fcd_exclude_filetypes\";s:0:\"\";s:24:\"aiowps_fcd_exclude_files\";s:0:\"\";s:26:\"aiowps_send_fcd_scan_email\";s:1:\"1\";s:29:\"aiowps_fcd_scan_email_address\";s:43:\"info@ucr.com.pl\nlukasz.zukowski@hotmail.com\";s:27:\"aiowps_fcds_change_detected\";b:1;s:22:\"aiowps_copy_protection\";s:0:\"\";s:40:\"aiowps_prevent_site_display_inside_frame\";s:0:\"\";s:32:\"aiowps_prevent_users_enumeration\";s:0:\"\";s:42:\"aiowps_disallow_unauthorized_rest_requests\";s:0:\"\";s:25:\"aiowps_ip_retrieve_method\";s:1:\"0\";s:25:\"aiowps_recaptcha_site_key\";s:0:\"\";s:27:\"aiowps_recaptcha_secret_key\";s:0:\"\";s:24:\"aiowps_default_recaptcha\";s:0:\"\";s:19:\"aiowps_fcd_filename\";s:26:\"aiowps_fcd_data_cj64hujecs\";s:25:\"aiowps_last_fcd_scan_time\";s:19:\"2023-11-22 18:39:36\";}", "yes");
INSERT INTO `wp_options` VALUES("40062", "wordfence_ls_version", "1.0.9", "yes");
INSERT INTO `wp_options` VALUES("40063", "wfls_last_role_change", "1642151100", "no");
INSERT INTO `wp_options` VALUES("40064", "wordfence_version", "7.5.7", "yes");
INSERT INTO `wp_options` VALUES("40065", "wordfence_case", "1", "yes");
INSERT INTO `wp_options` VALUES("40066", "wordfence_installed", "1", "yes");
INSERT INTO `wp_options` VALUES("40067", "wordfenceActivated", "1", "yes");
INSERT INTO `wp_options` VALUES("40068", "wf_plugin_act_error", "", "yes");
INSERT INTO `wp_options` VALUES("40080", "wordfence_syncAttackDataAttempts", "0", "no");
INSERT INTO `wp_options` VALUES("40081", "wordfence_syncingAttackData", "0", "no");
INSERT INTO `wp_options` VALUES("40082", "wordfence_lastSyncAttackData", "1700744543", "no");
INSERT INTO `wp_options` VALUES("40112", "duplicate_post_show_notice", "0", "no");
INSERT INTO `wp_options` VALUES("40113", "duplicate_post_version", "4.3", "yes");
INSERT INTO `wp_options` VALUES("40117", "auto_update_plugins", "a:1:{i:0;s:27:\"js_composer/js_composer.php\";}", "no");
INSERT INTO `wp_options` VALUES("40141", "secret_key", "f!/kP93Fx_Aqt0a9(R~D:PYe4>4 ]W+<QI8+HsJ{m<NYw_Vk@Nhl<Rum/qB^NO/@", "no");
INSERT INTO `wp_options` VALUES("107877", "user_count", "1", "no");
INSERT INTO `wp_options` VALUES("299413", "wp_attachment_pages_enabled", "1", "yes");
INSERT INTO `wp_options` VALUES("299626", "can_compress_scripts", "0", "yes");
INSERT INTO `wp_options` VALUES("299725", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/pl_PL/wordpress-6.4.1.zip\";s:6:\"locale\";s:5:\"pl_PL\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/pl_PL/wordpress-6.4.1.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.4.1\";s:7:\"version\";s:5:\"6.4.1\";s:11:\"php_version\";s:5:\"7.0.0\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"6.4\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1700748738;s:15:\"version_checked\";s:5:\"6.4.1\";s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("301960", "_site_transient_timeout_browser_74df78701189cc7205ee6a2acdc2e292", "1701258751", "no");
INSERT INTO `wp_options` VALUES("301961", "_site_transient_browser_74df78701189cc7205ee6a2acdc2e292", "a:10:{s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:5:\"119.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:32:\"https://www.mozilla.org/firefox/\";s:7:\"img_src\";s:44:\"http://s.w.org/images/browsers/firefox.png?1\";s:11:\"img_src_ssl\";s:45:\"https://s.w.org/images/browsers/firefox.png?1\";s:15:\"current_version\";s:2:\"56\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("301962", "_site_transient_timeout_php_check_990bfacb848fa087bcfc06850f5e4447", "1701258752", "no");
INSERT INTO `wp_options` VALUES("301963", "_site_transient_php_check_990bfacb848fa087bcfc06850f5e4447", "a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:3:\"7.0\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "no");
INSERT INTO `wp_options` VALUES("302077", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1700746336;s:7:\"checked\";a:5:{s:13:\"betheme-child\";s:3:\"1.5\";s:7:\"betheme\";s:3:\"8.9\";s:16:\"twentytwentyfour\";s:3:\"1.0\";s:17:\"twentytwentythree\";s:3:\"1.0\";s:15:\"twentytwentytwo\";s:3:\"1.0\";}s:8:\"response\";a:2:{s:17:\"twentytwentythree\";a:6:{s:5:\"theme\";s:17:\"twentytwentythree\";s:11:\"new_version\";s:3:\"1.3\";s:3:\"url\";s:47:\"https://wordpress.org/themes/twentytwentythree/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/theme/twentytwentythree.1.3.zip\";s:8:\"requires\";s:3:\"6.1\";s:12:\"requires_php\";s:3:\"5.6\";}s:15:\"twentytwentytwo\";a:6:{s:5:\"theme\";s:15:\"twentytwentytwo\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentytwentytwo/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentytwentytwo.1.6.zip\";s:8:\"requires\";s:3:\"5.9\";s:12:\"requires_php\";s:3:\"5.6\";}}s:9:\"no_update\";a:1:{s:16:\"twentytwentyfour\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfour\";s:11:\"new_version\";s:3:\"1.0\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfour/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/twentytwentyfour.1.0.zip\";s:8:\"requires\";s:3:\"6.4\";s:12:\"requires_php\";s:3:\"7.0\";}}s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("302078", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1700748746;s:8:\"response\";a:7:{s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:49:\"w.org/plugins/all-in-one-wp-security-and-firewall\";s:4:\"slug\";s:35:\"all-in-one-wp-security-and-firewall\";s:6:\"plugin\";s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";s:11:\"new_version\";s:5:\"5.2.5\";s:3:\"url\";s:66:\"https://wordpress.org/plugins/all-in-one-wp-security-and-firewall/\";s:7:\"package\";s:84:\"https://downloads.wordpress.org/plugin/all-in-one-wp-security-and-firewall.5.2.5.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:88:\"https://ps.w.org/all-in-one-wp-security-and-firewall/assets/icon-256x256.png?rev=2798307\";s:2:\"1x\";s:88:\"https://ps.w.org/all-in-one-wp-security-and-firewall/assets/icon-128x128.png?rev=2798307\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:91:\"https://ps.w.org/all-in-one-wp-security-and-firewall/assets/banner-1544x500.png?rev=2798307\";s:2:\"1x\";s:90:\"https://ps.w.org/all-in-one-wp-security-and-firewall/assets/banner-772x250.png?rev=2798307\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:5:\"6.4.1\";s:12:\"requires_php\";s:3:\"5.6\";}s:36:\"contact-form-7/wp-contact-form-7.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:28:\"w.org/plugins/contact-form-7\";s:4:\"slug\";s:14:\"contact-form-7\";s:6:\"plugin\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"new_version\";s:5:\"5.8.3\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/contact-form-7/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.8.3.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:59:\"https://ps.w.org/contact-form-7/assets/icon.svg?rev=2339255\";s:3:\"svg\";s:59:\"https://ps.w.org/contact-form-7/assets/icon.svg?rev=2339255\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/contact-form-7/assets/banner-1544x500.png?rev=860901\";s:2:\"1x\";s:68:\"https://ps.w.org/contact-form-7/assets/banner-772x250.png?rev=880427\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.2\";s:6:\"tested\";s:5:\"6.4.1\";s:12:\"requires_php\";s:3:\"7.4\";}s:31:\"cookie-notice/cookie-notice.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:27:\"w.org/plugins/cookie-notice\";s:4:\"slug\";s:13:\"cookie-notice\";s:6:\"plugin\";s:31:\"cookie-notice/cookie-notice.php\";s:11:\"new_version\";s:8:\"2.4.11.1\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/cookie-notice/\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/plugin/cookie-notice.2.4.11.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/cookie-notice/assets/icon-256x256.png?rev=2466385\";s:2:\"1x\";s:66:\"https://ps.w.org/cookie-notice/assets/icon-128x128.png?rev=2466385\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:68:\"https://ps.w.org/cookie-notice/assets/banner-772x250.png?rev=2466385\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:5:\"4.9.6\";s:6:\"tested\";s:5:\"6.3.2\";s:12:\"requires_php\";s:3:\"5.4\";s:14:\"upgrade_notice\";s:125:\"<p>Dedicated Consent Logs page, Google AMP support for Cookie Compliance, Settings navigation through tabs and menu items</p>\";}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:7:\"1.5.7.1\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/duplicator.1.5.7.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2906985\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2906985\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/duplicator/assets/banner-1544x500.png?rev=2906985\";s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2906985\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.0\";s:6:\"tested\";s:5:\"6.4.1\";s:12:\"requires_php\";s:5:\"5.3.8\";}s:23:\"wordfence/wordfence.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:23:\"w.org/plugins/wordfence\";s:4:\"slug\";s:9:\"wordfence\";s:6:\"plugin\";s:23:\"wordfence/wordfence.php\";s:11:\"new_version\";s:6:\"7.10.7\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/wordfence/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/wordfence.7.10.7.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:54:\"https://ps.w.org/wordfence/assets/icon.svg?rev=2070865\";s:3:\"svg\";s:54:\"https://ps.w.org/wordfence/assets/icon.svg?rev=2070865\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/wordfence/assets/banner-1544x500.jpg?rev=2124102\";s:2:\"1x\";s:64:\"https://ps.w.org/wordfence/assets/banner-772x250.jpg?rev=2124102\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"3.9\";s:6:\"tested\";s:5:\"6.4.1\";s:12:\"requires_php\";s:3:\"5.5\";}s:33:\"duplicate-post/duplicate-post.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:28:\"w.org/plugins/duplicate-post\";s:4:\"slug\";s:14:\"duplicate-post\";s:6:\"plugin\";s:33:\"duplicate-post/duplicate-post.php\";s:11:\"new_version\";s:3:\"4.5\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/duplicate-post/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/duplicate-post.4.5.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/duplicate-post/assets/icon-256x256.png?rev=2336666\";s:2:\"1x\";s:67:\"https://ps.w.org/duplicate-post/assets/icon-128x128.png?rev=2336666\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/duplicate-post/assets/banner-1544x500.png?rev=2336666\";s:2:\"1x\";s:69:\"https://ps.w.org/duplicate-post/assets/banner-772x250.png?rev=2336666\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.2\";s:6:\"tested\";s:5:\"6.4.1\";s:12:\"requires_php\";s:6:\"5.6.20\";}s:27:\"js_composer/js_composer.php\";O:8:\"stdClass\":5:{s:4:\"slug\";s:11:\"js_composer\";s:11:\"new_version\";s:3:\"7.2\";s:3:\"url\";s:0:\"\";s:7:\"package\";b:0;s:4:\"name\";s:24:\"WPBakery Visual Composer\";}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:1:{s:38:\"recent-tweets-widget/recent-tweets.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:34:\"w.org/plugins/recent-tweets-widget\";s:4:\"slug\";s:20:\"recent-tweets-widget\";s:6:\"plugin\";s:38:\"recent-tweets-widget/recent-tweets.php\";s:11:\"new_version\";s:5:\"1.6.8\";s:3:\"url\";s:51:\"https://wordpress.org/plugins/recent-tweets-widget/\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/plugin/recent-tweets-widget.1.6.8.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/recent-tweets-widget/assets/icon-256x256.png?rev=2529245\";s:2:\"1x\";s:73:\"https://ps.w.org/recent-tweets-widget/assets/icon-128x128.png?rev=2529245\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:75:\"https://ps.w.org/recent-tweets-widget/assets/banner-772x250.png?rev=2529245\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:5:\"3.4.1\";}}s:7:\"checked\";a:10:{s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";s:5:\"4.4.9\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:5:\"5.5.3\";s:31:\"cookie-notice/cookie-notice.php\";s:5:\"2.2.1\";s:25:\"duplicator/duplicator.php\";s:5:\"1.4.3\";s:27:\"LayerSlider/layerslider.php\";s:5:\"5.4.0\";s:38:\"recent-tweets-widget/recent-tweets.php\";s:5:\"1.6.8\";s:23:\"revslider/revslider.php\";s:6:\"4.6.93\";s:23:\"wordfence/wordfence.php\";s:5:\"7.5.7\";s:27:\"js_composer/js_composer.php\";s:5:\"6.0.5\";s:33:\"duplicate-post/duplicate-post.php\";s:3:\"4.3\";}}", "no");
INSERT INTO `wp_options` VALUES("302085", "_transient_timeout_wflginfl_00000000000000000000ffff75d88c76", "1700749329", "no");
INSERT INTO `wp_options` VALUES("302086", "_transient_wflginfl_00000000000000000000ffff75d88c76", "1", "no");
INSERT INTO `wp_options` VALUES("302111", "_transient_timeout_wflginfl_00000000000000000000ffff235b12a1", "1700757428", "no");
INSERT INTO `wp_options` VALUES("302112", "_transient_wflginfl_00000000000000000000ffff235b12a1", "1", "no");
INSERT INTO `wp_options` VALUES("302130", "_site_transient_timeout_available_translations", "1700756595", "no");
INSERT INTO `wp_options` VALUES("302131", "_site_transient_available_translations", "a:131:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-05-13 15:59:22\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:2:\"am\";a:8:{s:8:\"language\";s:2:\"am\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2022-09-29 20:43:49\";s:12:\"english_name\";s:7:\"Amharic\";s:11:\"native_name\";s:12:\"አማርኛ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.6/am.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"am\";i:2;s:3:\"amh\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"ቀጥል\";}}s:3:\"arg\";a:8:{s:8:\"language\";s:3:\"arg\";s:7:\"version\";s:8:\"6.2-beta\";s:7:\"updated\";s:19:\"2022-09-22 16:46:56\";s:12:\"english_name\";s:9:\"Aragonese\";s:11:\"native_name\";s:9:\"Aragonés\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.2-beta/arg.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"an\";i:2;s:3:\"arg\";i:3;s:3:\"arg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continar\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-01 15:34:53\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.1/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"متابعة\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:6:\"4.8.23\";s:7:\"updated\";s:19:\"2017-01-26 15:42:35\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.23/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"as\";a:8:{s:8:\"language\";s:2:\"as\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-10-19 09:22:30\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.1/as.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-06 00:09:27\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-12 20:34:31\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:3:\"bel\";a:8:{s:8:\"language\";s:3:\"bel\";s:7:\"version\";s:6:\"4.9.24\";s:7:\"updated\";s:19:\"2019-10-29 07:54:22\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.9.24/bel.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-09 09:13:37\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-08 17:35:02\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:28:\"চালিয়ে যান\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2020-10-30 03:24:38\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:33:\"མུ་མཐུད་དུ།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"6.2.3\";s:7:\"updated\";s:19:\"2023-02-22 20:45:53\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.3/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-23 08:14:07\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.1/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-02 17:25:51\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-13 07:01:35\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-03 10:36:13\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.1/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-13 17:42:11\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsæt\";}}s:5:\"de_AT\";a:8:{s:8:\"language\";s:5:\"de_AT\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-20 10:03:48\";s:12:\"english_name\";s:16:\"German (Austria)\";s:11:\"native_name\";s:21:\"Deutsch (Österreich)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/de_AT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-07 09:06:21\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-08 18:40:48\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/translation/core/6.4.1/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-08 18:40:24\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-02 18:36:15\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.4.1/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:3:\"dsb\";a:8:{s:8:\"language\";s:3:\"dsb\";s:7:\"version\";s:5:\"6.2.3\";s:7:\"updated\";s:19:\"2022-07-16 12:13:09\";s:12:\"english_name\";s:13:\"Lower Sorbian\";s:11:\"native_name\";s:16:\"Dolnoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.3/dsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"dsb\";i:3;s:3:\"dsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Dalej\";}}s:3:\"dzo\";a:8:{s:8:\"language\";s:3:\"dzo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-06-29 08:59:03\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-22 12:26:59\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.1/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-10-07 10:32:51\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-06 06:03:31\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-10-22 02:43:28\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-10-22 02:53:03\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-08-28 15:58:51\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-09-20 08:57:43\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.1/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-17 16:42:42\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/es_AR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-10-16 16:00:04\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-10 17:18:47\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CR\";a:8:{s:8:\"language\";s:5:\"es_CR\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-08 20:42:04\";s:12:\"english_name\";s:20:\"Spanish (Costa Rica)\";s:11:\"native_name\";s:22:\"Español de Costa Rica\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/es_CR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:5:\"6.2.3\";s:7:\"updated\";s:19:\"2023-03-14 22:16:37\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.3/es_CO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_EC\";a:8:{s:8:\"language\";s:5:\"es_EC\";s:7:\"version\";s:5:\"6.2.3\";s:7:\"updated\";s:19:\"2023-04-21 13:32:10\";s:12:\"english_name\";s:17:\"Spanish (Ecuador)\";s:11:\"native_name\";s:19:\"Español de Ecuador\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.3/es_EC.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_DO\";a:8:{s:8:\"language\";s:5:\"es_DO\";s:7:\"version\";s:5:\"5.8.8\";s:7:\"updated\";s:19:\"2021-10-08 14:32:50\";s:12:\"english_name\";s:28:\"Spanish (Dominican Republic)\";s:11:\"native_name\";s:33:\"Español de República Dominicana\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8.8/es_DO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"5.8.8\";s:7:\"updated\";s:19:\"2021-10-04 20:53:18\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8.8/es_PE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_UY\";a:8:{s:8:\"language\";s:5:\"es_UY\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-31 18:33:26\";s:12:\"english_name\";s:17:\"Spanish (Uruguay)\";s:11:\"native_name\";s:19:\"Español de Uruguay\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_UY.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-06-14 16:02:22\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_CL.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PR\";a:8:{s:8:\"language\";s:5:\"es_PR\";s:7:\"version\";s:6:\"5.4.14\";s:7:\"updated\";s:19:\"2020-04-29 15:36:59\";s:12:\"english_name\";s:21:\"Spanish (Puerto Rico)\";s:11:\"native_name\";s:23:\"Español de Puerto Rico\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.14/es_PR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:6:\"5.2.19\";s:7:\"updated\";s:19:\"2019-03-02 06:35:01\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.2.19/es_GT.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-09 11:37:23\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-10-05 10:16:58\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.1/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-05 22:07:07\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.1/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-20 15:18:28\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"fa_AF\";a:8:{s:8:\"language\";s:5:\"fa_AF\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-10-12 23:13:21\";s:12:\"english_name\";s:21:\"Persian (Afghanistan)\";s:11:\"native_name\";s:31:\"(فارسی (افغانستان\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/fa_AF.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-09 09:46:35\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.1/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-14 18:05:20\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-23 09:11:41\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-22 13:54:46\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:3:\"fur\";a:8:{s:8:\"language\";s:3:\"fur\";s:7:\"version\";s:6:\"4.8.23\";s:7:\"updated\";s:19:\"2023-04-30 13:56:46\";s:12:\"english_name\";s:8:\"Friulian\";s:11:\"native_name\";s:8:\"Friulian\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.23/fur.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"fur\";i:3;s:3:\"fur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"fy\";a:8:{s:8:\"language\";s:2:\"fy\";s:7:\"version\";s:5:\"6.2.3\";s:7:\"updated\";s:19:\"2022-12-25 12:53:23\";s:12:\"english_name\";s:7:\"Frisian\";s:11:\"native_name\";s:5:\"Frysk\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.3/fy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fy\";i:2;s:3:\"fry\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Trochgean\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-08-23 17:41:37\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-02 23:37:18\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"gu\";a:8:{s:8:\"language\";s:2:\"gu\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-08-09 07:20:47\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.1/gu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ચાલુ રાખો\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:6:\"4.4.31\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.4.31/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"6.2.3\";s:7:\"updated\";s:19:\"2023-05-28 22:06:16\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.3/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"המשך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-17 08:02:01\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"जारी रखें\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-10-18 09:19:46\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.1/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:3:\"hsb\";a:8:{s:8:\"language\";s:3:\"hsb\";s:7:\"version\";s:5:\"6.2.3\";s:7:\"updated\";s:19:\"2023-02-22 17:37:32\";s:12:\"english_name\";s:13:\"Upper Sorbian\";s:11:\"native_name\";s:17:\"Hornjoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.3/hsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"hsb\";i:3;s:3:\"hsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:4:\"Dale\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-08 09:00:55\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Folytatás\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-03 16:21:10\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-16 00:18:25\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:6:\"4.9.24\";s:7:\"updated\";s:19:\"2018-12-11 10:40:02\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.24/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-06 22:35:57\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-13 16:37:11\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.1/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"次へ\";}}s:5:\"jv_ID\";a:8:{s:8:\"language\";s:5:\"jv_ID\";s:7:\"version\";s:6:\"4.9.24\";s:7:\"updated\";s:19:\"2019-02-16 23:58:56\";s:12:\"english_name\";s:8:\"Javanese\";s:11:\"native_name\";s:9:\"Basa Jawa\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.24/jv_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"jv\";i:2;s:3:\"jav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Nerusaké\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-10-31 08:47:02\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:3:\"kab\";a:8:{s:8:\"language\";s:3:\"kab\";s:7:\"version\";s:5:\"6.2.3\";s:7:\"updated\";s:19:\"2023-07-05 11:40:39\";s:12:\"english_name\";s:6:\"Kabyle\";s:11:\"native_name\";s:9:\"Taqbaylit\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.3/kab.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"kab\";i:3;s:3:\"kab\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Kemmel\";}}s:2:\"kk\";a:8:{s:8:\"language\";s:2:\"kk\";s:7:\"version\";s:6:\"4.9.24\";s:7:\"updated\";s:19:\"2018-07-10 11:35:44\";s:12:\"english_name\";s:6:\"Kazakh\";s:11:\"native_name\";s:19:\"Қазақ тілі\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.24/kk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kk\";i:2;s:3:\"kaz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Жалғастыру\";}}s:2:\"km\";a:8:{s:8:\"language\";s:2:\"km\";s:7:\"version\";s:6:\"5.2.19\";s:7:\"updated\";s:19:\"2019-06-10 16:18:28\";s:12:\"english_name\";s:5:\"Khmer\";s:11:\"native_name\";s:27:\"ភាសាខ្មែរ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.2.19/km.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"km\";i:2;s:3:\"khm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"បន្ត\";}}s:2:\"kn\";a:8:{s:8:\"language\";s:2:\"kn\";s:7:\"version\";s:5:\"6.1.4\";s:7:\"updated\";s:19:\"2022-10-20 17:15:28\";s:12:\"english_name\";s:7:\"Kannada\";s:11:\"native_name\";s:15:\"ಕನ್ನಡ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.4/kn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kn\";i:2;s:3:\"kan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"ಮುಂದುವರಿಸು\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-10-19 07:05:28\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:3:\"ckb\";a:8:{s:8:\"language\";s:3:\"ckb\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-22 22:03:24\";s:12:\"english_name\";s:16:\"Kurdish (Sorani)\";s:11:\"native_name\";s:13:\"كوردی‎\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.4.1/ckb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ku\";i:3;s:3:\"ckb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"به‌رده‌وام به‌\";}}s:3:\"kir\";a:8:{s:8:\"language\";s:3:\"kir\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-21 15:26:43\";s:12:\"english_name\";s:6:\"Kyrgyz\";s:11:\"native_name\";s:16:\"Кыргызча\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.4.1/kir.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ky\";i:2;s:3:\"kir\";i:3;s:3:\"kir\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Улантуу\";}}s:2:\"lo\";a:8:{s:8:\"language\";s:2:\"lo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 09:59:23\";s:12:\"english_name\";s:3:\"Lao\";s:11:\"native_name\";s:21:\"ພາສາລາວ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lo\";i:2;s:3:\"lao\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"ຕໍ່​ໄປ\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:5:\"6.1.4\";s:7:\"updated\";s:19:\"2022-11-24 03:51:58\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.4/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:2:\"lv\";a:8:{s:8:\"language\";s:2:\"lv\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-09-01 07:05:22\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.1/lv.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2022-10-01 09:23:52\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:5:\"ml_IN\";a:8:{s:8:\"language\";s:5:\"ml_IN\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-22 05:30:48\";s:12:\"english_name\";s:9:\"Malayalam\";s:11:\"native_name\";s:18:\"മലയാളം\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/ml_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ml\";i:2;s:3:\"mal\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"തുടരുക\";}}s:2:\"mn\";a:8:{s:8:\"language\";s:2:\"mn\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-10-05 01:27:19\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:12:\"Монгол\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.1/mn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mn\";i:2;s:3:\"mon\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:6:\"4.9.24\";s:7:\"updated\";s:19:\"2019-11-22 15:32:08\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.24/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:6:\"5.5.13\";s:7:\"updated\";s:19:\"2022-03-11 13:52:22\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.5.13/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.2.36\";s:7:\"updated\";s:19:\"2017-12-26 11:57:10\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.36/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ဆောင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-08 08:09:26\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"ne_NP\";a:8:{s:8:\"language\";s:5:\"ne_NP\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-22 11:25:19\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:18:\"नेपाली\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/ne_NP.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ne\";i:2;s:3:\"nep\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:43:\"जारी राख्नुहोस्\";}}s:5:\"nl_BE\";a:8:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-22 10:29:56\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-10-14 13:34:08\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.4.1/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-09 06:56:05\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-18 10:59:16\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:6:\"4.8.23\";s:7:\"updated\";s:19:\"2017-08-25 10:03:08\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.23/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pa_IN\";a:8:{s:8:\"language\";s:5:\"pa_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-16 05:19:43\";s:12:\"english_name\";s:15:\"Panjabi (India)\";s:11:\"native_name\";s:18:\"ਪੰਜਾਬੀ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pa\";i:2;s:3:\"pan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ਜਾਰੀ ਰੱਖੋ\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-06 10:01:18\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.3.32\";s:7:\"updated\";s:19:\"2015-12-02 21:41:29\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.3.32/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"دوام ورکړه\";}}s:5:\"pt_AO\";a:8:{s:8:\"language\";s:5:\"pt_AO\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-08-21 12:17:05\";s:12:\"english_name\";s:19:\"Portuguese (Angola)\";s:11:\"native_name\";s:20:\"Português de Angola\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/pt_AO.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-08 00:25:54\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-07 09:07:54\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:10:\"pt_PT_ao90\";a:8:{s:8:\"language\";s:10:\"pt_PT_ao90\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-07 09:12:03\";s:12:\"english_name\";s:27:\"Portuguese (Portugal, AO90)\";s:11:\"native_name\";s:17:\"Português (AO90)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/6.4.1/pt_PT_ao90.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"rhg\";a:8:{s:8:\"language\";s:3:\"rhg\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-16 13:03:18\";s:12:\"english_name\";s:8:\"Rohingya\";s:11:\"native_name\";s:8:\"Ruáinga\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"rhg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-22 15:07:48\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-02 16:10:47\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:3:\"sah\";a:8:{s:8:\"language\";s:3:\"sah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-21 02:06:41\";s:12:\"english_name\";s:5:\"Sakha\";s:11:\"native_name\";s:14:\"Сахалыы\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"sah\";i:3;s:3:\"sah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Салҕаа\";}}s:3:\"snd\";a:8:{s:8:\"language\";s:3:\"snd\";s:7:\"version\";s:6:\"5.4.14\";s:7:\"updated\";s:19:\"2020-07-07 01:53:37\";s:12:\"english_name\";s:6:\"Sindhi\";s:11:\"native_name\";s:8:\"سنڌي\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/5.4.14/snd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"sd\";i:2;s:3:\"snd\";i:3;s:3:\"snd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"اڳتي هلو\";}}s:5:\"si_LK\";a:8:{s:8:\"language\";s:5:\"si_LK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 06:00:52\";s:12:\"english_name\";s:7:\"Sinhala\";s:11:\"native_name\";s:15:\"සිංහල\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"si\";i:2;s:3:\"sin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:44:\"දිගටම කරගෙන යන්න\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-20 13:34:53\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:3:\"skr\";a:8:{s:8:\"language\";s:3:\"skr\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-12 10:29:16\";s:12:\"english_name\";s:7:\"Saraiki\";s:11:\"native_name\";s:14:\"سرائیکی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.4.1/skr.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"skr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"جاری رکھو\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-10-27 05:49:48\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Nadaljuj\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-13 18:56:56\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.1/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"5.8.8\";s:7:\"updated\";s:19:\"2021-08-01 21:21:06\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8.8/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-21 10:09:50\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"sw\";a:8:{s:8:\"language\";s:2:\"sw\";s:7:\"version\";s:6:\"5.3.16\";s:7:\"updated\";s:19:\"2019-10-13 15:35:35\";s:12:\"english_name\";s:7:\"Swahili\";s:11:\"native_name\";s:9:\"Kiswahili\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.3.16/sw.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sw\";i:2;s:3:\"swa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Endelea\";}}s:3:\"szl\";a:8:{s:8:\"language\";s:3:\"szl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-24 19:58:14\";s:12:\"english_name\";s:8:\"Silesian\";s:11:\"native_name\";s:17:\"Ślōnskŏ gŏdka\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"szl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:13:\"Kōntynuować\";}}s:5:\"ta_IN\";a:8:{s:8:\"language\";s:5:\"ta_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:22:47\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"தொடரவும்\";}}s:5:\"ta_LK\";a:8:{s:8:\"language\";s:5:\"ta_LK\";s:7:\"version\";s:6:\"4.2.36\";s:7:\"updated\";s:19:\"2015-12-03 01:07:44\";s:12:\"english_name\";s:17:\"Tamil (Sri Lanka)\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.36/ta_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"தொடர்க\";}}s:2:\"te\";a:8:{s:8:\"language\";s:2:\"te\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:47:39\";s:12:\"english_name\";s:6:\"Telugu\";s:11:\"native_name\";s:18:\"తెలుగు\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/te.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"te\";i:2;s:3:\"tel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"కొనసాగించు\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:5:\"5.8.8\";s:7:\"updated\";s:19:\"2022-06-08 04:30:30\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.8.8/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:6:\"4.8.23\";s:7:\"updated\";s:19:\"2017-09-30 09:04:29\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.8.23/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-04 21:37:29\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"tt_RU\";a:8:{s:8:\"language\";s:5:\"tt_RU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-20 20:20:50\";s:12:\"english_name\";s:5:\"Tatar\";s:11:\"native_name\";s:19:\"Татар теле\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tt\";i:2;s:3:\"tat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"дәвам итү\";}}s:3:\"tah\";a:8:{s:8:\"language\";s:3:\"tah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-06 18:39:39\";s:12:\"english_name\";s:8:\"Tahitian\";s:11:\"native_name\";s:10:\"Reo Tahiti\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ty\";i:2;s:3:\"tah\";i:3;s:3:\"tah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-19 13:40:04\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:16:\"ئۇيغۇرچە\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"6.1.4\";s:7:\"updated\";s:19:\"2023-03-04 10:46:30\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.4/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"ur\";a:8:{s:8:\"language\";s:2:\"ur\";s:7:\"version\";s:6:\"5.4.14\";s:7:\"updated\";s:19:\"2020-04-09 11:17:33\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:8:\"اردو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.4.14/ur.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ur\";i:2;s:3:\"urd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"جاری رکھیں\";}}s:5:\"uz_UZ\";a:8:{s:8:\"language\";s:5:\"uz_UZ\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-28 12:02:22\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:11:\"O‘zbekcha\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/uz_UZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uz\";i:2;s:3:\"uzb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Davom etish\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"6.2.3\";s:7:\"updated\";s:19:\"2023-07-15 15:30:50\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.3/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-23 09:22:54\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-10 16:50:00\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_HK\";a:8:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"6.2.3\";s:7:\"updated\";s:19:\"2022-07-15 15:25:03\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:12:\"香港中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.3/zh_HK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}}", "no");
INSERT INTO `wp_options` VALUES("302138", "_transient_timeout_wfcredentialstatus_1", "1700752336", "no");
INSERT INTO `wp_options` VALUES("302139", "_transient_wfcredentialstatus_1", "067dda541428632e5679827ff49d7eeabded40b107dedc43fb051d44ce92d9e8c", "no");
INSERT INTO `wp_options` VALUES("302140", "_transient_timeout_users_online", "1700750537", "no");
INSERT INTO `wp_options` VALUES("302141", "_transient_users_online", "a:1:{i:0;a:4:{s:7:\"user_id\";i:1;s:13:\"last_activity\";i:1700752337;s:10:\"ip_address\";s:14:\"46.205.132.252\";s:7:\"blog_id\";b:0;}}", "no");
INSERT INTO `wp_options` VALUES("302142", "_site_transient_timeout_browser_4355e917423cadf894833f03efa36503", "1701353537", "no");
INSERT INTO `wp_options` VALUES("302143", "_site_transient_browser_4355e917423cadf894833f03efa36503", "a:10:{s:4:\"name\";s:6:\"Safari\";s:7:\"version\";s:4:\"16.6\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.apple.com/safari/\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/safari.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/safari.png?1\";s:15:\"current_version\";s:2:\"11\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("302144", "_site_transient_timeout_theme_roots", "1700750538", "no");
INSERT INTO `wp_options` VALUES("302145", "_site_transient_theme_roots", "a:5:{s:13:\"betheme-child\";s:7:\"/themes\";s:7:\"betheme\";s:7:\"/themes\";s:16:\"twentytwentyfour\";s:7:\"/themes\";s:17:\"twentytwentythree\";s:7:\"/themes\";s:15:\"twentytwentytwo\";s:7:\"/themes\";}", "no");
INSERT INTO `wp_options` VALUES("302146", "_site_transient_timeout_community-events-c2e0ea215e9bea612f4e6a15033ee087", "1700791941", "no");
INSERT INTO `wp_options` VALUES("302147", "_site_transient_community-events-c2e0ea215e9bea612f4e6a15033ee087", "a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:12:\"46.205.132.0\";}s:6:\"events\";a:0:{}}", "no");

/* INSERT TABLE DATA: wp_postmeta */
INSERT INTO `wp_postmeta` VALUES("13", "8", "_form", "<label> Your Name (required)\n    [text* your-name] </label>\n\n<label> Your Email (required)\n    [email* your-email] </label>\n\n<label> Subject\n    [text your-subject] </label>\n\n<label> Your Message\n    [textarea your-message] </label>\n\n[submit \"Send\"]");
INSERT INTO `wp_postmeta` VALUES("14", "8", "_mail", "a:8:{s:7:\"subject\";s:22:\"Winda \"[your-subject]\"\";s:6:\"sender\";s:40:\"[your-name] <wordpress@winda.ucr.com.pl>\";s:4:\"body\";s:170:\"From: [your-name] <[your-email]>\nSubject: [your-subject]\n\nMessage Body:\n[your-message]\n\n-- \nThis e-mail was sent from a contact form on Winda (http://www.winda.poznan.pl)\";s:9:\"recipient\";s:15:\"info@ucr.com.pl\";s:18:\"additional_headers\";s:22:\"Reply-To: [your-email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";i:0;s:13:\"exclude_blank\";i:0;}");
INSERT INTO `wp_postmeta` VALUES("15", "8", "_mail_2", "a:9:{s:6:\"active\";b:0;s:7:\"subject\";s:22:\"Winda \"[your-subject]\"\";s:6:\"sender\";s:34:\"Winda <wordpress@winda.ucr.com.pl>\";s:4:\"body\";s:112:\"Message Body:\n[your-message]\n\n-- \nThis e-mail was sent from a contact form on Winda (http://www.winda.poznan.pl)\";s:9:\"recipient\";s:12:\"[your-email]\";s:18:\"additional_headers\";s:25:\"Reply-To: info@ucr.com.pl\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";i:0;s:13:\"exclude_blank\";i:0;}");
INSERT INTO `wp_postmeta` VALUES("16", "8", "_messages", "a:8:{s:12:\"mail_sent_ok\";s:45:\"Thank you for your message. It has been sent.\";s:12:\"mail_sent_ng\";s:71:\"There was an error trying to send your message. Please try again later.\";s:16:\"validation_error\";s:61:\"One or more fields have an error. Please check and try again.\";s:4:\"spam\";s:71:\"There was an error trying to send your message. Please try again later.\";s:12:\"accept_terms\";s:69:\"You must accept the terms and conditions before sending your message.\";s:16:\"invalid_required\";s:22:\"The field is required.\";s:16:\"invalid_too_long\";s:22:\"The field is too long.\";s:17:\"invalid_too_short\";s:23:\"The field is too short.\";}");
INSERT INTO `wp_postmeta` VALUES("17", "8", "_additional_settings", NULL);
INSERT INTO `wp_postmeta` VALUES("18", "8", "_locale", "pl_PL");
INSERT INTO `wp_postmeta` VALUES("19", "9", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("20", "9", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("21", "9", "_menu_item_object_id", "9");
INSERT INTO `wp_postmeta` VALUES("22", "9", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("23", "9", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("24", "9", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("25", "9", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("26", "9", "_menu_item_url", "/o-firmie/");
INSERT INTO `wp_postmeta` VALUES("28", "9", "menu-item-mfn-megamenu", "");
INSERT INTO `wp_postmeta` VALUES("29", "9", "menu-item-mfn-bg", "");
INSERT INTO `wp_postmeta` VALUES("30", "10", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("31", "10", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("32", "10", "_menu_item_object_id", "10");
INSERT INTO `wp_postmeta` VALUES("33", "10", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("34", "10", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("35", "10", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("36", "10", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("37", "10", "_menu_item_url", "/oferta/");
INSERT INTO `wp_postmeta` VALUES("39", "10", "menu-item-mfn-megamenu", "");
INSERT INTO `wp_postmeta` VALUES("40", "10", "menu-item-mfn-bg", "");
INSERT INTO `wp_postmeta` VALUES("41", "11", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("42", "11", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("43", "11", "_menu_item_object_id", "11");
INSERT INTO `wp_postmeta` VALUES("44", "11", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("45", "11", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("46", "11", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("47", "11", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("48", "11", "_menu_item_url", "/serwis/");
INSERT INTO `wp_postmeta` VALUES("50", "11", "menu-item-mfn-megamenu", "");
INSERT INTO `wp_postmeta` VALUES("51", "11", "menu-item-mfn-bg", "");
INSERT INTO `wp_postmeta` VALUES("74", "14", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("75", "14", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("76", "14", "_menu_item_object_id", "14");
INSERT INTO `wp_postmeta` VALUES("77", "14", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("78", "14", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("79", "14", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("80", "14", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("81", "14", "_menu_item_url", "/galeria/");
INSERT INTO `wp_postmeta` VALUES("83", "14", "menu-item-mfn-megamenu", "");
INSERT INTO `wp_postmeta` VALUES("84", "14", "menu-item-mfn-bg", "");
INSERT INTO `wp_postmeta` VALUES("85", "15", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("86", "15", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("87", "15", "_menu_item_object_id", "15");
INSERT INTO `wp_postmeta` VALUES("88", "15", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("89", "15", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("90", "15", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("91", "15", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("92", "15", "_menu_item_url", "/kontakt/");
INSERT INTO `wp_postmeta` VALUES("94", "15", "menu-item-mfn-megamenu", "");
INSERT INTO `wp_postmeta` VALUES("95", "15", "menu-item-mfn-bg", "");
INSERT INTO `wp_postmeta` VALUES("96", "9", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("97", "10", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("98", "11", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("101", "14", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("102", "15", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("103", "16", "_wp_attached_file", "2017/10/logo.jpg");
INSERT INTO `wp_postmeta` VALUES("104", "16", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1144;s:6:\"height\";i:1058;s:4:\"file\";s:16:\"2017/10/logo.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"logo-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"logo-300x277.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:277;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:16:\"logo-768x710.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:710;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:17:\"logo-1024x947.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:947;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:16:\"logo-158x146.jpg\";s:5:\"width\";i:158;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:14:\"logo-50x46.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:46;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"portfolio-mf\";a:4:{s:4:\"file\";s:16:\"logo-960x750.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:16:\"logo-960x375.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:16:\"logo-480x750.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:17:\"logo-1144x450.jpg\";s:5:\"width\";i:1144;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:17:\"logo-1144x480.jpg\";s:5:\"width\";i:1144;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:14:\"logo-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:14:\"logo-81x75.jpg\";s:5:\"width\";i:81;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:16:\"logo-890x470.jpg\";s:5:\"width\";i:890;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:14:\"logo-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("105", "17", "_wp_attached_file", "2015/04/slide-lawyer-bg.jpg");
INSERT INTO `wp_postmeta` VALUES("106", "17", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:570;s:4:\"file\";s:27:\"2015/04/slide-lawyer-bg.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"slide-lawyer-bg-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"slide-lawyer-bg-300x89.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:89;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:27:\"slide-lawyer-bg-768x228.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:228;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:28:\"slide-lawyer-bg-1024x304.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:304;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:26:\"slide-lawyer-bg-260x77.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:77;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:25:\"slide-lawyer-bg-50x15.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:15;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"portfolio-mf\";a:4:{s:4:\"file\";s:27:\"slide-lawyer-bg-960x570.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:570;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:27:\"slide-lawyer-bg-960x375.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:27:\"slide-lawyer-bg-480x570.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:570;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:28:\"slide-lawyer-bg-1160x450.jpg\";s:5:\"width\";i:1160;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:28:\"slide-lawyer-bg-1200x480.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:25:\"slide-lawyer-bg-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:26:\"slide-lawyer-bg-150x45.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:45;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:27:\"slide-lawyer-bg-890x470.jpg\";s:5:\"width\";i:890;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:25:\"slide-lawyer-bg-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("107", "18", "_wp_attached_file", "2015/04/slide-lawyer-5.png");
INSERT INTO `wp_postmeta` VALUES("108", "18", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:276;s:6:\"height\";i:404;s:4:\"file\";s:26:\"2015/04/slide-lawyer-5.png\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"slide-lawyer-5-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"slide-lawyer-5-205x300.png\";s:5:\"width\";i:205;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:26:\"slide-lawyer-5-100x146.png\";s:5:\"width\";i:100;s:6:\"height\";i:146;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:24:\"slide-lawyer-5-34x50.png\";s:5:\"width\";i:34;s:6:\"height\";i:50;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:26:\"slide-lawyer-5-276x375.png\";s:5:\"width\";i:276;s:6:\"height\";i:375;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:24:\"slide-lawyer-5-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:24:\"slide-lawyer-5-51x75.png\";s:5:\"width\";i:51;s:6:\"height\";i:75;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:24:\"slide-lawyer-5-85x85.png\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("109", "19", "_wp_attached_file", "2015/04/slide-lawyer-4.png");
INSERT INTO `wp_postmeta` VALUES("110", "19", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:187;s:6:\"height\";i:266;s:4:\"file\";s:26:\"2015/04/slide-lawyer-4.png\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"slide-lawyer-4-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:26:\"slide-lawyer-4-103x146.png\";s:5:\"width\";i:103;s:6:\"height\";i:146;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:24:\"slide-lawyer-4-35x50.png\";s:5:\"width\";i:35;s:6:\"height\";i:50;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:24:\"slide-lawyer-4-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:24:\"slide-lawyer-4-53x75.png\";s:5:\"width\";i:53;s:6:\"height\";i:75;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:24:\"slide-lawyer-4-85x85.png\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("111", "20", "_wp_attached_file", "2015/04/slide-lawyer-3.png");
INSERT INTO `wp_postmeta` VALUES("112", "20", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:59;s:6:\"height\";i:196;s:4:\"file\";s:26:\"2015/04/slide-lawyer-3.png\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"slide-lawyer-3-59x150.png\";s:5:\"width\";i:59;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:25:\"slide-lawyer-3-44x146.png\";s:5:\"width\";i:44;s:6:\"height\";i:146;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:24:\"slide-lawyer-3-15x50.png\";s:5:\"width\";i:15;s:6:\"height\";i:50;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:24:\"slide-lawyer-3-59x80.png\";s:5:\"width\";i:59;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:24:\"slide-lawyer-3-23x75.png\";s:5:\"width\";i:23;s:6:\"height\";i:75;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:24:\"slide-lawyer-3-59x85.png\";s:5:\"width\";i:59;s:6:\"height\";i:85;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("113", "21", "_wp_attached_file", "2015/04/slide-lawyer-2.png");
INSERT INTO `wp_postmeta` VALUES("114", "21", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:249;s:6:\"height\";i:214;s:4:\"file\";s:26:\"2015/04/slide-lawyer-2.png\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"slide-lawyer-2-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:26:\"slide-lawyer-2-170x146.png\";s:5:\"width\";i:170;s:6:\"height\";i:146;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:24:\"slide-lawyer-2-50x43.png\";s:5:\"width\";i:50;s:6:\"height\";i:43;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:24:\"slide-lawyer-2-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:24:\"slide-lawyer-2-87x75.png\";s:5:\"width\";i:87;s:6:\"height\";i:75;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:24:\"slide-lawyer-2-85x85.png\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("115", "22", "_wp_attached_file", "2015/04/slide-lawyer-1.png");
INSERT INTO `wp_postmeta` VALUES("116", "22", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1022;s:6:\"height\";i:92;s:4:\"file\";s:26:\"2015/04/slide-lawyer-1.png\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"slide-lawyer-1-150x92.png\";s:5:\"width\";i:150;s:6:\"height\";i:92;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"slide-lawyer-1-300x27.png\";s:5:\"width\";i:300;s:6:\"height\";i:27;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:25:\"slide-lawyer-1-768x69.png\";s:5:\"width\";i:768;s:6:\"height\";i:69;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:25:\"slide-lawyer-1-260x23.png\";s:5:\"width\";i:260;s:6:\"height\";i:23;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:23:\"slide-lawyer-1-50x5.png\";s:5:\"width\";i:50;s:6:\"height\";i:5;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"portfolio-mf\";a:4:{s:4:\"file\";s:25:\"slide-lawyer-1-960x92.png\";s:5:\"width\";i:960;s:6:\"height\";i:92;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:25:\"slide-lawyer-1-960x92.png\";s:5:\"width\";i:960;s:6:\"height\";i:92;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:25:\"slide-lawyer-1-480x92.png\";s:5:\"width\";i:480;s:6:\"height\";i:92;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:24:\"slide-lawyer-1-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:25:\"slide-lawyer-1-150x14.png\";s:5:\"width\";i:150;s:6:\"height\";i:14;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:25:\"slide-lawyer-1-890x92.png\";s:5:\"width\";i:890;s:6:\"height\";i:92;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:24:\"slide-lawyer-1-85x85.png\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("117", "23", "_wp_attached_file", "2015/04/lawyer.png");
INSERT INTO `wp_postmeta` VALUES("118", "23", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:156;s:6:\"height\";i:36;s:4:\"file\";s:18:\"2015/04/lawyer.png\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"lawyer-150x36.png\";s:5:\"width\";i:150;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:16:\"lawyer-50x12.png\";s:5:\"width\";i:50;s:6:\"height\";i:12;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:16:\"lawyer-80x36.png\";s:5:\"width\";i:80;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:17:\"lawyer-150x35.png\";s:5:\"width\";i:150;s:6:\"height\";i:35;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:16:\"lawyer-85x36.png\";s:5:\"width\";i:85;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("119", "24", "_wp_attached_file", "2015/04/retina-lawyer.png");
INSERT INTO `wp_postmeta` VALUES("120", "24", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:310;s:6:\"height\";i:70;s:4:\"file\";s:25:\"2015/04/retina-lawyer.png\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"retina-lawyer-150x70.png\";s:5:\"width\";i:150;s:6:\"height\";i:70;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"retina-lawyer-300x68.png\";s:5:\"width\";i:300;s:6:\"height\";i:68;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:24:\"retina-lawyer-260x59.png\";s:5:\"width\";i:260;s:6:\"height\";i:59;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:23:\"retina-lawyer-50x11.png\";s:5:\"width\";i:50;s:6:\"height\";i:11;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:23:\"retina-lawyer-80x70.png\";s:5:\"width\";i:80;s:6:\"height\";i:70;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:24:\"retina-lawyer-150x34.png\";s:5:\"width\";i:150;s:6:\"height\";i:34;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:23:\"retina-lawyer-85x70.png\";s:5:\"width\";i:85;s:6:\"height\";i:70;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("121", "25", "_wp_attached_file", "2015/04/home_lawyer_section.jpg");
INSERT INTO `wp_postmeta` VALUES("122", "25", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:900;s:4:\"file\";s:31:\"2015/04/home_lawyer_section.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"home_lawyer_section-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:31:\"home_lawyer_section-300x141.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:141;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:31:\"home_lawyer_section-768x360.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:360;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:32:\"home_lawyer_section-1024x480.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:31:\"home_lawyer_section-260x122.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:122;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:29:\"home_lawyer_section-50x23.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:23;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"portfolio-mf\";a:4:{s:4:\"file\";s:31:\"home_lawyer_section-960x750.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:31:\"home_lawyer_section-960x375.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:31:\"home_lawyer_section-480x750.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:32:\"home_lawyer_section-1160x450.jpg\";s:5:\"width\";i:1160;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:32:\"home_lawyer_section-1200x480.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:29:\"home_lawyer_section-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:30:\"home_lawyer_section-150x70.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:31:\"home_lawyer_section-890x470.jpg\";s:5:\"width\";i:890;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:29:\"home_lawyer_section-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("123", "26", "_wp_attached_file", "2015/04/home_lawyer_list_1.png");
INSERT INTO `wp_postmeta` VALUES("124", "26", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:50;s:6:\"height\";i:50;s:4:\"file\";s:30:\"2015/04/home_lawyer_list_1.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("125", "27", "_wp_attached_file", "2015/04/home_lawyer_list_2.png");
INSERT INTO `wp_postmeta` VALUES("126", "27", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:50;s:6:\"height\";i:50;s:4:\"file\";s:30:\"2015/04/home_lawyer_list_2.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("127", "28", "_wp_attached_file", "2015/04/home_lawyer_list_3.png");
INSERT INTO `wp_postmeta` VALUES("128", "28", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:50;s:6:\"height\";i:50;s:4:\"file\";s:30:\"2015/04/home_lawyer_list_3.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("129", "29", "_wp_attached_file", "2015/04/home_lawyer_4.png");
INSERT INTO `wp_postmeta` VALUES("130", "29", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:50;s:6:\"height\";i:50;s:4:\"file\";s:25:\"2015/04/home_lawyer_4.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("131", "30", "_wp_attached_file", "2015/04/home_lawyer_5.png");
INSERT INTO `wp_postmeta` VALUES("132", "30", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:50;s:6:\"height\";i:50;s:4:\"file\";s:25:\"2015/04/home_lawyer_5.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("133", "31", "_wp_attached_file", "2015/04/home_lawyer_6.png");
INSERT INTO `wp_postmeta` VALUES("134", "31", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:50;s:6:\"height\";i:50;s:4:\"file\";s:25:\"2015/04/home_lawyer_6.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("135", "32", "_wp_attached_file", "2015/04/home_lawyer_about.png");
INSERT INTO `wp_postmeta` VALUES("136", "32", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:68;s:6:\"height\";i:150;s:4:\"file\";s:29:\"2015/04/home_lawyer_about.png\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"home_lawyer_about-68x150.png\";s:5:\"width\";i:68;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:28:\"home_lawyer_about-66x146.png\";s:5:\"width\";i:66;s:6:\"height\";i:146;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:27:\"home_lawyer_about-23x50.png\";s:5:\"width\";i:23;s:6:\"height\";i:50;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:27:\"home_lawyer_about-68x80.png\";s:5:\"width\";i:68;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:27:\"home_lawyer_about-34x75.png\";s:5:\"width\";i:34;s:6:\"height\";i:75;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:27:\"home_lawyer_about-68x85.png\";s:5:\"width\";i:68;s:6:\"height\";i:85;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("137", "33", "_wp_attached_file", "2015/04/home_lawyer_specialist.jpg");
INSERT INTO `wp_postmeta` VALUES("138", "33", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:780;s:6:\"height\";i:697;s:4:\"file\";s:34:\"2015/04/home_lawyer_specialist.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"home_lawyer_specialist-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"home_lawyer_specialist-300x268.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:268;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:34:\"home_lawyer_specialist-768x686.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:686;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:34:\"home_lawyer_specialist-163x146.jpg\";s:5:\"width\";i:163;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"home_lawyer_specialist-50x45.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:45;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"home_lawyer_specialist-780x375.jpg\";s:5:\"width\";i:780;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:34:\"home_lawyer_specialist-480x697.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:697;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:34:\"home_lawyer_specialist-780x450.jpg\";s:5:\"width\";i:780;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:34:\"home_lawyer_specialist-780x480.jpg\";s:5:\"width\";i:780;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"home_lawyer_specialist-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:32:\"home_lawyer_specialist-84x75.jpg\";s:5:\"width\";i:84;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:34:\"home_lawyer_specialist-780x470.jpg\";s:5:\"width\";i:780;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"home_lawyer_specialist-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("139", "44", "_wp_attached_file", "2015/04/home_lawyer_pin.png");
INSERT INTO `wp_postmeta` VALUES("140", "44", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:64;s:6:\"height\";i:64;s:4:\"file\";s:27:\"2015/04/home_lawyer_pin.png\";s:5:\"sizes\";a:1:{s:5:\"50x50\";a:4:{s:4:\"file\";s:25:\"home_lawyer_pin-50x50.png\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("141", "46", "_wp_attached_file", "2015/04/our_team_3.jpg");
INSERT INTO `wp_postmeta` VALUES("142", "46", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:780;s:6:\"height\";i:780;s:4:\"file\";s:22:\"2015/04/our_team_3.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"our_team_3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"our_team_3-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"our_team_3-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:22:\"our_team_3-146x146.jpg\";s:5:\"width\";i:146;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:20:\"our_team_3-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"portfolio-mf\";a:4:{s:4:\"file\";s:22:\"our_team_3-780x750.jpg\";s:5:\"width\";i:780;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:22:\"our_team_3-780x375.jpg\";s:5:\"width\";i:780;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:22:\"our_team_3-480x750.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:22:\"our_team_3-780x450.jpg\";s:5:\"width\";i:780;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:22:\"our_team_3-780x480.jpg\";s:5:\"width\";i:780;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:20:\"our_team_3-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:20:\"our_team_3-75x75.jpg\";s:5:\"width\";i:75;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:22:\"our_team_3-780x470.jpg\";s:5:\"width\";i:780;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:20:\"our_team_3-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("143", "47", "_wp_attached_file", "2015/04/our_team_1.jpg");
INSERT INTO `wp_postmeta` VALUES("144", "47", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:780;s:6:\"height\";i:780;s:4:\"file\";s:22:\"2015/04/our_team_1.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"our_team_1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"our_team_1-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"our_team_1-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:22:\"our_team_1-146x146.jpg\";s:5:\"width\";i:146;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:20:\"our_team_1-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"portfolio-mf\";a:4:{s:4:\"file\";s:22:\"our_team_1-780x750.jpg\";s:5:\"width\";i:780;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:22:\"our_team_1-780x375.jpg\";s:5:\"width\";i:780;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:22:\"our_team_1-480x750.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:22:\"our_team_1-780x450.jpg\";s:5:\"width\";i:780;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:22:\"our_team_1-780x480.jpg\";s:5:\"width\";i:780;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:20:\"our_team_1-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:20:\"our_team_1-75x75.jpg\";s:5:\"width\";i:75;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:22:\"our_team_1-780x470.jpg\";s:5:\"width\";i:780;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:20:\"our_team_1-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("146", "48", "mfn-post-love", "0");
INSERT INTO `wp_postmeta` VALUES("147", "49", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("148", "49", "mfn-post-hide-content", "0");
INSERT INTO `wp_postmeta` VALUES("149", "49", "mfn-post-custom-layout", "0");
INSERT INTO `wp_postmeta` VALUES("150", "49", "mfn-post-slider", "0");
INSERT INTO `wp_postmeta` VALUES("151", "49", "mfn-post-slider-layer", "0");
INSERT INTO `wp_postmeta` VALUES("152", "49", "mfn-post-menu", "0");
INSERT INTO `wp_postmeta` VALUES("153", "49", "mfn-post-one-page", "0");
INSERT INTO `wp_postmeta` VALUES("154", "49", "mfn-post-hide-title", "0");
INSERT INTO `wp_postmeta` VALUES("155", "49", "mfn-post-remove-padding", "1");
INSERT INTO `wp_postmeta` VALUES("157", "49", "mfn-page-items-seo", "icon\r\n\r\nicon-lamp\r\n\r\n<img src=\"http://www.winda.poznan.pl/wp-content/uploads/2015/04/home_lawyer_list_1.png\" alt=\"\"/>\r\n\r\nLegal help\r\n\r\nVitae adipiscing turpis. Aenean ligula nibh in, molestie id viverra a, dapibus at dolor.\r\n\r\n2\r\n\r\nfadeInLeft\r\n\r\nicon-lamp\r\n\r\n<img src=\"http://www.winda.poznan.pl/wp-content/uploads/2015/04/home_lawyer_list_2.png\" alt=\"\"/>\r\n\r\nFiscal advising\r\n\r\nVitae adipiscing turpis. Aenean ligula nibh in, molestie id viverra a, dapibus at dolor.\r\n\r\n2\r\n\r\nfadeInDown\r\n\r\nicon-lamp\r\n\r\n<img src=\"http://www.winda.poznan.pl/wp-content/uploads/2015/04/home_lawyer_list_3.png\" alt=\"\"/>\r\n\r\nQualified protection\r\n\r\nVitae adipiscing turpis. Aenean ligula nibh in, molestie id viverra a, dapibus at dolor.\r\n\r\n2\r\n\r\nfadeInRight\r\n\r\ndefault\r\n\r\nicon-lamp\r\n\r\n<img src=\"http://www.winda.poznan.pl/wp-content/uploads/2015/04/home_lawyer_4.png\" alt=\"\"/>\r\n\r\nFinancial advising\r\n\r\nVitae adipiscing turpis. Aenean ligula nibh in, molestie id viverra a, dapibus at dolor.\r\n\r\n2\r\n\r\nfadeInLeft\r\n\r\nicon-lamp\r\n\r\n<img src=\"http://www.winda.poznan.pl/wp-content/uploads/2015/04/home_lawyer_5.png\" alt=\"\"/>\r\n\r\nVindication\r\n\r\nVitae adipiscing turpis. Aenean ligula nibh in, molestie id viverra a, dapibus at dolor.\r\n\r\n2\r\n\r\nfadeInUp\r\n\r\nicon-lamp\r\n\r\n<img src=\"http://www.winda.poznan.pl/wp-content/uploads/2015/04/home_lawyer_6.png\" alt=\"\"/>\r\n\r\n10 years of experience\r\n\r\nVitae adipiscing turpis. Aenean ligula nibh in, molestie id viverra a, dapibus at dolor.\r\n\r\n2\r\n\r\nfadeInRight\r\n\r\nAbout us\r\n\r\n<h2 style=\"margin-bottom: 30px;\">About us</h2>\r\n[image src=\"http://www.winda.poznan.pl/wp-content/uploads/2015/04/home_lawyer_about.png\" align=\"left\" alt=\"\" border=\"0\"]\r\n<p style=\"font-weight: bold;\"><big>Vitae adipiscing turpis. Aenean ligula nibh, molestie id viverra a, dapibus at dolor. In iaculis viverra neque, ac eleifend ante lobortis id. In viverra ipsum ac eros tristique dignissim. Donec aliquam velit vitae mi dictum.</big></p>\r\n<p>Vitae adipiscing turpis. Aenean ligula nibh, molestie id viverra a, dapibus at dolor. In iaculis viverra neque, ac eleifend ante lobortis id. In viverra ipsum ac eros tristique dignissim. Donec aliquam velit vitae mi dictum. Vitae adipc aliquam velit vitae mi dictum. </p>\r\n\r\nzoomInLeft\r\n\r\nPopular information\r\n\r\n<h2 style=\"margin-bottom: 30px;\">Popular information</h2>\r\n<div class=\"column one-second\" style=\"margin-bottom: 0;\">\r\n<ul class=\"list_idea\">\r\n	<li>Lorem ipsum dolor sit amet, consectetuer adipiscing elit</li>\r\n	<li>Aliquam tincidunt cons ectetuer mauris eu risus</li>\r\n	<li>Vestibulum auctor dapibus conneque</li>\r\n</ul>\r\n</div>\r\n<div class=\"column one-second\" style=\"margin-bottom: 0;\">\r\n<ul class=\"list_idea\">\r\n	<li>Lorem ipsum dolor sit amet, consectetuer adipiscing elit</li>\r\n	<li>Aliquam tincidunt cons ectetuer mauris eu risus</li>\r\n	<li>Vestibulum auctor dapibus conneque</li>\r\n</ul>\r\n</div>\r\n\r\nzoomInRight\r\n\r\ndefault\r\n\r\nLatest questions and answers\r\n\r\n<h2 style=\"margin-bottom: 0;\">Latest questions and answers</h2>\r\n\r\nSpecialist\r\n\r\n<h2 style=\"margin-bottom: 0;\">Specialist</h2>\r\n\r\nSed est elit, posuere ac semper at, hendrerit a neque: <p><big>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce velit tortor, dictum in gravida nec, aliquet non lorem. </big></p>\r\n<p>Donec vestibulum justo a diam ultricies pellentesque. Quisque mattis diam vel lacus tincidunt elementum. Sed vitae adipiscing turpis. Aenean ligula nibh, molestie id viverra a, dapibus at dolor. In iaculis viverra neque, ac eleifend ante lobortis id. In viverra ipsum ac eros tristique dignissim. Donec aliquam velit vitae mi dictum. </p>\r\n\r\nSed est elit, posuere ac semper at, hendrerit a neque: <p><big>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce velit tortor, dictum in gravida nec, aliquet non lorem. </big></p>\r\n<p>Donec vestibulum justo a diam ultricies pellentesque. Quisque mattis diam vel lacus tincidunt elementum. Sed vitae adipiscing turpis. Aenean ligula nibh, molestie id viverra a, dapibus at dolor. In iaculis viverra neque, ac eleifend ante lobortis id. In viverra ipsum ac eros tristique dignissim. Donec aliquam velit vitae mi dictum. </p>\r\n\r\nSed est elit, posuere ac semper at, hendrerit a neque: <p><big>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce velit tortor, dictum in gravida nec, aliquet non lorem. </big></p>\r\n<p>Donec vestibulum justo a diam ultricies pellentesque. Quisque mattis diam vel lacus tincidunt elementum. Sed vitae adipiscing turpis. Aenean ligula nibh, molestie id viverra a, dapibus at dolor. In iaculis viverra neque, ac eleifend ante lobortis id. In viverra ipsum ac eros tristique dignissim. Donec aliquam velit vitae mi dictum. </p>\r\n\r\nSed est elit, posuere ac semper at, hendrerit a neque: <p><big>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce velit tortor, dictum in gravida nec, aliquet non lorem. </big></p>\r\n<p>Donec vestibulum justo a diam ultricies pellentesque. Quisque mattis diam vel lacus tincidunt elementum. Sed vitae adipiscing turpis. Aenean ligula nibh, molestie id viverra a, dapibus at dolor. In iaculis viverra neque, ac eleifend ante lobortis id. In viverra ipsum ac eros tristique dignissim. Donec aliquam velit vitae mi dictum. </p>\r\n\r\nSed est elit, posuere ac semper at, hendrerit a neque: <p><big>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce velit tortor, dictum in gravida nec, aliquet non lorem. </big></p>\r\n<p>Donec vestibulum justo a diam ultricies pellentesque. Quisque mattis diam vel lacus tincidunt elementum. Sed vitae adipiscing turpis. Aenean ligula nibh, molestie id viverra a, dapibus at dolor. In iaculis viverra neque, ac eleifend ante lobortis id. In viverra ipsum ac eros tristique dignissim. Donec aliquam velit vitae mi dictum. </p>\r\n\r\n<img src=\"http://www.winda.poznan.pl/wp-content/uploads/2015/04/home_lawyer_specialist.jpg\" alt=\"\"/>\r\n\r\nScott Adams\r\n\r\nLawyer\r\n\r\nVitae adipiscing turpis. Aenean ligula nibh, molestie id viverra a, dapibus at dolor.\r\n\r\nnoreply@envato.com\r\n\r\nhttp://facebook.com\r\n\r\nhttp://twitter.com/\r\n\r\nhttp://www.linkedin.com/\r\n\r\nvertical\r\n\r\n");
INSERT INTO `wp_postmeta` VALUES("158", "49", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("159", "50", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("160", "50", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("161", "50", "mfn-post-hide-content", "0");
INSERT INTO `wp_postmeta` VALUES("162", "50", "mfn-post-custom-layout", "0");
INSERT INTO `wp_postmeta` VALUES("163", "50", "mfn-post-slider", "0");
INSERT INTO `wp_postmeta` VALUES("164", "50", "mfn-post-slider-layer", "0");
INSERT INTO `wp_postmeta` VALUES("165", "50", "mfn-post-menu", "0");
INSERT INTO `wp_postmeta` VALUES("166", "50", "mfn-post-one-page", "0");
INSERT INTO `wp_postmeta` VALUES("167", "50", "mfn-post-hide-title", "1");
INSERT INTO `wp_postmeta` VALUES("168", "50", "mfn-post-remove-padding", "1");
INSERT INTO `wp_postmeta` VALUES("170", "50", "mfn-page-items-seo", "Heading\r\n\r\n[image src=\"http://www.winda.poznan.pl/wp-content/uploads/2015/04/home_lawyer_about.png\" border=\"0\"]\r\n[divider height=\"20\"]\r\n<h2 style=\"color: #5F3923;\">Am nec tellus a odio tincidunt auctor a ornare odio. Sed non mauris vitae erat consequat auctor eu in elit. Class aptent taciti sociosqu ad litora torquent</p>\r\n\r\ncenter\r\n\r\n<div style=\"padding: 30px 6% 0px; border-right: 1px solid #ccc;\"> \r\n<h2>Class aptent taciti<br>socios litora torquent per</h2>\r\n[divider height=\"40\"]\r\n[one_second]\r\n[image src=\"http://www.winda.poznan.pl/wp-content/uploads/2015/04/home_lawyer_specialist.jpg\" border=\"0\"]\r\n[divider height=\"20\"]\r\n<p class=\"big\">Proin condimentum fermentum nunc. Etiam pharetra, erat sed fermentum feugiat, velit mauris egestas quam, ut aliquam massa nisl quis neque. Suspendisse in orci enim. Telis dapibus condimentum sit amet a augue. Sed non neque elit. Sed ut imperdiet nisi. Proin condimentum fermentum nunc. Etiam pharetra, erat sed fermentum feugiat velit.</p>\r\n[/one_second]\r\n[one_second]\r\n<p class=\"big\"> Aenean sollicitudin, lorem quis bibendum auctor, nisi elit consequat ipsum, nec sagittis sem nibh id elit. Duis sed odio sit amet nibh vulputate cursus a sit amet mauris.</p>\r\n<p class=\"big\">Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt auctor a ornare odio. Sed non  mauris vitae erat consequat auctor eu in elit. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Mauris in erat justo. Nullam ac urna eu felis dapibus condimentum sit amet a augue. Sed non neque elit. Sed ut imperdiet nisi. Proin condimentum fermentum nunc. Etiam pharetra, erat sed fermentum feugiat, velit mauris egestas quam, ut aliquam.</p>\r\n[/one_second]\r\n[divider height=\"1\"]\r\n</div>\r\n\r\n<div style=\"padding: 30px 6% 0px;\"> \r\n<h2>Etiam pharetra erat <br />fermen tum feugiat velit</h2>\r\n[divider height=\"40\"]\r\n[one_second]\r\n<p class=\"big\">Aenean sollicitudin, lorem quis bibendum auctor, nisi elit consequat ipsum, nec sagittis sem nibh id elit. Duis sed odio sit amet nibh vulputate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt auctor a ornare odio. Sed non  mauris vitae erat consequat auctor eu in elit. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Mauris in erat justo.</p>\r\n<p class=\"big\">Nullam ac urna eu felis dapibus condimentum sit amet a augue. Sed non neque elit. Sed ut imperdiet nisi. Proin condimentum fermentum nunc. Etiam pharetra, erat sed fermentum feugiat, velit mauris egestas quam, ut aliquam massa nisl quis neque.</p>\r\n[/one_second]\r\n[one_second]\r\n<p class=\"big\">Nam nec tellus a odio tincidunt auctor a ornare odio. Sed non  mauris vitae erat consequat auctor eu in elit. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Mauris in erat justo. Nullam ac urna eu felis dapibus condimentum sit amet a augue. Sed non neque elit. Sed ut imperdiet nisi. Proin condimentum fermentum nunc. Etiam pharetra, erat sed fermentum feugiat, velit mauris egestas quam, ut aliquam massa nisl quis neque. Suspendisse in orci enim.</p>\r\n[/one_second]\r\n</div>\r\n\r\nHeading\r\n\r\n<h2 class=\"themecolor\">Become our partner</h2>\r\n[divider height=\"30\"]\r\n<p style=\"font-size: 17px; line-height: 25px; margin: 0 7% 30px; color: #845235;\">Psum, nec sagittis sem nibh id elit. Duis sed odio sit amet nibh vulputate<br />cursus a sit amet mauris. Morbi accumsan ipsum velit.</P>\r\n[button title=\"Go to contact\" link=\"#\"  color=\"theme\" large=\"1\"]\r\n\r\ncenter\r\n\r\n");
INSERT INTO `wp_postmeta` VALUES("171", "51", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("172", "51", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("173", "51", "mfn-post-hide-content", "0");
INSERT INTO `wp_postmeta` VALUES("174", "51", "mfn-post-custom-layout", "0");
INSERT INTO `wp_postmeta` VALUES("175", "51", "mfn-post-slider", "0");
INSERT INTO `wp_postmeta` VALUES("176", "51", "mfn-post-slider-layer", "0");
INSERT INTO `wp_postmeta` VALUES("177", "51", "mfn-post-menu", "0");
INSERT INTO `wp_postmeta` VALUES("178", "51", "mfn-post-one-page", "0");
INSERT INTO `wp_postmeta` VALUES("179", "51", "mfn-post-hide-title", "1");
INSERT INTO `wp_postmeta` VALUES("180", "51", "mfn-post-remove-padding", "1");
INSERT INTO `wp_postmeta` VALUES("182", "51", "mfn-page-items-seo", "Heading\r\n\r\n<h3 style=\"margin: 0 6%;\">Duis sed odio sit amet nibh vulputate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt auctor a ornare odio. Sed non  mauris vitae erat consequat auctor eu in elit. </h3>\r\n\r\ncenter\r\n\r\n30\r\n\r\ndefault\r\n\r\nhttp://www.winda.poznan.pl/wp-content/uploads/2015/04/home_lawyer_list_1.png\r\n\r\nright\r\n\r\n<div style=\"border-left: 1px solid #ccc; margin-left: 4%; padding: 0px 0px 0px 7%;\">\r\n<h3>Quisque cursus</h3>\r\n<p class=\"big\">Pellentesque eget, bibendum a, gravida ullamcorper quam. Nullam viverra consectetuer. Quisque cursus et, porttitor risus. Aliquam sem. In hendrerit nulla quam nunc, accumsan congue. Lorem ipsum primis in nibh vel risus. Sed vel lectus. Ut sagittis, ipsum quam.</p>\r\n<p style=\"color: #ababab;\">Aliquam erat ac ipsum. Integer aliquam purus. Quisque lorem tortor fringilla sed, vestibulum id, eleifend justo vel bibendum sapien massa ac turpis faucibus orci luctus non, consectetuer lobortis quis, varius in, purus. Integer ultrices posuere cubilia Curae, Nulla ipsum dolor lacus, suscipit adis.</p>\r\n</div>\r\n\r\ndefault\r\n\r\nhttp://www.winda.poznan.pl/wp-content/uploads/2015/04/home_lawyer_6.png\r\n\r\nright\r\n\r\n<div style=\"border-left: 1px solid #ccc; margin-left: 4%; padding: 0px 0px 0px 7%;\">\r\n<h3>Sed in faucibus</h3>\r\n<p class=\"big\">Aliquam consequat nunc. Etiam mollis luctus diam. Suspendisse est eu venenatis vitae, faucibus orci et odio. Donec sodales nulla. Suspendisse orci diam, tincidunt enim. Phasellus purus. Aliquam interdum ligula ut felis. Cum sociis natoque penatibus et interdum viverra. Cras tortor metus wisi, mollis nulla erat ornare facilisis risus.</p>\r\n<p style=\"color: #ababab;\">Nam nec tellus a odio tincidunt auctor a ornare odio. Sed non mauris vitae erat consequat auctor eu in elit. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Mauris in erat justo. Nullam ac urna eu felis dapibus condimentum sit amet a augue.</p>\r\n</div>\r\n\r\ndefault\r\n\r\nhttp://www.winda.poznan.pl/wp-content/uploads/2015/04/home_lawyer_5.png\r\n\r\nright\r\n\r\n<div style=\"border-left: 1px solid #ccc; margin-left: 4%; padding: 0px 0px 0px 7%;\">\r\n<h3>Integer ultricies</h3>\r\n<p class=\"big\">Mauris ut sapien magna orci lorem sapien, lacinia lacus. Nullam risus velit, scelerisque iaculis. In hac habitasse platea dictumst. Quisque eu lectus. Curabitur commodo. Curabitur urna fringilla orci. Sed nibh. Morbi feugiat lectus nulla eu condimentum eget, nunc. Fusce ullamcorper ac, molestie venenatis consequat. Curabitur ut metus. </p>\r\n<p style=\"color: #ababab;\">Aliquam erat ac ipsum. Integer aliquam purus. Quisque lorem tortor fringilla sed, vestibulum id, eleifend justo vel bibendum sapien massa ac turpis faucibus orci luctus non, consectetuer lobortis quis, varius in, purus. Integer ultrices posuere cubilia Curae, Nulla ipsum dolor lacus, suscipit adis.</p>\r\n</div>\r\n\r\ndefault\r\n\r\nhttp://www.winda.poznan.pl/wp-content/uploads/2015/04/home_lawyer_list_3.png\r\n\r\nright\r\n\r\n<div style=\"border-left: 1px solid #ccc; margin-left: 4%; padding: 0px 0px 0px 7%;\">\r\n<h3>Curabitus in elit</h3>\r\n<p class=\"big\">Nam hendrerit. Maecenas in faucibus a, gravida non, dictum libero, consectetuer lobortis magna blandit quam purus, dictum sed, eros. Morbi id purus. Aliquam erat volutpat. Nullam vulputate tempor posuere, nibh placerat nisl ac elit porttitor vel, ornare dolor nunc, at ante.</p>\r\n<p style=\"color: #ababab;\">Nam nec tellus a odio tincidunt auctor a ornare odio. Sed non mauris vitae erat consequat auctor eu in elit. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Mauris in erat justo. Nullam ac urna eu felis dapibus condimentum sit amet a augue.</p>\r\n</div>\r\n\r\nHeading\r\n\r\n<h2 class=\"themecolor\">Become our partner</h2>\r\n[divider height=\"30\"]\r\n<p style=\"font-size: 17px; line-height: 25px; margin: 0 7% 30px; color: #845235;\">Psum, nec sagittis sem nibh id elit. Duis sed odio sit amet nibh vulputate<br />cursus a sit amet mauris. Morbi accumsan ipsum velit.</P>\r\n[button title=\"Go to contact\" link=\"#\"  color=\"theme\" large=\"1\"]\r\n\r\ncenter\r\n\r\nfadeIn\r\n\r\n");
INSERT INTO `wp_postmeta` VALUES("195", "36", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("196", "36", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("197", "36", "mfn-post-hide-content", "0");
INSERT INTO `wp_postmeta` VALUES("198", "36", "mfn-post-custom-layout", "0");
INSERT INTO `wp_postmeta` VALUES("199", "36", "mfn-post-slider", "0");
INSERT INTO `wp_postmeta` VALUES("200", "36", "mfn-post-slider-layer", "0");
INSERT INTO `wp_postmeta` VALUES("201", "36", "mfn-post-menu", "0");
INSERT INTO `wp_postmeta` VALUES("202", "36", "mfn-post-one-page", "0");
INSERT INTO `wp_postmeta` VALUES("203", "36", "mfn-post-hide-title", "1");
INSERT INTO `wp_postmeta` VALUES("204", "36", "mfn-post-remove-padding", "1");
INSERT INTO `wp_postmeta` VALUES("206", "36", "mfn-page-items-seo", "<h3>BeLawyer</h4>\r\n<p class=\"big\">Level 13, 2 Elizabeth St,<br />\r\nMelbourne, Victoria 3000<br />\r\nAustralia</p>\r\n<table>\r\n<tr>\r\n<td>Mon-Fri</td>\r\n<td><b>10:00</b> a.m.</td>\r\n<td><b>10:30</b> p.m.</td>\r\n</tr>\r\n<tr>\r\n<td>Sat</td>\r\n<td><b>11:00</b> a.m.</td>\r\n<td><b>11:00</b> p.m.</td>\r\n</tr>\r\n<tr>\r\n<td>Sun</td>\r\n<td><b>10:30</b> a.m.</td>\r\n<td><b>10:00</b> p.m.</td>\r\n</tr>\r\n</table>\r\n\r\n-33.8710\r\n\r\n151.2039\r\n\r\n500\r\n\r\nR\r\n\r\nhttp://www.winda.poznan.pl/wp-content/uploads/2015/04/home_lawyer_pin.png\r\n\r\n[{\"featureType\":\"road\",\"elementType\":\"labels\",\"stylers\":[{\"visibility\":\"off\"}]},{\"featureType\":\"poi\",\"elementType\":\"labels\",\"stylers\":[{\"visibility\":\"off\"}]},{\"featureType\":\"transit\",\"elementType\":\"labels.text\",\"stylers\":[{\"visibility\":\"off\"}]}]\r\n\r\n");
INSERT INTO `wp_postmeta` VALUES("207", "43", "_form", "<div class=\"column one-second\">[text* your-name placeholder \"Imię i nazwisko\"] </div>\n<div class=\"column one-second\">[email* your-email placeholder \"E-mail\"] </div>\n<div class=\"column one\">[text your-subject placeholder \"Temat\"] </div>\n<div class=\"column one\">[textarea your-message x4 placeholder \"Wiadomość\"]</div>\n[acceptance acceptance-762] Wyrażam zgodę na przetwarzanie moich danych osobowych zgodnie z ustawą o ochronie danych osobowych w związku z wysłaniem zapytania przez formularz kontaktowy. Podanie danych jest dobrowolne, ale niezbędne do przetworzenia zapytania. Zostałem /am poinformowany /a, że przysługuje mi prawo dostępu do swoich danych, możliwości ich poprawiania, żądania zaprzestania ich przetwarzania. Administratorem danych osobowych jest \"WINDA\" S.j. Zakład Elektromechaniki Dźwigowej,61-357 Poznań, ul. Gołężycka 26. [/acceptance]\n<div class=\"column one\">[submit \"Wyślij wiadomość\"]</div>");
INSERT INTO `wp_postmeta` VALUES("208", "43", "_mail", "a:9:{s:6:\"active\";b:1;s:7:\"subject\";s:37:\"Wiadomość z formularza kontaktowego\";s:6:\"sender\";s:32:\"[your-name] <winda.poznan@op.pl>\";s:9:\"recipient\";s:18:\"winda.poznan@op.pl\";s:4:\"body\";s:145:\"Od: [your-name] <[your-email]>\nTemat wiadomości: [your-subject]\n\nWiadomość:\n[your-message]\n\n--\nWiadomość wysłana z formularza kontaktowego.\";s:18:\"additional_headers\";s:22:\"Reply-To: [your-email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO `wp_postmeta` VALUES("209", "43", "_mail_2", "a:9:{s:6:\"active\";b:0;s:7:\"subject\";s:14:\"[your-subject]\";s:6:\"sender\";s:53:\"BeLawyer - BeTheme <wordpress@themes.muffingroup.com>\";s:9:\"recipient\";s:12:\"[your-email]\";s:4:\"body\";s:137:\"Message Body:\n[your-message]\n\n--\nThis e-mail was sent from a contact form on BeLawyer - BeTheme (http://themes.muffingroup.com/be/lawyer)\";s:18:\"additional_headers\";s:27:\"Reply-To: noreply@gmail.com\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO `wp_postmeta` VALUES("210", "43", "_messages", "a:23:{s:12:\"mail_sent_ok\";s:29:\"Wiadomość została wysłana\";s:12:\"mail_sent_ng\";s:33:\"Wiadomość nie została wysłana\";s:16:\"validation_error\";s:35:\"Wprowadzono nieprawidłową treść\";s:4:\"spam\";s:46:\"Wysłany formularz został oznaczony jako spam\";s:12:\"accept_terms\";s:65:\"Nie wyrażono zgody, która jest wymagana do wysłania formularza\";s:16:\"invalid_required\";s:38:\"Wymagane pole nie zostało wypełnione\";s:16:\"invalid_too_long\";s:41:\"Jedno z pól zawiera zbyt długą treść\";s:17:\"invalid_too_short\";s:42:\"Jedno z pól zawiera zbyt krótką treść\";s:12:\"invalid_date\";s:51:\"Format daty podany przez nadawcę jest niepoprawny.\";s:14:\"date_too_early\";s:50:\"Data jest wcześniejsza, niż okreśłone minimum.\";s:13:\"date_too_late\";s:49:\"Data jest późniejsza, niż określone maksimum.\";s:13:\"upload_failed\";s:53:\"Wgrywanie pliku nie powiodło się z jakiegoś powodu\";s:24:\"upload_file_type_invalid\";s:45:\"Przesłanie pliku danego typu jest zabronione\";s:21:\"upload_file_too_large\";s:30:\"Przesyłany plik jest za duży\";s:23:\"upload_failed_php_error\";s:58:\"Przesyłanie pliku nie powiodło się z powodu błędu PHP\";s:14:\"invalid_number\";s:53:\"Format liczby podany przez nadawcę jest niepoprawny.\";s:16:\"number_too_small\";s:45:\"Liczba jest mniejsza niż określone minimum.\";s:16:\"number_too_large\";s:47:\"Liczba jest większa, niż określone maksimum.\";s:23:\"quiz_answer_not_correct\";s:42:\"Nie udzielono poprawnej odpowiedzi na quiz\";s:17:\"captcha_not_match\";s:31:\"Your entered code is incorrect.\";s:13:\"invalid_email\";s:29:\"Adres e-mail jest niepoprawny\";s:11:\"invalid_url\";s:49:\"Adres URL podany przez nadawcę jest niepoprawny.\";s:11:\"invalid_tel\";s:54:\"Numer telefonu podany przez nadawcę jest niepoprawny.\";}");
INSERT INTO `wp_postmeta` VALUES("211", "43", "_additional_settings", "");
INSERT INTO `wp_postmeta` VALUES("212", "43", "_locale", "en_US");
INSERT INTO `wp_postmeta` VALUES("213", "53", "_wp_attached_file", "2015/04/our_team_4.jpg");
INSERT INTO `wp_postmeta` VALUES("214", "53", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:780;s:6:\"height\";i:780;s:4:\"file\";s:22:\"2015/04/our_team_4.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"our_team_4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"our_team_4-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"our_team_4-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:22:\"our_team_4-146x146.jpg\";s:5:\"width\";i:146;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:20:\"our_team_4-50x50.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"portfolio-mf\";a:4:{s:4:\"file\";s:22:\"our_team_4-780x750.jpg\";s:5:\"width\";i:780;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:22:\"our_team_4-780x375.jpg\";s:5:\"width\";i:780;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:22:\"our_team_4-480x750.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:22:\"our_team_4-780x450.jpg\";s:5:\"width\";i:780;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:22:\"our_team_4-780x480.jpg\";s:5:\"width\";i:780;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:20:\"our_team_4-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:20:\"our_team_4-75x75.jpg\";s:5:\"width\";i:75;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:22:\"our_team_4-780x470.jpg\";s:5:\"width\";i:780;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:20:\"our_team_4-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("215", "48", "_vc_post_settings", "a:2:{s:7:\"vc_grid\";a:0:{}s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("216", "54", "_wp_attached_file", "revslider/lawyer/slide-lawyer-bg.jpg");
INSERT INTO `wp_postmeta` VALUES("217", "54", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:570;s:4:\"file\";s:36:\"revslider/lawyer/slide-lawyer-bg.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"slide-lawyer-bg-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"slide-lawyer-bg-300x89.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:89;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:27:\"slide-lawyer-bg-768x228.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:228;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:28:\"slide-lawyer-bg-1024x304.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:304;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:26:\"slide-lawyer-bg-260x77.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:77;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:25:\"slide-lawyer-bg-50x15.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:15;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"portfolio-mf\";a:4:{s:4:\"file\";s:27:\"slide-lawyer-bg-960x570.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:570;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:27:\"slide-lawyer-bg-960x375.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:27:\"slide-lawyer-bg-480x570.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:570;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:28:\"slide-lawyer-bg-1160x450.jpg\";s:5:\"width\";i:1160;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:28:\"slide-lawyer-bg-1200x480.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:25:\"slide-lawyer-bg-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:26:\"slide-lawyer-bg-150x45.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:45;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:27:\"slide-lawyer-bg-890x470.jpg\";s:5:\"width\";i:890;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:25:\"slide-lawyer-bg-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("218", "55", "_wp_attached_file", "revslider/lawyer/slide-lawyer-1.png");
INSERT INTO `wp_postmeta` VALUES("219", "55", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1022;s:6:\"height\";i:92;s:4:\"file\";s:35:\"revslider/lawyer/slide-lawyer-1.png\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"slide-lawyer-1-150x92.png\";s:5:\"width\";i:150;s:6:\"height\";i:92;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"slide-lawyer-1-300x27.png\";s:5:\"width\";i:300;s:6:\"height\";i:27;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:25:\"slide-lawyer-1-768x69.png\";s:5:\"width\";i:768;s:6:\"height\";i:69;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:25:\"slide-lawyer-1-260x23.png\";s:5:\"width\";i:260;s:6:\"height\";i:23;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:23:\"slide-lawyer-1-50x5.png\";s:5:\"width\";i:50;s:6:\"height\";i:5;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"portfolio-mf\";a:4:{s:4:\"file\";s:25:\"slide-lawyer-1-960x92.png\";s:5:\"width\";i:960;s:6:\"height\";i:92;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:25:\"slide-lawyer-1-960x92.png\";s:5:\"width\";i:960;s:6:\"height\";i:92;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:25:\"slide-lawyer-1-480x92.png\";s:5:\"width\";i:480;s:6:\"height\";i:92;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:24:\"slide-lawyer-1-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:25:\"slide-lawyer-1-150x14.png\";s:5:\"width\";i:150;s:6:\"height\";i:14;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:25:\"slide-lawyer-1-890x92.png\";s:5:\"width\";i:890;s:6:\"height\";i:92;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:24:\"slide-lawyer-1-85x85.png\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("220", "56", "_wp_attached_file", "revslider/lawyer/slide-lawyer-2.png");
INSERT INTO `wp_postmeta` VALUES("221", "56", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:249;s:6:\"height\";i:214;s:4:\"file\";s:35:\"revslider/lawyer/slide-lawyer-2.png\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"slide-lawyer-2-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:26:\"slide-lawyer-2-170x146.png\";s:5:\"width\";i:170;s:6:\"height\";i:146;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:24:\"slide-lawyer-2-50x43.png\";s:5:\"width\";i:50;s:6:\"height\";i:43;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:24:\"slide-lawyer-2-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:24:\"slide-lawyer-2-87x75.png\";s:5:\"width\";i:87;s:6:\"height\";i:75;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:24:\"slide-lawyer-2-85x85.png\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("222", "57", "_wp_attached_file", "revslider/lawyer/slide-lawyer-3.png");
INSERT INTO `wp_postmeta` VALUES("223", "57", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:59;s:6:\"height\";i:196;s:4:\"file\";s:35:\"revslider/lawyer/slide-lawyer-3.png\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"slide-lawyer-3-59x150.png\";s:5:\"width\";i:59;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:25:\"slide-lawyer-3-44x146.png\";s:5:\"width\";i:44;s:6:\"height\";i:146;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:24:\"slide-lawyer-3-15x50.png\";s:5:\"width\";i:15;s:6:\"height\";i:50;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:24:\"slide-lawyer-3-59x80.png\";s:5:\"width\";i:59;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:24:\"slide-lawyer-3-23x75.png\";s:5:\"width\";i:23;s:6:\"height\";i:75;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:24:\"slide-lawyer-3-59x85.png\";s:5:\"width\";i:59;s:6:\"height\";i:85;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("224", "58", "_wp_attached_file", "revslider/lawyer/slide-lawyer-4.png");
INSERT INTO `wp_postmeta` VALUES("225", "58", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:187;s:6:\"height\";i:266;s:4:\"file\";s:35:\"revslider/lawyer/slide-lawyer-4.png\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"slide-lawyer-4-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:26:\"slide-lawyer-4-103x146.png\";s:5:\"width\";i:103;s:6:\"height\";i:146;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:24:\"slide-lawyer-4-35x50.png\";s:5:\"width\";i:35;s:6:\"height\";i:50;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:24:\"slide-lawyer-4-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:24:\"slide-lawyer-4-53x75.png\";s:5:\"width\";i:53;s:6:\"height\";i:75;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:24:\"slide-lawyer-4-85x85.png\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("226", "59", "_wp_attached_file", "revslider/lawyer/slide-lawyer-5.png");
INSERT INTO `wp_postmeta` VALUES("227", "59", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:276;s:6:\"height\";i:404;s:4:\"file\";s:35:\"revslider/lawyer/slide-lawyer-5.png\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"slide-lawyer-5-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"slide-lawyer-5-205x300.png\";s:5:\"width\";i:205;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:26:\"slide-lawyer-5-100x146.png\";s:5:\"width\";i:100;s:6:\"height\";i:146;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:24:\"slide-lawyer-5-34x50.png\";s:5:\"width\";i:34;s:6:\"height\";i:50;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:26:\"slide-lawyer-5-276x375.png\";s:5:\"width\";i:276;s:6:\"height\";i:375;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:24:\"slide-lawyer-5-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:24:\"slide-lawyer-5-51x75.png\";s:5:\"width\";i:51;s:6:\"height\";i:75;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:24:\"slide-lawyer-5-85x85.png\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("228", "49", "_edit_lock", "1638545327:1");
INSERT INTO `wp_postmeta` VALUES("229", "49", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("230", "49", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("231", "49", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:1:{s:10:\"shortcodes\";a:1:{s:48:\"1638545261871-71f12aae114bdb1562d27ea89dbb38bf-4\";a:3:{s:3:\"tag\";s:13:\"vc_media_grid\";s:4:\"atts\";a:6:{s:13:\"element_width\";s:1:\"3\";s:3:\"gap\";s:1:\"0\";s:4:\"item\";s:25:\"mediaGrid_ScaleInWithIcon\";s:25:\"initial_loading_animation\";s:12:\"bounceInLeft\";s:7:\"grid_id\";s:55:\"vc_gid:1638545261871-71f12aae114bdb1562d27ea89dbb38bf-4\";s:7:\"include\";s:63:\"232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247\";}s:7:\"content\";s:0:\"\";}}}}");
INSERT INTO `wp_postmeta` VALUES("234", "62", "_wp_attached_file", "2017/10/winda-tlo.jpg");
INSERT INTO `wp_postmeta` VALUES("235", "62", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1290;s:4:\"file\";s:21:\"2017/10/winda-tlo.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"winda-tlo-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"winda-tlo-300x202.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:21:\"winda-tlo-768x516.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:22:\"winda-tlo-1024x688.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:688;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:21:\"winda-tlo-217x146.jpg\";s:5:\"width\";i:217;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:19:\"winda-tlo-50x34.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:34;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"portfolio-mf\";a:4:{s:4:\"file\";s:21:\"winda-tlo-960x750.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:21:\"winda-tlo-960x375.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:21:\"winda-tlo-480x750.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:22:\"winda-tlo-1160x450.jpg\";s:5:\"width\";i:1160;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:22:\"winda-tlo-1200x480.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:19:\"winda-tlo-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:20:\"winda-tlo-112x75.jpg\";s:5:\"width\";i:112;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:21:\"winda-tlo-890x470.jpg\";s:5:\"width\";i:890;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:19:\"winda-tlo-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"3\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:9:\"DMC-TZ101\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"10\";s:3:\"iso\";s:4:\"1600\";s:13:\"shutter_speed\";s:17:\"0.066666666666667\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("236", "49", "mfn-post-layout", "no-sidebar");
INSERT INTO `wp_postmeta` VALUES("237", "49", "mfn-post-slider-shortcode", "[rev_slider lawyer]");
INSERT INTO `wp_postmeta` VALUES("238", "49", "_wpb_shortcodes_custom_css", ".vc_custom_1507034725651{background-color: #00970a !important;}.vc_custom_1638545313969{background: #00970a url(https://www.winda.poznan.pl/wp-content/uploads/2015/04/20100311030009DSC_0759-1.jpg?id=85) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}.vc_custom_1507130856903{background-color: #00970a !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}.vc_custom_1510309948088{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}.vc_custom_1510309966538{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-bottom: 30px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}.vc_custom_1510309982460{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}.vc_custom_1507037364707{background-position: center !important;background-repeat: no-repeat !important;background-size: contain !important;}.vc_custom_1507037364707{background-position: center !important;background-repeat: no-repeat !important;background-size: contain !important;}");
INSERT INTO `wp_postmeta` VALUES("239", "68", "_wp_attached_file", "2015/04/20100311030051Custom-Name-003.jpg");
INSERT INTO `wp_postmeta` VALUES("240", "68", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:602;s:4:\"file\";s:41:\"2015/04/20100311030051Custom-Name-003.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:41:\"20100311030051Custom-Name-003-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:41:\"20100311030051Custom-Name-003-199x300.jpg\";s:5:\"width\";i:199;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:40:\"20100311030051Custom-Name-003-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:39:\"20100311030051Custom-Name-003-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:41:\"20100311030051Custom-Name-003-400x375.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:41:\"20100311030051Custom-Name-003-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:41:\"20100311030051Custom-Name-003-400x480.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:39:\"20100311030051Custom-Name-003-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:39:\"20100311030051Custom-Name-003-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:41:\"20100311030051Custom-Name-003-400x470.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:39:\"20100311030051Custom-Name-003-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("241", "71", "_wp_attached_file", "2015/04/im2.jpg");
INSERT INTO `wp_postmeta` VALUES("242", "71", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:106;s:6:\"height\";i:200;s:4:\"file\";s:15:\"2015/04/im2.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"im2-106x150.jpg\";s:5:\"width\";i:106;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:14:\"im2-77x146.jpg\";s:5:\"width\";i:77;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:13:\"im2-27x50.jpg\";s:5:\"width\";i:27;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:13:\"im2-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:13:\"im2-40x75.jpg\";s:5:\"width\";i:40;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:13:\"im2-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("244", "77", "_wp_attached_file", "2015/04/20100311030038Custom-Name-002.jpg");
INSERT INTO `wp_postmeta` VALUES("245", "77", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:600;s:4:\"file\";s:41:\"2015/04/20100311030038Custom-Name-002.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:41:\"20100311030038Custom-Name-002-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:41:\"20100311030038Custom-Name-002-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:40:\"20100311030038Custom-Name-002-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:39:\"20100311030038Custom-Name-002-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:41:\"20100311030038Custom-Name-002-400x375.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:41:\"20100311030038Custom-Name-002-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:41:\"20100311030038Custom-Name-002-400x480.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:39:\"20100311030038Custom-Name-002-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:39:\"20100311030038Custom-Name-002-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:41:\"20100311030038Custom-Name-002-400x470.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:39:\"20100311030038Custom-Name-002-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("246", "78", "_wp_attached_file", "2015/04/20100311030104Custom-Name-004.jpg");
INSERT INTO `wp_postmeta` VALUES("247", "78", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:399;s:4:\"file\";s:41:\"2015/04/20100311030104Custom-Name-004.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:41:\"20100311030104Custom-Name-004-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:41:\"20100311030104Custom-Name-004-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:41:\"20100311030104Custom-Name-004-220x146.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:39:\"20100311030104Custom-Name-004-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:41:\"20100311030104Custom-Name-004-600x375.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:41:\"20100311030104Custom-Name-004-480x399.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:399;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:39:\"20100311030104Custom-Name-004-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:40:\"20100311030104Custom-Name-004-113x75.jpg\";s:5:\"width\";i:113;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:39:\"20100311030104Custom-Name-004-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("248", "79", "_wp_attached_file", "2015/04/20100311030115Custom-Name-005.jpg");
INSERT INTO `wp_postmeta` VALUES("249", "79", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:602;s:4:\"file\";s:41:\"2015/04/20100311030115Custom-Name-005.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:41:\"20100311030115Custom-Name-005-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:41:\"20100311030115Custom-Name-005-199x300.jpg\";s:5:\"width\";i:199;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:40:\"20100311030115Custom-Name-005-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:39:\"20100311030115Custom-Name-005-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:41:\"20100311030115Custom-Name-005-400x375.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:41:\"20100311030115Custom-Name-005-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:41:\"20100311030115Custom-Name-005-400x480.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:39:\"20100311030115Custom-Name-005-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:39:\"20100311030115Custom-Name-005-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:41:\"20100311030115Custom-Name-005-400x470.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:39:\"20100311030115Custom-Name-005-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("250", "80", "_wp_attached_file", "2015/04/20100411110703Custom-Name-007.jpg");
INSERT INTO `wp_postmeta` VALUES("251", "80", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:399;s:4:\"file\";s:41:\"2015/04/20100411110703Custom-Name-007.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:41:\"20100411110703Custom-Name-007-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:41:\"20100411110703Custom-Name-007-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:41:\"20100411110703Custom-Name-007-220x146.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:39:\"20100411110703Custom-Name-007-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:41:\"20100411110703Custom-Name-007-600x375.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:41:\"20100411110703Custom-Name-007-480x399.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:399;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:39:\"20100411110703Custom-Name-007-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:40:\"20100411110703Custom-Name-007-113x75.jpg\";s:5:\"width\";i:113;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:39:\"20100411110703Custom-Name-007-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("254", "85", "_wp_attached_file", "2015/04/20100311030009DSC_0759-1.jpg");
INSERT INTO `wp_postmeta` VALUES("255", "85", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:399;s:4:\"file\";s:36:\"2015/04/20100311030009DSC_0759-1.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"20100311030009DSC_0759-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:36:\"20100311030009DSC_0759-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:36:\"20100311030009DSC_0759-1-220x146.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:34:\"20100311030009DSC_0759-1-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:36:\"20100311030009DSC_0759-1-600x375.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:36:\"20100311030009DSC_0759-1-480x399.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:399;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:34:\"20100311030009DSC_0759-1-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:35:\"20100311030009DSC_0759-1-113x75.jpg\";s:5:\"width\";i:113;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:34:\"20100311030009DSC_0759-1-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("256", "92", "_wp_attached_file", "2015/04/20100411110508Custom-Name-006.jpg");
INSERT INTO `wp_postmeta` VALUES("257", "92", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:600;s:4:\"file\";s:41:\"2015/04/20100411110508Custom-Name-006.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:41:\"20100411110508Custom-Name-006-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:41:\"20100411110508Custom-Name-006-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:40:\"20100411110508Custom-Name-006-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:39:\"20100411110508Custom-Name-006-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:41:\"20100411110508Custom-Name-006-400x375.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:41:\"20100411110508Custom-Name-006-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:41:\"20100411110508Custom-Name-006-400x480.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:39:\"20100411110508Custom-Name-006-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:39:\"20100411110508Custom-Name-006-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:41:\"20100411110508Custom-Name-006-400x470.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:39:\"20100411110508Custom-Name-006-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("258", "93", "_wp_attached_file", "2015/04/20100411110716Custom-Name-008.jpg");
INSERT INTO `wp_postmeta` VALUES("259", "93", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:400;s:4:\"file\";s:41:\"2015/04/20100411110716Custom-Name-008.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:41:\"20100411110716Custom-Name-008-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:41:\"20100411110716Custom-Name-008-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:41:\"20100411110716Custom-Name-008-219x146.jpg\";s:5:\"width\";i:219;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:39:\"20100411110716Custom-Name-008-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:41:\"20100411110716Custom-Name-008-600x375.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:41:\"20100411110716Custom-Name-008-480x400.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:39:\"20100411110716Custom-Name-008-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:40:\"20100411110716Custom-Name-008-113x75.jpg\";s:5:\"width\";i:113;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:39:\"20100411110716Custom-Name-008-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("260", "94", "_wp_attached_file", "2015/04/20100411110755DSC_0061.jpg");
INSERT INTO `wp_postmeta` VALUES("261", "94", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:399;s:4:\"file\";s:34:\"2015/04/20100411110755DSC_0061.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411110755DSC_0061-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411110755DSC_0061-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411110755DSC_0061-220x146.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411110755DSC_0061-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411110755DSC_0061-600x375.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:34:\"20100411110755DSC_0061-480x399.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:399;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411110755DSC_0061-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:33:\"20100411110755DSC_0061-113x75.jpg\";s:5:\"width\";i:113;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411110755DSC_0061-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("262", "95", "_wp_attached_file", "2015/04/20100411110820DSC_0068.jpg");
INSERT INTO `wp_postmeta` VALUES("263", "95", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:602;s:4:\"file\";s:34:\"2015/04/20100411110820DSC_0068.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411110820DSC_0068-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411110820DSC_0068-199x300.jpg\";s:5:\"width\";i:199;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:33:\"20100411110820DSC_0068-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411110820DSC_0068-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411110820DSC_0068-400x375.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:34:\"20100411110820DSC_0068-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:34:\"20100411110820DSC_0068-400x480.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411110820DSC_0068-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:32:\"20100411110820DSC_0068-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:34:\"20100411110820DSC_0068-400x470.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411110820DSC_0068-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("264", "96", "_wp_attached_file", "2017/10/20100411110755DSC_0061-everglow.jpg");
INSERT INTO `wp_postmeta` VALUES("265", "96", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:399;s:4:\"file\";s:43:\"2017/10/20100411110755DSC_0061-everglow.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:43:\"20100411110755DSC_0061-everglow-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:43:\"20100411110755DSC_0061-everglow-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:43:\"20100411110755DSC_0061-everglow-220x146.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:41:\"20100411110755DSC_0061-everglow-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:43:\"20100411110755DSC_0061-everglow-600x375.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:43:\"20100411110755DSC_0061-everglow-480x399.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:399;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:41:\"20100411110755DSC_0061-everglow-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:42:\"20100411110755DSC_0061-everglow-113x75.jpg\";s:5:\"width\";i:113;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:41:\"20100411110755DSC_0061-everglow-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("266", "96", "vc-applied-image-filter", "everglow");
INSERT INTO `wp_postmeta` VALUES("267", "49", "_wpb_post_custom_css", "#naglowek {font-size: 30px;font-family: lato;}");
INSERT INTO `wp_postmeta` VALUES("268", "101", "_wp_attached_file", "2015/04/20131103045218CI01000001.jpg");
INSERT INTO `wp_postmeta` VALUES("269", "101", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:551;s:6:\"height\";i:800;s:4:\"file\";s:36:\"2015/04/20131103045218CI01000001.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"20131103045218CI01000001-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:36:\"20131103045218CI01000001-207x300.jpg\";s:5:\"width\";i:207;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:36:\"20131103045218CI01000001-101x146.jpg\";s:5:\"width\";i:101;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:34:\"20131103045218CI01000001-34x50.jpg\";s:5:\"width\";i:34;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"portfolio-mf\";a:4:{s:4:\"file\";s:36:\"20131103045218CI01000001-551x750.jpg\";s:5:\"width\";i:551;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:36:\"20131103045218CI01000001-551x375.jpg\";s:5:\"width\";i:551;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:36:\"20131103045218CI01000001-480x750.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:36:\"20131103045218CI01000001-551x450.jpg\";s:5:\"width\";i:551;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:36:\"20131103045218CI01000001-551x480.jpg\";s:5:\"width\";i:551;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:34:\"20131103045218CI01000001-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:34:\"20131103045218CI01000001-52x75.jpg\";s:5:\"width\";i:52;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:36:\"20131103045218CI01000001-551x470.jpg\";s:5:\"width\";i:551;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:34:\"20131103045218CI01000001-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"6.3\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1352471588\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"40\";s:3:\"iso\";s:3:\"640\";s:13:\"shutter_speed\";s:4:\"0.01\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("270", "102", "_wp_attached_file", "2015/04/20131103045244CI01000000.jpg");
INSERT INTO `wp_postmeta` VALUES("271", "102", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:555;s:6:\"height\";i:800;s:4:\"file\";s:36:\"2015/04/20131103045244CI01000000.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"20131103045244CI01000000-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:36:\"20131103045244CI01000000-208x300.jpg\";s:5:\"width\";i:208;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:36:\"20131103045244CI01000000-101x146.jpg\";s:5:\"width\";i:101;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:34:\"20131103045244CI01000000-35x50.jpg\";s:5:\"width\";i:35;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"portfolio-mf\";a:4:{s:4:\"file\";s:36:\"20131103045244CI01000000-555x750.jpg\";s:5:\"width\";i:555;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:36:\"20131103045244CI01000000-555x375.jpg\";s:5:\"width\";i:555;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:36:\"20131103045244CI01000000-480x750.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:36:\"20131103045244CI01000000-555x450.jpg\";s:5:\"width\";i:555;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:36:\"20131103045244CI01000000-555x480.jpg\";s:5:\"width\";i:555;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:34:\"20131103045244CI01000000-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:34:\"20131103045244CI01000000-52x75.jpg\";s:5:\"width\";i:52;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:36:\"20131103045244CI01000000-555x470.jpg\";s:5:\"width\";i:555;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:34:\"20131103045244CI01000000-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1352471457\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"40\";s:3:\"iso\";s:3:\"640\";s:13:\"shutter_speed\";s:5:\"0.008\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("272", "103", "_wp_attached_file", "2015/04/20131103045307CI01000002.jpg");
INSERT INTO `wp_postmeta` VALUES("273", "103", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:555;s:6:\"height\";i:734;s:4:\"file\";s:36:\"2015/04/20131103045307CI01000002.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"20131103045307CI01000002-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:36:\"20131103045307CI01000002-227x300.jpg\";s:5:\"width\";i:227;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:36:\"20131103045307CI01000002-110x146.jpg\";s:5:\"width\";i:110;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:34:\"20131103045307CI01000002-38x50.jpg\";s:5:\"width\";i:38;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:36:\"20131103045307CI01000002-555x375.jpg\";s:5:\"width\";i:555;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:36:\"20131103045307CI01000002-480x734.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:734;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:36:\"20131103045307CI01000002-555x450.jpg\";s:5:\"width\";i:555;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:36:\"20131103045307CI01000002-555x480.jpg\";s:5:\"width\";i:555;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:34:\"20131103045307CI01000002-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:34:\"20131103045307CI01000002-57x75.jpg\";s:5:\"width\";i:57;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:36:\"20131103045307CI01000002-555x470.jpg\";s:5:\"width\";i:555;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:34:\"20131103045307CI01000002-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"6.3\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1352471732\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"40\";s:3:\"iso\";s:3:\"800\";s:13:\"shutter_speed\";s:17:\"0.016666666666667\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("274", "36", "_edit_lock", "1551458831:1");
INSERT INTO `wp_postmeta` VALUES("275", "36", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("276", "36", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("277", "36", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("278", "50", "_edit_lock", "1508840928:1");
INSERT INTO `wp_postmeta` VALUES("279", "50", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("280", "50", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("281", "50", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("286", "51", "_edit_lock", "1510310606:1");
INSERT INTO `wp_postmeta` VALUES("287", "51", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("288", "51", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("289", "51", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("291", "43", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("295", "50", "_wpb_shortcodes_custom_css", ".vc_custom_1507210280513{background-color: #f4f4f4 !important;}");
INSERT INTO `wp_postmeta` VALUES("298", "117", "_wp_attached_file", "2015/04/winda-tlo2.jpg");
INSERT INTO `wp_postmeta` VALUES("299", "117", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1503;s:6:\"height\";i:1010;s:4:\"file\";s:22:\"2015/04/winda-tlo2.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"winda-tlo2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"winda-tlo2-300x202.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"winda-tlo2-768x516.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:23:\"winda-tlo2-1024x688.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:688;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:22:\"winda-tlo2-217x146.jpg\";s:5:\"width\";i:217;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:20:\"winda-tlo2-50x34.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:34;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"portfolio-mf\";a:4:{s:4:\"file\";s:22:\"winda-tlo2-960x750.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:22:\"winda-tlo2-960x375.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:22:\"winda-tlo2-480x750.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:23:\"winda-tlo2-1160x450.jpg\";s:5:\"width\";i:1160;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:23:\"winda-tlo2-1200x480.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:20:\"winda-tlo2-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:21:\"winda-tlo2-112x75.jpg\";s:5:\"width\";i:112;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:22:\"winda-tlo2-890x470.jpg\";s:5:\"width\";i:890;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:20:\"winda-tlo2-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"3\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:9:\"DMC-TZ101\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"10\";s:3:\"iso\";s:4:\"1600\";s:13:\"shutter_speed\";s:17:\"0.066666666666667\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("300", "121", "_wp_attached_file", "2017/10/3037.jpg");
INSERT INTO `wp_postmeta` VALUES("301", "121", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1600;s:6:\"height\";i:1066;s:4:\"file\";s:16:\"2017/10/3037.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"3037-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"3037-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:16:\"3037-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:17:\"3037-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:16:\"3037-219x146.jpg\";s:5:\"width\";i:219;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:14:\"3037-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"portfolio-mf\";a:4:{s:4:\"file\";s:16:\"3037-960x750.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:16:\"3037-960x375.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:16:\"3037-480x750.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:17:\"3037-1160x450.jpg\";s:5:\"width\";i:1160;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:17:\"3037-1200x480.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:14:\"3037-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:15:\"3037-113x75.jpg\";s:5:\"width\";i:113;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:16:\"3037-890x470.jpg\";s:5:\"width\";i:890;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:14:\"3037-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"5.6\";s:6:\"credit\";s:8:\"Thiet Vu\";s:6:\"camera\";s:12:\"Canon EOS 6D\";s:7:\"caption\";s:113:\"Empty lobby of condominium building. Elevators in hall of modern business center. Stylish interior design concept\";s:17:\"created_timestamp\";s:10:\"1487334009\";s:9:\"copyright\";s:8:\"Thiet Vu\";s:12:\"focal_length\";s:2:\"24\";s:3:\"iso\";s:3:\"400\";s:13:\"shutter_speed\";s:5:\"0.008\";s:5:\"title\";s:29:\"Lobby of condominium building\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:42:{i:0;s:8:\"interior\";i:1;s:6:\"design\";i:2;s:6:\"nobody\";i:3;s:8:\"elevator\";i:4;s:4:\"hall\";i:5;s:5:\"hotel\";i:6;s:6:\"office\";i:7;s:6:\"inside\";i:8;s:6:\"indoor\";i:9;s:5:\"light\";i:10;s:5:\"style\";i:11;s:5:\"plant\";i:12;s:4:\"lift\";i:13;s:4:\"door\";i:14;s:8:\"entrance\";i:15;s:5:\"empty\";i:16;s:12:\"construction\";i:17;s:12:\"contemporary\";i:18;s:5:\"level\";i:19;s:5:\"lobby\";i:20;s:6:\"modern\";i:21;s:11:\"condominium\";i:22;s:11:\"residential\";i:23;s:5:\"house\";i:24;s:10:\"commercial\";i:25;s:6:\"marble\";i:26;s:12:\"architecture\";i:27;s:7:\"renting\";i:28;s:10:\"decoration\";i:29;s:8:\"spacious\";i:30;s:5:\"space\";i:31;s:15:\"business center\";i:32;s:7:\"company\";i:33;s:8:\"building\";i:34;s:6:\"public\";i:35;s:5:\"clean\";i:36;s:4:\"room\";i:37;s:7:\"project\";i:38;s:4:\"seat\";i:39;s:7:\"hallway\";i:40;s:13:\"accommodation\";i:41;s:7:\"ceiling\";}}}");
INSERT INTO `wp_postmeta` VALUES("302", "51", "_wpb_post_custom_css", "#naglowek {font-size: 40px;}");
INSERT INTO `wp_postmeta` VALUES("303", "51", "_wpb_shortcodes_custom_css", ".vc_custom_1510309779781{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}.vc_custom_1510309760801{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}.vc_custom_1510309797442{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}");
INSERT INTO `wp_postmeta` VALUES("310", "127", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("311", "127", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("312", "127", "_edit_lock", "1508930865:1");
INSERT INTO `wp_postmeta` VALUES("313", "127", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("314", "127", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("315", "127", "mfn-post-hide-content", "0");
INSERT INTO `wp_postmeta` VALUES("316", "127", "mfn-post-custom-layout", "0");
INSERT INTO `wp_postmeta` VALUES("317", "127", "mfn-post-slider", "0");
INSERT INTO `wp_postmeta` VALUES("318", "127", "mfn-post-slider-layer", "0");
INSERT INTO `wp_postmeta` VALUES("319", "127", "mfn-post-menu", "0");
INSERT INTO `wp_postmeta` VALUES("320", "127", "mfn-post-one-page", "0");
INSERT INTO `wp_postmeta` VALUES("321", "127", "mfn-post-hide-title", "1");
INSERT INTO `wp_postmeta` VALUES("322", "127", "mfn-post-remove-padding", "1");
INSERT INTO `wp_postmeta` VALUES("323", "127", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("324", "141", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:1:{s:10:\"shortcodes\";a:1:{s:48:\"1508233589656-69ae6b1e628fc86a416ab05d79a9077c-5\";a:3:{s:3:\"tag\";s:13:\"vc_media_grid\";s:4:\"atts\";a:5:{s:13:\"element_width\";s:1:\"2\";s:3:\"gap\";s:1:\"0\";s:4:\"item\";s:23:\"mediaGrid_SimpleOverlay\";s:7:\"grid_id\";s:55:\"vc_gid:1508233589656-69ae6b1e628fc86a416ab05d79a9077c-5\";s:7:\"include\";s:383:\"219,218,217,216,215,214,213,206,207,208,209,211,212,205,204,203,202,201,200,199,192,193,194,195,196,197,198,191,190,189,188,187,186,185,178,179,180,181,182,183,184,177,176,175,174,173,172,171,164,165,166,167,168,169,170,162,163,161,160,159,158,157,150,151,152,153,154,155,156,149,148,147,146,145,144,252,250,251,249,247,248,239,241,242,243,244,245,246,240,238,236,237,235,234,233,232\";}s:7:\"content\";s:0:\"\";}}}}");
INSERT INTO `wp_postmeta` VALUES("325", "141", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("326", "141", "_edit_lock", "1508233597:1");
INSERT INTO `wp_postmeta` VALUES("327", "141", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("328", "141", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("329", "141", "mfn-post-hide-content", "0");
INSERT INTO `wp_postmeta` VALUES("330", "141", "mfn-post-custom-layout", "0");
INSERT INTO `wp_postmeta` VALUES("331", "141", "mfn-post-slider", "0");
INSERT INTO `wp_postmeta` VALUES("332", "141", "mfn-post-slider-layer", "0");
INSERT INTO `wp_postmeta` VALUES("333", "141", "mfn-post-menu", "0");
INSERT INTO `wp_postmeta` VALUES("334", "141", "mfn-post-one-page", "0");
INSERT INTO `wp_postmeta` VALUES("335", "141", "mfn-post-hide-title", "1");
INSERT INTO `wp_postmeta` VALUES("336", "141", "mfn-post-remove-padding", "1");
INSERT INTO `wp_postmeta` VALUES("337", "141", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("338", "141", "_wpb_post_custom_css", "#naglowek {font-size: 30px;}");
INSERT INTO `wp_postmeta` VALUES("339", "144", "_wp_attached_file", "2017/10/20100311030038Custom-Name-002.jpg");
INSERT INTO `wp_postmeta` VALUES("340", "144", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:600;s:4:\"file\";s:41:\"2017/10/20100311030038Custom-Name-002.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:41:\"20100311030038Custom-Name-002-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:41:\"20100311030038Custom-Name-002-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:40:\"20100311030038Custom-Name-002-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:39:\"20100311030038Custom-Name-002-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:41:\"20100311030038Custom-Name-002-400x375.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:41:\"20100311030038Custom-Name-002-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:41:\"20100311030038Custom-Name-002-400x480.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:39:\"20100311030038Custom-Name-002-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:39:\"20100311030038Custom-Name-002-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:41:\"20100311030038Custom-Name-002-400x470.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:39:\"20100311030038Custom-Name-002-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("341", "145", "_wp_attached_file", "2017/10/20100311030051Custom-Name-003.jpg");
INSERT INTO `wp_postmeta` VALUES("342", "145", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:602;s:4:\"file\";s:41:\"2017/10/20100311030051Custom-Name-003.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:41:\"20100311030051Custom-Name-003-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:41:\"20100311030051Custom-Name-003-199x300.jpg\";s:5:\"width\";i:199;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:40:\"20100311030051Custom-Name-003-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:39:\"20100311030051Custom-Name-003-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:41:\"20100311030051Custom-Name-003-400x375.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:41:\"20100311030051Custom-Name-003-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:41:\"20100311030051Custom-Name-003-400x480.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:39:\"20100311030051Custom-Name-003-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:39:\"20100311030051Custom-Name-003-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:41:\"20100311030051Custom-Name-003-400x470.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:39:\"20100311030051Custom-Name-003-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("343", "146", "_wp_attached_file", "2017/10/20100311030104Custom-Name-004.jpg");
INSERT INTO `wp_postmeta` VALUES("344", "146", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:399;s:4:\"file\";s:41:\"2017/10/20100311030104Custom-Name-004.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:41:\"20100311030104Custom-Name-004-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:41:\"20100311030104Custom-Name-004-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:41:\"20100311030104Custom-Name-004-220x146.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:39:\"20100311030104Custom-Name-004-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:41:\"20100311030104Custom-Name-004-600x375.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:41:\"20100311030104Custom-Name-004-480x399.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:399;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:39:\"20100311030104Custom-Name-004-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:40:\"20100311030104Custom-Name-004-113x75.jpg\";s:5:\"width\";i:113;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:39:\"20100311030104Custom-Name-004-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("345", "147", "_wp_attached_file", "2017/10/20100311030115Custom-Name-005.jpg");
INSERT INTO `wp_postmeta` VALUES("346", "147", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:602;s:4:\"file\";s:41:\"2017/10/20100311030115Custom-Name-005.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:41:\"20100311030115Custom-Name-005-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:41:\"20100311030115Custom-Name-005-199x300.jpg\";s:5:\"width\";i:199;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:40:\"20100311030115Custom-Name-005-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:39:\"20100311030115Custom-Name-005-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:41:\"20100311030115Custom-Name-005-400x375.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:41:\"20100311030115Custom-Name-005-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:41:\"20100311030115Custom-Name-005-400x480.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:39:\"20100311030115Custom-Name-005-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:39:\"20100311030115Custom-Name-005-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:41:\"20100311030115Custom-Name-005-400x470.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:39:\"20100311030115Custom-Name-005-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("347", "148", "_wp_attached_file", "2017/10/20100411110508Custom-Name-006.jpg");
INSERT INTO `wp_postmeta` VALUES("348", "148", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:600;s:4:\"file\";s:41:\"2017/10/20100411110508Custom-Name-006.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:41:\"20100411110508Custom-Name-006-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:41:\"20100411110508Custom-Name-006-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:40:\"20100411110508Custom-Name-006-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:39:\"20100411110508Custom-Name-006-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:41:\"20100411110508Custom-Name-006-400x375.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:41:\"20100411110508Custom-Name-006-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:41:\"20100411110508Custom-Name-006-400x480.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:39:\"20100411110508Custom-Name-006-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:39:\"20100411110508Custom-Name-006-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:41:\"20100411110508Custom-Name-006-400x470.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:39:\"20100411110508Custom-Name-006-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("349", "149", "_wp_attached_file", "2017/10/20100411110703Custom-Name-007.jpg");
INSERT INTO `wp_postmeta` VALUES("350", "149", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:399;s:4:\"file\";s:41:\"2017/10/20100411110703Custom-Name-007.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:41:\"20100411110703Custom-Name-007-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:41:\"20100411110703Custom-Name-007-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:41:\"20100411110703Custom-Name-007-220x146.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:39:\"20100411110703Custom-Name-007-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:41:\"20100411110703Custom-Name-007-600x375.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:41:\"20100411110703Custom-Name-007-480x399.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:399;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:39:\"20100411110703Custom-Name-007-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:40:\"20100411110703Custom-Name-007-113x75.jpg\";s:5:\"width\";i:113;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:39:\"20100411110703Custom-Name-007-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("351", "150", "_wp_attached_file", "2017/10/20100411110716Custom-Name-008.jpg");
INSERT INTO `wp_postmeta` VALUES("352", "150", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:400;s:4:\"file\";s:41:\"2017/10/20100411110716Custom-Name-008.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:41:\"20100411110716Custom-Name-008-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:41:\"20100411110716Custom-Name-008-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:41:\"20100411110716Custom-Name-008-219x146.jpg\";s:5:\"width\";i:219;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:39:\"20100411110716Custom-Name-008-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:41:\"20100411110716Custom-Name-008-600x375.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:41:\"20100411110716Custom-Name-008-480x400.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:39:\"20100411110716Custom-Name-008-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:40:\"20100411110716Custom-Name-008-113x75.jpg\";s:5:\"width\";i:113;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:39:\"20100411110716Custom-Name-008-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("353", "151", "_wp_attached_file", "2017/10/20100411110755DSC_0061.jpg");
INSERT INTO `wp_postmeta` VALUES("354", "151", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:399;s:4:\"file\";s:34:\"2017/10/20100411110755DSC_0061.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411110755DSC_0061-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411110755DSC_0061-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411110755DSC_0061-220x146.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411110755DSC_0061-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411110755DSC_0061-600x375.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:34:\"20100411110755DSC_0061-480x399.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:399;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411110755DSC_0061-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:33:\"20100411110755DSC_0061-113x75.jpg\";s:5:\"width\";i:113;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411110755DSC_0061-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("355", "152", "_wp_attached_file", "2017/10/20100411110807DSC_0066.jpg");
INSERT INTO `wp_postmeta` VALUES("356", "152", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:602;s:4:\"file\";s:34:\"2017/10/20100411110807DSC_0066.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411110807DSC_0066-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411110807DSC_0066-199x300.jpg\";s:5:\"width\";i:199;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:33:\"20100411110807DSC_0066-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411110807DSC_0066-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411110807DSC_0066-400x375.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:34:\"20100411110807DSC_0066-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:34:\"20100411110807DSC_0066-400x480.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411110807DSC_0066-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:32:\"20100411110807DSC_0066-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:34:\"20100411110807DSC_0066-400x470.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411110807DSC_0066-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("357", "153", "_wp_attached_file", "2017/10/20100411110820DSC_0068.jpg");
INSERT INTO `wp_postmeta` VALUES("358", "153", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:602;s:4:\"file\";s:34:\"2017/10/20100411110820DSC_0068.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411110820DSC_0068-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411110820DSC_0068-199x300.jpg\";s:5:\"width\";i:199;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:33:\"20100411110820DSC_0068-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411110820DSC_0068-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411110820DSC_0068-400x375.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:34:\"20100411110820DSC_0068-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:34:\"20100411110820DSC_0068-400x480.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411110820DSC_0068-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:32:\"20100411110820DSC_0068-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:34:\"20100411110820DSC_0068-400x470.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411110820DSC_0068-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("359", "154", "_wp_attached_file", "2017/10/20100411110847DSC_0070.jpg");
INSERT INTO `wp_postmeta` VALUES("360", "154", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:399;s:4:\"file\";s:34:\"2017/10/20100411110847DSC_0070.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411110847DSC_0070-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411110847DSC_0070-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411110847DSC_0070-220x146.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411110847DSC_0070-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411110847DSC_0070-600x375.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:34:\"20100411110847DSC_0070-480x399.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:399;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411110847DSC_0070-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:33:\"20100411110847DSC_0070-113x75.jpg\";s:5:\"width\";i:113;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411110847DSC_0070-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("361", "155", "_wp_attached_file", "2017/10/20100411110900DSC_0076.jpg");
INSERT INTO `wp_postmeta` VALUES("362", "155", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:600;s:4:\"file\";s:34:\"2017/10/20100411110900DSC_0076.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411110900DSC_0076-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411110900DSC_0076-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:33:\"20100411110900DSC_0076-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411110900DSC_0076-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411110900DSC_0076-400x375.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:34:\"20100411110900DSC_0076-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:34:\"20100411110900DSC_0076-400x480.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411110900DSC_0076-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:32:\"20100411110900DSC_0076-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:34:\"20100411110900DSC_0076-400x470.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411110900DSC_0076-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("363", "156", "_wp_attached_file", "2017/10/20100411110915DSC_0003.jpg");
INSERT INTO `wp_postmeta` VALUES("364", "156", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:602;s:4:\"file\";s:34:\"2017/10/20100411110915DSC_0003.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411110915DSC_0003-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411110915DSC_0003-199x300.jpg\";s:5:\"width\";i:199;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:33:\"20100411110915DSC_0003-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411110915DSC_0003-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411110915DSC_0003-400x375.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:34:\"20100411110915DSC_0003-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:34:\"20100411110915DSC_0003-400x480.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411110915DSC_0003-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:32:\"20100411110915DSC_0003-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:34:\"20100411110915DSC_0003-400x470.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411110915DSC_0003-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("365", "157", "_wp_attached_file", "2017/10/20100411110926DSC_0005.jpg");
INSERT INTO `wp_postmeta` VALUES("366", "157", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:602;s:4:\"file\";s:34:\"2017/10/20100411110926DSC_0005.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411110926DSC_0005-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411110926DSC_0005-199x300.jpg\";s:5:\"width\";i:199;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:33:\"20100411110926DSC_0005-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411110926DSC_0005-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411110926DSC_0005-400x375.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:34:\"20100411110926DSC_0005-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:34:\"20100411110926DSC_0005-400x480.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411110926DSC_0005-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:32:\"20100411110926DSC_0005-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:34:\"20100411110926DSC_0005-400x470.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411110926DSC_0005-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("367", "158", "_wp_attached_file", "2017/10/20100411110936DSC_0007.jpg");
INSERT INTO `wp_postmeta` VALUES("368", "158", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:399;s:4:\"file\";s:34:\"2017/10/20100411110936DSC_0007.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411110936DSC_0007-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411110936DSC_0007-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411110936DSC_0007-220x146.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411110936DSC_0007-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411110936DSC_0007-600x375.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:34:\"20100411110936DSC_0007-480x399.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:399;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411110936DSC_0007-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:33:\"20100411110936DSC_0007-113x75.jpg\";s:5:\"width\";i:113;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411110936DSC_0007-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("369", "159", "_wp_attached_file", "2017/10/20100411110947DSC_0009.jpg");
INSERT INTO `wp_postmeta` VALUES("370", "159", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:602;s:4:\"file\";s:34:\"2017/10/20100411110947DSC_0009.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411110947DSC_0009-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411110947DSC_0009-199x300.jpg\";s:5:\"width\";i:199;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:33:\"20100411110947DSC_0009-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411110947DSC_0009-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411110947DSC_0009-400x375.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:34:\"20100411110947DSC_0009-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:34:\"20100411110947DSC_0009-400x480.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411110947DSC_0009-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:32:\"20100411110947DSC_0009-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:34:\"20100411110947DSC_0009-400x470.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411110947DSC_0009-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("371", "160", "_wp_attached_file", "2017/10/20100411110959DSC_0013.jpg");
INSERT INTO `wp_postmeta` VALUES("372", "160", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:602;s:4:\"file\";s:34:\"2017/10/20100411110959DSC_0013.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411110959DSC_0013-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411110959DSC_0013-199x300.jpg\";s:5:\"width\";i:199;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:33:\"20100411110959DSC_0013-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411110959DSC_0013-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411110959DSC_0013-400x375.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:34:\"20100411110959DSC_0013-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:34:\"20100411110959DSC_0013-400x480.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411110959DSC_0013-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:32:\"20100411110959DSC_0013-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:34:\"20100411110959DSC_0013-400x470.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411110959DSC_0013-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("373", "161", "_wp_attached_file", "2017/10/20100411111010DSC_0015.jpg");
INSERT INTO `wp_postmeta` VALUES("374", "161", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:399;s:4:\"file\";s:34:\"2017/10/20100411111010DSC_0015.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411111010DSC_0015-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411111010DSC_0015-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411111010DSC_0015-220x146.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411111010DSC_0015-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411111010DSC_0015-600x375.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:34:\"20100411111010DSC_0015-480x399.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:399;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411111010DSC_0015-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:33:\"20100411111010DSC_0015-113x75.jpg\";s:5:\"width\";i:113;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411111010DSC_0015-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("375", "162", "_wp_attached_file", "2017/10/20100411111023DSC_0018.jpg");
INSERT INTO `wp_postmeta` VALUES("376", "162", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:602;s:4:\"file\";s:34:\"2017/10/20100411111023DSC_0018.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411111023DSC_0018-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411111023DSC_0018-199x300.jpg\";s:5:\"width\";i:199;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:33:\"20100411111023DSC_0018-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411111023DSC_0018-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411111023DSC_0018-400x375.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:34:\"20100411111023DSC_0018-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:34:\"20100411111023DSC_0018-400x480.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411111023DSC_0018-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:32:\"20100411111023DSC_0018-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:34:\"20100411111023DSC_0018-400x470.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411111023DSC_0018-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("377", "163", "_wp_attached_file", "2017/10/20100411111037DSC_0022.jpg");
INSERT INTO `wp_postmeta` VALUES("378", "163", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:399;s:4:\"file\";s:34:\"2017/10/20100411111037DSC_0022.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411111037DSC_0022-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411111037DSC_0022-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411111037DSC_0022-220x146.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411111037DSC_0022-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411111037DSC_0022-600x375.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:34:\"20100411111037DSC_0022-480x399.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:399;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411111037DSC_0022-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:33:\"20100411111037DSC_0022-113x75.jpg\";s:5:\"width\";i:113;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411111037DSC_0022-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("379", "164", "_wp_attached_file", "2017/10/20100411111106DSC_0027.jpg");
INSERT INTO `wp_postmeta` VALUES("380", "164", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:600;s:4:\"file\";s:34:\"2017/10/20100411111106DSC_0027.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411111106DSC_0027-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411111106DSC_0027-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:33:\"20100411111106DSC_0027-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411111106DSC_0027-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411111106DSC_0027-400x375.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:34:\"20100411111106DSC_0027-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:34:\"20100411111106DSC_0027-400x480.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411111106DSC_0027-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:32:\"20100411111106DSC_0027-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:34:\"20100411111106DSC_0027-400x470.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411111106DSC_0027-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("381", "165", "_wp_attached_file", "2017/10/20100411111449DSC_0028.jpg");
INSERT INTO `wp_postmeta` VALUES("382", "165", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:600;s:4:\"file\";s:34:\"2017/10/20100411111449DSC_0028.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411111449DSC_0028-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411111449DSC_0028-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:33:\"20100411111449DSC_0028-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411111449DSC_0028-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411111449DSC_0028-400x375.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:34:\"20100411111449DSC_0028-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:34:\"20100411111449DSC_0028-400x480.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411111449DSC_0028-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:32:\"20100411111449DSC_0028-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:34:\"20100411111449DSC_0028-400x470.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411111449DSC_0028-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("383", "166", "_wp_attached_file", "2017/10/20100411111507DSC_0031.jpg");
INSERT INTO `wp_postmeta` VALUES("384", "166", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:602;s:4:\"file\";s:34:\"2017/10/20100411111507DSC_0031.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411111507DSC_0031-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411111507DSC_0031-199x300.jpg\";s:5:\"width\";i:199;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:33:\"20100411111507DSC_0031-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411111507DSC_0031-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411111507DSC_0031-400x375.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:34:\"20100411111507DSC_0031-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:34:\"20100411111507DSC_0031-400x480.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411111507DSC_0031-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:32:\"20100411111507DSC_0031-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:34:\"20100411111507DSC_0031-400x470.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411111507DSC_0031-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("385", "167", "_wp_attached_file", "2017/10/20100411111550DSC_0034.jpg");
INSERT INTO `wp_postmeta` VALUES("386", "167", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:602;s:4:\"file\";s:34:\"2017/10/20100411111550DSC_0034.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411111550DSC_0034-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411111550DSC_0034-199x300.jpg\";s:5:\"width\";i:199;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:33:\"20100411111550DSC_0034-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411111550DSC_0034-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411111550DSC_0034-400x375.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:34:\"20100411111550DSC_0034-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:34:\"20100411111550DSC_0034-400x480.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411111550DSC_0034-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:32:\"20100411111550DSC_0034-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:34:\"20100411111550DSC_0034-400x470.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411111550DSC_0034-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("387", "168", "_wp_attached_file", "2017/10/20100411111602DSC_0036.jpg");
INSERT INTO `wp_postmeta` VALUES("388", "168", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:600;s:4:\"file\";s:34:\"2017/10/20100411111602DSC_0036.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411111602DSC_0036-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411111602DSC_0036-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:33:\"20100411111602DSC_0036-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411111602DSC_0036-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411111602DSC_0036-400x375.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:34:\"20100411111602DSC_0036-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:34:\"20100411111602DSC_0036-400x480.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411111602DSC_0036-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:32:\"20100411111602DSC_0036-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:34:\"20100411111602DSC_0036-400x470.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411111602DSC_0036-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("389", "169", "_wp_attached_file", "2017/10/20100411111621DSC_0037.jpg");
INSERT INTO `wp_postmeta` VALUES("390", "169", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:602;s:4:\"file\";s:34:\"2017/10/20100411111621DSC_0037.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411111621DSC_0037-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411111621DSC_0037-199x300.jpg\";s:5:\"width\";i:199;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:33:\"20100411111621DSC_0037-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411111621DSC_0037-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411111621DSC_0037-400x375.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:34:\"20100411111621DSC_0037-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:34:\"20100411111621DSC_0037-400x480.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411111621DSC_0037-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:32:\"20100411111621DSC_0037-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:34:\"20100411111621DSC_0037-400x470.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411111621DSC_0037-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("391", "170", "_wp_attached_file", "2017/10/20100411111647DSC_0038.jpg");
INSERT INTO `wp_postmeta` VALUES("392", "170", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:602;s:4:\"file\";s:34:\"2017/10/20100411111647DSC_0038.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411111647DSC_0038-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411111647DSC_0038-199x300.jpg\";s:5:\"width\";i:199;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:33:\"20100411111647DSC_0038-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411111647DSC_0038-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411111647DSC_0038-400x375.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:34:\"20100411111647DSC_0038-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:34:\"20100411111647DSC_0038-400x480.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411111647DSC_0038-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:32:\"20100411111647DSC_0038-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:34:\"20100411111647DSC_0038-400x470.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411111647DSC_0038-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("393", "171", "_wp_attached_file", "2017/10/20100411111706DSC_0040.jpg");
INSERT INTO `wp_postmeta` VALUES("394", "171", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:602;s:4:\"file\";s:34:\"2017/10/20100411111706DSC_0040.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411111706DSC_0040-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411111706DSC_0040-199x300.jpg\";s:5:\"width\";i:199;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:33:\"20100411111706DSC_0040-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411111706DSC_0040-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411111706DSC_0040-400x375.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:34:\"20100411111706DSC_0040-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:34:\"20100411111706DSC_0040-400x480.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411111706DSC_0040-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:32:\"20100411111706DSC_0040-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:34:\"20100411111706DSC_0040-400x470.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411111706DSC_0040-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("395", "172", "_wp_attached_file", "2017/10/20100411111746DSC_0042.jpg");
INSERT INTO `wp_postmeta` VALUES("396", "172", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:602;s:4:\"file\";s:34:\"2017/10/20100411111746DSC_0042.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411111746DSC_0042-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411111746DSC_0042-199x300.jpg\";s:5:\"width\";i:199;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:33:\"20100411111746DSC_0042-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411111746DSC_0042-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411111746DSC_0042-400x375.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:34:\"20100411111746DSC_0042-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:34:\"20100411111746DSC_0042-400x480.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411111746DSC_0042-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:32:\"20100411111746DSC_0042-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:34:\"20100411111746DSC_0042-400x470.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411111746DSC_0042-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("397", "173", "_wp_attached_file", "2017/10/20100411111805DSC_0047.jpg");
INSERT INTO `wp_postmeta` VALUES("398", "173", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:602;s:4:\"file\";s:34:\"2017/10/20100411111805DSC_0047.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411111805DSC_0047-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411111805DSC_0047-199x300.jpg\";s:5:\"width\";i:199;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:33:\"20100411111805DSC_0047-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411111805DSC_0047-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411111805DSC_0047-400x375.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:34:\"20100411111805DSC_0047-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:34:\"20100411111805DSC_0047-400x480.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411111805DSC_0047-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:32:\"20100411111805DSC_0047-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:34:\"20100411111805DSC_0047-400x470.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411111805DSC_0047-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("399", "174", "_wp_attached_file", "2017/10/20100411111820DSC_0056.jpg");
INSERT INTO `wp_postmeta` VALUES("400", "174", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:400;s:4:\"file\";s:34:\"2017/10/20100411111820DSC_0056.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411111820DSC_0056-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411111820DSC_0056-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411111820DSC_0056-219x146.jpg\";s:5:\"width\";i:219;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411111820DSC_0056-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411111820DSC_0056-600x375.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:34:\"20100411111820DSC_0056-480x400.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411111820DSC_0056-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:33:\"20100411111820DSC_0056-113x75.jpg\";s:5:\"width\";i:113;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411111820DSC_0056-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("401", "175", "_wp_attached_file", "2017/10/20100411111849DSC_0051.jpg");
INSERT INTO `wp_postmeta` VALUES("402", "175", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:400;s:4:\"file\";s:34:\"2017/10/20100411111849DSC_0051.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411111849DSC_0051-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411111849DSC_0051-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411111849DSC_0051-219x146.jpg\";s:5:\"width\";i:219;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411111849DSC_0051-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411111849DSC_0051-600x375.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:34:\"20100411111849DSC_0051-480x400.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411111849DSC_0051-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:33:\"20100411111849DSC_0051-113x75.jpg\";s:5:\"width\";i:113;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411111849DSC_0051-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("403", "176", "_wp_attached_file", "2017/10/20100411111903DSC_0056.jpg");
INSERT INTO `wp_postmeta` VALUES("404", "176", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:400;s:4:\"file\";s:34:\"2017/10/20100411111903DSC_0056.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411111903DSC_0056-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411111903DSC_0056-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411111903DSC_0056-219x146.jpg\";s:5:\"width\";i:219;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411111903DSC_0056-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411111903DSC_0056-600x375.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:34:\"20100411111903DSC_0056-480x400.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411111903DSC_0056-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:33:\"20100411111903DSC_0056-113x75.jpg\";s:5:\"width\";i:113;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411111903DSC_0056-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("405", "177", "_wp_attached_file", "2017/10/20100411111926DSC_0058.jpg");
INSERT INTO `wp_postmeta` VALUES("406", "177", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:600;s:4:\"file\";s:34:\"2017/10/20100411111926DSC_0058.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411111926DSC_0058-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411111926DSC_0058-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:33:\"20100411111926DSC_0058-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411111926DSC_0058-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411111926DSC_0058-400x375.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:34:\"20100411111926DSC_0058-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:34:\"20100411111926DSC_0058-400x480.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411111926DSC_0058-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:32:\"20100411111926DSC_0058-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:34:\"20100411111926DSC_0058-400x470.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411111926DSC_0058-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("407", "178", "_wp_attached_file", "2017/10/20100411111946DSC_0739.jpg");
INSERT INTO `wp_postmeta` VALUES("408", "178", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:602;s:4:\"file\";s:34:\"2017/10/20100411111946DSC_0739.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411111946DSC_0739-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411111946DSC_0739-199x300.jpg\";s:5:\"width\";i:199;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:33:\"20100411111946DSC_0739-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411111946DSC_0739-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411111946DSC_0739-400x375.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:34:\"20100411111946DSC_0739-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:34:\"20100411111946DSC_0739-400x480.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411111946DSC_0739-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:32:\"20100411111946DSC_0739-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:34:\"20100411111946DSC_0739-400x470.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411111946DSC_0739-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("409", "179", "_wp_attached_file", "2017/10/20100411112006DSC_0742.jpg");
INSERT INTO `wp_postmeta` VALUES("410", "179", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:602;s:4:\"file\";s:34:\"2017/10/20100411112006DSC_0742.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411112006DSC_0742-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411112006DSC_0742-199x300.jpg\";s:5:\"width\";i:199;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:33:\"20100411112006DSC_0742-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411112006DSC_0742-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411112006DSC_0742-400x375.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:34:\"20100411112006DSC_0742-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:34:\"20100411112006DSC_0742-400x480.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411112006DSC_0742-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:32:\"20100411112006DSC_0742-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:34:\"20100411112006DSC_0742-400x470.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411112006DSC_0742-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("411", "180", "_wp_attached_file", "2017/10/20100411112021DSC_0744.jpg");
INSERT INTO `wp_postmeta` VALUES("412", "180", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:399;s:4:\"file\";s:34:\"2017/10/20100411112021DSC_0744.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411112021DSC_0744-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411112021DSC_0744-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411112021DSC_0744-220x146.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411112021DSC_0744-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411112021DSC_0744-600x375.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:34:\"20100411112021DSC_0744-480x399.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:399;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411112021DSC_0744-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:33:\"20100411112021DSC_0744-113x75.jpg\";s:5:\"width\";i:113;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411112021DSC_0744-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("413", "181", "_wp_attached_file", "2017/10/20100411112035DSC_0745.jpg");
INSERT INTO `wp_postmeta` VALUES("414", "181", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:399;s:4:\"file\";s:34:\"2017/10/20100411112035DSC_0745.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411112035DSC_0745-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411112035DSC_0745-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411112035DSC_0745-220x146.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411112035DSC_0745-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411112035DSC_0745-600x375.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:34:\"20100411112035DSC_0745-480x399.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:399;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411112035DSC_0745-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:33:\"20100411112035DSC_0745-113x75.jpg\";s:5:\"width\";i:113;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411112035DSC_0745-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("415", "182", "_wp_attached_file", "2017/10/20100411112048DSC_0752.jpg");
INSERT INTO `wp_postmeta` VALUES("416", "182", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:602;s:4:\"file\";s:34:\"2017/10/20100411112048DSC_0752.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411112048DSC_0752-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411112048DSC_0752-199x300.jpg\";s:5:\"width\";i:199;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:33:\"20100411112048DSC_0752-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411112048DSC_0752-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411112048DSC_0752-400x375.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:34:\"20100411112048DSC_0752-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:34:\"20100411112048DSC_0752-400x480.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411112048DSC_0752-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:32:\"20100411112048DSC_0752-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:34:\"20100411112048DSC_0752-400x470.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411112048DSC_0752-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("417", "183", "_wp_attached_file", "2017/10/20100411112108DSC_0753.jpg");
INSERT INTO `wp_postmeta` VALUES("418", "183", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:602;s:4:\"file\";s:34:\"2017/10/20100411112108DSC_0753.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411112108DSC_0753-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411112108DSC_0753-199x300.jpg\";s:5:\"width\";i:199;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:33:\"20100411112108DSC_0753-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411112108DSC_0753-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411112108DSC_0753-400x375.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:34:\"20100411112108DSC_0753-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:34:\"20100411112108DSC_0753-400x480.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411112108DSC_0753-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:32:\"20100411112108DSC_0753-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:34:\"20100411112108DSC_0753-400x470.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411112108DSC_0753-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("419", "184", "_wp_attached_file", "2017/10/20100411112131DSC_0754.jpg");
INSERT INTO `wp_postmeta` VALUES("420", "184", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:602;s:4:\"file\";s:34:\"2017/10/20100411112131DSC_0754.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411112131DSC_0754-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411112131DSC_0754-199x300.jpg\";s:5:\"width\";i:199;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:33:\"20100411112131DSC_0754-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411112131DSC_0754-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411112131DSC_0754-400x375.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:34:\"20100411112131DSC_0754-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:34:\"20100411112131DSC_0754-400x480.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411112131DSC_0754-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:32:\"20100411112131DSC_0754-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:34:\"20100411112131DSC_0754-400x470.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411112131DSC_0754-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("421", "185", "_wp_attached_file", "2017/10/20100411112144DSC_0759.jpg");
INSERT INTO `wp_postmeta` VALUES("422", "185", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:399;s:4:\"file\";s:34:\"2017/10/20100411112144DSC_0759.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411112144DSC_0759-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411112144DSC_0759-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411112144DSC_0759-220x146.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411112144DSC_0759-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411112144DSC_0759-600x375.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:34:\"20100411112144DSC_0759-480x399.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:399;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411112144DSC_0759-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:33:\"20100411112144DSC_0759-113x75.jpg\";s:5:\"width\";i:113;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411112144DSC_0759-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("423", "186", "_wp_attached_file", "2017/10/20100411112156DSC_0762.jpg");
INSERT INTO `wp_postmeta` VALUES("424", "186", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:600;s:4:\"file\";s:34:\"2017/10/20100411112156DSC_0762.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411112156DSC_0762-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411112156DSC_0762-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:33:\"20100411112156DSC_0762-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411112156DSC_0762-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411112156DSC_0762-400x375.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:34:\"20100411112156DSC_0762-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:34:\"20100411112156DSC_0762-400x480.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411112156DSC_0762-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:32:\"20100411112156DSC_0762-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:34:\"20100411112156DSC_0762-400x470.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411112156DSC_0762-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("425", "187", "_wp_attached_file", "2017/10/20100411112208DSC_0765.jpg");
INSERT INTO `wp_postmeta` VALUES("426", "187", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:602;s:4:\"file\";s:34:\"2017/10/20100411112208DSC_0765.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411112208DSC_0765-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411112208DSC_0765-199x300.jpg\";s:5:\"width\";i:199;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:33:\"20100411112208DSC_0765-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411112208DSC_0765-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411112208DSC_0765-400x375.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:34:\"20100411112208DSC_0765-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:34:\"20100411112208DSC_0765-400x480.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411112208DSC_0765-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:32:\"20100411112208DSC_0765-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:34:\"20100411112208DSC_0765-400x470.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411112208DSC_0765-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("427", "188", "_wp_attached_file", "2017/10/20100411112229DSC_0767.jpg");
INSERT INTO `wp_postmeta` VALUES("428", "188", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:602;s:4:\"file\";s:34:\"2017/10/20100411112229DSC_0767.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411112229DSC_0767-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411112229DSC_0767-199x300.jpg\";s:5:\"width\";i:199;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:33:\"20100411112229DSC_0767-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411112229DSC_0767-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411112229DSC_0767-400x375.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:34:\"20100411112229DSC_0767-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:34:\"20100411112229DSC_0767-400x480.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411112229DSC_0767-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:32:\"20100411112229DSC_0767-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:34:\"20100411112229DSC_0767-400x470.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411112229DSC_0767-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("429", "189", "_wp_attached_file", "2017/10/20100411112252DSC_0768.jpg");
INSERT INTO `wp_postmeta` VALUES("430", "189", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:600;s:4:\"file\";s:34:\"2017/10/20100411112252DSC_0768.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411112252DSC_0768-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411112252DSC_0768-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:33:\"20100411112252DSC_0768-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411112252DSC_0768-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411112252DSC_0768-400x375.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:34:\"20100411112252DSC_0768-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:34:\"20100411112252DSC_0768-400x480.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411112252DSC_0768-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:32:\"20100411112252DSC_0768-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:34:\"20100411112252DSC_0768-400x470.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411112252DSC_0768-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("431", "190", "_wp_attached_file", "2017/10/20100411112305DSC_0771.jpg");
INSERT INTO `wp_postmeta` VALUES("432", "190", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:399;s:4:\"file\";s:34:\"2017/10/20100411112305DSC_0771.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411112305DSC_0771-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411112305DSC_0771-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411112305DSC_0771-220x146.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411112305DSC_0771-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411112305DSC_0771-600x375.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:34:\"20100411112305DSC_0771-480x399.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:399;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411112305DSC_0771-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:33:\"20100411112305DSC_0771-113x75.jpg\";s:5:\"width\";i:113;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411112305DSC_0771-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("433", "191", "_wp_attached_file", "2017/10/20100411112322DSC_0773.jpg");
INSERT INTO `wp_postmeta` VALUES("434", "191", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:602;s:4:\"file\";s:34:\"2017/10/20100411112322DSC_0773.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411112322DSC_0773-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411112322DSC_0773-199x300.jpg\";s:5:\"width\";i:199;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:33:\"20100411112322DSC_0773-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411112322DSC_0773-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411112322DSC_0773-400x375.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:34:\"20100411112322DSC_0773-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:34:\"20100411112322DSC_0773-400x480.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411112322DSC_0773-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:32:\"20100411112322DSC_0773-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:34:\"20100411112322DSC_0773-400x470.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411112322DSC_0773-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("435", "192", "_wp_attached_file", "2017/10/20100411112338DSC_0774.jpg");
INSERT INTO `wp_postmeta` VALUES("436", "192", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:602;s:4:\"file\";s:34:\"2017/10/20100411112338DSC_0774.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411112338DSC_0774-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411112338DSC_0774-199x300.jpg\";s:5:\"width\";i:199;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:33:\"20100411112338DSC_0774-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411112338DSC_0774-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411112338DSC_0774-400x375.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:34:\"20100411112338DSC_0774-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:34:\"20100411112338DSC_0774-400x480.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411112338DSC_0774-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:32:\"20100411112338DSC_0774-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:34:\"20100411112338DSC_0774-400x470.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411112338DSC_0774-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("437", "193", "_wp_attached_file", "2017/10/20100411112350DSC_0775.jpg");
INSERT INTO `wp_postmeta` VALUES("438", "193", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:399;s:4:\"file\";s:34:\"2017/10/20100411112350DSC_0775.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411112350DSC_0775-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411112350DSC_0775-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411112350DSC_0775-220x146.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411112350DSC_0775-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411112350DSC_0775-600x375.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:34:\"20100411112350DSC_0775-480x399.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:399;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411112350DSC_0775-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:33:\"20100411112350DSC_0775-113x75.jpg\";s:5:\"width\";i:113;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411112350DSC_0775-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("439", "194", "_wp_attached_file", "2017/10/20100411112402DSC_0778.jpg");
INSERT INTO `wp_postmeta` VALUES("440", "194", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:400;s:4:\"file\";s:34:\"2017/10/20100411112402DSC_0778.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411112402DSC_0778-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411112402DSC_0778-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411112402DSC_0778-219x146.jpg\";s:5:\"width\";i:219;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411112402DSC_0778-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411112402DSC_0778-600x375.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:34:\"20100411112402DSC_0778-480x400.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411112402DSC_0778-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:33:\"20100411112402DSC_0778-113x75.jpg\";s:5:\"width\";i:113;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411112402DSC_0778-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("441", "195", "_wp_attached_file", "2017/10/20100411112423DSC_0782.jpg");
INSERT INTO `wp_postmeta` VALUES("442", "195", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:399;s:4:\"file\";s:34:\"2017/10/20100411112423DSC_0782.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411112423DSC_0782-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411112423DSC_0782-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411112423DSC_0782-220x146.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411112423DSC_0782-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411112423DSC_0782-600x375.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:34:\"20100411112423DSC_0782-480x399.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:399;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411112423DSC_0782-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:33:\"20100411112423DSC_0782-113x75.jpg\";s:5:\"width\";i:113;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411112423DSC_0782-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("443", "196", "_wp_attached_file", "2017/10/20100411112434DSC_0792.jpg");
INSERT INTO `wp_postmeta` VALUES("444", "196", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:600;s:4:\"file\";s:34:\"2017/10/20100411112434DSC_0792.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"20100411112434DSC_0792-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"20100411112434DSC_0792-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:33:\"20100411112434DSC_0792-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:32:\"20100411112434DSC_0792-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:34:\"20100411112434DSC_0792-400x375.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:34:\"20100411112434DSC_0792-400x450.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:34:\"20100411112434DSC_0792-400x480.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:32:\"20100411112434DSC_0792-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:32:\"20100411112434DSC_0792-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:34:\"20100411112434DSC_0792-400x470.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:32:\"20100411112434DSC_0792-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("445", "197", "_wp_attached_file", "2017/10/20131303034515Artiko01000000.jpg");
INSERT INTO `wp_postmeta` VALUES("446", "197", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:427;s:6:\"height\";i:640;s:4:\"file\";s:40:\"2017/10/20131303034515Artiko01000000.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:40:\"20131303034515Artiko01000000-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:40:\"20131303034515Artiko01000000-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:39:\"20131303034515Artiko01000000-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:38:\"20131303034515Artiko01000000-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:40:\"20131303034515Artiko01000000-427x375.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:40:\"20131303034515Artiko01000000-427x450.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:40:\"20131303034515Artiko01000000-427x480.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:38:\"20131303034515Artiko01000000-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:38:\"20131303034515Artiko01000000-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:40:\"20131303034515Artiko01000000-427x470.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:38:\"20131303034515Artiko01000000-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1352462921\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"29\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:17:\"0.033333333333333\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("447", "198", "_wp_attached_file", "2017/10/20131303034529Artiko01000001.jpg");
INSERT INTO `wp_postmeta` VALUES("448", "198", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:427;s:6:\"height\";i:640;s:4:\"file\";s:40:\"2017/10/20131303034529Artiko01000001.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:40:\"20131303034529Artiko01000001-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:40:\"20131303034529Artiko01000001-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:39:\"20131303034529Artiko01000001-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:38:\"20131303034529Artiko01000001-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:40:\"20131303034529Artiko01000001-427x375.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:40:\"20131303034529Artiko01000001-427x450.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:40:\"20131303034529Artiko01000001-427x480.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:38:\"20131303034529Artiko01000001-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:38:\"20131303034529Artiko01000001-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:40:\"20131303034529Artiko01000001-427x470.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:38:\"20131303034529Artiko01000001-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1352462979\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"28\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:4:\"0.02\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("449", "199", "_wp_attached_file", "2017/10/20131303034546Artiko01000002.jpg");
INSERT INTO `wp_postmeta` VALUES("450", "199", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:427;s:6:\"height\";i:640;s:4:\"file\";s:40:\"2017/10/20131303034546Artiko01000002.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:40:\"20131303034546Artiko01000002-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:40:\"20131303034546Artiko01000002-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:39:\"20131303034546Artiko01000002-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:38:\"20131303034546Artiko01000002-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:40:\"20131303034546Artiko01000002-427x375.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:40:\"20131303034546Artiko01000002-427x450.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:40:\"20131303034546Artiko01000002-427x480.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:38:\"20131303034546Artiko01000002-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:38:\"20131303034546Artiko01000002-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:40:\"20131303034546Artiko01000002-427x470.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:38:\"20131303034546Artiko01000002-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1352463135\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"36\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:5:\"0.025\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("451", "200", "_wp_attached_file", "2017/10/20131303034608Artiko01000003.jpg");
INSERT INTO `wp_postmeta` VALUES("452", "200", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:427;s:6:\"height\";i:640;s:4:\"file\";s:40:\"2017/10/20131303034608Artiko01000003.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:40:\"20131303034608Artiko01000003-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:40:\"20131303034608Artiko01000003-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:39:\"20131303034608Artiko01000003-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:38:\"20131303034608Artiko01000003-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:40:\"20131303034608Artiko01000003-427x375.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:40:\"20131303034608Artiko01000003-427x450.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:40:\"20131303034608Artiko01000003-427x480.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:38:\"20131303034608Artiko01000003-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:38:\"20131303034608Artiko01000003-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:40:\"20131303034608Artiko01000003-427x470.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:38:\"20131303034608Artiko01000003-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"6.3\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1352464211\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"19\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:17:\"0.033333333333333\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("453", "201", "_wp_attached_file", "2017/10/20131303034624Artiko02000000.jpg");
INSERT INTO `wp_postmeta` VALUES("454", "201", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:640;s:6:\"height\";i:427;s:4:\"file\";s:40:\"2017/10/20131303034624Artiko02000000.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:40:\"20131303034624Artiko02000000-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:40:\"20131303034624Artiko02000000-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:40:\"20131303034624Artiko02000000-219x146.jpg\";s:5:\"width\";i:219;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:38:\"20131303034624Artiko02000000-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:40:\"20131303034624Artiko02000000-640x375.jpg\";s:5:\"width\";i:640;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:40:\"20131303034624Artiko02000000-480x427.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:427;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:38:\"20131303034624Artiko02000000-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:39:\"20131303034624Artiko02000000-112x75.jpg\";s:5:\"width\";i:112;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:38:\"20131303034624Artiko02000000-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"6.3\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1352464245\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"22\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:6:\"0.0125\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("455", "202", "_wp_attached_file", "2017/10/20131303034748Cibes01000000.jpg");
INSERT INTO `wp_postmeta` VALUES("456", "202", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:427;s:6:\"height\";i:640;s:4:\"file\";s:39:\"2017/10/20131303034748Cibes01000000.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:39:\"20131303034748Cibes01000000-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:39:\"20131303034748Cibes01000000-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:38:\"20131303034748Cibes01000000-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:37:\"20131303034748Cibes01000000-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:39:\"20131303034748Cibes01000000-427x375.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:39:\"20131303034748Cibes01000000-427x450.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:39:\"20131303034748Cibes01000000-427x480.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:37:\"20131303034748Cibes01000000-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:37:\"20131303034748Cibes01000000-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:39:\"20131303034748Cibes01000000-427x470.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:37:\"20131303034748Cibes01000000-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"4.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1352461357\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"25\";s:3:\"iso\";s:3:\"400\";s:13:\"shutter_speed\";s:17:\"0.016666666666667\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("457", "203", "_wp_attached_file", "2017/10/20131303034801Cibes01000001.jpg");
INSERT INTO `wp_postmeta` VALUES("458", "203", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:427;s:6:\"height\";i:640;s:4:\"file\";s:39:\"2017/10/20131303034801Cibes01000001.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:39:\"20131303034801Cibes01000001-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:39:\"20131303034801Cibes01000001-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:38:\"20131303034801Cibes01000001-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:37:\"20131303034801Cibes01000001-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:39:\"20131303034801Cibes01000001-427x375.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:39:\"20131303034801Cibes01000001-427x450.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:39:\"20131303034801Cibes01000001-427x480.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:37:\"20131303034801Cibes01000001-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:37:\"20131303034801Cibes01000001-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:39:\"20131303034801Cibes01000001-427x470.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:37:\"20131303034801Cibes01000001-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"4.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1352461414\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"25\";s:3:\"iso\";s:3:\"400\";s:13:\"shutter_speed\";s:17:\"0.016666666666667\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("459", "204", "_wp_attached_file", "2017/10/20131303034815Cibes01000002.jpg");
INSERT INTO `wp_postmeta` VALUES("460", "204", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:427;s:6:\"height\";i:640;s:4:\"file\";s:39:\"2017/10/20131303034815Cibes01000002.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:39:\"20131303034815Cibes01000002-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:39:\"20131303034815Cibes01000002-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:38:\"20131303034815Cibes01000002-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:37:\"20131303034815Cibes01000002-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:39:\"20131303034815Cibes01000002-427x375.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:39:\"20131303034815Cibes01000002-427x450.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:39:\"20131303034815Cibes01000002-427x480.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:37:\"20131303034815Cibes01000002-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:37:\"20131303034815Cibes01000002-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:39:\"20131303034815Cibes01000002-427x470.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:37:\"20131303034815Cibes01000002-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"4.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1352461667\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"22\";s:3:\"iso\";s:3:\"400\";s:13:\"shutter_speed\";s:17:\"0.016666666666667\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("461", "205", "_wp_attached_file", "2017/10/20131303034940KWP01000000.jpg");
INSERT INTO `wp_postmeta` VALUES("462", "205", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:427;s:6:\"height\";i:640;s:4:\"file\";s:37:\"2017/10/20131303034940KWP01000000.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:37:\"20131303034940KWP01000000-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"20131303034940KWP01000000-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:36:\"20131303034940KWP01000000-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:35:\"20131303034940KWP01000000-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:37:\"20131303034940KWP01000000-427x375.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:37:\"20131303034940KWP01000000-427x450.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:37:\"20131303034940KWP01000000-427x480.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:35:\"20131303034940KWP01000000-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:35:\"20131303034940KWP01000000-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:37:\"20131303034940KWP01000000-427x470.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:35:\"20131303034940KWP01000000-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"4\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1352463887\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"21\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:17:\"0.016666666666667\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("463", "206", "_wp_attached_file", "2017/10/20131303034953KWP02000000.jpg");
INSERT INTO `wp_postmeta` VALUES("464", "206", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:640;s:6:\"height\";i:427;s:4:\"file\";s:37:\"2017/10/20131303034953KWP02000000.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:37:\"20131303034953KWP02000000-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"20131303034953KWP02000000-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:37:\"20131303034953KWP02000000-219x146.jpg\";s:5:\"width\";i:219;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:35:\"20131303034953KWP02000000-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:37:\"20131303034953KWP02000000-640x375.jpg\";s:5:\"width\";i:640;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:37:\"20131303034953KWP02000000-480x427.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:427;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:35:\"20131303034953KWP02000000-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:36:\"20131303034953KWP02000000-112x75.jpg\";s:5:\"width\";i:112;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:35:\"20131303034953KWP02000000-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"4.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1352470327\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"36\";s:3:\"iso\";s:3:\"400\";s:13:\"shutter_speed\";s:8:\"0.003125\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("465", "207", "_wp_attached_file", "2017/10/20131303035007KWP03000000.jpg");
INSERT INTO `wp_postmeta` VALUES("466", "207", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:427;s:6:\"height\";i:640;s:4:\"file\";s:37:\"2017/10/20131303035007KWP03000000.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:37:\"20131303035007KWP03000000-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"20131303035007KWP03000000-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:36:\"20131303035007KWP03000000-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:35:\"20131303035007KWP03000000-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:37:\"20131303035007KWP03000000-427x375.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:37:\"20131303035007KWP03000000-427x450.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:37:\"20131303035007KWP03000000-427x480.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:35:\"20131303035007KWP03000000-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:35:\"20131303035007KWP03000000-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:37:\"20131303035007KWP03000000-427x470.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:35:\"20131303035007KWP03000000-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1352463750\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"26\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:17:\"0.016666666666667\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("467", "208", "_wp_attached_file", "2017/10/20131303035021KWP03000001.jpg");
INSERT INTO `wp_postmeta` VALUES("468", "208", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:427;s:6:\"height\";i:640;s:4:\"file\";s:37:\"2017/10/20131303035021KWP03000001.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:37:\"20131303035021KWP03000001-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"20131303035021KWP03000001-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:36:\"20131303035021KWP03000001-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:35:\"20131303035021KWP03000001-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:37:\"20131303035021KWP03000001-427x375.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:37:\"20131303035021KWP03000001-427x450.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:37:\"20131303035021KWP03000001-427x480.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:35:\"20131303035021KWP03000001-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:35:\"20131303035021KWP03000001-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:37:\"20131303035021KWP03000001-427x470.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:35:\"20131303035021KWP03000001-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"4\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1352463813\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"25\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:17:\"0.016666666666667\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("469", "209", "_wp_attached_file", "2017/10/20131303035154Krzeslo01000001.jpg");
INSERT INTO `wp_postmeta` VALUES("470", "209", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:427;s:6:\"height\";i:640;s:4:\"file\";s:41:\"2017/10/20131303035154Krzeslo01000001.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:41:\"20131303035154Krzeslo01000001-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:41:\"20131303035154Krzeslo01000001-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:40:\"20131303035154Krzeslo01000001-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:39:\"20131303035154Krzeslo01000001-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:41:\"20131303035154Krzeslo01000001-427x375.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:41:\"20131303035154Krzeslo01000001-427x450.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:41:\"20131303035154Krzeslo01000001-427x480.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:39:\"20131303035154Krzeslo01000001-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:39:\"20131303035154Krzeslo01000001-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:41:\"20131303035154Krzeslo01000001-427x470.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:39:\"20131303035154Krzeslo01000001-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"4.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1352458832\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"17\";s:3:\"iso\";s:3:\"400\";s:13:\"shutter_speed\";s:17:\"0.016666666666667\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("471", "210", "_wp_attached_file", "2017/10/20131303035154Krzeslo010000012.jpg");
INSERT INTO `wp_postmeta` VALUES("472", "210", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:427;s:6:\"height\";i:640;s:4:\"file\";s:42:\"2017/10/20131303035154Krzeslo010000012.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:42:\"20131303035154Krzeslo010000012-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:42:\"20131303035154Krzeslo010000012-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:41:\"20131303035154Krzeslo010000012-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:40:\"20131303035154Krzeslo010000012-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:42:\"20131303035154Krzeslo010000012-427x375.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:42:\"20131303035154Krzeslo010000012-427x450.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:42:\"20131303035154Krzeslo010000012-427x480.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:40:\"20131303035154Krzeslo010000012-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:40:\"20131303035154Krzeslo010000012-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:42:\"20131303035154Krzeslo010000012-427x470.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:40:\"20131303035154Krzeslo010000012-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"4.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1352458832\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"17\";s:3:\"iso\";s:3:\"400\";s:13:\"shutter_speed\";s:17:\"0.016666666666667\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("473", "211", "_wp_attached_file", "2017/10/20131303035215Krzeslo02000000.jpg");
INSERT INTO `wp_postmeta` VALUES("474", "211", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:640;s:6:\"height\";i:427;s:4:\"file\";s:41:\"2017/10/20131303035215Krzeslo02000000.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:41:\"20131303035215Krzeslo02000000-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:41:\"20131303035215Krzeslo02000000-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:41:\"20131303035215Krzeslo02000000-219x146.jpg\";s:5:\"width\";i:219;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:39:\"20131303035215Krzeslo02000000-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:41:\"20131303035215Krzeslo02000000-640x375.jpg\";s:5:\"width\";i:640;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:41:\"20131303035215Krzeslo02000000-480x427.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:427;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:39:\"20131303035215Krzeslo02000000-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:40:\"20131303035215Krzeslo02000000-112x75.jpg\";s:5:\"width\";i:112;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:39:\"20131303035215Krzeslo02000000-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"7.1\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1352458256\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"40\";s:3:\"iso\";s:3:\"400\";s:13:\"shutter_speed\";s:17:\"0.016666666666667\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("475", "212", "_wp_attached_file", "2017/10/20131303035317Eagle01000000.jpg");
INSERT INTO `wp_postmeta` VALUES("476", "212", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:427;s:6:\"height\";i:640;s:4:\"file\";s:39:\"2017/10/20131303035317Eagle01000000.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:39:\"20131303035317Eagle01000000-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:39:\"20131303035317Eagle01000000-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:38:\"20131303035317Eagle01000000-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:37:\"20131303035317Eagle01000000-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:39:\"20131303035317Eagle01000000-427x375.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:39:\"20131303035317Eagle01000000-427x450.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:39:\"20131303035317Eagle01000000-427x480.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:37:\"20131303035317Eagle01000000-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:37:\"20131303035317Eagle01000000-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:39:\"20131303035317Eagle01000000-427x470.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:37:\"20131303035317Eagle01000000-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"4\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1352470396\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"27\";s:3:\"iso\";s:4:\"1000\";s:13:\"shutter_speed\";s:7:\"0.00625\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("477", "213", "_wp_attached_file", "2017/10/20131303035331Eagle01000001.jpg");
INSERT INTO `wp_postmeta` VALUES("478", "213", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:427;s:6:\"height\";i:640;s:4:\"file\";s:39:\"2017/10/20131303035331Eagle01000001.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:39:\"20131303035331Eagle01000001-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:39:\"20131303035331Eagle01000001-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:38:\"20131303035331Eagle01000001-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:37:\"20131303035331Eagle01000001-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:39:\"20131303035331Eagle01000001-427x375.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:39:\"20131303035331Eagle01000001-427x450.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:39:\"20131303035331Eagle01000001-427x480.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:37:\"20131303035331Eagle01000001-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:37:\"20131303035331Eagle01000001-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:39:\"20131303035331Eagle01000001-427x470.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:37:\"20131303035331Eagle01000001-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"4\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1352470414\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"25\";s:3:\"iso\";s:4:\"1000\";s:13:\"shutter_speed\";s:7:\"0.00625\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("479", "214", "_wp_attached_file", "2017/10/20131303035344Eagle02000000.jpg");
INSERT INTO `wp_postmeta` VALUES("480", "214", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:640;s:6:\"height\";i:427;s:4:\"file\";s:39:\"2017/10/20131303035344Eagle02000000.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:39:\"20131303035344Eagle02000000-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:39:\"20131303035344Eagle02000000-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:39:\"20131303035344Eagle02000000-219x146.jpg\";s:5:\"width\";i:219;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:37:\"20131303035344Eagle02000000-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:39:\"20131303035344Eagle02000000-640x375.jpg\";s:5:\"width\";i:640;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:39:\"20131303035344Eagle02000000-480x427.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:427;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:37:\"20131303035344Eagle02000000-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:38:\"20131303035344Eagle02000000-112x75.jpg\";s:5:\"width\";i:112;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:37:\"20131303035344Eagle02000000-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"4.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1352470346\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"40\";s:3:\"iso\";s:3:\"400\";s:13:\"shutter_speed\";s:17:\"0.066666666666667\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("481", "215", "_wp_attached_file", "2017/10/20131303035358Eagle02000001.jpg");
INSERT INTO `wp_postmeta` VALUES("482", "215", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:640;s:6:\"height\";i:427;s:4:\"file\";s:39:\"2017/10/20131303035358Eagle02000001.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:39:\"20131303035358Eagle02000001-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:39:\"20131303035358Eagle02000001-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:39:\"20131303035358Eagle02000001-219x146.jpg\";s:5:\"width\";i:219;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:37:\"20131303035358Eagle02000001-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:39:\"20131303035358Eagle02000001-640x375.jpg\";s:5:\"width\";i:640;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:39:\"20131303035358Eagle02000001-480x427.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:427;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:37:\"20131303035358Eagle02000001-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:38:\"20131303035358Eagle02000001-112x75.jpg\";s:5:\"width\";i:112;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:37:\"20131303035358Eagle02000001-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1352470670\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"40\";s:3:\"iso\";s:4:\"1000\";s:13:\"shutter_speed\";s:17:\"0.016666666666667\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("483", "216", "_wp_attached_file", "2017/10/20131303035414Eagle03000000.jpg");
INSERT INTO `wp_postmeta` VALUES("484", "216", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:427;s:6:\"height\";i:640;s:4:\"file\";s:39:\"2017/10/20131303035414Eagle03000000.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:39:\"20131303035414Eagle03000000-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:39:\"20131303035414Eagle03000000-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:38:\"20131303035414Eagle03000000-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:37:\"20131303035414Eagle03000000-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:39:\"20131303035414Eagle03000000-427x375.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:39:\"20131303035414Eagle03000000-427x450.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:39:\"20131303035414Eagle03000000-427x480.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:37:\"20131303035414Eagle03000000-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:37:\"20131303035414Eagle03000000-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:39:\"20131303035414Eagle03000000-427x470.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:37:\"20131303035414Eagle03000000-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1352470567\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"40\";s:3:\"iso\";s:4:\"1000\";s:13:\"shutter_speed\";s:17:\"0.016666666666667\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("485", "217", "_wp_attached_file", "2017/10/20131303035544Pobiedziska01000000.jpg");
INSERT INTO `wp_postmeta` VALUES("486", "217", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:427;s:6:\"height\";i:640;s:4:\"file\";s:45:\"2017/10/20131303035544Pobiedziska01000000.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:45:\"20131303035544Pobiedziska01000000-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:45:\"20131303035544Pobiedziska01000000-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:44:\"20131303035544Pobiedziska01000000-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:43:\"20131303035544Pobiedziska01000000-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:45:\"20131303035544Pobiedziska01000000-427x375.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:45:\"20131303035544Pobiedziska01000000-427x450.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:45:\"20131303035544Pobiedziska01000000-427x480.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:43:\"20131303035544Pobiedziska01000000-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:43:\"20131303035544Pobiedziska01000000-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:45:\"20131303035544Pobiedziska01000000-427x470.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:43:\"20131303035544Pobiedziska01000000-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"5.6\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1352467231\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"32\";s:3:\"iso\";s:3:\"400\";s:13:\"shutter_speed\";s:4:\"0.01\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("487", "218", "_wp_attached_file", "2017/10/20131303035557Pobiedziska02000000.jpg");
INSERT INTO `wp_postmeta` VALUES("488", "218", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:640;s:6:\"height\";i:427;s:4:\"file\";s:45:\"2017/10/20131303035557Pobiedziska02000000.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:45:\"20131303035557Pobiedziska02000000-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:45:\"20131303035557Pobiedziska02000000-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:45:\"20131303035557Pobiedziska02000000-219x146.jpg\";s:5:\"width\";i:219;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:43:\"20131303035557Pobiedziska02000000-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:45:\"20131303035557Pobiedziska02000000-640x375.jpg\";s:5:\"width\";i:640;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:45:\"20131303035557Pobiedziska02000000-480x427.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:427;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:43:\"20131303035557Pobiedziska02000000-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:44:\"20131303035557Pobiedziska02000000-112x75.jpg\";s:5:\"width\";i:112;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:43:\"20131303035557Pobiedziska02000000-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1352467297\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"38\";s:3:\"iso\";s:3:\"400\";s:13:\"shutter_speed\";s:17:\"0.016666666666667\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("489", "219", "_wp_attached_file", "2017/10/20131303035609Pobiedziska03000000.jpg");
INSERT INTO `wp_postmeta` VALUES("490", "219", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:427;s:6:\"height\";i:640;s:4:\"file\";s:45:\"2017/10/20131303035609Pobiedziska03000000.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:45:\"20131303035609Pobiedziska03000000-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:45:\"20131303035609Pobiedziska03000000-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:44:\"20131303035609Pobiedziska03000000-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:43:\"20131303035609Pobiedziska03000000-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:45:\"20131303035609Pobiedziska03000000-427x375.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:45:\"20131303035609Pobiedziska03000000-427x450.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:45:\"20131303035609Pobiedziska03000000-427x480.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:43:\"20131303035609Pobiedziska03000000-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:43:\"20131303035609Pobiedziska03000000-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:45:\"20131303035609Pobiedziska03000000-427x470.jpg\";s:5:\"width\";i:427;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:43:\"20131303035609Pobiedziska03000000-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1352467489\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"25\";s:3:\"iso\";s:3:\"400\";s:13:\"shutter_speed\";s:4:\"0.02\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("491", "141", "_wpb_shortcodes_custom_css", ".vc_custom_1507142112109{background-color: #f4f4f4 !important;}");
INSERT INTO `wp_postmeta` VALUES("492", "222", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("493", "222", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("494", "222", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("495", "222", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("496", "222", "mfn-post-hide-content", "0");
INSERT INTO `wp_postmeta` VALUES("497", "222", "mfn-post-custom-layout", "0");
INSERT INTO `wp_postmeta` VALUES("498", "222", "mfn-post-slider", "0");
INSERT INTO `wp_postmeta` VALUES("499", "222", "mfn-post-slider-layer", "0");
INSERT INTO `wp_postmeta` VALUES("500", "222", "mfn-post-menu", "0");
INSERT INTO `wp_postmeta` VALUES("501", "222", "mfn-post-one-page", "0");
INSERT INTO `wp_postmeta` VALUES("502", "222", "mfn-post-hide-title", "1");
INSERT INTO `wp_postmeta` VALUES("503", "222", "mfn-post-remove-padding", "0");
INSERT INTO `wp_postmeta` VALUES("504", "222", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("505", "222", "_dp_original", "127");
INSERT INTO `wp_postmeta` VALUES("506", "222", "_edit_lock", "1510134947:1");
INSERT INTO `wp_postmeta` VALUES("507", "222", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("508", "225", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("509", "225", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("510", "225", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("511", "225", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("512", "225", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("513", "225", "mfn-post-hide-content", "0");
INSERT INTO `wp_postmeta` VALUES("514", "225", "mfn-post-custom-layout", "0");
INSERT INTO `wp_postmeta` VALUES("515", "225", "mfn-post-slider", "0");
INSERT INTO `wp_postmeta` VALUES("516", "225", "mfn-post-slider-layer", "0");
INSERT INTO `wp_postmeta` VALUES("517", "225", "mfn-post-menu", "0");
INSERT INTO `wp_postmeta` VALUES("518", "225", "mfn-post-one-page", "0");
INSERT INTO `wp_postmeta` VALUES("519", "225", "mfn-post-hide-title", "1");
INSERT INTO `wp_postmeta` VALUES("520", "225", "mfn-post-remove-padding", "0");
INSERT INTO `wp_postmeta` VALUES("521", "225", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("523", "225", "_dp_original", "222");
INSERT INTO `wp_postmeta` VALUES("524", "225", "_edit_lock", "1510135006:1");
INSERT INTO `wp_postmeta` VALUES("525", "225", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("526", "228", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("527", "228", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("528", "228", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("529", "228", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("530", "228", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("531", "228", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("532", "228", "mfn-post-hide-content", "0");
INSERT INTO `wp_postmeta` VALUES("533", "228", "mfn-post-custom-layout", "0");
INSERT INTO `wp_postmeta` VALUES("534", "228", "mfn-post-slider", "0");
INSERT INTO `wp_postmeta` VALUES("535", "228", "mfn-post-slider-layer", "0");
INSERT INTO `wp_postmeta` VALUES("536", "228", "mfn-post-menu", "0");
INSERT INTO `wp_postmeta` VALUES("537", "228", "mfn-post-one-page", "0");
INSERT INTO `wp_postmeta` VALUES("538", "228", "mfn-post-hide-title", "1");
INSERT INTO `wp_postmeta` VALUES("539", "228", "mfn-post-remove-padding", "0");
INSERT INTO `wp_postmeta` VALUES("540", "228", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("542", "228", "_dp_original", "225");
INSERT INTO `wp_postmeta` VALUES("543", "228", "_edit_lock", "1511255122:1");
INSERT INTO `wp_postmeta` VALUES("544", "228", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("545", "232", "_wp_attached_file", "2015/04/1WINDA-MAŁE.jpg");
INSERT INTO `wp_postmeta` VALUES("546", "232", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:667;s:6:\"height\";i:1000;s:4:\"file\";s:24:\"2015/04/1WINDA-MAŁE.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"1WINDA-MAŁE-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"1WINDA-MAŁE-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:23:\"1WINDA-MAŁE-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:22:\"1WINDA-MAŁE-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"portfolio-mf\";a:4:{s:4:\"file\";s:24:\"1WINDA-MAŁE-667x750.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:24:\"1WINDA-MAŁE-667x375.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:24:\"1WINDA-MAŁE-480x750.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:24:\"1WINDA-MAŁE-667x450.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:24:\"1WINDA-MAŁE-667x480.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:22:\"1WINDA-MAŁE-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:22:\"1WINDA-MAŁE-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:24:\"1WINDA-MAŁE-667x470.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:22:\"1WINDA-MAŁE-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"4.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:10:\"NIKON D800\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1495188417\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"24\";s:3:\"iso\";s:3:\"800\";s:13:\"shutter_speed\";s:5:\"0.025\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("547", "233", "_wp_attached_file", "2015/04/2WINDA-MAŁE.jpg");
INSERT INTO `wp_postmeta` VALUES("548", "233", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:667;s:6:\"height\";i:1000;s:4:\"file\";s:24:\"2015/04/2WINDA-MAŁE.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"2WINDA-MAŁE-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"2WINDA-MAŁE-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:23:\"2WINDA-MAŁE-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:22:\"2WINDA-MAŁE-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"portfolio-mf\";a:4:{s:4:\"file\";s:24:\"2WINDA-MAŁE-667x750.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:24:\"2WINDA-MAŁE-667x375.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:24:\"2WINDA-MAŁE-480x750.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:24:\"2WINDA-MAŁE-667x450.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:24:\"2WINDA-MAŁE-667x480.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:22:\"2WINDA-MAŁE-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:22:\"2WINDA-MAŁE-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:24:\"2WINDA-MAŁE-667x470.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:22:\"2WINDA-MAŁE-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"4.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:10:\"NIKON D800\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1495188542\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"32\";s:3:\"iso\";s:3:\"800\";s:13:\"shutter_speed\";s:4:\"0.04\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("549", "234", "_wp_attached_file", "2015/04/3WINDA-MAŁE.jpg");
INSERT INTO `wp_postmeta` VALUES("550", "234", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:24:\"2015/04/3WINDA-MAŁE.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"3WINDA-MAŁE-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"3WINDA-MAŁE-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:24:\"3WINDA-MAŁE-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:24:\"3WINDA-MAŁE-219x146.jpg\";s:5:\"width\";i:219;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:22:\"3WINDA-MAŁE-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"portfolio-mf\";a:4:{s:4:\"file\";s:24:\"3WINDA-MAŁE-960x667.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:667;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:24:\"3WINDA-MAŁE-960x375.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:24:\"3WINDA-MAŁE-480x667.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:667;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:25:\"3WINDA-MAŁE-1000x450.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:25:\"3WINDA-MAŁE-1000x480.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:22:\"3WINDA-MAŁE-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:23:\"3WINDA-MAŁE-112x75.jpg\";s:5:\"width\";i:112;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:24:\"3WINDA-MAŁE-890x470.jpg\";s:5:\"width\";i:890;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:22:\"3WINDA-MAŁE-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"4.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:10:\"NIKON D800\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1495188564\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"24\";s:3:\"iso\";s:3:\"800\";s:13:\"shutter_speed\";s:8:\"0.000625\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("551", "235", "_wp_attached_file", "2015/04/4WINDA-MAŁE.jpg");
INSERT INTO `wp_postmeta` VALUES("552", "235", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:667;s:6:\"height\";i:1000;s:4:\"file\";s:24:\"2015/04/4WINDA-MAŁE.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"4WINDA-MAŁE-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"4WINDA-MAŁE-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:23:\"4WINDA-MAŁE-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:22:\"4WINDA-MAŁE-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"portfolio-mf\";a:4:{s:4:\"file\";s:24:\"4WINDA-MAŁE-667x750.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:24:\"4WINDA-MAŁE-667x375.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:24:\"4WINDA-MAŁE-480x750.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:24:\"4WINDA-MAŁE-667x450.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:24:\"4WINDA-MAŁE-667x480.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:22:\"4WINDA-MAŁE-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:22:\"4WINDA-MAŁE-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:24:\"4WINDA-MAŁE-667x470.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:22:\"4WINDA-MAŁE-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"3.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:10:\"NIKON D800\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1495188724\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"48\";s:3:\"iso\";s:4:\"1250\";s:13:\"shutter_speed\";s:5:\"0.005\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("553", "236", "_wp_attached_file", "2015/04/5WINDA-MAŁE.jpg");
INSERT INTO `wp_postmeta` VALUES("554", "236", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:667;s:6:\"height\";i:1000;s:4:\"file\";s:24:\"2015/04/5WINDA-MAŁE.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"5WINDA-MAŁE-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"5WINDA-MAŁE-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:23:\"5WINDA-MAŁE-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:22:\"5WINDA-MAŁE-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"portfolio-mf\";a:4:{s:4:\"file\";s:24:\"5WINDA-MAŁE-667x750.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:24:\"5WINDA-MAŁE-667x375.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:24:\"5WINDA-MAŁE-480x750.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:24:\"5WINDA-MAŁE-667x450.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:24:\"5WINDA-MAŁE-667x480.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:22:\"5WINDA-MAŁE-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:22:\"5WINDA-MAŁE-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:24:\"5WINDA-MAŁE-667x470.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:22:\"5WINDA-MAŁE-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"3.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:10:\"NIKON D800\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1495188849\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"28\";s:3:\"iso\";s:3:\"800\";s:13:\"shutter_speed\";s:17:\"0.066666666666667\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("555", "237", "_wp_attached_file", "2015/04/6WINDA-MAŁE.jpg");
INSERT INTO `wp_postmeta` VALUES("556", "237", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:667;s:6:\"height\";i:1000;s:4:\"file\";s:24:\"2015/04/6WINDA-MAŁE.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"6WINDA-MAŁE-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"6WINDA-MAŁE-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:23:\"6WINDA-MAŁE-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:22:\"6WINDA-MAŁE-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"portfolio-mf\";a:4:{s:4:\"file\";s:24:\"6WINDA-MAŁE-667x750.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:24:\"6WINDA-MAŁE-667x375.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:24:\"6WINDA-MAŁE-480x750.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:24:\"6WINDA-MAŁE-667x450.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:24:\"6WINDA-MAŁE-667x480.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:22:\"6WINDA-MAŁE-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:22:\"6WINDA-MAŁE-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:24:\"6WINDA-MAŁE-667x470.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:22:\"6WINDA-MAŁE-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"3.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:10:\"NIKON D800\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1495188853\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"28\";s:3:\"iso\";s:3:\"800\";s:13:\"shutter_speed\";s:17:\"0.066666666666667\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("557", "238", "_wp_attached_file", "2015/04/7WINDA-MAŁE.jpg");
INSERT INTO `wp_postmeta` VALUES("558", "238", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:24:\"2015/04/7WINDA-MAŁE.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"7WINDA-MAŁE-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"7WINDA-MAŁE-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:24:\"7WINDA-MAŁE-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:24:\"7WINDA-MAŁE-219x146.jpg\";s:5:\"width\";i:219;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:22:\"7WINDA-MAŁE-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"portfolio-mf\";a:4:{s:4:\"file\";s:24:\"7WINDA-MAŁE-960x667.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:667;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:24:\"7WINDA-MAŁE-960x375.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:24:\"7WINDA-MAŁE-480x667.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:667;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:25:\"7WINDA-MAŁE-1000x450.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:25:\"7WINDA-MAŁE-1000x480.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:22:\"7WINDA-MAŁE-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:23:\"7WINDA-MAŁE-112x75.jpg\";s:5:\"width\";i:112;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:24:\"7WINDA-MAŁE-890x470.jpg\";s:5:\"width\";i:890;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:22:\"7WINDA-MAŁE-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"3.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:10:\"NIKON D800\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1495189006\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"31\";s:3:\"iso\";s:3:\"400\";s:13:\"shutter_speed\";s:17:\"0.016666666666667\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("559", "239", "_wp_attached_file", "2015/04/8WINDA-MAŁE.jpg");
INSERT INTO `wp_postmeta` VALUES("560", "239", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:667;s:6:\"height\";i:1000;s:4:\"file\";s:24:\"2015/04/8WINDA-MAŁE.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"8WINDA-MAŁE-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"8WINDA-MAŁE-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:23:\"8WINDA-MAŁE-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:22:\"8WINDA-MAŁE-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"portfolio-mf\";a:4:{s:4:\"file\";s:24:\"8WINDA-MAŁE-667x750.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:24:\"8WINDA-MAŁE-667x375.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:24:\"8WINDA-MAŁE-480x750.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:24:\"8WINDA-MAŁE-667x450.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:24:\"8WINDA-MAŁE-667x480.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:22:\"8WINDA-MAŁE-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:22:\"8WINDA-MAŁE-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:24:\"8WINDA-MAŁE-667x470.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:22:\"8WINDA-MAŁE-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"6.3\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:10:\"NIKON D800\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1495189046\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"35\";s:3:\"iso\";s:3:\"400\";s:13:\"shutter_speed\";s:17:\"0.016666666666667\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("561", "240", "_wp_attached_file", "2015/04/9WINDA-MAŁE.jpg");
INSERT INTO `wp_postmeta` VALUES("562", "240", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:667;s:6:\"height\";i:1000;s:4:\"file\";s:24:\"2015/04/9WINDA-MAŁE.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"9WINDA-MAŁE-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"9WINDA-MAŁE-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:23:\"9WINDA-MAŁE-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:22:\"9WINDA-MAŁE-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"portfolio-mf\";a:4:{s:4:\"file\";s:24:\"9WINDA-MAŁE-667x750.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:24:\"9WINDA-MAŁE-667x375.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:24:\"9WINDA-MAŁE-480x750.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:24:\"9WINDA-MAŁE-667x450.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:24:\"9WINDA-MAŁE-667x480.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:22:\"9WINDA-MAŁE-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:22:\"9WINDA-MAŁE-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:24:\"9WINDA-MAŁE-667x470.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:22:\"9WINDA-MAŁE-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"3.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:10:\"NIKON D800\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1495189094\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"35\";s:3:\"iso\";s:4:\"1600\";s:13:\"shutter_speed\";s:17:\"0.016666666666667\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("563", "241", "_wp_attached_file", "2015/04/10WINDA-MAŁE.jpg");
INSERT INTO `wp_postmeta` VALUES("564", "241", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:25:\"2015/04/10WINDA-MAŁE.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"10WINDA-MAŁE-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"10WINDA-MAŁE-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:25:\"10WINDA-MAŁE-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:25:\"10WINDA-MAŁE-219x146.jpg\";s:5:\"width\";i:219;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:23:\"10WINDA-MAŁE-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"portfolio-mf\";a:4:{s:4:\"file\";s:25:\"10WINDA-MAŁE-960x667.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:667;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:25:\"10WINDA-MAŁE-960x375.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:25:\"10WINDA-MAŁE-480x667.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:667;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:26:\"10WINDA-MAŁE-1000x450.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:26:\"10WINDA-MAŁE-1000x480.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:23:\"10WINDA-MAŁE-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:24:\"10WINDA-MAŁE-112x75.jpg\";s:5:\"width\";i:112;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:25:\"10WINDA-MAŁE-890x470.jpg\";s:5:\"width\";i:890;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:23:\"10WINDA-MAŁE-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:10:\"NIKON D800\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1495190746\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"24\";s:3:\"iso\";s:4:\"1250\";s:13:\"shutter_speed\";s:17:\"0.016666666666667\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("565", "242", "_wp_attached_file", "2015/04/11WINDA-MAŁE.jpg");
INSERT INTO `wp_postmeta` VALUES("566", "242", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:667;s:6:\"height\";i:1000;s:4:\"file\";s:25:\"2015/04/11WINDA-MAŁE.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"11WINDA-MAŁE-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"11WINDA-MAŁE-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:24:\"11WINDA-MAŁE-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:23:\"11WINDA-MAŁE-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"portfolio-mf\";a:4:{s:4:\"file\";s:25:\"11WINDA-MAŁE-667x750.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:25:\"11WINDA-MAŁE-667x375.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:25:\"11WINDA-MAŁE-480x750.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:25:\"11WINDA-MAŁE-667x450.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:25:\"11WINDA-MAŁE-667x480.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:23:\"11WINDA-MAŁE-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:23:\"11WINDA-MAŁE-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:25:\"11WINDA-MAŁE-667x470.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:23:\"11WINDA-MAŁE-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:10:\"NIKON D800\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1495190986\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"32\";s:3:\"iso\";s:3:\"800\";s:13:\"shutter_speed\";s:17:\"0.076923076923077\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("567", "243", "_wp_attached_file", "2015/04/12WINDA-MAŁE.jpg");
INSERT INTO `wp_postmeta` VALUES("568", "243", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:25:\"2015/04/12WINDA-MAŁE.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"12WINDA-MAŁE-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"12WINDA-MAŁE-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:25:\"12WINDA-MAŁE-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:25:\"12WINDA-MAŁE-219x146.jpg\";s:5:\"width\";i:219;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:23:\"12WINDA-MAŁE-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"portfolio-mf\";a:4:{s:4:\"file\";s:25:\"12WINDA-MAŁE-960x667.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:667;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:25:\"12WINDA-MAŁE-960x375.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:25:\"12WINDA-MAŁE-480x667.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:667;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:26:\"12WINDA-MAŁE-1000x450.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:26:\"12WINDA-MAŁE-1000x480.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:23:\"12WINDA-MAŁE-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:24:\"12WINDA-MAŁE-112x75.jpg\";s:5:\"width\";i:112;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:25:\"12WINDA-MAŁE-890x470.jpg\";s:5:\"width\";i:890;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:23:\"12WINDA-MAŁE-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"3.2\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:10:\"NIKON D800\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1495191045\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"31\";s:3:\"iso\";s:4:\"1600\";s:13:\"shutter_speed\";s:17:\"0.016666666666667\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("569", "244", "_wp_attached_file", "2015/04/13WINDA-MAŁE.jpg");
INSERT INTO `wp_postmeta` VALUES("570", "244", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:25:\"2015/04/13WINDA-MAŁE.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"13WINDA-MAŁE-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"13WINDA-MAŁE-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:25:\"13WINDA-MAŁE-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:25:\"13WINDA-MAŁE-219x146.jpg\";s:5:\"width\";i:219;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:23:\"13WINDA-MAŁE-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"portfolio-mf\";a:4:{s:4:\"file\";s:25:\"13WINDA-MAŁE-960x667.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:667;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:25:\"13WINDA-MAŁE-960x375.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:25:\"13WINDA-MAŁE-480x667.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:667;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:26:\"13WINDA-MAŁE-1000x450.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:26:\"13WINDA-MAŁE-1000x480.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:23:\"13WINDA-MAŁE-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:24:\"13WINDA-MAŁE-112x75.jpg\";s:5:\"width\";i:112;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:25:\"13WINDA-MAŁE-890x470.jpg\";s:5:\"width\";i:890;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:23:\"13WINDA-MAŁE-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"3.2\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:10:\"NIKON D800\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1495191083\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"26\";s:3:\"iso\";s:4:\"1600\";s:13:\"shutter_speed\";s:6:\"0.0025\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("571", "245", "_wp_attached_file", "2015/04/14WINDA-MAŁE.jpg");
INSERT INTO `wp_postmeta` VALUES("572", "245", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:667;s:6:\"height\";i:1000;s:4:\"file\";s:25:\"2015/04/14WINDA-MAŁE.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"14WINDA-MAŁE-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"14WINDA-MAŁE-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:24:\"14WINDA-MAŁE-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:23:\"14WINDA-MAŁE-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"portfolio-mf\";a:4:{s:4:\"file\";s:25:\"14WINDA-MAŁE-667x750.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:25:\"14WINDA-MAŁE-667x375.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:25:\"14WINDA-MAŁE-480x750.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:25:\"14WINDA-MAŁE-667x450.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:25:\"14WINDA-MAŁE-667x480.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:23:\"14WINDA-MAŁE-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:23:\"14WINDA-MAŁE-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:25:\"14WINDA-MAŁE-667x470.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:23:\"14WINDA-MAŁE-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"3.2\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:10:\"NIKON D800\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1495191363\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"34\";s:3:\"iso\";s:4:\"1250\";s:13:\"shutter_speed\";s:17:\"0.016666666666667\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("573", "246", "_wp_attached_file", "2015/04/15WINDA-MAŁE.jpg");
INSERT INTO `wp_postmeta` VALUES("574", "246", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:25:\"2015/04/15WINDA-MAŁE.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"15WINDA-MAŁE-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"15WINDA-MAŁE-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:25:\"15WINDA-MAŁE-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:25:\"15WINDA-MAŁE-219x146.jpg\";s:5:\"width\";i:219;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:23:\"15WINDA-MAŁE-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"portfolio-mf\";a:4:{s:4:\"file\";s:25:\"15WINDA-MAŁE-960x667.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:667;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:25:\"15WINDA-MAŁE-960x375.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:25:\"15WINDA-MAŁE-480x667.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:667;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:26:\"15WINDA-MAŁE-1000x450.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:26:\"15WINDA-MAŁE-1000x480.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:23:\"15WINDA-MAŁE-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:24:\"15WINDA-MAŁE-112x75.jpg\";s:5:\"width\";i:112;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:25:\"15WINDA-MAŁE-890x470.jpg\";s:5:\"width\";i:890;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:23:\"15WINDA-MAŁE-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"3.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:10:\"NIKON D800\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1495191517\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"56\";s:3:\"iso\";s:3:\"500\";s:13:\"shutter_speed\";s:4:\"0.05\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("575", "247", "_wp_attached_file", "2015/04/16WINDA-MAŁE.jpg");
INSERT INTO `wp_postmeta` VALUES("576", "247", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:667;s:6:\"height\";i:1000;s:4:\"file\";s:25:\"2015/04/16WINDA-MAŁE.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"16WINDA-MAŁE-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"16WINDA-MAŁE-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:24:\"16WINDA-MAŁE-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:23:\"16WINDA-MAŁE-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"portfolio-mf\";a:4:{s:4:\"file\";s:25:\"16WINDA-MAŁE-667x750.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:25:\"16WINDA-MAŁE-667x375.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:25:\"16WINDA-MAŁE-480x750.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:25:\"16WINDA-MAŁE-667x450.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:25:\"16WINDA-MAŁE-667x480.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:23:\"16WINDA-MAŁE-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:23:\"16WINDA-MAŁE-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:25:\"16WINDA-MAŁE-667x470.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:23:\"16WINDA-MAŁE-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"3.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:10:\"NIKON D800\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1495191599\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"36\";s:3:\"iso\";s:3:\"500\";s:13:\"shutter_speed\";s:4:\"0.05\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("577", "248", "_wp_attached_file", "2015/04/17WINDA-MAŁE.jpg");
INSERT INTO `wp_postmeta` VALUES("578", "248", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:25:\"2015/04/17WINDA-MAŁE.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"17WINDA-MAŁE-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"17WINDA-MAŁE-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:25:\"17WINDA-MAŁE-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:25:\"17WINDA-MAŁE-219x146.jpg\";s:5:\"width\";i:219;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:23:\"17WINDA-MAŁE-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"portfolio-mf\";a:4:{s:4:\"file\";s:25:\"17WINDA-MAŁE-960x667.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:667;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:25:\"17WINDA-MAŁE-960x375.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:25:\"17WINDA-MAŁE-480x667.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:667;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:26:\"17WINDA-MAŁE-1000x450.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:26:\"17WINDA-MAŁE-1000x480.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:23:\"17WINDA-MAŁE-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:24:\"17WINDA-MAŁE-112x75.jpg\";s:5:\"width\";i:112;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:25:\"17WINDA-MAŁE-890x470.jpg\";s:5:\"width\";i:890;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:23:\"17WINDA-MAŁE-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"3.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:10:\"NIKON D800\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1495192455\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"28\";s:3:\"iso\";s:3:\"500\";s:13:\"shutter_speed\";s:4:\"0.04\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("579", "249", "_wp_attached_file", "2015/04/18WINDA-MAŁE.jpg");
INSERT INTO `wp_postmeta` VALUES("580", "249", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:667;s:6:\"height\";i:1000;s:4:\"file\";s:25:\"2015/04/18WINDA-MAŁE.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"18WINDA-MAŁE-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"18WINDA-MAŁE-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:24:\"18WINDA-MAŁE-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:23:\"18WINDA-MAŁE-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"portfolio-mf\";a:4:{s:4:\"file\";s:25:\"18WINDA-MAŁE-667x750.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:25:\"18WINDA-MAŁE-667x375.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:25:\"18WINDA-MAŁE-480x750.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:25:\"18WINDA-MAŁE-667x450.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:25:\"18WINDA-MAŁE-667x480.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:23:\"18WINDA-MAŁE-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:23:\"18WINDA-MAŁE-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:25:\"18WINDA-MAŁE-667x470.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:23:\"18WINDA-MAŁE-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"3.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:10:\"NIKON D800\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1495192530\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"35\";s:3:\"iso\";s:3:\"800\";s:13:\"shutter_speed\";s:6:\"0.0125\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("581", "250", "_wp_attached_file", "2015/04/19WINDA-MAŁE.jpg");
INSERT INTO `wp_postmeta` VALUES("582", "250", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:667;s:6:\"height\";i:1000;s:4:\"file\";s:25:\"2015/04/19WINDA-MAŁE.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"19WINDA-MAŁE-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"19WINDA-MAŁE-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:24:\"19WINDA-MAŁE-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:23:\"19WINDA-MAŁE-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"portfolio-mf\";a:4:{s:4:\"file\";s:25:\"19WINDA-MAŁE-667x750.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:25:\"19WINDA-MAŁE-667x375.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:25:\"19WINDA-MAŁE-480x750.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:25:\"19WINDA-MAŁE-667x450.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:25:\"19WINDA-MAŁE-667x480.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:23:\"19WINDA-MAŁE-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:23:\"19WINDA-MAŁE-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:25:\"19WINDA-MAŁE-667x470.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:23:\"19WINDA-MAŁE-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"3.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:10:\"NIKON D800\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1495192620\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"36\";s:3:\"iso\";s:4:\"1600\";s:13:\"shutter_speed\";s:5:\"0.008\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("583", "251", "_wp_attached_file", "2015/04/20WINDA-MAŁE.jpg");
INSERT INTO `wp_postmeta` VALUES("584", "251", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:667;s:4:\"file\";s:25:\"2015/04/20WINDA-MAŁE.jpg\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"20WINDA-MAŁE-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"20WINDA-MAŁE-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:25:\"20WINDA-MAŁE-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:25:\"20WINDA-MAŁE-219x146.jpg\";s:5:\"width\";i:219;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:23:\"20WINDA-MAŁE-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"portfolio-mf\";a:4:{s:4:\"file\";s:25:\"20WINDA-MAŁE-960x667.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:667;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:25:\"20WINDA-MAŁE-960x375.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:25:\"20WINDA-MAŁE-480x667.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:667;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:26:\"20WINDA-MAŁE-1000x450.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:26:\"20WINDA-MAŁE-1000x480.jpg\";s:5:\"width\";i:1000;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:23:\"20WINDA-MAŁE-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:24:\"20WINDA-MAŁE-112x75.jpg\";s:5:\"width\";i:112;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:25:\"20WINDA-MAŁE-890x470.jpg\";s:5:\"width\";i:890;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:23:\"20WINDA-MAŁE-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"3.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:10:\"NIKON D800\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1495192910\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"50\";s:3:\"iso\";s:3:\"800\";s:13:\"shutter_speed\";s:4:\"0.01\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("585", "252", "_wp_attached_file", "2015/04/21WINDA-MAŁE.jpg");
INSERT INTO `wp_postmeta` VALUES("586", "252", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:667;s:6:\"height\";i:1000;s:4:\"file\";s:25:\"2015/04/21WINDA-MAŁE.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"21WINDA-MAŁE-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"21WINDA-MAŁE-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:24:\"21WINDA-MAŁE-97x146.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:23:\"21WINDA-MAŁE-33x50.jpg\";s:5:\"width\";i:33;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"portfolio-mf\";a:4:{s:4:\"file\";s:25:\"21WINDA-MAŁE-667x750.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:25:\"21WINDA-MAŁE-667x375.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:25:\"21WINDA-MAŁE-480x750.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:25:\"21WINDA-MAŁE-667x450.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:25:\"21WINDA-MAŁE-667x480.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:23:\"21WINDA-MAŁE-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:23:\"21WINDA-MAŁE-50x75.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:25:\"21WINDA-MAŁE-667x470.jpg\";s:5:\"width\";i:667;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:23:\"21WINDA-MAŁE-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"3.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:10:\"NIKON D800\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1495193108\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"27\";s:3:\"iso\";s:3:\"800\";s:13:\"shutter_speed\";s:5:\"0.125\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("587", "36", "mfn-post-subheader-image", "");
INSERT INTO `wp_postmeta` VALUES("588", "36", "_wpb_post_custom_css", "#naglowek {font-size: 40px; font-family: lato;}");
INSERT INTO `wp_postmeta` VALUES("589", "127", "_wpb_shortcodes_custom_css", ".vc_custom_1507210740652{background-color: #f4f4f4 !important;}");
INSERT INTO `wp_postmeta` VALUES("590", "222", "_wpb_shortcodes_custom_css", ".vc_custom_1507210820157{background-color: #f4f4f4 !important;}");
INSERT INTO `wp_postmeta` VALUES("591", "225", "_wpb_shortcodes_custom_css", ".vc_custom_1507210887662{background-color: #f4f4f4 !important;}");
INSERT INTO `wp_postmeta` VALUES("592", "228", "_wpb_shortcodes_custom_css", ".vc_custom_1507210950870{background-color: #f4f4f4 !important;}");
INSERT INTO `wp_postmeta` VALUES("594", "286", "_wp_attached_file", "2017/10/20150605_0633-flota-.jpg");
INSERT INTO `wp_postmeta` VALUES("595", "286", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:3888;s:6:\"height\";i:2592;s:4:\"file\";s:32:\"2017/10/20150605_0633-flota-.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"20150605_0633-flota--150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"20150605_0633-flota--300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:32:\"20150605_0633-flota--768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:33:\"20150605_0633-flota--1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:32:\"20150605_0633-flota--219x146.jpg\";s:5:\"width\";i:219;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:30:\"20150605_0633-flota--50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"portfolio-mf\";a:4:{s:4:\"file\";s:32:\"20150605_0633-flota--960x750.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:32:\"20150605_0633-flota--960x375.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:32:\"20150605_0633-flota--480x750.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:33:\"20150605_0633-flota--1160x450.jpg\";s:5:\"width\";i:1160;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:33:\"20150605_0633-flota--1200x480.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:30:\"20150605_0633-flota--80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:31:\"20150605_0633-flota--113x75.jpg\";s:5:\"width\";i:113;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:32:\"20150605_0633-flota--890x470.jpg\";s:5:\"width\";i:890;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:30:\"20150605_0633-flota--85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:2:\"11\";s:6:\"credit\";s:18:\"Andrzej Stachowiak\";s:6:\"camera\";s:22:\"Canon EOS 400D DIGITAL\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1433498975\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"18\";s:3:\"iso\";s:3:\"400\";s:13:\"shutter_speed\";s:6:\"0.0025\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("596", "287", "_wp_attached_file", "2017/10/IMG_3977.jpg");
INSERT INTO `wp_postmeta` VALUES("597", "287", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:3888;s:6:\"height\";i:2592;s:4:\"file\";s:20:\"2017/10/IMG_3977.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_3977-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_3977-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:20:\"IMG_3977-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"IMG_3977-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_3977-219x146.jpg\";s:5:\"width\";i:219;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:18:\"IMG_3977-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"portfolio-mf\";a:4:{s:4:\"file\";s:20:\"IMG_3977-960x750.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:20:\"IMG_3977-960x375.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:20:\"IMG_3977-480x750.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:21:\"IMG_3977-1160x450.jpg\";s:5:\"width\";i:1160;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:21:\"IMG_3977-1200x480.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:18:\"IMG_3977-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:19:\"IMG_3977-113x75.jpg\";s:5:\"width\";i:113;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:20:\"IMG_3977-890x470.jpg\";s:5:\"width\";i:890;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:18:\"IMG_3977-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"4\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:22:\"Canon EOS 400D DIGITAL\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1267729042\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"27\";s:3:\"iso\";s:3:\"400\";s:13:\"shutter_speed\";s:3:\"1.3\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("599", "293", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("600", "293", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("601", "293", "_menu_item_menu_item_parent", "10");
INSERT INTO `wp_postmeta` VALUES("602", "293", "_menu_item_object_id", "293");
INSERT INTO `wp_postmeta` VALUES("603", "293", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("604", "293", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("605", "293", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("606", "293", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("607", "293", "_menu_item_url", "/oferta/dzwigi-osobowe/");
INSERT INTO `wp_postmeta` VALUES("609", "293", "menu-item-mfn-megamenu", "");
INSERT INTO `wp_postmeta` VALUES("610", "293", "menu-item-mfn-bg", "");
INSERT INTO `wp_postmeta` VALUES("611", "294", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("612", "294", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("613", "294", "_menu_item_menu_item_parent", "10");
INSERT INTO `wp_postmeta` VALUES("614", "294", "_menu_item_object_id", "294");
INSERT INTO `wp_postmeta` VALUES("615", "294", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("616", "294", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("617", "294", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("618", "294", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("619", "294", "_menu_item_url", "/oferta/dzwigi-towarowe/");
INSERT INTO `wp_postmeta` VALUES("621", "294", "menu-item-mfn-megamenu", "");
INSERT INTO `wp_postmeta` VALUES("622", "294", "menu-item-mfn-bg", "");
INSERT INTO `wp_postmeta` VALUES("623", "295", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("624", "295", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("625", "295", "_menu_item_menu_item_parent", "10");
INSERT INTO `wp_postmeta` VALUES("626", "295", "_menu_item_object_id", "295");
INSERT INTO `wp_postmeta` VALUES("627", "295", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("628", "295", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("629", "295", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("630", "295", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("631", "295", "_menu_item_url", "/oferta/dzwigi-dla-osob-niepelnosprawnych/");
INSERT INTO `wp_postmeta` VALUES("633", "295", "menu-item-mfn-megamenu", "");
INSERT INTO `wp_postmeta` VALUES("634", "295", "menu-item-mfn-bg", "");
INSERT INTO `wp_postmeta` VALUES("635", "296", "_wp_attached_file", "2017/11/Slider-2.jpg");
INSERT INTO `wp_postmeta` VALUES("636", "296", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:4000;s:6:\"height\";i:2669;s:4:\"file\";s:20:\"2017/11/Slider-2.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"Slider-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"Slider-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:20:\"Slider-2-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"Slider-2-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:20:\"Slider-2-219x146.jpg\";s:5:\"width\";i:219;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"50x50\";a:4:{s:4:\"file\";s:18:\"Slider-2-50x33.jpg\";s:5:\"width\";i:50;s:6:\"height\";i:33;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"portfolio-mf\";a:4:{s:4:\"file\";s:20:\"Slider-2-960x750.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-w\";a:4:{s:4:\"file\";s:20:\"Slider-2-960x375.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-mf-t\";a:4:{s:4:\"file\";s:20:\"Slider-2-480x750.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:750;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-list\";a:4:{s:4:\"file\";s:21:\"Slider-2-1160x450.jpg\";s:5:\"width\";i:1160;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-single\";a:4:{s:4:\"file\";s:21:\"Slider-2-1200x480.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"blog-navi\";a:4:{s:4:\"file\";s:18:\"Slider-2-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"clients-slider\";a:4:{s:4:\"file\";s:19:\"Slider-2-112x75.jpg\";s:5:\"width\";i:112;s:6:\"height\";i:75;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"slider-content\";a:4:{s:4:\"file\";s:20:\"Slider-2-890x470.jpg\";s:5:\"width\";i:890;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"testimonials\";a:4:{s:4:\"file\";s:18:\"Slider-2-85x85.jpg\";s:5:\"width\";i:85;s:6:\"height\";i:85;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"3.2\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:10:\"NIKON D800\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1495191083\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"26\";s:3:\"iso\";s:4:\"1600\";s:13:\"shutter_speed\";s:6:\"0.0025\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("639", "309", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("640", "309", "_wpb_shortcodes_custom_css", ".vc_custom_1507210950870{background-color: #f4f4f4 !important;}");
INSERT INTO `wp_postmeta` VALUES("641", "309", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("642", "309", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("643", "309", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("644", "309", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("645", "309", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("646", "309", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("647", "309", "mfn-post-hide-content", "0");
INSERT INTO `wp_postmeta` VALUES("648", "309", "mfn-post-custom-layout", "0");
INSERT INTO `wp_postmeta` VALUES("649", "309", "mfn-post-slider", "0");
INSERT INTO `wp_postmeta` VALUES("650", "309", "mfn-post-slider-layer", "0");
INSERT INTO `wp_postmeta` VALUES("651", "309", "mfn-post-menu", "0");
INSERT INTO `wp_postmeta` VALUES("652", "309", "mfn-post-one-page", "0");
INSERT INTO `wp_postmeta` VALUES("653", "309", "mfn-post-hide-title", "1");
INSERT INTO `wp_postmeta` VALUES("654", "309", "mfn-post-remove-padding", "0");
INSERT INTO `wp_postmeta` VALUES("655", "309", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("657", "309", "_wpb_shortcodes_custom_css", ".vc_custom_1507210950870{background-color: #f4f4f4 !important;}");
INSERT INTO `wp_postmeta` VALUES("658", "309", "_dp_original", "228");
INSERT INTO `wp_postmeta` VALUES("660", "313", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO `wp_postmeta` VALUES("661", "313", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("662", "313", "_edit_lock", "1527162248:1");
INSERT INTO `wp_postmeta` VALUES("663", "313", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("664", "313", "slide_template", "default");
INSERT INTO `wp_postmeta` VALUES("665", "313", "mfn-post-hide-content", "0");
INSERT INTO `wp_postmeta` VALUES("666", "313", "mfn-post-custom-layout", "0");
INSERT INTO `wp_postmeta` VALUES("667", "313", "mfn-post-slider", "0");
INSERT INTO `wp_postmeta` VALUES("668", "313", "mfn-post-slider-layer", "0");
INSERT INTO `wp_postmeta` VALUES("669", "313", "mfn-post-menu", "0");
INSERT INTO `wp_postmeta` VALUES("670", "313", "mfn-post-one-page", "0");
INSERT INTO `wp_postmeta` VALUES("671", "313", "mfn-post-hide-title", "0");
INSERT INTO `wp_postmeta` VALUES("672", "313", "mfn-post-remove-padding", "0");
INSERT INTO `wp_postmeta` VALUES("673", "313", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("674", "43", "_config_errors", "a:1:{s:11:\"mail.sender\";a:1:{i:0;a:2:{s:4:\"code\";i:103;s:4:\"args\";a:3:{s:7:\"message\";s:0:\"\";s:6:\"params\";a:0:{}s:4:\"link\";s:70:\"https://contactform7.com/configuration-errors/email-not-in-site-domain\";}}}}");
INSERT INTO `wp_postmeta` VALUES("675", "323", "_vc_post_settings", "a:1:{s:10:\"vc_grid_id\";a:0:{}}");

/* INSERT TABLE DATA: wp_posts */
INSERT INTO `wp_posts` VALUES("8", "1", "2017-10-02 15:27:06", "2017-10-02 13:27:06", "<label> Your Name (required)\n    [text* your-name] </label>\n\n<label> Your Email (required)\n    [email* your-email] </label>\n\n<label> Subject\n    [text your-subject] </label>\n\n<label> Your Message\n    [textarea your-message] </label>\n\n[submit \"Send\"]\nWinda \"[your-subject]\"\n[your-name] <wordpress@winda.ucr.com.pl>\nFrom: [your-name] <[your-email]>\nSubject: [your-subject]\n\nMessage Body:\n[your-message]\n\n-- \nThis e-mail was sent from a contact form on Winda (http://www.winda.poznan.pl)\ninfo@ucr.com.pl\nReply-To: [your-email]\n\n0\n0\n\nWinda \"[your-subject]\"\nWinda <wordpress@winda.ucr.com.pl>\nMessage Body:\n[your-message]\n\n-- \nThis e-mail was sent from a contact form on Winda (http://www.winda.poznan.pl)\n[your-email]\nReply-To: info@ucr.com.pl\n\n0\n0\nThank you for your message. It has been sent.\nThere was an error trying to send your message. Please try again later.\nOne or more fields have an error. Please check and try again.\nThere was an error trying to send your message. Please try again later.\nYou must accept the terms and conditions before sending your message.\nThe field is required.\nThe field is too long.\nThe field is too short.", "Contact form 1", "", "publish", "closed", "closed", "", "contact-form-1", "", "", "2017-10-02 15:27:06", "2017-10-02 13:27:06", "", "0", "http://www.winda.poznan.pl/?post_type=wpcf7_contact_form&p=8", "0", "wpcf7_contact_form", "", "0");
INSERT INTO `wp_posts` VALUES("9", "1", "2017-10-02 15:28:15", "2017-10-02 13:28:15", "", "O firmie", "", "publish", "closed", "closed", "", "o-firmie", "", "", "2017-11-09 13:51:49", "2017-11-09 12:51:49", "", "0", "http://www.winda.poznan.pl/?p=9", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("10", "1", "2017-10-02 15:28:15", "2017-10-02 13:28:15", "", "Oferta", "", "publish", "closed", "closed", "", "oferta", "", "", "2017-11-09 13:51:49", "2017-11-09 12:51:49", "", "0", "http://www.winda.poznan.pl/?p=10", "2", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("11", "1", "2017-10-02 15:28:15", "2017-10-02 13:28:15", "", "Serwis", "", "publish", "closed", "closed", "", "serwis", "", "", "2017-11-09 13:51:49", "2017-11-09 12:51:49", "", "0", "http://www.winda.poznan.pl/?p=11", "6", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("14", "1", "2017-10-02 15:28:15", "2017-10-02 13:28:15", "", "Galeria", "", "publish", "closed", "closed", "", "certyfikaty", "", "", "2017-11-09 13:51:49", "2017-11-09 12:51:49", "", "0", "http://www.winda.poznan.pl/?p=14", "7", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("15", "1", "2017-10-02 15:28:15", "2017-10-02 13:28:15", "", "Kontakt", "", "publish", "closed", "closed", "", "kontakt", "", "", "2017-11-09 13:51:49", "2017-11-09 12:51:49", "", "0", "http://www.winda.poznan.pl/?p=15", "8", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("16", "1", "2017-10-02 15:28:34", "2017-10-02 13:28:34", "", "logo", "", "inherit", "closed", "closed", "", "logo", "", "", "2017-10-02 15:28:34", "2017-10-02 13:28:34", "", "0", "http://www.winda.poznan.pl/wp-content/uploads/2017/10/logo.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("17", "1", "2015-04-10 12:42:17", "2015-04-10 12:42:17", "", "slide-lawyer-bg", "", "inherit", "open", "open", "", "slide-lawyer-bg", "", "", "2015-04-10 12:42:17", "2015-04-10 12:42:17", "", "0", "http://www.winda.poznan.pl/wp-content/uploads/2015/04/slide-lawyer-bg.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("18", "1", "2015-04-10 12:42:39", "2015-04-10 12:42:39", "", "slide-lawyer-5", "", "inherit", "open", "open", "", "slide-lawyer-5", "", "", "2015-04-10 12:42:39", "2015-04-10 12:42:39", "", "0", "http://www.winda.poznan.pl/wp-content/uploads/2015/04/slide-lawyer-5.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("19", "1", "2015-04-10 12:42:53", "2015-04-10 12:42:53", "", "slide-lawyer-4", "", "inherit", "open", "open", "", "slide-lawyer-4", "", "", "2015-04-10 12:42:53", "2015-04-10 12:42:53", "", "0", "http://www.winda.poznan.pl/wp-content/uploads/2015/04/slide-lawyer-4.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("20", "1", "2015-04-10 12:43:05", "2015-04-10 12:43:05", "", "slide-lawyer-3", "", "inherit", "open", "open", "", "slide-lawyer-3", "", "", "2015-04-10 12:43:05", "2015-04-10 12:43:05", "", "0", "http://www.winda.poznan.pl/wp-content/uploads/2015/04/slide-lawyer-3.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("21", "1", "2015-04-10 12:43:16", "2015-04-10 12:43:16", "", "slide-lawyer-2", "", "inherit", "open", "open", "", "slide-lawyer-2", "", "", "2015-04-10 12:43:16", "2015-04-10 12:43:16", "", "0", "http://www.winda.poznan.pl/wp-content/uploads/2015/04/slide-lawyer-2.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("22", "1", "2015-04-10 12:43:36", "2015-04-10 12:43:36", "", "slide-lawyer-1", "", "inherit", "open", "open", "", "slide-lawyer-1", "", "", "2015-04-10 12:43:36", "2015-04-10 12:43:36", "", "0", "http://www.winda.poznan.pl/wp-content/uploads/2015/04/slide-lawyer-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("23", "1", "2015-04-10 12:45:16", "2015-04-10 12:45:16", "", "lawyer", "", "inherit", "open", "open", "", "lawyer", "", "", "2015-04-10 12:45:16", "2015-04-10 12:45:16", "", "0", "http://www.winda.poznan.pl/wp-content/uploads/2015/04/lawyer.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("24", "1", "2015-04-10 12:45:17", "2015-04-10 12:45:17", "", "retina-lawyer", "", "inherit", "open", "open", "", "retina-lawyer", "", "", "2015-04-10 12:45:17", "2015-04-10 12:45:17", "", "0", "http://www.winda.poznan.pl/wp-content/uploads/2015/04/retina-lawyer.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("25", "1", "2015-04-10 12:47:49", "2015-04-10 12:47:49", "", "home_lawyer_section", "", "inherit", "open", "open", "", "home_lawyer_section", "", "", "2015-04-10 12:47:49", "2015-04-10 12:47:49", "", "49", "http://www.winda.poznan.pl/wp-content/uploads/2015/04/home_lawyer_section.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("26", "1", "2015-04-10 12:48:03", "2015-04-10 12:48:03", "", "home_lawyer_list_1", "", "inherit", "open", "open", "", "home_lawyer_list_1", "", "", "2015-04-10 12:48:03", "2015-04-10 12:48:03", "", "49", "http://www.winda.poznan.pl/wp-content/uploads/2015/04/home_lawyer_list_1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("27", "1", "2015-04-10 12:48:13", "2015-04-10 12:48:13", "", "home_lawyer_list_2", "", "inherit", "open", "open", "", "home_lawyer_list_2", "", "", "2015-04-10 12:48:13", "2015-04-10 12:48:13", "", "49", "http://www.winda.poznan.pl/wp-content/uploads/2015/04/home_lawyer_list_2.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("28", "1", "2015-04-10 12:48:22", "2015-04-10 12:48:22", "", "home_lawyer_list_3", "", "inherit", "open", "open", "", "home_lawyer_list_3", "", "", "2015-04-10 12:48:22", "2015-04-10 12:48:22", "", "49", "http://www.winda.poznan.pl/wp-content/uploads/2015/04/home_lawyer_list_3.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("29", "1", "2015-04-10 12:48:32", "2015-04-10 12:48:32", "", "home_lawyer_4", "", "inherit", "open", "open", "", "home_lawyer_4", "", "", "2015-04-10 12:48:32", "2015-04-10 12:48:32", "", "49", "http://www.winda.poznan.pl/wp-content/uploads/2015/04/home_lawyer_4.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("30", "1", "2015-04-10 12:48:42", "2015-04-10 12:48:42", "", "home_lawyer_5", "", "inherit", "open", "open", "", "home_lawyer_5", "", "", "2015-04-10 12:48:42", "2015-04-10 12:48:42", "", "49", "http://www.winda.poznan.pl/wp-content/uploads/2015/04/home_lawyer_5.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("31", "1", "2015-04-10 12:48:53", "2015-04-10 12:48:53", "", "home_lawyer_6", "", "inherit", "open", "open", "", "home_lawyer_6", "", "", "2015-04-10 12:48:53", "2015-04-10 12:48:53", "", "49", "http://www.winda.poznan.pl/wp-content/uploads/2015/04/home_lawyer_6.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("32", "1", "2015-04-10 12:49:37", "2015-04-10 12:49:37", "", "home_lawyer_about", "", "inherit", "open", "open", "", "home_lawyer_about", "", "", "2015-04-10 12:49:37", "2015-04-10 12:49:37", "", "0", "http://www.winda.poznan.pl/wp-content/uploads/2015/04/home_lawyer_about.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("33", "1", "2015-04-10 12:50:05", "2015-04-10 12:50:05", "", "home_lawyer_specialist", "", "inherit", "open", "open", "", "home_lawyer_specialist", "", "", "2015-04-10 12:50:05", "2015-04-10 12:50:05", "", "49", "http://www.winda.poznan.pl/wp-content/uploads/2015/04/home_lawyer_specialist.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("36", "1", "2015-04-11 17:58:23", "2015-04-11 17:58:23", "[vc_row full_width=\"stretch_row\" parallax=\"content-moving\" parallax_image=\"25\"][vc_column 0=\"\"][vc_text_separator title=\"KONTAKT Z NAMI\" color=\"green\" el_id=\"naglowek\"][vc_row_inner 0=\"\"][vc_column_inner width=\"1/3\"][vc_custom_heading text=\"``WINDA`` S.j. Zakład Elektromechaniki Dźwigowej\" font_container=\"tag:h2|font_size:22|text_align:left\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_custom_heading text=\"61-357 Poznań, ul. Gołężycka 26\ntel. (61) 879-63-10\ntel. kom. 501 437 310\" font_container=\"tag:p|font_size:16|text_align:left\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal\"][vc_custom_heading text=\"61-251 Poznań, oś. Orła Białego 3\" font_container=\"tag:p|font_size:16|text_align:left\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal\"][vc_custom_heading text=\"Masz do nas pytania? Skontaktuj się z nami w dogodny dla Ciebie sposób. Jesteśmy do dyspozycji od poniedziałku do piątku w godzinach 8:00 - 17:00.\" font_container=\"tag:p|font_size:16|text_align:left\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal\"][/vc_column_inner][vc_column_inner width=\"1/3\"][contact-form-7 id=\"43\"][/vc_column_inner][vc_column_inner width=\"1/3\"][vc_gmaps link=\"#E-8_JTNDaWZyYW1lJTIwc3JjJTNEJTIyaHR0cHMlM0ElMkYlMkZ3d3cuZ29vZ2xlLmNvbSUyRm1hcHMlMkZlbWJlZCUzRnBiJTNEJTIxMW0xOCUyMTFtMTIlMjExbTMlMjExZDI0MzYuMjU5MDg1NjExNjQ1JTIxMmQxNi45NDg5MTkyMTUzNjEwNDglMjEzZDUyLjM2NTcyMTk3OTc4NTI0JTIxMm0zJTIxMWYwJTIxMmYwJTIxM2YwJTIxM20yJTIxMWkxMDI0JTIxMmk3NjglMjE0ZjEzLjElMjEzbTMlMjExbTIlMjExczB4NDcwNDVhNWYxYmJiZGY2MyUyNTNBMHg5ZjJlYmViNWJhMmJkZWUlMjEyelIyX0Znc1NaeGJ4NVkydGhJREkyTENCUWIzcHVZY1dFTENCUWIyeHphMkUlMjE1ZTAlMjEzbTIlMjExc3BsJTIxMnN1cyUyMTR2MTUwNzAzOTU0MjE4MSUyMiUyMHdpZHRoJTNEJTIyMTAwJTI1JTIyJTIwaGVpZ2h0JTNEJTIyMjAwJTIyJTIwZnJhbWVib3JkZXIlM0QlMjIwJTIyJTIwc3R5bGUlM0QlMjJib3JkZXIlM0EwJTIyJTIwYWxsb3dmdWxsc2NyZWVuJTNFJTNDJTJGaWZyYW1lJTNF\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]", "Kontakt", "", "publish", "open", "open", "", "kontakt", "", "", "2019-03-01 17:45:43", "2019-03-01 16:45:43", "", "0", "http://themes.muffingroup.com/be/lawyer/?page_id=36", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("43", "1", "2015-04-11 18:03:43", "2015-04-11 18:03:43", "<div class=\"column one-second\">[text* your-name placeholder \"Imię i nazwisko\"] </div>\r\n<div class=\"column one-second\">[email* your-email placeholder \"E-mail\"] </div>\r\n<div class=\"column one\">[text your-subject placeholder \"Temat\"] </div>\r\n<div class=\"column one\">[textarea your-message x4 placeholder \"Wiadomość\"]</div>\r\n[acceptance acceptance-762] Wyrażam zgodę na przetwarzanie moich danych osobowych zgodnie z ustawą o ochronie danych osobowych w związku z wysłaniem zapytania przez formularz kontaktowy. Podanie danych jest dobrowolne, ale niezbędne do przetworzenia zapytania. Zostałem /am poinformowany /a, że przysługuje mi prawo dostępu do swoich danych, możliwości ich poprawiania, żądania zaprzestania ich przetwarzania. Administratorem danych osobowych jest \"WINDA\" S.j. Zakład Elektromechaniki Dźwigowej,61-357 Poznań, ul. Gołężycka 26. [/acceptance]\r\n<div class=\"column one\">[submit \"Wyślij wiadomość\"]</div>\n1\nWiadomość z formularza kontaktowego\n[your-name] <winda.poznan@op.pl>\nwinda.poznan@op.pl\nOd: [your-name] <[your-email]>\r\nTemat wiadomości: [your-subject]\r\n\r\nWiadomość:\r\n[your-message]\r\n\r\n--\r\nWiadomość wysłana z formularza kontaktowego.\nReply-To: [your-email]\n\n\n\n\n[your-subject]\nBeLawyer - BeTheme <wordpress@themes.muffingroup.com>\n[your-email]\nMessage Body:\r\n[your-message]\r\n\r\n--\r\nThis e-mail was sent from a contact form on BeLawyer - BeTheme (http://themes.muffingroup.com/be/lawyer)\nReply-To: noreply@gmail.com\n\n\n\nWiadomość została wysłana\nWiadomość nie została wysłana\nWprowadzono nieprawidłową treść\nWysłany formularz został oznaczony jako spam\nNie wyrażono zgody, która jest wymagana do wysłania formularza\nWymagane pole nie zostało wypełnione\nJedno z pól zawiera zbyt długą treść\nJedno z pól zawiera zbyt krótką treść\nFormat daty podany przez nadawcę jest niepoprawny.\nData jest wcześniejsza, niż okreśłone minimum.\nData jest późniejsza, niż określone maksimum.\nWgrywanie pliku nie powiodło się z jakiegoś powodu\nPrzesłanie pliku danego typu jest zabronione\nPrzesyłany plik jest za duży\nPrzesyłanie pliku nie powiodło się z powodu błędu PHP\nFormat liczby podany przez nadawcę jest niepoprawny.\nLiczba jest mniejsza niż określone minimum.\nLiczba jest większa, niż określone maksimum.\nNie udzielono poprawnej odpowiedzi na quiz\nYour entered code is incorrect.\nAdres e-mail jest niepoprawny\nAdres URL podany przez nadawcę jest niepoprawny.\nNumer telefonu podany przez nadawcę jest niepoprawny.", "Contact page", "", "publish", "open", "open", "", "contact-page", "", "", "2018-05-24 13:48:13", "2018-05-24 11:48:13", "", "0", "http://themes.muffingroup.com/be/lawyer/?post_type=wpcf7_contact_form&#038;p=43", "0", "wpcf7_contact_form", "", "0");
INSERT INTO `wp_posts` VALUES("44", "1", "2015-04-11 18:08:05", "2015-04-11 18:08:05", "", "home_lawyer_pin", "", "inherit", "open", "open", "", "home_lawyer_pin", "", "", "2015-04-11 18:08:05", "2015-04-11 18:08:05", "", "36", "http://www.winda.poznan.pl/wp-content/uploads/2015/04/home_lawyer_pin.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("46", "1", "2015-04-11 19:14:52", "2015-04-11 19:14:52", "", "our_team_3", "", "inherit", "open", "open", "", "our_team_3", "", "", "2015-04-11 19:14:52", "2015-04-11 19:14:52", "", "0", "http://www.winda.poznan.pl/wp-content/uploads/2015/04/our_team_3.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("47", "1", "2015-04-11 19:15:00", "2015-04-11 19:15:00", "", "our_team_1", "", "inherit", "open", "open", "", "our_team_1", "", "", "2015-04-11 19:15:00", "2015-04-11 19:15:00", "", "0", "http://www.winda.poznan.pl/wp-content/uploads/2015/04/our_team_1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("48", "1", "2015-04-08 06:56:18", "2015-04-08 06:56:18", "Welcome to WordPress. This is your first post. Edit or delete it, then start blogging!", "Hello world!", "", "publish", "open", "open", "", "hello-world", "", "", "2015-04-08 06:56:18", "2015-04-08 06:56:18", "", "0", "http://themes.muffingroup.com/be/lawyer/?p=1", "0", "post", "", "1");
INSERT INTO `wp_posts` VALUES("49", "1", "2015-04-08 06:56:18", "2015-04-08 06:56:18", "[vc_row full_width=\"stretch_row\" content_placement=\"middle\" css=\".vc_custom_1507034725651{background-color: #00970a !important;}\"][vc_column width=\"2/3\"][vc_custom_heading text=\"``WINDA`` S.j. Zakład Elektromechaniki Dźwigowej\" font_container=\"tag:p|font_size:22|text_align:left|color:%23ffffff\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_separator color=\"white\" align=\"align_left\" el_width=\"40\"][vc_custom_heading text=\"Firma WINDA S. J. powstała w 1990 roku po likwidacji Zakładu Montażu Dźwigów w Poznaniu działającego w ramach Kombinatu Dźwigów Osobowych ZREMB - Warszawa. Firma posiada solidne podstawy finansowe, oraz duży profesjonalizm oparty na trzydziestoletnich doświadczeniach\" font_container=\"tag:p|font_size:18|text_align:left|color:%23ffffff\" use_theme_fonts=\"yes\" css_animation=\"none\"][/vc_column][vc_column width=\"1/3\"][vc_btn title=\"O firmie\" style=\"outline\" shape=\"square\" size=\"lg\" align=\"center\" button_block=\"true\" link=\"url:%2Fo-firmie%2F|||\"][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" content_placement=\"middle\" parallax=\"content-moving\" parallax_image=\"25\"][vc_column][vc_text_separator title=\"NASZA OFERTA\" color=\"custom\" accent_color=\"#00970a\" el_id=\"naglowek\"][vc_row_inner][vc_column_inner width=\"1/3\"][vc_cta h2=\"Dźwigi Osobowe\" h2_font_container=\"font_size:16\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów osobowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" css_animation=\"fadeInLeft\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-osobowe%2F|||\" css=\".vc_custom_1510309948088{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]Estetyczne i komfortowe.[/vc_cta][/vc_column_inner][vc_column_inner width=\"1/3\"][vc_cta h2=\"Dźwigi Towarowe\" h2_font_container=\"font_size:18\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów towarowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" css_animation=\"fadeInLeft\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-towarowe%2F|||\" css=\".vc_custom_1510309966538{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-bottom: 30px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]Szeroka gama zastosowań.[/vc_cta][/vc_column_inner][vc_column_inner width=\"1/3\"][vc_cta h2=\"Dźwigi dla osób niepełnosprawnych\" h2_font_container=\"font_size:18\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Dźwigi dla osób niepełnosprawnych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" css_animation=\"fadeInLeft\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-dla-osob-niepelnosprawnych%2F|||\" css=\".vc_custom_1510309982460{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]Likwidacja barier architektonicznych.[/vc_cta][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" content_placement=\"middle\" css=\".vc_custom_1638545313969{background: #00970a url(https://www.winda.poznan.pl/wp-content/uploads/2015/04/20100311030009DSC_0759-1.jpg?id=85) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}\"][vc_column width=\"1/2\" css=\".vc_custom_1507037364707{background-position: center !important;background-repeat: no-repeat !important;background-size: contain !important;}\"][/vc_column][vc_column width=\"1/2\"][vc_custom_heading text=\"Serwis urządzeń dźwigowych\" font_container=\"tag:p|font_size:26|text_align:right|color:%23ffffff\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_separator color=\"white\" align=\"align_right\" el_width=\"40\"][vc_custom_heading text=\"Firma WINDA prowadzi także serwis urządzeń dźwigowych (nowych, zakupionych w naszej firmie oraz starszego typu). Wykonujemy także naprawy gwarancyjne zakupionych u nas urządzeń. Przeprowadzamy remonty dźwigów w każdym zakresie. \" font_container=\"tag:p|font_size:18|text_align:right|color:%23ffffff\" use_theme_fonts=\"yes\"][vc_btn title=\"Dowiedz się więcej\" style=\"outline\" shape=\"square\" size=\"lg\" align=\"center\" button_block=\"true\" link=\"url:%2Fserwis%2F|||\"][/vc_column][/vc_row][vc_row full_width=\"stretch_row_content\" parallax=\"content-moving\" parallax_image=\"25\"][vc_column][vc_text_separator title=\"REALIZACJE\" color=\"custom\" accent_color=\"#00970a\" el_id=\"naglowek\"][vc_media_grid element_width=\"3\" gap=\"0\" item=\"mediaGrid_ScaleInWithIcon\" initial_loading_animation=\"bounceInLeft\" grid_id=\"vc_gid:1638545261871-71f12aae114bdb1562d27ea89dbb38bf-4\" include=\"232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247\"][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" content_placement=\"top\" disable_element=\"yes\" css=\".vc_custom_1507130856903{background-color: #00970a !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}\"][vc_column width=\"1/3\" css=\".vc_custom_1507037364707{background-position: center !important;background-repeat: no-repeat !important;background-size: contain !important;}\"][vc_custom_heading text=\"Certyfikaty\" font_container=\"tag:p|font_size:26|text_align:left|color:%23ffffff\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_separator color=\"white\" align=\"align_left\" el_width=\"40\"][vc_custom_heading text=\"Nasza firma posiada odpowiednie certyfikaty które upoważniają nas do montażu i serwisu dźwigów różnego typu.\" font_container=\"tag:p|font_size:18|text_align:left|color:%23ffffff\" use_theme_fonts=\"yes\"][/vc_column][vc_column width=\"2/3\"][vc_row_inner][vc_column_inner width=\"1/3\"][vc_single_image image=\"102\" img_size=\"large\"][/vc_column_inner][vc_column_inner width=\"1/3\"][vc_single_image image=\"101\" img_size=\"large\"][/vc_column_inner][vc_column_inner width=\"1/3\"][vc_single_image image=\"103\" img_size=\"large\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]", "Home", "", "publish", "open", "open", "", "home", "", "", "2021-12-03 16:28:46", "2021-12-03 15:28:46", "", "0", "http://themes.muffingroup.com/be/lawyer/?page_id=2", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("50", "1", "2015-04-11 17:57:38", "2015-04-11 17:57:38", "[vc_row full_width=\"stretch_row\" gap=\"35\" parallax=\"content-moving\" parallax_speed_bg=\"1.2\" css=\".vc_custom_1507210280513{background-color: #f4f4f4 !important;}\"][vc_column width=\"1/2\"][vc_custom_heading text=\"O firmie\" font_container=\"tag:h1|font_size:40|text_align:left|color:%2301913f\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:900%20bold%20regular%3A900%3Anormal\" css_animation=\"none\"][vc_separator color=\"black\" align=\"align_left\" el_width=\"30\"][vc_custom_heading text=\"Wśród firm dźwigowych działających w kraju jest firma o nazwie WINDA S. J. W krótkim wstępie pragniemy przybliżyć nie tylko ofertę lecz także historię i znaczące osiągnięcia naszej firmy.\" font_container=\"tag:div|text_align:left\" use_theme_fonts=\"yes\"][vc_column_text css_animation=\"none\"]\n<div>Firma WINDA S. J. powstała w 1990 roku po likwidacji Zakładu Montażu Dźwigów w Poznaniu działającego w ramach Kombinatu Dźwigów Osobowych ZREMB - Warszawa. Firma posiada solidne podstawy finansowe, oraz duży profesjonalizm oparty na trzydziestoletnich doświadczeniach ludzi pracujących w tej branży.</div>\n<div>Dzięki zaangażowaniu kadry kierowniczej, jak i bezpośrednio produkcyjnej możliwy był dynamiczny rozwój, którym niewiele firm w obecnych czasach może się poszczycić. Poczynione inwestycje gwarantują pełną niezależność finansową, oraz dostęp do wszelkich części dźwigowych, jak i urządzeń potrzebnych do prac związanych z dźwigami. Preferując krajowy przemysł jesteśmy autoryzowanym przedstawicielem wszystkich polskich producentów dźwigów.</div>\n<div>W okresie działalności dostarczyliśmy i zamontowaliśmy kilkaset urządzeń różnych typów w obiektach przemysłowych, budynkach użyteczności publicznej oraz budynkach mieszkalnych. Poza instalowaniem nowych urządzeń, firma podejmuje się prac związanych z modernizacją dźwigów. Podejmujemy się prac związanych z generalnym wykonawstwem, uczestniczymy w fazie projektowania i budowania szybów. Oddajemy gotowe urządzenia do eksploatacji po odbiorze Urzędu Dozoru Technicznego. Dostarczone i zmontowane przez nas dźwigi przejmujemy w konserwację, co umożliwia przedłużenie okresu gwarancji.</div>\n<div>Wszystkie urządzenia proponowane przez nas wyprodukowane są zgodnie z obowiązującymi normami EN81.1 i EN81.2 oraz EN81-20 i EN81-50. Firma posiada wszelkie uprawnienia wydane przez Urząd Dozoru Technicznego niezbędne do prowadzenia działalności w pełnym zakresie.</div>\n<div><strong>Równie ważnym jak montaż jest dział konserwacji.</strong></div>\n<div>Jesteśmy związani umowami z wieloma użytkownikami dźwigów. Konserwujemy kilkaset dźwigów w szpitalach, urzędach, hotelach, bankach, dużych przedsiębiorstwach o ruchu ciągłym, pojedyńczych budynkach mieszkalnych oraz całych osiedlach mieszkaniowych. Wzorcowy model sposobu konserwacji wypracowany przez nas daje dużą skuteczność i niezawodność w działaniu. Wśród zakładów dźwigowych tylko niewiele posiada pełną zdolność do prowadzenia tej działalności.</div>\n<div>O niezawodności i atrakcyjności naszych usług świadczą liczne listy referencyjne od zadowolonych klientów oraz lista najbardziej znaczących odbiorców.</div>\n<div>Deklarujemy, że czas w którym przystąpimy do usunięcia awarii nie przekroczy 30 min.</div>\n<div>Pracujemy 365 dni w roku łącznie z całodobowym pogotowiem dźwigowym, aby utrzymać wysoki poziom usług, zapewnić bezpieczeństwo i wygodę ludzi.</div>\n[/vc_column_text][vc_custom_heading text=\"Jesteśmy do waszej dyspozycji. Wybierając firmę WINDA S. J.\nNie będziesz chodził po schodach.\" font_container=\"tag:div|text_align:left\" use_theme_fonts=\"yes\"][/vc_column][vc_column width=\"1/2\"][vc_single_image image=\"182\" img_size=\"full\" alignment=\"center\"][vc_single_image image=\"179\" img_size=\"full\" alignment=\"center\"][/vc_column][/vc_row]", "O firmie", "", "publish", "open", "open", "", "o-firmie", "", "", "2017-10-24 12:28:48", "2017-10-24 10:28:48", "", "0", "http://themes.muffingroup.com/be/lawyer/?page_id=29", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("51", "1", "2015-04-11 17:57:52", "2015-04-11 17:57:52", "[vc_row full_width=\"stretch_row\" parallax=\"content-moving\" parallax_image=\"25\"][vc_column 0=\"\"][vc_text_separator title=\"NASZA OFERTA\" color=\"green\" el_id=\"naglowek\"][vc_row_inner 0=\"\"][vc_column_inner width=\"1/3\"][vc_cta h2=\"Dżwigi osobowe \" h2_font_container=\"font_size:20\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:900%20bold%20regular%3A900%3Anormal\" add_button=\"bottom\" btn_title=\"Dźwigi osobowe\" btn_style=\"outline\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" css_animation=\"fadeInLeft\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-osobowe%2F|||\" css=\".vc_custom_1510309779781{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]Estetyczne i komfortowe.[/vc_cta][/vc_column_inner][vc_column_inner width=\"1/3\"][vc_cta h2=\"Dźwigi towarowe\" h2_font_container=\"font_size:20\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:900%20bold%20regular%3A900%3Anormal\" add_button=\"bottom\" btn_title=\"Dźwigi towarowe\" btn_style=\"outline\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" css_animation=\"fadeInLeft\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-towarowe%2F|||\" css=\".vc_custom_1510309760801{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]Szeroka gama zastosowań.[/vc_cta][/vc_column_inner][vc_column_inner width=\"1/3\"][vc_cta h2=\"Dźwigi dla osób niepełnosprawnych\" h2_font_container=\"font_size:18\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:900%20bold%20regular%3A900%3Anormal\" add_button=\"bottom\" btn_title=\"Dźwigi dla osób niepełnosprawnych\" btn_style=\"outline\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" css_animation=\"fadeInLeft\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-dla-osob-niepelnosprawnych%2F|||\" css=\".vc_custom_1510309797442{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]Likwidacja barier architektonicznych.[/vc_cta][/vc_column_inner][/vc_row_inner][vc_empty_space height=\"20px\"][/vc_column][/vc_row]", "Oferta", "", "publish", "open", "open", "", "oferta", "", "", "2017-11-10 11:43:26", "2017-11-10 10:43:26", "", "0", "http://themes.muffingroup.com/be/lawyer/?page_id=31", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("53", "1", "2015-04-11 19:15:10", "2015-04-11 19:15:10", "", "our_team_4", "", "inherit", "open", "open", "", "our_team_4", "", "", "2015-04-11 19:15:10", "2015-04-11 19:15:10", "", "0", "http://www.winda.poznan.pl/wp-content/uploads/2015/04/our_team_4.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("54", "1", "2017-10-02 16:37:36", "2017-10-02 16:37:36", "", "slide-lawyer-bg.jpg", "", "inherit", "closed", "closed", "", "slide-lawyer-bg-jpg", "", "", "2017-10-02 16:37:36", "2017-10-02 16:37:36", "", "0", "http://www.winda.poznan.pl/wp-content/uploads/revslider/lawyer/slide-lawyer-bg.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("55", "1", "2017-10-02 16:37:36", "2017-10-02 16:37:36", "", "slide-lawyer-1.png", "", "inherit", "closed", "closed", "", "slide-lawyer-1-png", "", "", "2017-10-02 16:37:36", "2017-10-02 16:37:36", "", "0", "http://www.winda.poznan.pl/wp-content/uploads/revslider/lawyer/slide-lawyer-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("56", "1", "2017-10-02 16:37:37", "2017-10-02 16:37:37", "", "slide-lawyer-2.png", "", "inherit", "closed", "closed", "", "slide-lawyer-2-png", "", "", "2017-10-03 14:23:12", "2017-10-03 12:23:12", "", "49", "http://www.winda.poznan.pl/wp-content/uploads/revslider/lawyer/slide-lawyer-2.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("57", "1", "2017-10-02 16:37:37", "2017-10-02 16:37:37", "", "slide-lawyer-3.png", "", "inherit", "closed", "closed", "", "slide-lawyer-3-png", "", "", "2017-10-02 16:37:37", "2017-10-02 16:37:37", "", "0", "http://www.winda.poznan.pl/wp-content/uploads/revslider/lawyer/slide-lawyer-3.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("58", "1", "2017-10-02 16:37:37", "2017-10-02 16:37:37", "", "slide-lawyer-4.png", "", "inherit", "closed", "closed", "", "slide-lawyer-4-png", "", "", "2017-10-02 16:37:37", "2017-10-02 16:37:37", "", "0", "http://www.winda.poznan.pl/wp-content/uploads/revslider/lawyer/slide-lawyer-4.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("59", "1", "2017-10-02 16:37:37", "2017-10-02 16:37:37", "", "slide-lawyer-5.png", "", "inherit", "closed", "closed", "", "slide-lawyer-5-png", "", "", "2017-10-02 16:37:37", "2017-10-02 16:37:37", "", "0", "http://www.winda.poznan.pl/wp-content/uploads/revslider/lawyer/slide-lawyer-5.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("60", "1", "2017-10-02 16:41:18", "2017-10-02 14:41:18", "", "Home", "", "inherit", "closed", "closed", "", "49-revision-v1", "", "", "2017-10-02 16:41:18", "2017-10-02 14:41:18", "", "49", "http://www.winda.poznan.pl/49-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("62", "1", "2017-10-02 16:52:13", "2017-10-02 14:52:13", "", "winda-tlo", "", "inherit", "closed", "closed", "", "winda-tlo", "", "", "2017-10-02 16:52:13", "2017-10-02 14:52:13", "", "0", "http://www.winda.poznan.pl/wp-content/uploads/2017/10/winda-tlo.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("63", "1", "2017-10-03 14:24:19", "2017-10-03 12:24:19", "[vc_row][vc_column][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][/vc_row]", "Home", "", "inherit", "closed", "closed", "", "49-revision-v1", "", "", "2017-10-03 14:24:19", "2017-10-03 12:24:19", "", "49", "http://www.winda.poznan.pl/49-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("64", "1", "2017-10-03 14:25:15", "2017-10-03 12:25:15", "", "Home", "", "inherit", "closed", "closed", "", "49-revision-v1", "", "", "2017-10-03 14:25:15", "2017-10-03 12:25:15", "", "49", "http://www.winda.poznan.pl/49-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("65", "1", "2017-10-03 14:42:32", "2017-10-03 12:42:32", "[vc_row full_width=\"stretch_row\" css=\".vc_custom_1507034470583{background-color: #00970a !important;}\"][vc_column width=\"2/3\"][vc_custom_heading text=\"Firma WINDA S. J. powstała w 1990 roku po likwidacji Zakładu Montażu Dźwigów w Poznaniu działającego w ramach Kombinatu Dźwigów Osobowych ZREMB - Warszawa. Firma posiada solidne podstawy finansowe, oraz duży profesjonalizm oparty na dwudziestoletnich doświadczeniach\" font_container=\"tag:p|font_size:18|text_align:left|color:%23ffffff\" use_theme_fonts=\"yes\"][/vc_column][vc_column width=\"1/3\"][vc_btn title=\"O firmie\" style=\"outline\" shape=\"square\" size=\"lg\" align=\"center\" button_block=\"true\" link=\"url:%2Fo-firmie%2F|||\"][/vc_column][/vc_row]", "Home", "", "inherit", "closed", "closed", "", "49-revision-v1", "", "", "2017-10-03 14:42:32", "2017-10-03 12:42:32", "", "49", "http://www.winda.poznan.pl/49-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("66", "1", "2017-10-03 14:44:26", "2017-10-03 12:44:26", "[vc_row full_width=\"stretch_row\" css=\".vc_custom_1507034470583{background-color: #00970a !important;}\"][vc_column width=\"2/3\"][vc_custom_heading text=\"``WINDA`` S.j. Zakład Elektromechaniki Dźwigowej\" font_container=\"tag:p|font_size:22|text_align:left|color:%23ffffff\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_separator color=\"white\" align=\"align_left\" el_width=\"40\"][vc_custom_heading text=\"Firma WINDA S. J. powstała w 1990 roku po likwidacji Zakładu Montażu Dźwigów w Poznaniu działającego w ramach Kombinatu Dźwigów Osobowych ZREMB - Warszawa. Firma posiada solidne podstawy finansowe, oraz duży profesjonalizm oparty na dwudziestoletnich doświadczeniach\" font_container=\"tag:p|font_size:18|text_align:left|color:%23ffffff\" use_theme_fonts=\"yes\"][/vc_column][vc_column width=\"1/3\"][vc_btn title=\"O firmie\" style=\"outline\" shape=\"square\" size=\"lg\" align=\"center\" button_block=\"true\" link=\"url:%2Fo-firmie%2F|||\"][/vc_column][/vc_row]", "Home", "", "inherit", "closed", "closed", "", "49-revision-v1", "", "", "2017-10-03 14:44:26", "2017-10-03 12:44:26", "", "49", "http://www.winda.poznan.pl/49-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("67", "1", "2017-10-03 14:44:43", "2017-10-03 12:44:43", "[vc_row full_width=\"stretch_row\" content_placement=\"middle\" css=\".vc_custom_1507034681217{background-color: #00970a !important;}\"][vc_column width=\"2/3\"][vc_custom_heading text=\"``WINDA`` S.j. Zakład Elektromechaniki Dźwigowej\" font_container=\"tag:p|font_size:22|text_align:left|color:%23ffffff\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_separator color=\"white\" align=\"align_left\" el_width=\"40\"][vc_custom_heading text=\"Firma WINDA S. J. powstała w 1990 roku po likwidacji Zakładu Montażu Dźwigów w Poznaniu działającego w ramach Kombinatu Dźwigów Osobowych ZREMB - Warszawa. Firma posiada solidne podstawy finansowe, oraz duży profesjonalizm oparty na dwudziestoletnich doświadczeniach\" font_container=\"tag:p|font_size:18|text_align:left|color:%23ffffff\" use_theme_fonts=\"yes\"][/vc_column][vc_column width=\"1/3\"][vc_btn title=\"O firmie\" style=\"outline\" shape=\"square\" size=\"lg\" align=\"center\" button_block=\"true\" link=\"url:%2Fo-firmie%2F|||\"][/vc_column][/vc_row]", "Home", "", "inherit", "closed", "closed", "", "49-revision-v1", "", "", "2017-10-03 14:44:43", "2017-10-03 12:44:43", "", "49", "http://www.winda.poznan.pl/49-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("68", "1", "2017-10-03 14:46:52", "2017-10-03 12:46:52", "", "20100311030051Custom-Name--003", "", "inherit", "closed", "closed", "", "20100311030051custom-name-003", "", "", "2017-10-03 14:46:52", "2017-10-03 12:46:52", "", "49", "http://www.winda.poznan.pl/wp-content/uploads/2015/04/20100311030051Custom-Name-003.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("69", "1", "2017-10-03 14:53:46", "2017-10-03 12:53:46", "[vc_row full_width=\"stretch_row\" content_placement=\"middle\" css=\".vc_custom_1507034725651{background-color: #00970a !important;}\"][vc_column width=\"2/3\"][vc_custom_heading text=\"``WINDA`` S.j. Zakład Elektromechaniki Dźwigowej\" font_container=\"tag:p|font_size:22|text_align:left|color:%23ffffff\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_separator color=\"white\" align=\"align_left\" el_width=\"40\"][vc_custom_heading text=\"Firma WINDA S. J. powstała w 1990 roku po likwidacji Zakładu Montażu Dźwigów w Poznaniu działającego w ramach Kombinatu Dźwigów Osobowych ZREMB - Warszawa. Firma posiada solidne podstawy finansowe, oraz duży profesjonalizm oparty na dwudziestoletnich doświadczeniach\" font_container=\"tag:p|font_size:18|text_align:left|color:%23ffffff\" use_theme_fonts=\"yes\"][/vc_column][vc_column width=\"1/3\"][vc_btn title=\"O firmie\" style=\"outline\" shape=\"square\" size=\"lg\" align=\"center\" button_block=\"true\" link=\"url:%2Fo-firmie%2F|||\"][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" content_placement=\"middle\" parallax=\"content-moving\" parallax_image=\"25\" parallax_speed_bg=\"1.1\"][vc_column width=\"1/2\"][vc_single_image image=\"68\" img_size=\"full\" alignment=\"center\" style=\"vc_box_shadow_3d\"][/vc_column][vc_column width=\"1/2\"][vc_cta h2=\"Dźwigi Osobowe\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów osobowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"mulled-wine\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-osobowe%2F|||\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów, które możemy Państwu dostarczyć.[/vc_cta][/vc_column][/vc_row]", "Home", "", "inherit", "closed", "closed", "", "49-revision-v1", "", "", "2017-10-03 14:53:46", "2017-10-03 12:53:46", "", "49", "http://www.winda.poznan.pl/49-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("70", "1", "2017-10-03 14:54:37", "2017-10-03 12:54:37", "[vc_row full_width=\"stretch_row\" content_placement=\"middle\" css=\".vc_custom_1507034725651{background-color: #00970a !important;}\"][vc_column width=\"2/3\"][vc_custom_heading text=\"``WINDA`` S.j. Zakład Elektromechaniki Dźwigowej\" font_container=\"tag:p|font_size:22|text_align:left|color:%23ffffff\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_separator color=\"white\" align=\"align_left\" el_width=\"40\"][vc_custom_heading text=\"Firma WINDA S. J. powstała w 1990 roku po likwidacji Zakładu Montażu Dźwigów w Poznaniu działającego w ramach Kombinatu Dźwigów Osobowych ZREMB - Warszawa. Firma posiada solidne podstawy finansowe, oraz duży profesjonalizm oparty na dwudziestoletnich doświadczeniach\" font_container=\"tag:p|font_size:18|text_align:left|color:%23ffffff\" use_theme_fonts=\"yes\"][/vc_column][vc_column width=\"1/3\"][vc_btn title=\"O firmie\" style=\"outline\" shape=\"square\" size=\"lg\" align=\"center\" button_block=\"true\" link=\"url:%2Fo-firmie%2F|||\"][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" content_placement=\"middle\" parallax=\"content-moving\" parallax_image=\"25\" parallax_speed_bg=\"1.1\"][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi Osobowe\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów osobowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"mulled-wine\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-osobowe%2F|||\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów, które możemy Państwu dostarczyć.[/vc_cta][/vc_column][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi Osobowe\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów osobowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"mulled-wine\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-osobowe%2F|||\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów, które możemy Państwu dostarczyć.[/vc_cta][/vc_column][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi Osobowe\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów osobowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"mulled-wine\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-osobowe%2F|||\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów, które możemy Państwu dostarczyć.[/vc_cta][/vc_column][/vc_row]", "Home", "", "inherit", "closed", "closed", "", "49-revision-v1", "", "", "2017-10-03 14:54:37", "2017-10-03 12:54:37", "", "49", "http://www.winda.poznan.pl/49-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("71", "1", "2017-10-03 14:55:07", "2017-10-03 12:55:07", "", "im2", "", "inherit", "closed", "closed", "", "im2", "", "", "2017-10-03 14:55:07", "2017-10-03 12:55:07", "", "49", "http://www.winda.poznan.pl/wp-content/uploads/2015/04/im2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("72", "1", "2017-10-03 14:59:09", "2017-10-03 12:59:09", "[vc_row full_width=\"stretch_row\" content_placement=\"middle\" css=\".vc_custom_1507034725651{background-color: #00970a !important;}\"][vc_column width=\"2/3\"][vc_custom_heading text=\"``WINDA`` S.j. Zakład Elektromechaniki Dźwigowej\" font_container=\"tag:p|font_size:22|text_align:left|color:%23ffffff\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_separator color=\"white\" align=\"align_left\" el_width=\"40\"][vc_custom_heading text=\"Firma WINDA S. J. powstała w 1990 roku po likwidacji Zakładu Montażu Dźwigów w Poznaniu działającego w ramach Kombinatu Dźwigów Osobowych ZREMB - Warszawa. Firma posiada solidne podstawy finansowe, oraz duży profesjonalizm oparty na dwudziestoletnich doświadczeniach\" font_container=\"tag:p|font_size:18|text_align:left|color:%23ffffff\" use_theme_fonts=\"yes\"][/vc_column][vc_column width=\"1/3\"][vc_btn title=\"O firmie\" style=\"outline\" shape=\"square\" size=\"lg\" align=\"center\" button_block=\"true\" link=\"url:%2Fo-firmie%2F|||\"][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" content_placement=\"middle\" parallax=\"content-moving\" parallax_image=\"25\" parallax_speed_bg=\"1.1\"][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi Osobowe\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów osobowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-osobowe%2F|||\" css=\".vc_custom_1507035494934{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów, które możemy Państwu dostarczyć.[/vc_cta][/vc_column][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi Towarowe\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów towarowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-towarowych%2F|||\" css=\".vc_custom_1507035547499{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów towarowych, które możemy Państwu dostarczyć.[/vc_cta][/vc_column][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi Osobowe\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów osobowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-osobowe%2F|||\" css=\".vc_custom_1507035537992{border: 1px solid #00970a !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów, które możemy Państwu dostarczyć.[/vc_cta][/vc_column][/vc_row]", "Home", "", "inherit", "closed", "closed", "", "49-revision-v1", "", "", "2017-10-03 14:59:09", "2017-10-03 12:59:09", "", "49", "http://www.winda.poznan.pl/49-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("73", "1", "2017-10-03 15:00:05", "2017-10-03 13:00:05", "[vc_row full_width=\"stretch_row\" content_placement=\"middle\" css=\".vc_custom_1507034725651{background-color: #00970a !important;}\"][vc_column width=\"2/3\"][vc_custom_heading text=\"``WINDA`` S.j. Zakład Elektromechaniki Dźwigowej\" font_container=\"tag:p|font_size:22|text_align:left|color:%23ffffff\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_separator color=\"white\" align=\"align_left\" el_width=\"40\"][vc_custom_heading text=\"Firma WINDA S. J. powstała w 1990 roku po likwidacji Zakładu Montażu Dźwigów w Poznaniu działającego w ramach Kombinatu Dźwigów Osobowych ZREMB - Warszawa. Firma posiada solidne podstawy finansowe, oraz duży profesjonalizm oparty na dwudziestoletnich doświadczeniach\" font_container=\"tag:p|font_size:18|text_align:left|color:%23ffffff\" use_theme_fonts=\"yes\"][/vc_column][vc_column width=\"1/3\"][vc_btn title=\"O firmie\" style=\"outline\" shape=\"square\" size=\"lg\" align=\"center\" button_block=\"true\" link=\"url:%2Fo-firmie%2F|||\"][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" content_placement=\"middle\" parallax=\"content-moving\" parallax_image=\"25\" parallax_speed_bg=\"1.1\"][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi Osobowe\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów osobowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-osobowe%2F|||\" css=\".vc_custom_1507035494934{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów, które możemy Państwu dostarczyć.[/vc_cta][/vc_column][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi Towarowe\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów towarowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-towarowych%2F|||\" css=\".vc_custom_1507035547499{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów towarowych, które możemy Państwu dostarczyć.[/vc_cta][/vc_column][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi dla osób niepełnosprawnych\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Dźwigi dla osób niepełnosprawnych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-dla-osob-niepelnosprawnych%2F|||\" css=\".vc_custom_1507035599074{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów, które możemy Państwu dostarczyć.[/vc_cta][/vc_column][/vc_row]", "Home", "", "inherit", "closed", "closed", "", "49-revision-v1", "", "", "2017-10-03 15:00:05", "2017-10-03 13:00:05", "", "49", "http://www.winda.poznan.pl/49-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("74", "1", "2017-10-03 15:04:05", "2017-10-03 13:04:05", "[vc_row full_width=\"stretch_row\" content_placement=\"middle\" css=\".vc_custom_1507034725651{background-color: #00970a !important;}\"][vc_column width=\"2/3\"][vc_custom_heading text=\"``WINDA`` S.j. Zakład Elektromechaniki Dźwigowej\" font_container=\"tag:p|font_size:22|text_align:left|color:%23ffffff\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_separator color=\"white\" align=\"align_left\" el_width=\"40\"][vc_custom_heading text=\"Firma WINDA S. J. powstała w 1990 roku po likwidacji Zakładu Montażu Dźwigów w Poznaniu działającego w ramach Kombinatu Dźwigów Osobowych ZREMB - Warszawa. Firma posiada solidne podstawy finansowe, oraz duży profesjonalizm oparty na dwudziestoletnich doświadczeniach\" font_container=\"tag:p|font_size:18|text_align:left|color:%23ffffff\" use_theme_fonts=\"yes\"][/vc_column][vc_column width=\"1/3\"][vc_btn title=\"O firmie\" style=\"outline\" shape=\"square\" size=\"lg\" align=\"center\" button_block=\"true\" link=\"url:%2Fo-firmie%2F|||\"][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" content_placement=\"middle\" parallax=\"content-moving\" parallax_image=\"25\" parallax_speed_bg=\"1.1\"][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi Osobowe\" h2_font_container=\"font_size:16\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów osobowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-osobowe%2F|||\" css=\".vc_custom_1507035830828{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów, które możemy Państwu dostarczyć. Serdecznie zachęcamy do zapoznania się z ofertą.[/vc_cta][/vc_column][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi Towarowe\" h2_font_container=\"font_size:18\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów towarowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-towarowych%2F|||\" css=\".vc_custom_1507035814330{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów towarowych, które możemy Państwu dostarczyć.[/vc_cta][/vc_column][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi dla osób niepełnosprawnych\" h2_font_container=\"font_size:18\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Dźwigi dla osób niepełnosprawnych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-dla-osob-niepelnosprawnych%2F|||\" css=\".vc_custom_1507035842594{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów, które możemy Państwu dostarczyć. Zapraszamy do zapoznania się z ofertą.[/vc_cta][/vc_column][/vc_row]", "Home", "", "inherit", "closed", "closed", "", "49-revision-v1", "", "", "2017-10-03 15:04:05", "2017-10-03 13:04:05", "", "49", "http://www.winda.poznan.pl/49-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("75", "1", "2017-10-03 15:04:41", "2017-10-03 13:04:41", "[vc_row full_width=\"stretch_row\" content_placement=\"middle\" css=\".vc_custom_1507034725651{background-color: #00970a !important;}\"][vc_column width=\"2/3\"][vc_custom_heading text=\"``WINDA`` S.j. Zakład Elektromechaniki Dźwigowej\" font_container=\"tag:p|font_size:22|text_align:left|color:%23ffffff\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_separator color=\"white\" align=\"align_left\" el_width=\"40\"][vc_custom_heading text=\"Firma WINDA S. J. powstała w 1990 roku po likwidacji Zakładu Montażu Dźwigów w Poznaniu działającego w ramach Kombinatu Dźwigów Osobowych ZREMB - Warszawa. Firma posiada solidne podstawy finansowe, oraz duży profesjonalizm oparty na dwudziestoletnich doświadczeniach\" font_container=\"tag:p|font_size:18|text_align:left|color:%23ffffff\" use_theme_fonts=\"yes\"][/vc_column][vc_column width=\"1/3\"][vc_btn title=\"O firmie\" style=\"outline\" shape=\"square\" size=\"lg\" align=\"center\" button_block=\"true\" link=\"url:%2Fo-firmie%2F|||\"][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" content_placement=\"middle\" parallax=\"content-moving\" parallax_image=\"25\"][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi Osobowe\" h2_font_container=\"font_size:16\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów osobowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-osobowe%2F|||\" css=\".vc_custom_1507035830828{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów, które możemy Państwu dostarczyć. Serdecznie zachęcamy do zapoznania się z ofertą.[/vc_cta][/vc_column][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi Towarowe\" h2_font_container=\"font_size:18\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów towarowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-towarowych%2F|||\" css=\".vc_custom_1507035814330{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów towarowych, które możemy Państwu dostarczyć.[/vc_cta][/vc_column][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi dla osób niepełnosprawnych\" h2_font_container=\"font_size:18\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Dźwigi dla osób niepełnosprawnych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-dla-osob-niepelnosprawnych%2F|||\" css=\".vc_custom_1507035842594{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów, które możemy Państwu dostarczyć. Zapraszamy do zapoznania się z ofertą.[/vc_cta][/vc_column][/vc_row]", "Home", "", "inherit", "closed", "closed", "", "49-revision-v1", "", "", "2017-10-03 15:04:41", "2017-10-03 13:04:41", "", "49", "http://www.winda.poznan.pl/49-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("76", "1", "2017-10-03 15:10:29", "2017-10-03 13:10:29", "[vc_row full_width=\"stretch_row\" content_placement=\"middle\" css=\".vc_custom_1507034725651{background-color: #00970a !important;}\"][vc_column width=\"2/3\"][vc_custom_heading text=\"``WINDA`` S.j. Zakład Elektromechaniki Dźwigowej\" font_container=\"tag:p|font_size:22|text_align:left|color:%23ffffff\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_separator color=\"white\" align=\"align_left\" el_width=\"40\"][vc_custom_heading text=\"Firma WINDA S. J. powstała w 1990 roku po likwidacji Zakładu Montażu Dźwigów w Poznaniu działającego w ramach Kombinatu Dźwigów Osobowych ZREMB - Warszawa. Firma posiada solidne podstawy finansowe, oraz duży profesjonalizm oparty na dwudziestoletnich doświadczeniach\" font_container=\"tag:p|font_size:18|text_align:left|color:%23ffffff\" use_theme_fonts=\"yes\"][/vc_column][vc_column width=\"1/3\"][vc_btn title=\"O firmie\" style=\"outline\" shape=\"square\" size=\"lg\" align=\"center\" button_block=\"true\" link=\"url:%2Fo-firmie%2F|||\"][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" content_placement=\"middle\" parallax=\"content-moving\" parallax_image=\"25\"][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi Osobowe\" h2_font_container=\"font_size:16\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów osobowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-osobowe%2F|||\" css=\".vc_custom_1507035830828{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów, które możemy Państwu dostarczyć. Serdecznie zachęcamy do zapoznania się z ofertą.[/vc_cta][/vc_column][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi Towarowe\" h2_font_container=\"font_size:18\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów towarowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-towarowych%2F|||\" css=\".vc_custom_1507035814330{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów towarowych, które możemy Państwu dostarczyć.[/vc_cta][/vc_column][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi dla osób niepełnosprawnych\" h2_font_container=\"font_size:18\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Dźwigi dla osób niepełnosprawnych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-dla-osob-niepelnosprawnych%2F|||\" css=\".vc_custom_1507035842594{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów, które możemy Państwu dostarczyć. Zapraszamy do zapoznania się z ofertą.[/vc_cta][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" parallax=\"content-moving\" parallax_image=\"62\"][vc_column][vc_images_carousel][/vc_column][/vc_row]", "Home", "", "inherit", "closed", "closed", "", "49-revision-v1", "", "", "2017-10-03 15:10:29", "2017-10-03 13:10:29", "", "49", "http://www.winda.poznan.pl/49-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("77", "1", "2017-10-03 15:16:35", "2017-10-03 13:16:35", "", "20100311030038Custom-Name--002", "", "inherit", "closed", "closed", "", "20100311030038custom-name-002", "", "", "2017-10-03 15:16:35", "2017-10-03 13:16:35", "", "49", "http://www.winda.poznan.pl/wp-content/uploads/2015/04/20100311030038Custom-Name-002.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("78", "1", "2017-10-03 15:16:35", "2017-10-03 13:16:35", "", "20100311030104Custom-Name--004", "", "inherit", "closed", "closed", "", "20100311030104custom-name-004", "", "", "2017-10-03 15:16:35", "2017-10-03 13:16:35", "", "49", "http://www.winda.poznan.pl/wp-content/uploads/2015/04/20100311030104Custom-Name-004.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("79", "1", "2017-10-03 15:16:36", "2017-10-03 13:16:36", "", "20100311030115Custom-Name--005", "", "inherit", "closed", "closed", "", "20100311030115custom-name-005", "", "", "2017-10-03 15:16:36", "2017-10-03 13:16:36", "", "49", "http://www.winda.poznan.pl/wp-content/uploads/2015/04/20100311030115Custom-Name-005.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("80", "1", "2017-10-03 15:16:36", "2017-10-03 13:16:36", "", "20100411110703Custom-Name--007", "", "inherit", "closed", "closed", "", "20100411110703custom-name-007", "", "", "2017-10-03 15:16:36", "2017-10-03 13:16:36", "", "49", "http://www.winda.poznan.pl/wp-content/uploads/2015/04/20100411110703Custom-Name-007.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("81", "1", "2017-10-03 15:18:09", "2017-10-03 13:18:09", "[vc_row full_width=\"stretch_row\" content_placement=\"middle\" css=\".vc_custom_1507034725651{background-color: #00970a !important;}\"][vc_column width=\"2/3\"][vc_custom_heading text=\"``WINDA`` S.j. Zakład Elektromechaniki Dźwigowej\" font_container=\"tag:p|font_size:22|text_align:left|color:%23ffffff\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_separator color=\"white\" align=\"align_left\" el_width=\"40\"][vc_custom_heading text=\"Firma WINDA S. J. powstała w 1990 roku po likwidacji Zakładu Montażu Dźwigów w Poznaniu działającego w ramach Kombinatu Dźwigów Osobowych ZREMB - Warszawa. Firma posiada solidne podstawy finansowe, oraz duży profesjonalizm oparty na dwudziestoletnich doświadczeniach\" font_container=\"tag:p|font_size:18|text_align:left|color:%23ffffff\" use_theme_fonts=\"yes\"][/vc_column][vc_column width=\"1/3\"][vc_btn title=\"O firmie\" style=\"outline\" shape=\"square\" size=\"lg\" align=\"center\" button_block=\"true\" link=\"url:%2Fo-firmie%2F|||\"][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" content_placement=\"middle\" parallax=\"content-moving\" parallax_image=\"25\"][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi Osobowe\" h2_font_container=\"font_size:16\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów osobowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-osobowe%2F|||\" css=\".vc_custom_1507035830828{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów, które możemy Państwu dostarczyć. Serdecznie zachęcamy do zapoznania się z ofertą.[/vc_cta][/vc_column][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi Towarowe\" h2_font_container=\"font_size:18\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów towarowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-towarowych%2F|||\" css=\".vc_custom_1507035814330{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów towarowych, które możemy Państwu dostarczyć.[/vc_cta][/vc_column][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi dla osób niepełnosprawnych\" h2_font_container=\"font_size:18\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Dźwigi dla osób niepełnosprawnych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-dla-osob-niepelnosprawnych%2F|||\" css=\".vc_custom_1507035842594{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów, które możemy Państwu dostarczyć. Zapraszamy do zapoznania się z ofertą.[/vc_cta][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" parallax=\"content-moving\" parallax_image=\"62\"][vc_column][vc_media_grid element_width=\"3\" item=\"mediaGrid_ScaleInWithIcon\" initial_loading_animation=\"bounceInLeft\" grid_id=\"vc_gid:1507036585397-bfe96fb2-fd55-4\" include=\"77,78,79,80,68\"][/vc_column][/vc_row]", "Home", "", "inherit", "closed", "closed", "", "49-revision-v1", "", "", "2017-10-03 15:18:09", "2017-10-03 13:18:09", "", "49", "http://www.winda.poznan.pl/49-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("82", "1", "2017-10-03 15:18:51", "2017-10-03 13:18:51", "[vc_row full_width=\"stretch_row\" content_placement=\"middle\" css=\".vc_custom_1507034725651{background-color: #00970a !important;}\"][vc_column width=\"2/3\"][vc_custom_heading text=\"``WINDA`` S.j. Zakład Elektromechaniki Dźwigowej\" font_container=\"tag:p|font_size:22|text_align:left|color:%23ffffff\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_separator color=\"white\" align=\"align_left\" el_width=\"40\"][vc_custom_heading text=\"Firma WINDA S. J. powstała w 1990 roku po likwidacji Zakładu Montażu Dźwigów w Poznaniu działającego w ramach Kombinatu Dźwigów Osobowych ZREMB - Warszawa. Firma posiada solidne podstawy finansowe, oraz duży profesjonalizm oparty na dwudziestoletnich doświadczeniach\" font_container=\"tag:p|font_size:18|text_align:left|color:%23ffffff\" use_theme_fonts=\"yes\"][/vc_column][vc_column width=\"1/3\"][vc_btn title=\"O firmie\" style=\"outline\" shape=\"square\" size=\"lg\" align=\"center\" button_block=\"true\" link=\"url:%2Fo-firmie%2F|||\"][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" content_placement=\"middle\" parallax=\"content-moving\" parallax_image=\"25\"][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi Osobowe\" h2_font_container=\"font_size:16\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów osobowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-osobowe%2F|||\" css=\".vc_custom_1507035830828{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów, które możemy Państwu dostarczyć. Serdecznie zachęcamy do zapoznania się z ofertą.[/vc_cta][/vc_column][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi Towarowe\" h2_font_container=\"font_size:18\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów towarowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-towarowych%2F|||\" css=\".vc_custom_1507035814330{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów towarowych, które możemy Państwu dostarczyć.[/vc_cta][/vc_column][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi dla osób niepełnosprawnych\" h2_font_container=\"font_size:18\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Dźwigi dla osób niepełnosprawnych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-dla-osob-niepelnosprawnych%2F|||\" css=\".vc_custom_1507035842594{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów, które możemy Państwu dostarczyć. Zapraszamy do zapoznania się z ofertą.[/vc_cta][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" parallax=\"content-moving\" parallax_image=\"62\"][vc_column][vc_media_grid element_width=\"3\" gap=\"0\" item=\"mediaGrid_ScaleInWithIcon\" initial_loading_animation=\"bounceInLeft\" grid_id=\"vc_gid:1507036585397-bfe96fb2-fd55-4\" include=\"77,78,79,80,68\"][/vc_column][/vc_row]", "Home", "", "inherit", "closed", "closed", "", "49-revision-v1", "", "", "2017-10-03 15:18:51", "2017-10-03 13:18:51", "", "49", "http://www.winda.poznan.pl/49-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("83", "1", "2017-10-03 15:23:03", "2017-10-03 13:23:03", "[vc_row full_width=\"stretch_row\" content_placement=\"middle\" css=\".vc_custom_1507034725651{background-color: #00970a !important;}\"][vc_column width=\"2/3\"][vc_custom_heading text=\"``WINDA`` S.j. Zakład Elektromechaniki Dźwigowej\" font_container=\"tag:p|font_size:22|text_align:left|color:%23ffffff\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_separator color=\"white\" align=\"align_left\" el_width=\"40\"][vc_custom_heading text=\"Firma WINDA S. J. powstała w 1990 roku po likwidacji Zakładu Montażu Dźwigów w Poznaniu działającego w ramach Kombinatu Dźwigów Osobowych ZREMB - Warszawa. Firma posiada solidne podstawy finansowe, oraz duży profesjonalizm oparty na dwudziestoletnich doświadczeniach\" font_container=\"tag:p|font_size:18|text_align:left|color:%23ffffff\" use_theme_fonts=\"yes\"][/vc_column][vc_column width=\"1/3\"][vc_btn title=\"O firmie\" style=\"outline\" shape=\"square\" size=\"lg\" align=\"center\" button_block=\"true\" link=\"url:%2Fo-firmie%2F|||\"][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" content_placement=\"middle\" parallax=\"content-moving\" parallax_image=\"25\"][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi Osobowe\" h2_font_container=\"font_size:16\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów osobowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-osobowe%2F|||\" css=\".vc_custom_1507035830828{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów, które możemy Państwu dostarczyć. Serdecznie zachęcamy do zapoznania się z ofertą.[/vc_cta][/vc_column][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi Towarowe\" h2_font_container=\"font_size:18\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów towarowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-towarowych%2F|||\" css=\".vc_custom_1507035814330{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów towarowych, które możemy Państwu dostarczyć.[/vc_cta][/vc_column][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi dla osób niepełnosprawnych\" h2_font_container=\"font_size:18\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Dźwigi dla osób niepełnosprawnych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-dla-osob-niepelnosprawnych%2F|||\" css=\".vc_custom_1507035842594{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów, które możemy Państwu dostarczyć. Zapraszamy do zapoznania się z ofertą.[/vc_cta][/vc_column][/vc_row][vc_row full_width=\"stretch_row_content_no_spaces\"][vc_column][vc_media_grid element_width=\"3\" gap=\"0\" item=\"mediaGrid_ScaleInWithIcon\" initial_loading_animation=\"bounceInLeft\" grid_id=\"vc_gid:1507036585397-bfe96fb2-fd55-4\" include=\"77,78,79,80,68\"][/vc_column][/vc_row]", "Home", "", "inherit", "closed", "closed", "", "49-revision-v1", "", "", "2017-10-03 15:23:03", "2017-10-03 13:23:03", "", "49", "http://www.winda.poznan.pl/49-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("85", "1", "2017-10-03 15:30:30", "2017-10-03 13:30:30", "", "20100311030009DSC_0759", "", "inherit", "closed", "closed", "", "20100311030009dsc_0759-2", "", "", "2017-10-03 15:30:30", "2017-10-03 13:30:30", "", "49", "http://www.winda.poznan.pl/wp-content/uploads/2015/04/20100311030009DSC_0759-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("86", "1", "2017-10-03 15:31:09", "2017-10-03 13:31:09", "[vc_row full_width=\"stretch_row\" content_placement=\"middle\" css=\".vc_custom_1507034725651{background-color: #00970a !important;}\"][vc_column width=\"2/3\"][vc_custom_heading text=\"``WINDA`` S.j. Zakład Elektromechaniki Dźwigowej\" font_container=\"tag:p|font_size:22|text_align:left|color:%23ffffff\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_separator color=\"white\" align=\"align_left\" el_width=\"40\"][vc_custom_heading text=\"Firma WINDA S. J. powstała w 1990 roku po likwidacji Zakładu Montażu Dźwigów w Poznaniu działającego w ramach Kombinatu Dźwigów Osobowych ZREMB - Warszawa. Firma posiada solidne podstawy finansowe, oraz duży profesjonalizm oparty na dwudziestoletnich doświadczeniach\" font_container=\"tag:p|font_size:18|text_align:left|color:%23ffffff\" use_theme_fonts=\"yes\"][/vc_column][vc_column width=\"1/3\"][vc_btn title=\"O firmie\" style=\"outline\" shape=\"square\" size=\"lg\" align=\"center\" button_block=\"true\" link=\"url:%2Fo-firmie%2F|||\"][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" content_placement=\"middle\" parallax=\"content-moving\" parallax_image=\"25\"][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi Osobowe\" h2_font_container=\"font_size:16\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów osobowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-osobowe%2F|||\" css=\".vc_custom_1507035830828{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów, które możemy Państwu dostarczyć. Serdecznie zachęcamy do zapoznania się z ofertą.[/vc_cta][/vc_column][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi Towarowe\" h2_font_container=\"font_size:18\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów towarowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-towarowych%2F|||\" css=\".vc_custom_1507035814330{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów towarowych, które możemy Państwu dostarczyć.[/vc_cta][/vc_column][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi dla osób niepełnosprawnych\" h2_font_container=\"font_size:18\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Dźwigi dla osób niepełnosprawnych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-dla-osob-niepelnosprawnych%2F|||\" css=\".vc_custom_1507035842594{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów, które możemy Państwu dostarczyć. Zapraszamy do zapoznania się z ofertą.[/vc_cta][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" content_placement=\"middle\" css=\".vc_custom_1507037445668{background: #00970a url(http://www.winda.poznan.pl/wp-content/uploads/2015/04/20100311030009DSC_0759-1.jpg?id=85) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}\"][vc_column width=\"1/2\" css=\".vc_custom_1507037364707{background-position: center !important;background-repeat: no-repeat !important;background-size: contain !important;}\"][/vc_column][vc_column width=\"1/2\"][vc_custom_heading text=\"``WINDA`` S.j. Zakład Elektromechaniki Dźwigowej\" font_container=\"tag:p|font_size:22|text_align:left|color:%23ffffff\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_separator color=\"white\" align=\"align_left\" el_width=\"40\"][vc_custom_heading text=\"Firma WINDA S. J. powstała w 1990 roku po likwidacji Zakładu Montażu Dźwigów w Poznaniu działającego w ramach Kombinatu Dźwigów Osobowych ZREMB - Warszawa. Firma posiada solidne podstawy finansowe, oraz duży profesjonalizm oparty na dwudziestoletnich doświadczeniach\" font_container=\"tag:p|font_size:18|text_align:left|color:%23ffffff\" use_theme_fonts=\"yes\"][/vc_column][/vc_row][vc_row full_width=\"stretch_row_content_no_spaces\"][vc_column][vc_media_grid element_width=\"3\" gap=\"0\" item=\"mediaGrid_ScaleInWithIcon\" initial_loading_animation=\"bounceInLeft\" grid_id=\"vc_gid:1507036585397-bfe96fb2-fd55-4\" include=\"77,78,79,80,68\"][/vc_column][/vc_row]", "Home", "", "inherit", "closed", "closed", "", "49-revision-v1", "", "", "2017-10-03 15:31:09", "2017-10-03 13:31:09", "", "49", "http://www.winda.poznan.pl/49-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("87", "1", "2017-10-03 15:32:33", "2017-10-03 13:32:33", "[vc_row full_width=\"stretch_row\" content_placement=\"middle\" css=\".vc_custom_1507034725651{background-color: #00970a !important;}\"][vc_column width=\"2/3\"][vc_custom_heading text=\"``WINDA`` S.j. Zakład Elektromechaniki Dźwigowej\" font_container=\"tag:p|font_size:22|text_align:left|color:%23ffffff\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_separator color=\"white\" align=\"align_left\" el_width=\"40\"][vc_custom_heading text=\"Firma WINDA S. J. powstała w 1990 roku po likwidacji Zakładu Montażu Dźwigów w Poznaniu działającego w ramach Kombinatu Dźwigów Osobowych ZREMB - Warszawa. Firma posiada solidne podstawy finansowe, oraz duży profesjonalizm oparty na dwudziestoletnich doświadczeniach\" font_container=\"tag:p|font_size:18|text_align:left|color:%23ffffff\" use_theme_fonts=\"yes\"][/vc_column][vc_column width=\"1/3\"][vc_btn title=\"O firmie\" style=\"outline\" shape=\"square\" size=\"lg\" align=\"center\" button_block=\"true\" link=\"url:%2Fo-firmie%2F|||\"][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" content_placement=\"middle\" parallax=\"content-moving\" parallax_image=\"25\"][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi Osobowe\" h2_font_container=\"font_size:16\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów osobowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-osobowe%2F|||\" css=\".vc_custom_1507035830828{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów, które możemy Państwu dostarczyć. Serdecznie zachęcamy do zapoznania się z ofertą.[/vc_cta][/vc_column][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi Towarowe\" h2_font_container=\"font_size:18\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów towarowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-towarowych%2F|||\" css=\".vc_custom_1507035814330{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów towarowych, które możemy Państwu dostarczyć.[/vc_cta][/vc_column][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi dla osób niepełnosprawnych\" h2_font_container=\"font_size:18\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Dźwigi dla osób niepełnosprawnych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-dla-osob-niepelnosprawnych%2F|||\" css=\".vc_custom_1507035842594{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów, które możemy Państwu dostarczyć. Zapraszamy do zapoznania się z ofertą.[/vc_cta][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" content_placement=\"middle\" css=\".vc_custom_1507037445668{background: #00970a url(http://www.winda.poznan.pl/wp-content/uploads/2015/04/20100311030009DSC_0759-1.jpg?id=85) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}\"][vc_column width=\"1/2\" css=\".vc_custom_1507037364707{background-position: center !important;background-repeat: no-repeat !important;background-size: contain !important;}\"][/vc_column][vc_column width=\"1/2\"][vc_custom_heading text=\"Serwis\" font_container=\"tag:p|font_size:22|text_align:right|color:%23ffffff\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_separator color=\"white\" align=\"align_right\" el_width=\"40\"][vc_custom_heading text=\"Firma WINDA prowadzi także serwis urządzeń dźwigowych (nowych, zakupionych w naszej firmie oraz starszego typu). Wykonujemy także naprawy gwarancyjne zakupionych u nas urządzeń. Przeprowadzamy remonty dźwigów w każdym zakresie. \" font_container=\"tag:p|font_size:18|text_align:right|color:%23ffffff\" use_theme_fonts=\"yes\"][vc_btn title=\"Dowiedz się więcej\" style=\"outline\" shape=\"square\" size=\"lg\" align=\"center\" button_block=\"true\"][/vc_column][/vc_row][vc_row full_width=\"stretch_row_content_no_spaces\"][vc_column][vc_media_grid element_width=\"3\" gap=\"0\" item=\"mediaGrid_ScaleInWithIcon\" initial_loading_animation=\"bounceInLeft\" grid_id=\"vc_gid:1507036585397-bfe96fb2-fd55-4\" include=\"77,78,79,80,68\"][/vc_column][/vc_row]", "Home", "", "inherit", "closed", "closed", "", "49-revision-v1", "", "", "2017-10-03 15:32:33", "2017-10-03 13:32:33", "", "49", "http://www.winda.poznan.pl/49-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("88", "1", "2017-10-03 15:33:02", "2017-10-03 13:33:02", "[vc_row full_width=\"stretch_row\" content_placement=\"middle\" css=\".vc_custom_1507034725651{background-color: #00970a !important;}\"][vc_column width=\"2/3\"][vc_custom_heading text=\"``WINDA`` S.j. Zakład Elektromechaniki Dźwigowej\" font_container=\"tag:p|font_size:22|text_align:left|color:%23ffffff\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_separator color=\"white\" align=\"align_left\" el_width=\"40\"][vc_custom_heading text=\"Firma WINDA S. J. powstała w 1990 roku po likwidacji Zakładu Montażu Dźwigów w Poznaniu działającego w ramach Kombinatu Dźwigów Osobowych ZREMB - Warszawa. Firma posiada solidne podstawy finansowe, oraz duży profesjonalizm oparty na dwudziestoletnich doświadczeniach\" font_container=\"tag:p|font_size:18|text_align:left|color:%23ffffff\" use_theme_fonts=\"yes\"][/vc_column][vc_column width=\"1/3\"][vc_btn title=\"O firmie\" style=\"outline\" shape=\"square\" size=\"lg\" align=\"center\" button_block=\"true\" link=\"url:%2Fo-firmie%2F|||\"][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" content_placement=\"middle\" parallax=\"content-moving\" parallax_image=\"25\"][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi Osobowe\" h2_font_container=\"font_size:16\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów osobowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-osobowe%2F|||\" css=\".vc_custom_1507035830828{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów, które możemy Państwu dostarczyć. Serdecznie zachęcamy do zapoznania się z ofertą.[/vc_cta][/vc_column][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi Towarowe\" h2_font_container=\"font_size:18\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów towarowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-towarowych%2F|||\" css=\".vc_custom_1507035814330{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów towarowych, które możemy Państwu dostarczyć.[/vc_cta][/vc_column][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi dla osób niepełnosprawnych\" h2_font_container=\"font_size:18\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Dźwigi dla osób niepełnosprawnych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-dla-osob-niepelnosprawnych%2F|||\" css=\".vc_custom_1507035842594{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów, które możemy Państwu dostarczyć. Zapraszamy do zapoznania się z ofertą.[/vc_cta][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" content_placement=\"middle\" css=\".vc_custom_1507037445668{background: #00970a url(http://www.winda.poznan.pl/wp-content/uploads/2015/04/20100311030009DSC_0759-1.jpg?id=85) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}\"][vc_column width=\"1/2\" css=\".vc_custom_1507037364707{background-position: center !important;background-repeat: no-repeat !important;background-size: contain !important;}\"][/vc_column][vc_column width=\"1/2\"][vc_custom_heading text=\"Serwis urządzeń dźwigowych\" font_container=\"tag:p|font_size:26|text_align:right|color:%23ffffff\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_separator color=\"white\" align=\"align_right\" el_width=\"40\"][vc_custom_heading text=\"Firma WINDA prowadzi także serwis urządzeń dźwigowych (nowych, zakupionych w naszej firmie oraz starszego typu). Wykonujemy także naprawy gwarancyjne zakupionych u nas urządzeń. Przeprowadzamy remonty dźwigów w każdym zakresie. \" font_container=\"tag:p|font_size:18|text_align:right|color:%23ffffff\" use_theme_fonts=\"yes\"][vc_btn title=\"Dowiedz się więcej\" style=\"outline\" shape=\"square\" size=\"lg\" align=\"center\" button_block=\"true\"][/vc_column][/vc_row][vc_row full_width=\"stretch_row_content_no_spaces\"][vc_column][vc_media_grid element_width=\"3\" gap=\"0\" item=\"mediaGrid_ScaleInWithIcon\" initial_loading_animation=\"bounceInLeft\" grid_id=\"vc_gid:1507036585397-bfe96fb2-fd55-4\" include=\"77,78,79,80,68\"][/vc_column][/vc_row]", "Home", "", "inherit", "closed", "closed", "", "49-revision-v1", "", "", "2017-10-03 15:33:02", "2017-10-03 13:33:02", "", "49", "http://www.winda.poznan.pl/49-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("89", "1", "2017-10-03 15:35:32", "2017-10-03 13:35:32", "[vc_row full_width=\"stretch_row\" content_placement=\"middle\" css=\".vc_custom_1507034725651{background-color: #00970a !important;}\"][vc_column width=\"2/3\"][vc_custom_heading text=\"``WINDA`` S.j. Zakład Elektromechaniki Dźwigowej\" font_container=\"tag:p|font_size:22|text_align:left|color:%23ffffff\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_separator color=\"white\" align=\"align_left\" el_width=\"40\"][vc_custom_heading text=\"Firma WINDA S. J. powstała w 1990 roku po likwidacji Zakładu Montażu Dźwigów w Poznaniu działającego w ramach Kombinatu Dźwigów Osobowych ZREMB - Warszawa. Firma posiada solidne podstawy finansowe, oraz duży profesjonalizm oparty na dwudziestoletnich doświadczeniach\" font_container=\"tag:p|font_size:18|text_align:left|color:%23ffffff\" use_theme_fonts=\"yes\"][/vc_column][vc_column width=\"1/3\"][vc_btn title=\"O firmie\" style=\"outline\" shape=\"square\" size=\"lg\" align=\"center\" button_block=\"true\" link=\"url:%2Fo-firmie%2F|||\"][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" content_placement=\"middle\" parallax=\"content-moving\" parallax_image=\"25\"][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi Osobowe\" h2_font_container=\"font_size:16\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów osobowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-osobowe%2F|||\" css=\".vc_custom_1507035830828{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów, które możemy Państwu dostarczyć. Serdecznie zachęcamy do zapoznania się z ofertą.[/vc_cta][/vc_column][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi Towarowe\" h2_font_container=\"font_size:18\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów towarowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-towarowych%2F|||\" css=\".vc_custom_1507035814330{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów towarowych, które możemy Państwu dostarczyć.[/vc_cta][/vc_column][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi dla osób niepełnosprawnych\" h2_font_container=\"font_size:18\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Dźwigi dla osób niepełnosprawnych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-dla-osob-niepelnosprawnych%2F|||\" css=\".vc_custom_1507035842594{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów, które możemy Państwu dostarczyć. Zapraszamy do zapoznania się z ofertą.[/vc_cta][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" content_placement=\"middle\" css=\".vc_custom_1507037445668{background: #00970a url(http://www.winda.poznan.pl/wp-content/uploads/2015/04/20100311030009DSC_0759-1.jpg?id=85) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}\"][vc_column width=\"1/2\" css=\".vc_custom_1507037364707{background-position: center !important;background-repeat: no-repeat !important;background-size: contain !important;}\"][/vc_column][vc_column width=\"1/2\"][vc_custom_heading text=\"Serwis urządzeń dźwigowych\" font_container=\"tag:p|font_size:26|text_align:right|color:%23ffffff\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_separator color=\"white\" align=\"align_right\" el_width=\"40\"][vc_custom_heading text=\"Firma WINDA prowadzi także serwis urządzeń dźwigowych (nowych, zakupionych w naszej firmie oraz starszego typu). Wykonujemy także naprawy gwarancyjne zakupionych u nas urządzeń. Przeprowadzamy remonty dźwigów w każdym zakresie. \" font_container=\"tag:p|font_size:18|text_align:right|color:%23ffffff\" use_theme_fonts=\"yes\"][vc_btn title=\"Dowiedz się więcej\" style=\"outline\" shape=\"square\" size=\"lg\" align=\"center\" button_block=\"true\"][/vc_column][/vc_row][vc_row full_width=\"stretch_row_content_no_spaces\"][vc_column][vc_custom_heading text=\"NASZA GALERIA\" font_container=\"tag:p|font_size:30|text_align:center\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_separator color=\"custom\" el_width=\"20\" accent_color=\"#00970a\"][vc_media_grid element_width=\"3\" gap=\"0\" item=\"mediaGrid_ScaleInWithIcon\" initial_loading_animation=\"bounceInLeft\" grid_id=\"vc_gid:1507036585397-bfe96fb2-fd55-4\" include=\"77,78,79,80,68\"][/vc_column][/vc_row]", "Home", "", "inherit", "closed", "closed", "", "49-revision-v1", "", "", "2017-10-03 15:35:32", "2017-10-03 13:35:32", "", "49", "http://www.winda.poznan.pl/49-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("90", "1", "2017-10-03 15:36:01", "2017-10-03 13:36:01", "[vc_row full_width=\"stretch_row\" content_placement=\"middle\" css=\".vc_custom_1507034725651{background-color: #00970a !important;}\"][vc_column width=\"2/3\"][vc_custom_heading text=\"``WINDA`` S.j. Zakład Elektromechaniki Dźwigowej\" font_container=\"tag:p|font_size:22|text_align:left|color:%23ffffff\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_separator color=\"white\" align=\"align_left\" el_width=\"40\"][vc_custom_heading text=\"Firma WINDA S. J. powstała w 1990 roku po likwidacji Zakładu Montażu Dźwigów w Poznaniu działającego w ramach Kombinatu Dźwigów Osobowych ZREMB - Warszawa. Firma posiada solidne podstawy finansowe, oraz duży profesjonalizm oparty na dwudziestoletnich doświadczeniach\" font_container=\"tag:p|font_size:18|text_align:left|color:%23ffffff\" use_theme_fonts=\"yes\"][/vc_column][vc_column width=\"1/3\"][vc_btn title=\"O firmie\" style=\"outline\" shape=\"square\" size=\"lg\" align=\"center\" button_block=\"true\" link=\"url:%2Fo-firmie%2F|||\"][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" content_placement=\"middle\" parallax=\"content-moving\" parallax_image=\"25\"][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi Osobowe\" h2_font_container=\"font_size:16\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów osobowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-osobowe%2F|||\" css=\".vc_custom_1507035830828{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów, które możemy Państwu dostarczyć. Serdecznie zachęcamy do zapoznania się z ofertą.[/vc_cta][/vc_column][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi Towarowe\" h2_font_container=\"font_size:18\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów towarowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-towarowych%2F|||\" css=\".vc_custom_1507035814330{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów towarowych, które możemy Państwu dostarczyć.[/vc_cta][/vc_column][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi dla osób niepełnosprawnych\" h2_font_container=\"font_size:18\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Dźwigi dla osób niepełnosprawnych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-dla-osob-niepelnosprawnych%2F|||\" css=\".vc_custom_1507035842594{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów, które możemy Państwu dostarczyć. Zapraszamy do zapoznania się z ofertą.[/vc_cta][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" content_placement=\"middle\" css=\".vc_custom_1507037445668{background: #00970a url(http://www.winda.poznan.pl/wp-content/uploads/2015/04/20100311030009DSC_0759-1.jpg?id=85) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}\"][vc_column width=\"1/2\" css=\".vc_custom_1507037364707{background-position: center !important;background-repeat: no-repeat !important;background-size: contain !important;}\"][/vc_column][vc_column width=\"1/2\"][vc_custom_heading text=\"Serwis urządzeń dźwigowych\" font_container=\"tag:p|font_size:26|text_align:right|color:%23ffffff\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_separator color=\"white\" align=\"align_right\" el_width=\"40\"][vc_custom_heading text=\"Firma WINDA prowadzi także serwis urządzeń dźwigowych (nowych, zakupionych w naszej firmie oraz starszego typu). Wykonujemy także naprawy gwarancyjne zakupionych u nas urządzeń. Przeprowadzamy remonty dźwigów w każdym zakresie. \" font_container=\"tag:p|font_size:18|text_align:right|color:%23ffffff\" use_theme_fonts=\"yes\"][vc_btn title=\"Dowiedz się więcej\" style=\"outline\" shape=\"square\" size=\"lg\" align=\"center\" button_block=\"true\"][/vc_column][/vc_row][vc_row full_width=\"stretch_row_content_no_spaces\" parallax=\"content-moving-fade\" parallax_image=\"25\"][vc_column][vc_custom_heading text=\"NASZA GALERIA\" font_container=\"tag:p|font_size:30|text_align:center\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_separator color=\"custom\" el_width=\"20\" accent_color=\"#00970a\"][vc_media_grid element_width=\"3\" gap=\"0\" item=\"mediaGrid_ScaleInWithIcon\" initial_loading_animation=\"bounceInLeft\" grid_id=\"vc_gid:1507036585397-bfe96fb2-fd55-4\" include=\"77,78,79,80,68\"][/vc_column][/vc_row]", "Home", "", "inherit", "closed", "closed", "", "49-revision-v1", "", "", "2017-10-03 15:36:01", "2017-10-03 13:36:01", "", "49", "http://www.winda.poznan.pl/49-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("91", "1", "2017-10-03 15:36:23", "2017-10-03 13:36:23", "[vc_row full_width=\"stretch_row\" content_placement=\"middle\" css=\".vc_custom_1507034725651{background-color: #00970a !important;}\"][vc_column width=\"2/3\"][vc_custom_heading text=\"``WINDA`` S.j. Zakład Elektromechaniki Dźwigowej\" font_container=\"tag:p|font_size:22|text_align:left|color:%23ffffff\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_separator color=\"white\" align=\"align_left\" el_width=\"40\"][vc_custom_heading text=\"Firma WINDA S. J. powstała w 1990 roku po likwidacji Zakładu Montażu Dźwigów w Poznaniu działającego w ramach Kombinatu Dźwigów Osobowych ZREMB - Warszawa. Firma posiada solidne podstawy finansowe, oraz duży profesjonalizm oparty na dwudziestoletnich doświadczeniach\" font_container=\"tag:p|font_size:18|text_align:left|color:%23ffffff\" use_theme_fonts=\"yes\"][/vc_column][vc_column width=\"1/3\"][vc_btn title=\"O firmie\" style=\"outline\" shape=\"square\" size=\"lg\" align=\"center\" button_block=\"true\" link=\"url:%2Fo-firmie%2F|||\"][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" content_placement=\"middle\" parallax=\"content-moving\" parallax_image=\"25\"][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi Osobowe\" h2_font_container=\"font_size:16\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów osobowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-osobowe%2F|||\" css=\".vc_custom_1507035830828{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów, które możemy Państwu dostarczyć. Serdecznie zachęcamy do zapoznania się z ofertą.[/vc_cta][/vc_column][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi Towarowe\" h2_font_container=\"font_size:18\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów towarowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-towarowych%2F|||\" css=\".vc_custom_1507035814330{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów towarowych, które możemy Państwu dostarczyć.[/vc_cta][/vc_column][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi dla osób niepełnosprawnych\" h2_font_container=\"font_size:18\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Dźwigi dla osób niepełnosprawnych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-dla-osob-niepelnosprawnych%2F|||\" css=\".vc_custom_1507035842594{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów, które możemy Państwu dostarczyć. Zapraszamy do zapoznania się z ofertą.[/vc_cta][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" content_placement=\"middle\" css=\".vc_custom_1507037445668{background: #00970a url(http://www.winda.poznan.pl/wp-content/uploads/2015/04/20100311030009DSC_0759-1.jpg?id=85) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}\"][vc_column width=\"1/2\" css=\".vc_custom_1507037364707{background-position: center !important;background-repeat: no-repeat !important;background-size: contain !important;}\"][/vc_column][vc_column width=\"1/2\"][vc_custom_heading text=\"Serwis urządzeń dźwigowych\" font_container=\"tag:p|font_size:26|text_align:right|color:%23ffffff\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_separator color=\"white\" align=\"align_right\" el_width=\"40\"][vc_custom_heading text=\"Firma WINDA prowadzi także serwis urządzeń dźwigowych (nowych, zakupionych w naszej firmie oraz starszego typu). Wykonujemy także naprawy gwarancyjne zakupionych u nas urządzeń. Przeprowadzamy remonty dźwigów w każdym zakresie. \" font_container=\"tag:p|font_size:18|text_align:right|color:%23ffffff\" use_theme_fonts=\"yes\"][vc_btn title=\"Dowiedz się więcej\" style=\"outline\" shape=\"square\" size=\"lg\" align=\"center\" button_block=\"true\"][/vc_column][/vc_row][vc_row full_width=\"stretch_row_content_no_spaces\" parallax=\"content-moving\" parallax_image=\"25\"][vc_column][vc_custom_heading text=\"NASZA GALERIA\" font_container=\"tag:p|font_size:30|text_align:center\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_separator color=\"custom\" el_width=\"20\" accent_color=\"#00970a\"][vc_media_grid element_width=\"3\" gap=\"0\" item=\"mediaGrid_ScaleInWithIcon\" initial_loading_animation=\"bounceInLeft\" grid_id=\"vc_gid:1507036585397-bfe96fb2-fd55-4\" include=\"77,78,79,80,68\"][/vc_column][/vc_row]", "Home", "", "inherit", "closed", "closed", "", "49-revision-v1", "", "", "2017-10-03 15:36:23", "2017-10-03 13:36:23", "", "49", "http://www.winda.poznan.pl/49-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("92", "1", "2017-10-03 15:38:07", "2017-10-03 13:38:07", "", "20100411110508Custom-Name--006", "", "inherit", "closed", "closed", "", "20100411110508custom-name-006", "", "", "2017-10-03 15:38:07", "2017-10-03 13:38:07", "", "49", "http://www.winda.poznan.pl/wp-content/uploads/2015/04/20100411110508Custom-Name-006.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("93", "1", "2017-10-03 15:38:09", "2017-10-03 13:38:09", "", "20100411110716Custom-Name--008", "", "inherit", "closed", "closed", "", "20100411110716custom-name-008", "", "", "2017-10-03 15:38:09", "2017-10-03 13:38:09", "", "49", "http://www.winda.poznan.pl/wp-content/uploads/2015/04/20100411110716Custom-Name-008.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("94", "1", "2017-10-03 15:38:09", "2017-10-03 13:38:09", "", "20100411110755DSC_0061", "", "inherit", "closed", "closed", "", "20100411110755dsc_0061", "", "", "2017-10-03 15:38:09", "2017-10-03 13:38:09", "", "49", "http://www.winda.poznan.pl/wp-content/uploads/2015/04/20100411110755DSC_0061.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("95", "1", "2017-10-03 15:38:09", "2017-10-03 13:38:09", "", "20100411110820DSC_0068", "", "inherit", "closed", "closed", "", "20100411110820dsc_0068", "", "", "2017-10-03 15:38:09", "2017-10-03 13:38:09", "", "49", "http://www.winda.poznan.pl/wp-content/uploads/2015/04/20100411110820DSC_0068.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("96", "1", "2017-10-03 15:38:51", "2017-10-03 13:38:51", "", "20100411110755DSC_0061-everglow", "", "inherit", "closed", "closed", "", "20100411110755dsc_0061-everglow", "", "", "2017-10-03 15:38:51", "2017-10-03 13:38:51", "", "0", "http://www.winda.poznan.pl/wp-content/uploads/2017/10/20100411110755DSC_0061-everglow.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("97", "1", "2017-10-03 15:39:03", "2017-10-03 13:39:03", "[vc_row full_width=\"stretch_row\" content_placement=\"middle\" css=\".vc_custom_1507034725651{background-color: #00970a !important;}\"][vc_column width=\"2/3\"][vc_custom_heading text=\"``WINDA`` S.j. Zakład Elektromechaniki Dźwigowej\" font_container=\"tag:p|font_size:22|text_align:left|color:%23ffffff\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_separator color=\"white\" align=\"align_left\" el_width=\"40\"][vc_custom_heading text=\"Firma WINDA S. J. powstała w 1990 roku po likwidacji Zakładu Montażu Dźwigów w Poznaniu działającego w ramach Kombinatu Dźwigów Osobowych ZREMB - Warszawa. Firma posiada solidne podstawy finansowe, oraz duży profesjonalizm oparty na dwudziestoletnich doświadczeniach\" font_container=\"tag:p|font_size:18|text_align:left|color:%23ffffff\" use_theme_fonts=\"yes\"][/vc_column][vc_column width=\"1/3\"][vc_btn title=\"O firmie\" style=\"outline\" shape=\"square\" size=\"lg\" align=\"center\" button_block=\"true\" link=\"url:%2Fo-firmie%2F|||\"][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" content_placement=\"middle\" parallax=\"content-moving\" parallax_image=\"25\"][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi Osobowe\" h2_font_container=\"font_size:16\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów osobowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-osobowe%2F|||\" css=\".vc_custom_1507035830828{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów, które możemy Państwu dostarczyć. Serdecznie zachęcamy do zapoznania się z ofertą.[/vc_cta][/vc_column][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi Towarowe\" h2_font_container=\"font_size:18\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów towarowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-towarowych%2F|||\" css=\".vc_custom_1507035814330{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów towarowych, które możemy Państwu dostarczyć.[/vc_cta][/vc_column][vc_column width=\"1/3\"][vc_cta h2=\"Dźwigi dla osób niepełnosprawnych\" h2_font_container=\"font_size:18\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Dźwigi dla osób niepełnosprawnych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-dla-osob-niepelnosprawnych%2F|||\" css=\".vc_custom_1507035842594{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów, które możemy Państwu dostarczyć. Zapraszamy do zapoznania się z ofertą.[/vc_cta][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" content_placement=\"middle\" css=\".vc_custom_1507037445668{background: #00970a url(http://www.winda.poznan.pl/wp-content/uploads/2015/04/20100311030009DSC_0759-1.jpg?id=85) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}\"][vc_column width=\"1/2\" css=\".vc_custom_1507037364707{background-position: center !important;background-repeat: no-repeat !important;background-size: contain !important;}\"][/vc_column][vc_column width=\"1/2\"][vc_custom_heading text=\"Serwis urządzeń dźwigowych\" font_container=\"tag:p|font_size:26|text_align:right|color:%23ffffff\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_separator color=\"white\" align=\"align_right\" el_width=\"40\"][vc_custom_heading text=\"Firma WINDA prowadzi także serwis urządzeń dźwigowych (nowych, zakupionych w naszej firmie oraz starszego typu). Wykonujemy także naprawy gwarancyjne zakupionych u nas urządzeń. Przeprowadzamy remonty dźwigów w każdym zakresie. \" font_container=\"tag:p|font_size:18|text_align:right|color:%23ffffff\" use_theme_fonts=\"yes\"][vc_btn title=\"Dowiedz się więcej\" style=\"outline\" shape=\"square\" size=\"lg\" align=\"center\" button_block=\"true\"][/vc_column][/vc_row][vc_row full_width=\"stretch_row_content_no_spaces\" parallax=\"content-moving\" parallax_image=\"25\"][vc_column][vc_custom_heading text=\"NASZA GALERIA\" font_container=\"tag:p|font_size:30|text_align:center\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_separator color=\"custom\" el_width=\"20\" accent_color=\"#00970a\"][vc_media_grid element_width=\"3\" gap=\"0\" item=\"mediaGrid_ScaleInWithIcon\" initial_loading_animation=\"bounceInLeft\" grid_id=\"vc_gid:1507036585397-bfe96fb2-fd55-4\" include=\"77,78,79,80,68,92,93,96\"][/vc_column][/vc_row]", "Home", "", "inherit", "closed", "closed", "", "49-revision-v1", "", "", "2017-10-03 15:39:03", "2017-10-03 13:39:03", "", "49", "http://www.winda.poznan.pl/49-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("98", "1", "2017-10-03 15:42:30", "2017-10-03 13:42:30", "[vc_row full_width=\"stretch_row\" content_placement=\"middle\" css=\".vc_custom_1507034725651{background-color: #00970a !important;}\"][vc_column width=\"2/3\"][vc_custom_heading text=\"``WINDA`` S.j. Zakład Elektromechaniki Dźwigowej\" font_container=\"tag:p|font_size:22|text_align:left|color:%23ffffff\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_separator color=\"white\" align=\"align_left\" el_width=\"40\"][vc_custom_heading text=\"Firma WINDA S. J. powstała w 1990 roku po likwidacji Zakładu Montażu Dźwigów w Poznaniu działającego w ramach Kombinatu Dźwigów Osobowych ZREMB - Warszawa. Firma posiada solidne podstawy finansowe, oraz duży profesjonalizm oparty na dwudziestoletnich doświadczeniach\" font_container=\"tag:p|font_size:18|text_align:left|color:%23ffffff\" use_theme_fonts=\"yes\"][/vc_column][vc_column width=\"1/3\"][vc_btn title=\"O firmie\" style=\"outline\" shape=\"square\" size=\"lg\" align=\"center\" button_block=\"true\" link=\"url:%2Fo-firmie%2F|||\"][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" content_placement=\"middle\" parallax=\"content-moving\" parallax_image=\"25\"][vc_column][vc_text_separator title=\"NASZA OFERTA\" color=\"custom\" accent_color=\"#00970a\" el_id=\"naglowek\"][vc_row_inner][vc_column_inner width=\"1/3\"][vc_cta h2=\"Dźwigi Osobowe\" h2_font_container=\"font_size:16\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów osobowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-osobowe%2F|||\" css=\".vc_custom_1507035830828{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów, które możemy Państwu dostarczyć. Serdecznie zachęcamy do zapoznania się z ofertą.[/vc_cta][/vc_column_inner][vc_column_inner width=\"1/3\"][vc_cta h2=\"Dźwigi dla osób niepełnosprawnych\" h2_font_container=\"font_size:18\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Dźwigi dla osób niepełnosprawnych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-dla-osob-niepelnosprawnych%2F|||\" css=\".vc_custom_1507035842594{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów, które możemy Państwu dostarczyć. Zapraszamy do zapoznania się z ofertą.[/vc_cta][/vc_column_inner][vc_column_inner width=\"1/3\"][vc_cta h2=\"Dźwigi Towarowe\" h2_font_container=\"font_size:18\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów towarowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-towarowych%2F|||\" css=\".vc_custom_1507035814330{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów towarowych, które możemy Państwu dostarczyć.[/vc_cta][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" content_placement=\"middle\" css=\".vc_custom_1507037445668{background: #00970a url(http://www.winda.poznan.pl/wp-content/uploads/2015/04/20100311030009DSC_0759-1.jpg?id=85) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}\"][vc_column width=\"1/2\" css=\".vc_custom_1507037364707{background-position: center !important;background-repeat: no-repeat !important;background-size: contain !important;}\"][/vc_column][vc_column width=\"1/2\"][vc_custom_heading text=\"Serwis urządzeń dźwigowych\" font_container=\"tag:p|font_size:26|text_align:right|color:%23ffffff\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_separator color=\"white\" align=\"align_right\" el_width=\"40\"][vc_custom_heading text=\"Firma WINDA prowadzi także serwis urządzeń dźwigowych (nowych, zakupionych w naszej firmie oraz starszego typu). Wykonujemy także naprawy gwarancyjne zakupionych u nas urządzeń. Przeprowadzamy remonty dźwigów w każdym zakresie. \" font_container=\"tag:p|font_size:18|text_align:right|color:%23ffffff\" use_theme_fonts=\"yes\"][vc_btn title=\"Dowiedz się więcej\" style=\"outline\" shape=\"square\" size=\"lg\" align=\"center\" button_block=\"true\"][/vc_column][/vc_row][vc_row full_width=\"stretch_row_content_no_spaces\" parallax=\"content-moving\" parallax_image=\"25\"][vc_column][vc_custom_heading text=\"NASZA GALERIA\" font_container=\"tag:p|font_size:30|text_align:center\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_separator color=\"custom\" el_width=\"20\" accent_color=\"#00970a\"][vc_media_grid element_width=\"3\" gap=\"0\" item=\"mediaGrid_ScaleInWithIcon\" initial_loading_animation=\"bounceInLeft\" grid_id=\"vc_gid:1507036585397-bfe96fb2-fd55-4\" include=\"77,78,79,80,68,92,93,96\"][/vc_column][/vc_row]", "Home", "", "inherit", "closed", "closed", "", "49-revision-v1", "", "", "2017-10-03 15:42:30", "2017-10-03 13:42:30", "", "49", "http://www.winda.poznan.pl/49-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("99", "1", "2017-10-03 15:43:06", "2017-10-03 13:43:06", "[vc_row full_width=\"stretch_row\" content_placement=\"middle\" css=\".vc_custom_1507034725651{background-color: #00970a !important;}\"][vc_column width=\"2/3\"][vc_custom_heading text=\"``WINDA`` S.j. Zakład Elektromechaniki Dźwigowej\" font_container=\"tag:p|font_size:22|text_align:left|color:%23ffffff\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_separator color=\"white\" align=\"align_left\" el_width=\"40\"][vc_custom_heading text=\"Firma WINDA S. J. powstała w 1990 roku po likwidacji Zakładu Montażu Dźwigów w Poznaniu działającego w ramach Kombinatu Dźwigów Osobowych ZREMB - Warszawa. Firma posiada solidne podstawy finansowe, oraz duży profesjonalizm oparty na dwudziestoletnich doświadczeniach\" font_container=\"tag:p|font_size:18|text_align:left|color:%23ffffff\" use_theme_fonts=\"yes\"][/vc_column][vc_column width=\"1/3\"][vc_btn title=\"O firmie\" style=\"outline\" shape=\"square\" size=\"lg\" align=\"center\" button_block=\"true\" link=\"url:%2Fo-firmie%2F|||\"][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" content_placement=\"middle\" parallax=\"content-moving\" parallax_image=\"25\"][vc_column][vc_text_separator title=\"NASZA OFERTA\" color=\"custom\" accent_color=\"#00970a\" el_id=\"naglowek\"][vc_row_inner][vc_column_inner width=\"1/3\"][vc_cta h2=\"Dźwigi Osobowe\" h2_font_container=\"font_size:16\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów osobowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-osobowe%2F|||\" css=\".vc_custom_1507035830828{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów, które możemy Państwu dostarczyć. Serdecznie zachęcamy do zapoznania się z ofertą.[/vc_cta][/vc_column_inner][vc_column_inner width=\"1/3\"][vc_cta h2=\"Dźwigi dla osób niepełnosprawnych\" h2_font_container=\"font_size:18\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Dźwigi dla osób niepełnosprawnych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-dla-osob-niepelnosprawnych%2F|||\" css=\".vc_custom_1507035842594{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów, które możemy Państwu dostarczyć. Zapraszamy do zapoznania się z ofertą.[/vc_cta][/vc_column_inner][vc_column_inner width=\"1/3\"][vc_cta h2=\"Dźwigi Towarowe\" h2_font_container=\"font_size:18\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów towarowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-towarowych%2F|||\" css=\".vc_custom_1507035814330{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów towarowych, które możemy Państwu dostarczyć.[/vc_cta][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" content_placement=\"middle\" css=\".vc_custom_1507037445668{background: #00970a url(http://www.winda.poznan.pl/wp-content/uploads/2015/04/20100311030009DSC_0759-1.jpg?id=85) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}\"][vc_column width=\"1/2\" css=\".vc_custom_1507037364707{background-position: center !important;background-repeat: no-repeat !important;background-size: contain !important;}\"][/vc_column][vc_column width=\"1/2\"][vc_custom_heading text=\"Serwis urządzeń dźwigowych\" font_container=\"tag:p|font_size:26|text_align:right|color:%23ffffff\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_separator color=\"white\" align=\"align_right\" el_width=\"40\"][vc_custom_heading text=\"Firma WINDA prowadzi także serwis urządzeń dźwigowych (nowych, zakupionych w naszej firmie oraz starszego typu). Wykonujemy także naprawy gwarancyjne zakupionych u nas urządzeń. Przeprowadzamy remonty dźwigów w każdym zakresie. \" font_container=\"tag:p|font_size:18|text_align:right|color:%23ffffff\" use_theme_fonts=\"yes\"][vc_btn title=\"Dowiedz się więcej\" style=\"outline\" shape=\"square\" size=\"lg\" align=\"center\" button_block=\"true\"][/vc_column][/vc_row][vc_row full_width=\"stretch_row_content_no_spaces\" parallax=\"content-moving\" parallax_image=\"25\"][vc_column][vc_text_separator title=\"NASZA GALERIA\" color=\"custom\" accent_color=\"#00970a\" el_id=\"naglowek\"][vc_media_grid element_width=\"3\" gap=\"0\" item=\"mediaGrid_ScaleInWithIcon\" initial_loading_animation=\"bounceInLeft\" grid_id=\"vc_gid:1507036585397-bfe96fb2-fd55-4\" include=\"77,78,79,80,68,92,93,96\"][/vc_column][/vc_row]", "Home", "", "inherit", "closed", "closed", "", "49-revision-v1", "", "", "2017-10-03 15:43:06", "2017-10-03 13:43:06", "", "49", "http://www.winda.poznan.pl/49-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("100", "1", "2017-10-03 15:43:18", "2017-10-03 13:43:18", "[vc_row full_width=\"stretch_row\" content_placement=\"middle\" css=\".vc_custom_1507034725651{background-color: #00970a !important;}\"][vc_column width=\"2/3\"][vc_custom_heading text=\"``WINDA`` S.j. Zakład Elektromechaniki Dźwigowej\" font_container=\"tag:p|font_size:22|text_align:left|color:%23ffffff\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_separator color=\"white\" align=\"align_left\" el_width=\"40\"][vc_custom_heading text=\"Firma WINDA S. J. powstała w 1990 roku po likwidacji Zakładu Montażu Dźwigów w Poznaniu działającego w ramach Kombinatu Dźwigów Osobowych ZREMB - Warszawa. Firma posiada solidne podstawy finansowe, oraz duży profesjonalizm oparty na dwudziestoletnich doświadczeniach\" font_container=\"tag:p|font_size:18|text_align:left|color:%23ffffff\" use_theme_fonts=\"yes\"][/vc_column][vc_column width=\"1/3\"][vc_btn title=\"O firmie\" style=\"outline\" shape=\"square\" size=\"lg\" align=\"center\" button_block=\"true\" link=\"url:%2Fo-firmie%2F|||\"][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" content_placement=\"middle\" parallax=\"content-moving\" parallax_image=\"25\"][vc_column][vc_text_separator title=\"NASZA OFERTA\" color=\"custom\" accent_color=\"#00970a\" el_id=\"naglowek\"][vc_row_inner][vc_column_inner width=\"1/3\"][vc_cta h2=\"Dźwigi Osobowe\" h2_font_container=\"font_size:16\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów osobowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-osobowe%2F|||\" css=\".vc_custom_1507035830828{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów, które możemy Państwu dostarczyć. Serdecznie zachęcamy do zapoznania się z ofertą.[/vc_cta][/vc_column_inner][vc_column_inner width=\"1/3\"][vc_cta h2=\"Dźwigi dla osób niepełnosprawnych\" h2_font_container=\"font_size:18\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Dźwigi dla osób niepełnosprawnych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-dla-osob-niepelnosprawnych%2F|||\" css=\".vc_custom_1507035842594{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów, które możemy Państwu dostarczyć. Zapraszamy do zapoznania się z ofertą.[/vc_cta][/vc_column_inner][vc_column_inner width=\"1/3\"][vc_cta h2=\"Dźwigi Towarowe\" h2_font_container=\"font_size:18\" h2_google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\" add_button=\"bottom\" btn_title=\"Pełna oferta dźwigów towarowych\" btn_style=\"outline\" btn_shape=\"square\" btn_color=\"success\" btn_size=\"lg\" btn_align=\"center\" use_custom_fonts_h2=\"true\" btn_button_block=\"true\" btn_link=\"url:%2Foferta%2Fdzwigi-towarowych%2F|||\" css=\".vc_custom_1507035814330{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;border-left-color: #00970a !important;border-left-style: solid !important;border-right-color: #00970a !important;border-right-style: solid !important;border-top-color: #00970a !important;border-top-style: solid !important;border-bottom-color: #00970a !important;border-bottom-style: solid !important;}\"]W zależności od potrzeb klienta i od celów do jakich mają być przeznaczone, proponujemy szeroką ofertę dźwigów towarowych, które możemy Państwu dostarczyć.[/vc_cta][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width=\"stretch_row\" content_placement=\"middle\" css=\".vc_custom_1507037445668{background: #00970a url(http://www.winda.poznan.pl/wp-content/uploads/2015/04/20100311030009DSC_0759-1.jpg?id=85) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}\"][vc_column width=\"1/2\" css=\".vc_custom_1507037364707{background-position: center !important;background-repeat: no-repeat !important;background-size: contain !important;}\"][/vc_column][vc_column width=\"1/2\"][vc_custom_heading text=\"Serwis urządzeń dźwigowych\" font_container=\"tag:p|font_size:26|text_align:right|color:%23ffffff\" google_fonts=\"font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal\"][vc_separator color=\"white\" align=\"align_right\" el_width=\"40\"][vc_custom_heading text=\"Firma WINDA prowadzi także serwis urządzeń dźwigowych (nowych, zakupionych w naszej firmie oraz starszego typu). Wykonujemy także naprawy gwarancyjne zakupionych u nas urządzeń. Przeprowadzamy remonty dźwigów w każdym zakresie. \" font_container=\"tag:p|font_size:18|text_align:right|color:%23ffffff\" use_theme_fonts=\"yes\"][vc_btn title=\"Dowiedz się więcej\" style=\"outline\" shape=\"square\" size=\"lg\" align=\"center\" button_block=\"true\"][/vc_column][/vc_row][vc_row full_width=\"stretch_row_content\" parallax=\"content-moving\" parallax_image=\"25\"][vc_column][vc_text_separator title=\"NASZA GALERIA\" color=\"custom\" accent_color=\"#00970a\" el_id=\"naglowek\"][vc_media_grid element_width=\"3\" gap=\"0\" item=\"mediaGrid_ScaleInWithIcon\" initial_loading_animation=\"bounceInLeft\" grid_id=\"vc_gid:1507036585397-bfe96fb2-fd55-4\" include=\"77,78,79,80,68,92,93,96\"][/vc_column][/vc_row]", "Home", "", "inherit", "closed", "closed", "", "49-revision-v1", "", "", "2017-10-03 15:43:18", "2017-10-03 13:43:18", "", "49", "http://www.winda.poznan.pl/49-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("101", "1", "2017-10-03 15:47:07", "2017-10-03 13:47:07", "", "20131103045218CI01000001", "", "inherit", "closed", "closed", "", "20131103045218ci01000001", "", "", "2017-10-03 15:47:07", "2017-10-03 13:47:07", "", "49", "http://www.winda.poznan.pl/wp-content/uploads/2015/04/20131103045218CI01000001.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("102", "1", "2017-10-03 15:47:14", "2017-10-03 13:47:14", "", "20131103045244CI01000000", "", "inherit", "closed", "closed", "", "20131103045244ci01000000", "", "", "2017-10-03 15:47:14", "2017-10-03 13:47:14", "", "49", "http://www.winda.poznan.pl/wp-content/uploads/2015/04/20131103045244CI01000000.jpg", "0", "attachment", "image/jpeg", "